/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.grammar;

import java.util.Hashtable;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.FunctionTable;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.stx.Value;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Tree {
    public static final int ROOT = 1;
    public static final int CHILD = 2;
    public static final int DESC = 3;
    public static final int UNION = 4;
    public static final int NAME_TEST = 5;
    public static final int WILDCARD = 6;
    public static final int URI_WILDCARD = 7;
    public static final int LOCAL_WILDCARD = 8;
    public static final int NODE_TEST = 9;
    public static final int TEXT_TEST = 10;
    public static final int CDATA_TEST = 100;
    public static final int COMMENT_TEST = 11;
    public static final int PI_TEST = 12;
    public static final int FUNCTION = 13;
    public static final int PREDICATE = 14;
    public static final int NUMBER = 15;
    public static final int STRING = 16;
    public static final int ADD = 17;
    public static final int SUB = 18;
    public static final int MULT = 19;
    public static final int DIV = 20;
    public static final int MOD = 21;
    public static final int AND = 22;
    public static final int OR = 23;
    public static final int EQ = 24;
    public static final int NE = 25;
    public static final int LT = 26;
    public static final int LE = 27;
    public static final int GT = 28;
    public static final int GE = 29;
    public static final int ATTR = 30;
    public static final int ATTR_WILDCARD = 31;
    public static final int ATTR_URI_WILDCARD = 32;
    public static final int ATTR_LOCAL_WILDCARD = 33;
    public static final int LIST = 34;
    public static final int SEQ = 35;
    public static final int AVT = 36;
    public static final int VAR = 37;
    public static final int DOT = 38;
    public static final int DDOT = 39;
    public static final int VALUE = 40;
    public int type;
    public Tree left;
    public Tree right;
    public Object value;
    public String uri;
    public String lName;
    private static FunctionTable funcTable = new FunctionTable();
    private FunctionTable.Instance func;
    private static Log log = LogFactory.getLog((Class)(class$net$sf$joost$grammar$Tree == null ? (class$net$sf$joost$grammar$Tree = Tree.class$("net.sf.joost.grammar.Tree")) : class$net$sf$joost$grammar$Tree));
    static /* synthetic */ Class class$net$sf$joost$grammar$Tree;

    public Tree(int n, Tree tree, Tree tree2, Object object) {
        this.type = n;
        this.left = tree;
        this.right = tree2;
        this.value = object;
    }

    public Tree(int n, Tree tree, Tree tree2) {
        this(n, tree, tree2, null);
    }

    public Tree(int n, Object object) {
        this(n, null, null, object);
    }

    public Tree(int n) {
        this(n, null);
    }

    public Tree(Value value) {
        this(40, value);
    }

    public Tree(int n, String string, ParseContext parseContext) throws SAXParseException {
        this(n, null, null, string);
        if (n != 5 && n != 30 && n != 13 && n != 37) {
            log.fatal((Object)("Wrong Tree type; " + this));
            return;
        }
        String string2 = string;
        int n2 = string2.indexOf(":");
        if (n2 != -1) {
            this.uri = (String)parseContext.nsSet.get(string2.substring(0, n2));
            this.lName = string2.substring(n2 + 1);
            if (this.uri == null) {
                throw new SAXParseException("Undeclared prefix `" + string2.substring(0, n2) + "'", parseContext.locator);
            }
        } else {
            switch (n) {
                case 5: {
                    this.uri = parseContext.transformNode.stxpathDefaultNamespace;
                    break;
                }
                case 13: {
                    this.uri = "http://stx.sourceforge.net/2003/functions";
                    break;
                }
                default: {
                    this.uri = "";
                }
            }
            this.lName = string2;
        }
    }

    public Tree(int n, String string, String string2, ParseContext parseContext) throws SAXParseException {
        this(n, null, null, string + ":" + string2);
        if (n != 7 && n != 8 && n != 32 && n != 33) {
            log.fatal((Object)("Unexpected type " + n));
            throw new SAXParseException("FATAL: Tree constructor: Unexpected type " + n, parseContext.locator);
        }
        this.lName = string2;
        if (n == 7 || n == 32) {
            this.uri = "*";
        } else {
            this.uri = (String)parseContext.nsSet.get(string);
            this.lName = string2;
            if (this.uri == null) {
                throw new SAXParseException("Undeclared prefix `" + string + "'", parseContext.locator);
            }
        }
    }

    public Tree(int n, String string, Tree tree, ParseContext parseContext) throws SAXParseException {
        this(n, string, parseContext);
        this.left = tree;
        this.func = funcTable.getFunction(this.uri, this.lName, string, tree, parseContext.locator);
    }

    public boolean matches(Context context, int n, boolean bl) throws SAXException {
        switch (this.type) {
            case 4: {
                if (this.left.matches(context, n, false)) {
                    return true;
                }
                return this.right.matches(context, n, false);
            }
            case 1: {
                if (n != 1) {
                    return false;
                }
                if (bl) {
                    context.position = 1L;
                }
                return true;
            }
            case 2: {
                if (n < 2) {
                    return false;
                }
                return this.left.matches(context, n - 1, false) && this.right.matches(context, n, bl);
            }
            case 3: {
                if (n < 3) {
                    return false;
                }
                if (this.right.matches(context, n, bl)) {
                    while (n > 1) {
                        if (this.left.matches(context, n - 1, false)) {
                            return true;
                        }
                        --n;
                    }
                }
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (n < 2) {
                    return false;
                }
                SAXEvent sAXEvent = (SAXEvent)context.ancestorStack.elementAt(n - 1);
                if (sAXEvent.type != 1) {
                    return false;
                }
                SAXEvent sAXEvent2 = (SAXEvent)context.ancestorStack.elementAt(n - 2);
                switch (this.type) {
                    case 5: {
                        if (!this.uri.equals(sAXEvent.uri) || !this.lName.equals(sAXEvent.lName)) {
                            return false;
                        }
                        if (!bl) break;
                        context.position = sAXEvent2.getPositionOf(this.uri, this.lName);
                        break;
                    }
                    case 6: {
                        if (!bl) break;
                        context.position = sAXEvent2.getPositionOf("*", "*");
                        break;
                    }
                    case 8: {
                        if (!this.uri.equals(sAXEvent.uri)) {
                            return false;
                        }
                        if (!bl) break;
                        context.position = sAXEvent2.getPositionOf(this.uri, "*");
                        break;
                    }
                    case 7: {
                        if (!this.lName.equals(sAXEvent.lName)) {
                            return false;
                        }
                        if (!bl) break;
                        context.position = sAXEvent2.getPositionOf("*", this.lName);
                    }
                }
                return true;
            }
            case 14: {
                long l = context.position;
                boolean bl2 = false;
                if (n > 1 && this.left.matches(context, n, true)) {
                    Value value = this.right.evaluate(context, n);
                    bl2 = value.type == 3 ? context.position == Math.round(value.number) : value.convertToBoolean().bool;
                }
                if (!bl) {
                    context.position = l;
                }
                return bl2;
            }
            case 9: {
                if (n < 2 || ((SAXEvent)context.ancestorStack.elementAt((int)(n - 1))).type == 6) {
                    return false;
                }
                if (bl) {
                    context.position = ((SAXEvent)context.ancestorStack.elementAt(n - 2)).getPositionOfNode();
                }
                return true;
            }
            case 10: {
                if (n < 2) {
                    return false;
                }
                int n2 = ((SAXEvent)context.ancestorStack.elementAt((int)(n - 1))).type;
                if (n2 == 2 || n2 == 3) {
                    if (bl) {
                        context.position = ((SAXEvent)context.ancestorStack.elementAt(n - 2)).getPositionOfText();
                    }
                    return true;
                }
                return false;
            }
            case 100: {
                if (n < 2) {
                    return false;
                }
                if (((SAXEvent)context.ancestorStack.elementAt((int)(n - 1))).type == 3) {
                    if (bl) {
                        context.position = ((SAXEvent)context.ancestorStack.elementAt(n - 2)).getPositionOfCDATA();
                    }
                    return true;
                }
                return false;
            }
            case 11: {
                if (n < 2) {
                    return false;
                }
                if (((SAXEvent)context.ancestorStack.elementAt((int)(n - 1))).type == 5) {
                    if (bl) {
                        context.position = ((SAXEvent)context.ancestorStack.elementAt(n - 2)).getPositionOfComment();
                    }
                    return true;
                }
                return false;
            }
            case 12: {
                if (n < 2) {
                    return false;
                }
                SAXEvent sAXEvent = (SAXEvent)context.ancestorStack.elementAt(n - 1);
                if (sAXEvent.type == 4) {
                    if (this.value != "" && !this.value.equals(sAXEvent.qName)) {
                        return false;
                    }
                    if (bl) {
                        context.position = ((SAXEvent)context.ancestorStack.elementAt(n - 2)).getPositionOfPI((String)this.value);
                    }
                    return true;
                }
                return false;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                if (n < 3) {
                    return false;
                }
                SAXEvent sAXEvent = (SAXEvent)context.ancestorStack.elementAt(n - 1);
                if (sAXEvent.type != 6) {
                    return false;
                }
                if (bl) {
                    context.position = 1L;
                }
                switch (this.type) {
                    case 31: {
                        return true;
                    }
                    case 30: {
                        if (!this.uri.equals(sAXEvent.uri) || !this.lName.equals(sAXEvent.lName)) break;
                        return true;
                    }
                    case 32: {
                        if (!this.lName.equals(sAXEvent.lName)) break;
                        return true;
                    }
                    case 33: {
                        if (!this.uri.equals(sAXEvent.uri)) break;
                        return true;
                    }
                }
                return false;
            }
        }
        log.fatal((Object)("unprocessed type: " + this));
        return false;
    }

    public Value evaluate(Context context, NodeBase nodeBase) throws SAXException {
        context.currentInstruction = nodeBase;
        return this.evaluate(context, context.ancestorStack.size());
    }

    public Value evaluate(Context context, int n) throws SAXException {
        try {
            switch (this.type) {
                case 15: {
                    return new Value((Double)this.value);
                }
                case 16: {
                    return new Value((String)this.value);
                }
                case 40: {
                    return ((Value)this.value).copy();
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    Value value;
                    if (this.left != null) {
                        value = this.left.evaluate(context, n);
                        if (value.type == 0) {
                            return value;
                        }
                        value.convertToNumber();
                    } else {
                        value = null;
                    }
                    Value value2 = this.right.evaluate(context, n);
                    if (value2.type == 0) {
                        return value2;
                    }
                    value2.convertToNumber();
                    switch (this.type) {
                        case 17: {
                            if (this.left == null) {
                                return value2;
                            }
                            value.number += value2.number;
                            return value;
                        }
                        case 18: {
                            if (this.left == null) {
                                value2.number = -value2.number;
                                return value2;
                            }
                            value.number -= value2.number;
                            return value;
                        }
                        case 19: {
                            value.number *= value2.number;
                            return value;
                        }
                        case 20: {
                            value.number /= value2.number;
                            return value;
                        }
                        case 21: {
                            value.number %= value2.number;
                            return value;
                        }
                    }
                    log.fatal((Object)"Mustn't reach this line");
                    return new Value();
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    Value value = this.left.evaluate(context, n);
                    Value value3 = this.right.evaluate(context, n);
                    if (value.type == 0 || value3.type == 0) {
                        return value.setBoolean(false);
                    }
                    Value value4 = value.copy();
                    while (value4 != null) {
                        Value value5 = value4.next;
                        Value value6 = value3.copy();
                        while (value6 != null) {
                            Value value7 = value6.next;
                            switch (this.type) {
                                case 24: {
                                    if (!(value4.type == 2 || value6.type == 2 ? value4.convertToBoolean().bool == value6.convertToBoolean().bool : (value4.type == 3 || value6.type == 3 ? value4.convertToNumber().number == value6.convertToNumber().number : value4.convertToString().string.equals(value6.convertToString().string)))) break;
                                    return value.setBoolean(true);
                                }
                                case 25: {
                                    if (!(value4.type == 2 || value6.type == 2 ? value4.convertToBoolean().bool != value6.convertToBoolean().bool : (value4.type == 3 || value6.type == 3 ? value4.convertToNumber().number != value6.convertToNumber().number : !value4.convertToString().string.equals(value6.convertToString().string)))) break;
                                    return value.setBoolean(true);
                                }
                                case 26: {
                                    if (!(value4.convertToNumber().number < value6.convertToNumber().number)) break;
                                    return value.setBoolean(true);
                                }
                                case 27: {
                                    if (!(value4.convertToNumber().number <= value6.convertToNumber().number)) break;
                                    return value.setBoolean(true);
                                }
                                case 28: {
                                    if (!(value4.convertToNumber().number > value6.convertToNumber().number)) break;
                                    return value.setBoolean(true);
                                }
                                case 29: {
                                    if (!(value4.convertToNumber().number >= value6.convertToNumber().number)) break;
                                    return value.setBoolean(true);
                                }
                            }
                            value6 = value7;
                        }
                        value4 = value5;
                    }
                    return value.setBoolean(false);
                }
                case 22: {
                    Value value = this.left.evaluate(context, n).convertToBoolean();
                    if (!value.bool) {
                        return value;
                    }
                    return this.right.evaluate(context, n).convertToBoolean();
                }
                case 23: {
                    Value value = this.left.evaluate(context, n).convertToBoolean();
                    if (value.bool) {
                        return value;
                    }
                    return this.right.evaluate(context, n).convertToBoolean();
                }
                case 13: {
                    return this.func.evaluate(context, n, this.left);
                }
                case 36: {
                    Value value = this.right.evaluate(context, n).convertToString();
                    if (this.left != null) {
                        Value value8 = this.left.evaluate(context, n);
                        value8.string = value8.string + value.string;
                        return value8;
                    }
                    return value;
                }
                case 37: {
                    String string = "{" + this.uri + "}" + this.lName;
                    Value value = (Value)context.localVars.get(string);
                    if (value == null) {
                        GroupBase groupBase = context.currentGroup;
                        while (value == null && groupBase != null) {
                            value = (Value)((Hashtable)groupBase.groupVars.peek()).get(string);
                            groupBase = groupBase.parentGroup;
                        }
                    }
                    if (value == null) {
                        throw new EvalException("Undeclared variable `" + this.value + "'");
                    }
                    return value.copy();
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    Value value;
                    if (this.left != null) {
                        value = this.left.evaluate(context, n);
                        if (value.type == 0) {
                            return value;
                        }
                    } else {
                        value = n > 0 ? new Value((SAXEvent)context.ancestorStack.elementAt(n - 1)) : null;
                    }
                    Value value9 = null;
                    Value value10 = null;
                    while (value != null) {
                        Value value11;
                        int n2;
                        if (value.type != 1) {
                            throw new EvalException("Current item for evaluating `@" + this.value + "' is not a node (got " + value + ")");
                        }
                        SAXEvent sAXEvent = value.event;
                        if (this.type == 30) {
                            if (sAXEvent != null && sAXEvent.attrs != null && (n2 = sAXEvent.attrs.getIndex(this.uri, this.lName)) != -1) {
                                value11 = new Value(SAXEvent.newAttribute(sAXEvent.attrs, n2));
                                if (value10 != null) {
                                    value10.next = value11;
                                } else {
                                    value9 = value11;
                                }
                                value10 = value11;
                            }
                        } else {
                            n2 = sAXEvent.attrs.getLength();
                            int n3 = 0;
                            while (n3 < n2) {
                                value11 = null;
                                if (this.type == 31) {
                                    value11 = new Value(SAXEvent.newAttribute(sAXEvent.attrs, n3));
                                } else if (this.type == 33) {
                                    if (this.uri.equals(sAXEvent.attrs.getURI(n3))) {
                                        value11 = new Value(SAXEvent.newAttribute(sAXEvent.attrs, n3));
                                    }
                                } else if (this.type == 32 && this.lName.equals(sAXEvent.attrs.getLocalName(n3))) {
                                    value11 = new Value(SAXEvent.newAttribute(sAXEvent.attrs, n3));
                                }
                                if (value11 != null) {
                                    if (value10 != null) {
                                        value10.next = value11;
                                    } else {
                                        value9 = value11;
                                    }
                                    value10 = value11;
                                }
                                ++n3;
                            }
                        }
                        value = value.next;
                    }
                    if (value9 != null) {
                        return value9;
                    }
                    return new Value();
                }
                case 38: {
                    if (n > 0) {
                        return new Value((SAXEvent)context.ancestorStack.elementAt(n - 1));
                    }
                    return new Value();
                }
                case 39: {
                    if (n > 1) {
                        if (this.right != null) {
                            return this.right.evaluate(context, n - 1);
                        }
                        return new Value((SAXEvent)context.ancestorStack.elementAt(n - 2));
                    }
                    return new Value();
                }
                case 1: {
                    return this.left.evaluate(context, 1);
                }
                case 2: {
                    if (n < context.ancestorStack.size() && this.left.matches(context, n + 1, false)) {
                        if (this.right != null) {
                            return this.right.evaluate(context, n + 1);
                        }
                        return new Value((SAXEvent)context.ancestorStack.elementAt(n));
                    }
                    return new Value();
                }
                case 3: {
                    Value value = null;
                    Value value12 = null;
                    while (n < context.ancestorStack.size()) {
                        Value value13 = this.right.evaluate(context, n++);
                        if (value13.type != 1) continue;
                        if (value != null) {
                            Value value14 = value13;
                            while (value14 != null) {
                                Value value15 = value;
                                while (value15 != null) {
                                    if (value14.event == value15.event) break;
                                    value15 = value15.next;
                                }
                                if (value15 == null) {
                                    value12.next = value14;
                                    value12 = value14;
                                }
                                value14 = value14.next;
                                value12.next = null;
                            }
                            continue;
                        }
                        value = value13;
                        value12 = value13;
                        while (value12.next != null) {
                            value12 = value12.next;
                        }
                    }
                    if (value != null) {
                        return value;
                    }
                    return new Value();
                }
                case 34: {
                    log.fatal((Object)"LIST: this mustn't happen");
                    return new Value();
                }
                case 35: {
                    Value value = this.left != null ? this.left.evaluate(context, n) : new Value();
                    Value value16 = this.right != null ? this.right.evaluate(context, n) : new Value();
                    if (value.type == 0) {
                        return value16;
                    }
                    if (value16.type == 0) {
                        return value;
                    }
                    Value value17 = value;
                    while (value17.next != null) {
                        value17 = value17.next;
                    }
                    value17.next = value16;
                    return value;
                }
            }
            log.fatal((Object)("type " + this + " is not implemented"));
            return null;
        }
        catch (EvalException evalException) {
            context.errorHandler.error(evalException.getMessage(), context.currentInstruction.publicId, context.currentInstruction.systemId, context.currentInstruction.lineNo, context.currentInstruction.colNo);
            return new Value();
        }
    }

    protected Tree reverseAssociativity() {
        if (this.type == 2 || this.type == 3 || this.type == 38 || this.type == 39) {
            Tree tree;
            if (this.left != null) {
                tree = this.left.reverseAssociativity();
                this.left.right = this;
            } else {
                tree = this;
            }
            this.left = this.right;
            this.right = null;
            return tree;
        }
        return this;
    }

    public String toString() {
        String string = "{";
        switch (this.type) {
            case 1: {
                string = string + "ROOT";
                break;
            }
            case 2: {
                string = string + "CHILD";
                break;
            }
            case 3: {
                string = string + "DESC";
                break;
            }
            case 5: {
                string = string + "NAME_TEST";
                break;
            }
            case 10: {
                string = string + "TEXT_TEST";
                break;
            }
            case 9: {
                string = string + "NODE_TEST";
                break;
            }
            case 11: {
                string = string + "COMMENT_TEST";
                break;
            }
            case 30: {
                string = string + "ATTR";
                break;
            }
            case 24: {
                string = string + "EQ";
                break;
            }
            case 16: {
                string = string + "STRING";
                break;
            }
            case 15: {
                string = string + "NUMBER";
                break;
            }
            case 6: {
                string = string + "*";
                break;
            }
            case 39: {
                string = string + "..";
                break;
            }
            default: {
                string = string + this.type;
            }
        }
        string = string + "," + this.left + "," + this.right + "," + this.value;
        if (this.type == 5 || this.type == 7 || this.type == 8) {
            string = string + "(" + this.uri + "|" + this.lName + ")";
        }
        return string + "}";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

