/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.emitter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import net.sf.joost.emitter.StxEmitter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class StreamEmitter
implements StxEmitter {
    private Writer outwriter;
    private String propEncoding = "UTF-8";
    private boolean propOmitXmlDeclaration = false;
    private boolean propStandalone = false;
    private String propVersion = "1.0";
    private StringBuffer nsDeclarations = new StringBuffer();
    private String uri;
    private String qName;
    private Attributes attrs;
    private boolean insideCDATA = false;
    private static Log log = LogFactory.getLog((Class)(class$net$sf$joost$emitter$StreamEmitter == null ? (class$net$sf$joost$emitter$StreamEmitter = StreamEmitter.class$("net.sf.joost.emitter.StreamEmitter")) : class$net$sf$joost$emitter$StreamEmitter));
    static /* synthetic */ Class class$net$sf$joost$emitter$StreamEmitter;

    public StreamEmitter(Writer writer, Properties properties) throws IOException {
        this.outwriter = writer;
        if (properties != null) {
            this.propEncoding = properties.getProperty("encoding").toUpperCase();
            this.propOmitXmlDeclaration = properties.getProperty("omit-xml-declaration").equals("yes");
            if (!this.propEncoding.equals("UTF-8") && !this.propEncoding.equals("UTF-16")) {
                this.propOmitXmlDeclaration = false;
            }
            this.propStandalone = properties.getProperty("standalone").equals("yes");
            this.propVersion = properties.getProperty("version");
        }
    }

    public StreamEmitter(OutputStream outputStream, Properties properties) throws IOException {
        OutputStreamWriter outputStreamWriter;
        if (properties != null) {
            this.propEncoding = properties.getProperty("encoding").toUpperCase();
            this.propOmitXmlDeclaration = properties.getProperty("omit-xml-declaration").equals("yes");
            if (!this.propEncoding.equals("UTF-8") && !this.propEncoding.equals("UTF-16")) {
                this.propOmitXmlDeclaration = false;
            }
            this.propStandalone = properties.getProperty("standalone").equals("yes");
            this.propVersion = properties.getProperty("version");
        }
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, this.propEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)("Unsupported encoding " + this.propEncoding + ", using " + "UTF-8"));
            this.propEncoding = "UTF-8";
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        this.outwriter = new BufferedWriter(outputStreamWriter);
    }

    public StreamEmitter() throws IOException {
        this(System.out, null);
    }

    public StreamEmitter(Writer writer) throws IOException {
        this(writer, null);
    }

    public StreamEmitter(String string, Properties properties) throws IOException {
        this(new FileOutputStream(string), properties);
    }

    public void setOmitXmlDeclaration(boolean bl) {
        this.propOmitXmlDeclaration = bl;
    }

    private boolean processLastElement(boolean bl) throws SAXException {
        if (this.qName != null) {
            StringBuffer stringBuffer = new StringBuffer("<");
            stringBuffer.append(this.qName);
            stringBuffer.append(this.nsDeclarations);
            this.nsDeclarations.setLength(0);
            int n = this.attrs.getLength();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ').append(this.attrs.getQName(n2)).append("=\"");
                boolean bl2 = false;
                char[] cArray = this.attrs.getValue(n2).toCharArray();
                int n3 = 0;
                while (n3 < cArray.length) {
                    switch (cArray[n3]) {
                        case '&': {
                            stringBuffer.append("&amp;");
                            break;
                        }
                        case '<': {
                            stringBuffer.append("&lt;");
                            break;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            break;
                        }
                        case '\"': {
                            stringBuffer.append("&quot;");
                            break;
                        }
                        case '\t': {
                            stringBuffer.append("&#x9;");
                            break;
                        }
                        case '\n': {
                            stringBuffer.append("&#xA;");
                            break;
                        }
                        case '\r': {
                            stringBuffer.append("&#xD;");
                            break;
                        }
                        default: {
                            stringBuffer.append(cArray[n3]);
                        }
                    }
                    ++n3;
                }
                stringBuffer.append('\"');
                ++n2;
            }
            stringBuffer.append(bl ? " />" : ">");
            try {
                this.outwriter.write(stringBuffer.toString());
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
                throw new SAXException(iOException);
            }
            this.qName = null;
            return true;
        }
        return false;
    }

    public void startDocument() throws SAXException {
        if (this.propOmitXmlDeclaration) {
            return;
        }
        try {
            this.outwriter.write("<?xml version=\"");
            this.outwriter.write(this.propVersion);
            this.outwriter.write("\" encoding=\"");
            this.outwriter.write(this.propEncoding);
            if (this.propStandalone) {
                this.outwriter.write("\" standalone=\"yes");
            }
            this.outwriter.write("\"?>\n");
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        this.processLastElement(false);
        try {
            this.outwriter.write("\n");
            this.outwriter.flush();
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.processLastElement(false);
        this.uri = string;
        this.qName = string3;
        this.attrs = attributes;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.processLastElement(true)) {
            try {
                this.outwriter.write("</");
                this.outwriter.write(string3);
                this.outwriter.write(">");
            }
            catch (IOException iOException) {
                log.error((Object)iOException);
                throw new SAXException(iOException);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.processLastElement(false);
        try {
            if (this.insideCDATA) {
                this.outwriter.write(cArray, n, n2);
            } else {
                StringBuffer stringBuffer = new StringBuffer(n2);
                int n3 = 0;
                while (n3 < n2) {
                    switch (cArray[n + n3]) {
                        case '&': {
                            stringBuffer.append("&amp;");
                            break;
                        }
                        case '<': {
                            stringBuffer.append("&lt;");
                            break;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            break;
                        }
                        default: {
                            stringBuffer.append(cArray[n + n3]);
                        }
                    }
                    ++n3;
                }
                this.outwriter.write(stringBuffer.toString());
            }
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.processLastElement(false);
        if ("".equals(string)) {
            this.nsDeclarations.append(" xmlns=\"");
        } else {
            this.nsDeclarations.append(" xmlns:").append(string).append("=\"");
        }
        this.nsDeclarations.append(string2).append('\"');
    }

    public void endPrefixMapping(String string) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.processLastElement(false);
        try {
            this.outwriter.write("<?");
            this.outwriter.write(string);
            if (!string2.equals("")) {
                this.outwriter.write(" ");
                this.outwriter.write(string2);
            }
            this.outwriter.write("?>");
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new SAXException(iOException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.processLastElement(false);
        try {
            this.outwriter.write("<![CDATA[");
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new SAXException(iOException);
        }
        this.insideCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.outwriter.write("]]>");
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new SAXException(iOException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.processLastElement(false);
        try {
            this.outwriter.write("<!--");
            this.outwriter.write(cArray, n, n2);
            this.outwriter.write("-->");
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            throw new SAXException(iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

