/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.KeyObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class StringKey
extends KeyObject {
    static final long serialVersionUID = -6894793231339165076L;
    protected static final int KEY_LENGTH = 16;
    private String m_key;

    public StringKey(String string) {
        this.m_key = string.length() > 16 ? string.substring(16) : new String(string);
    }

    public StringKey() {
        this.m_key = new String();
    }

    public int compareTo(KeyObject keyObject) {
        if (keyObject instanceof StringKey) {
            int n = this.m_key.trim().compareTo(((StringKey)keyObject).m_key.trim());
            if (n == 0) {
                return 0;
            }
            if (n < 0) {
                return -1;
            }
            return 1;
        }
        return 99;
    }

    public KeyObject makeNullKey() {
        return new StringKey();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string;
        int n = this.m_key.length();
        if (this.m_key.length() < 16) {
            string = new String(this.m_key);
            int n2 = 0;
            while (n2 < 16 - this.m_key.length()) {
                string = string + ' ';
                ++n2;
            }
        } else {
            string = this.m_key.substring(0, 16);
        }
        objectOutput.writeUTF(string);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.m_key = objectInput.readUTF();
    }

    public String toString() {
        return this.m_key;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.m_key.length() < 16 ? this.m_key.length() : 16;
        int n3 = 0;
        while (n3 < n2) {
            n += this.m_key.charAt(n3);
            ++n3;
        }
        return n;
    }
}

