/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.history;

import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.SchedulerPlugin;

public class LoggingJobHistoryPlugin
implements SchedulerPlugin,
JobListener {
    private String name;
    private String jobToBeFiredMessage = "Job {1}.{0} fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private String jobCompleteMessage = "Job {1}.{0} execution complete at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    static /* synthetic */ Class class$org$quartz$plugins$history$LoggingJobHistoryPlugin;

    protected static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$plugins$history$LoggingJobHistoryPlugin == null ? (class$org$quartz$plugins$history$LoggingJobHistoryPlugin = LoggingJobHistoryPlugin.class$("org.quartz.plugins.history.LoggingJobHistoryPlugin")) : class$org$quartz$plugins$history$LoggingJobHistoryPlugin));
    }

    public String getJobCompleteMessage() {
        return this.jobCompleteMessage;
    }

    public String getJobToBeFiredMessage() {
        return this.jobToBeFiredMessage;
    }

    public void setJobCompleteMessage(String jobCompleteMessage) {
        this.jobCompleteMessage = jobCompleteMessage;
    }

    public void setJobToBeFiredMessage(String jobToBeFiredMessage) {
        this.jobToBeFiredMessage = jobToBeFiredMessage;
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.name = name;
        scheduler.addGlobalJobListener(this);
    }

    public void shutdown() {
    }

    public String getName() {
        return this.name;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        Trigger trigger = context.getTrigger();
        Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount())};
        LoggingJobHistoryPlugin.getLog().debug((Object)MessageFormat.format(this.jobToBeFiredMessage, args));
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Trigger trigger = context.getTrigger();
        String errMsg = "NO ERRORS";
        if (jobException != null) {
            errMsg = jobException.getMessage();
        }
        Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount()), errMsg};
        LoggingJobHistoryPlugin.getLog().debug((Object)MessageFormat.format(this.jobCompleteMessage, args));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

