/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DBConnectionManager;

public class JobStoreCMT
extends JobStoreSupport {
    protected String nonManagedTxDsName;
    protected boolean dontSetNonManagedTXConnectionAutoCommitFalse = false;

    public void setNonManagedTXDataSource(String nonManagedTxDsName) {
        this.nonManagedTxDsName = nonManagedTxDsName;
    }

    public String getNonManagedTXDataSource() {
        return this.nonManagedTxDsName;
    }

    public boolean isDontSetNonManagedTXConnectionAutoCommitFalse() {
        return this.dontSetNonManagedTXConnectionAutoCommitFalse;
    }

    public void setDontSetNonManagedTXConnectionAutoCommitFalse(boolean b) {
        this.dontSetNonManagedTXConnectionAutoCommitFalse = b;
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        if (this.nonManagedTxDsName == null) {
            throw new SchedulerConfigException("Non-ManagedTX DataSource name not set!");
        }
        this.setUseDBLocks(true);
        super.initialize(loadHelper, signaler);
    }

    /*
     * Loose catch block
     */
    protected void recoverJobs() throws JobPersistenceException {
        block18: {
            Connection conn = null;
            boolean transOwner = false;
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.recoverJobs(conn);
            conn.commit();
            Object var7_3 = null;
            if (conn == null) break block18;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block18;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error recovering jobs: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                if (conn != null) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        block18: {
            Connection conn = null;
            boolean transOwner = false;
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.cleanVolatileTriggerAndJobs(conn);
            conn.commit();
            Object var7_3 = null;
            if (conn == null) break block18;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block18;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error cleaning volatile data: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                if (conn != null) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            if (newJob.isVolatile() && !newTrigger.isVolatile()) {
                JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
                jpe.setErrorCode(100);
                throw jpe;
            }
            this.storeJob(conn, ctxt, newJob, false);
            this.storeTrigger(conn, ctxt, newTrigger, false, "WAITING", false);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.storeJob(conn, ctxt, newJob, replaceExisting);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            bl = this.removeJob(conn, ctxt, jobName, groupName, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        JobDetail jobDetail;
        Connection conn = this.getConnection();
        try {
            jobDetail = this.retrieveJob(conn, ctxt, jobName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return jobDetail;
    }

    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.storeTrigger(conn, ctxt, newTrigger, replaceExisting, "WAITING", false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            bl = this.removeTrigger(conn, ctxt, triggerName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Trigger trigger;
        Connection conn = this.getConnection();
        try {
            trigger = this.retrieveTrigger(conn, ctxt, triggerName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return trigger;
    }

    public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            this.storeCalendar(conn, ctxt, calName, calendar, replaceExisting);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            bl = this.removeCalendar(conn, ctxt, calName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Calendar calendar;
        Connection conn = this.getConnection();
        try {
            calendar = this.retrieveCalendar(conn, ctxt, calName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return calendar;
    }

    public int getNumberOfJobs(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getNumberOfJobs(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public int getNumberOfTriggers(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getNumberOfTriggers(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public int getNumberOfCalendars(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getNumberOfCalendars(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getJobNames(conn, ctxt, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getTriggerNames(conn, ctxt, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getJobGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getJobGroupNames(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getTriggerGroupNames(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getCalendarNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            stringArray = this.getCalendarNames(conn, ctxt);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return stringArray;
    }

    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Trigger[] triggerArray;
        Connection conn = this.getConnection();
        try {
            triggerArray = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return triggerArray;
    }

    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            n = this.getTriggerState(conn, ctxt, triggerName, groupName);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.pauseTrigger(conn, ctxt, triggerName, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.pauseTriggerGroup(conn, ctxt, groupName);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.resumeTrigger(conn, ctxt, triggerName, groupName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.resumeTriggerGroup(conn, ctxt, groupName);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    public void pauseAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.pauseAll(conn, ctxt);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    public void resumeAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.resumeAll(conn, ctxt);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
        }
        catch (LockException le) {
            this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
        }
        try {
            conn.close();
        }
        catch (SQLException ignore) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Trigger acquireNextTrigger(SchedulingContext ctxt) throws JobPersistenceException {
        block17: {
            conn = null;
            try {
                try {
                    conn = this.getNonManagedTXConnection();
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    trigger = this.acquireNextTrigger(conn, ctxt);
                    conn.commit();
                    var4_5 = trigger;
                    var7_8 = null;
                    if (conn == null) return var4_5;
                }
                catch (JobPersistenceException e) {
                    try {
                        if (conn == null) throw e;
                        conn.rollback();
                        throw e;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn == null) throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
                        conn.rollback();
                        throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), e);
                }
            }
            catch (Throwable var6_13) {
                var7_9 = null;
                if (conn == null) throw var6_13;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le) {
                    this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                }
                try {
                    conn.close();
                    throw var6_13;
                }
                catch (SQLException ignore) {
                    throw var6_13;
                }
            }
            ** try [egrp 4[TRYBLOCK] [5 : 125->141)] { 
lbl47:
            // 1 sources

            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            break block17;
lbl49:
            // 1 sources

            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        ** try [egrp 5[TRYBLOCK] [6 : 177->186)] { 
lbl53:
        // 1 sources

        conn.close();
        return var4_5;
lbl55:
        // 1 sources

        catch (SQLException ignore) {
            // empty catch block
        }
        return var4_5;
    }

    /*
     * Loose catch block
     */
    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        block18: {
            Connection conn = null;
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.releaseAcquiredTrigger(conn, ctxt, trigger);
            conn.commit();
            Object var8_4 = null;
            if (conn == null) break block18;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block18;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("Error releasing acquired trigger: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_5 = null;
                if (conn != null) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        block21: {
            conn = null;
            try {
                try {
                    conn = this.getNonManagedTXConnection();
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    tfb = null;
                    err = null;
                    try {
                        tfb = this.triggerFired(conn, ctxt, trigger);
                    }
                    catch (JobPersistenceException jpe) {
                        if (jpe.getErrorCode() != 410) {
                            throw jpe;
                        }
                        err = jpe;
                    }
                    if (err != null) {
                        throw err;
                    }
                    conn.commit();
                    jpe = tfb;
                    var8_12 = null;
                    if (conn == null) return jpe;
                }
                catch (JobPersistenceException e) {
                    try {
                        if (conn == null) throw e;
                        conn.rollback();
                        throw e;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn == null) throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                        conn.rollback();
                        throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable var7_16) {
                var8_13 = null;
                if (conn == null) throw var7_16;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le) {
                    this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                }
                try {
                    conn.close();
                    throw var7_16;
                }
                catch (SQLException ignore) {
                    throw var7_16;
                }
            }
            ** try [egrp 5[TRYBLOCK] [6 : 167->183)] { 
lbl57:
            // 1 sources

            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            break block21;
lbl59:
            // 1 sources

            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        ** try [egrp 6[TRYBLOCK] [7 : 219->228)] { 
lbl63:
        // 1 sources

        conn.close();
        return jpe;
lbl65:
        // 1 sources

        catch (SQLException ignore) {
            // empty catch block
        }
        return jpe;
    }

    /*
     * Loose catch block
     */
    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        block18: {
            Connection conn = null;
            conn = this.getNonManagedTXConnection();
            this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            this.triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
            conn.commit();
            Object var10_6 = null;
            if (conn == null) break block18;
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block18;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (conn != null) {
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    }
                    catch (LockException le) {
                        this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doRecoverMisfires() throws JobPersistenceException {
        block19: {
            conn = null;
            moreToDo = false;
            try {
                try {
                    conn = this.getNonManagedTXConnection();
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    try {
                        moreToDo = this.recoverMisfiredJobs(conn);
                    }
                    catch (Exception e) {
                        throw new JobPersistenceException(e.getMessage(), e);
                    }
                    conn.commit();
                    e = moreToDo;
                    var7_6 = null;
                    if (conn == null) return e;
                }
                catch (JobPersistenceException e) {
                    try {
                        if (conn == null) throw e;
                        conn.rollback();
                        throw e;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn == null) throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                        conn.rollback();
                        throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable var6_13) {
                var7_7 = null;
                if (conn == null) throw var6_13;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le) {
                    this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
                }
                try {
                    conn.close();
                    throw var6_13;
                }
                catch (SQLException ignore) {
                    throw var6_13;
                }
            }
            ** try [egrp 5[TRYBLOCK] [6 : 141->157)] { 
lbl52:
            // 1 sources

            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
            break block19;
lbl54:
            // 1 sources

            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
        ** try [egrp 6[TRYBLOCK] [7 : 193->202)] { 
lbl58:
        // 1 sources

        conn.close();
        return e;
lbl60:
        // 1 sources

        catch (SQLException ignore) {
            // empty catch block
        }
        return e;
    }

    /*
     * Loose catch block
     */
    protected boolean doCheckin() throws JobPersistenceException {
        boolean recovered;
        block23: {
            LockException le2;
            boolean obtainedTriggerLock;
            Connection conn;
            block24: {
                conn = null;
                obtainedTriggerLock = false;
                recovered = false;
                conn = this.getNonManagedTXConnection();
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_STATE_ACCESS);
                List failedRecords = this.clusterCheckIn(conn);
                if (failedRecords.size() > 0) {
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    obtainedTriggerLock = true;
                    this.clusterRecover(conn, failedRecords);
                    recovered = true;
                }
                conn.commit();
                Object var8_6 = null;
                if (conn == null) break block23;
                if (!obtainedTriggerLock) break block24;
                try {
                    this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                }
                catch (LockException le2) {
                    this.getLog().error((Object)("Error returning lock: " + le2.getMessage()), (Throwable)le2);
                }
            }
            try {
                this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_STATE_ACCESS);
            }
            catch (LockException le2) {
                this.getLog().error((Object)("Error returning lock: " + le2.getMessage()), (Throwable)le2);
            }
            try {
                conn.close();
            }
            catch (SQLException ignore) {}
            break block23;
            {
                catch (JobPersistenceException e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw new JobPersistenceException("TX failure: " + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (conn != null) {
                    if (obtainedTriggerLock) {
                        try {
                            this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                        }
                        catch (LockException le2) {
                            this.getLog().error((Object)("Error returning lock: " + le2.getMessage()), (Throwable)le2);
                        }
                    }
                    try {
                        this.getLockHandler().releaseLock(conn, JobStoreSupport.LOCK_STATE_ACCESS);
                    }
                    catch (LockException le2) {
                        this.getLog().error((Object)("Error returning lock: " + le2.getMessage()), (Throwable)le2);
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.firstCheckIn = false;
        return recovered;
    }

    private Connection getConnection() throws JobPersistenceException {
        try {
            Connection conn = DBConnectionManager.getInstance().getConnection(this.getDataSource());
            if (conn == null) {
                throw new SQLException("Could not get connection from DataSource '" + this.getDataSource() + "'");
            }
            try {
                if (!this.isDontSetAutoCommitFalse()) {
                    conn.setAutoCommit(false);
                }
            }
            catch (SQLException ingore) {
                // empty catch block
            }
            return conn;
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + sqle.toString(), sqle);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + e.toString(), e, 499);
        }
    }

    private Connection getNonManagedTXConnection() throws JobPersistenceException {
        try {
            Connection conn = DBConnectionManager.getInstance().getConnection(this.getNonManagedTXDataSource());
            if (conn == null) {
                throw new SQLException("Could not get connection from DataSource '" + this.getNonManagedTXDataSource() + "'");
            }
            if (!this.isDontSetNonManagedTXConnectionAutoCommitFalse()) {
                conn.setAutoCommit(false);
            }
            return conn;
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + sqle.toString(), sqle);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getNonManagedTXDataSource() + "': " + e.toString(), e, 499);
        }
    }
}

