/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.util.HashMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.QuartzSchedulerResources;

public class SchedulerRepository {
    private HashMap schedulers = new HashMap();
    private static SchedulerRepository inst;

    private SchedulerRepository() {
    }

    public static synchronized SchedulerRepository getInstance() {
        if (inst == null) {
            inst = new SchedulerRepository();
        }
        return inst;
    }

    public synchronized void bind(Scheduler sched) throws SchedulerException {
        String uId = QuartzSchedulerResources.getUniqueIdentifier(sched.getSchedulerName(), sched.getSchedulerInstanceId());
        if ((Scheduler)this.schedulers.get(uId) != null) {
            throw new SchedulerException("Scheduler '" + uId + "' already exists.", 50);
        }
        this.schedulers.put(uId, sched);
    }

    public synchronized boolean remove(String schedName, String schedInstId) {
        String uId = QuartzSchedulerResources.getUniqueIdentifier(schedName, schedInstId);
        return this.schedulers.remove(uId) != null;
    }

    public synchronized Scheduler lookup(String schedName, String schedInstId) {
        String uId = QuartzSchedulerResources.getUniqueIdentifier(schedName, schedInstId);
        return (Scheduler)this.schedulers.get(uId);
    }

    public synchronized Scheduler[] lookupAll() {
        return this.schedulers.values().toArray(new Scheduler[this.schedulers.size()]);
    }
}

