/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.core.SchedulingContext;

public class RemoteScheduler
implements Scheduler {
    private RemotableQuartzScheduler sched;
    private SchedulingContext schedCtxt;

    public RemoteScheduler(RemotableQuartzScheduler sched, SchedulingContext schedCtxt) {
        this.sched = sched;
        this.schedCtxt = schedCtxt;
    }

    public String getSchedulerName() throws SchedulerException {
        try {
            return this.sched.getSchedulerName();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public String getSchedulerInstanceId() throws SchedulerException {
        try {
            return this.sched.getSchedulerInstanceId();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public SchedulerMetaData getMetaData() throws SchedulerException {
        try {
            return new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), true, this.sched.runningSince() != null, this.isPaused(), this.isShutdown(), this.sched.runningSince(), this.sched.numJobsExecuted(), this.sched.getJobStoreClass(), this.sched.supportsPersistence(), this.sched.getThreadPoolClass(), this.sched.getThreadPoolSize(), this.sched.getVersion());
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public SchedulerContext getContext() throws SchedulerException {
        try {
            return this.sched.getSchedulerContext();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void start() throws SchedulerException {
        try {
            this.sched.start();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void pause() throws SchedulerException {
        try {
            this.sched.pause();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean isPaused() throws SchedulerException {
        try {
            return this.sched.isPaused();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void shutdown() throws SchedulerException {
        try {
            this.sched.shutdown();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        try {
            this.sched.shutdown(waitForJobsToComplete);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean isShutdown() throws SchedulerException {
        try {
            return this.sched.isShutdown();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public List getCurrentlyExecutingJobs() throws SchedulerException {
        try {
            return this.sched.getCurrentlyExecutingJobs();
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        try {
            return this.sched.scheduleJob(this.schedCtxt, jobDetail, trigger);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        try {
            return this.sched.scheduleJob(this.schedCtxt, trigger);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        try {
            this.sched.addJob(this.schedCtxt, jobDetail, replace);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
        try {
            return this.sched.deleteJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
        try {
            return this.sched.unscheduleJob(this.schedCtxt, triggerName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        try {
            this.sched.triggerJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
        try {
            this.sched.triggerJobWithVolatileTrigger(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
        try {
            this.sched.pauseTrigger(this.schedCtxt, triggerName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseTriggerGroup(String groupName) throws SchedulerException {
        try {
            this.sched.pauseTriggerGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        try {
            this.sched.pauseJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseJobGroup(String groupName) throws SchedulerException {
        try {
            this.sched.pauseJobGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
        try {
            this.sched.resumeTrigger(this.schedCtxt, triggerName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeTriggerGroup(String groupName) throws SchedulerException {
        try {
            this.sched.resumeTriggerGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        try {
            this.sched.resumeJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeJobGroup(String groupName) throws SchedulerException {
        try {
            this.sched.resumeJobGroup(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void pauseAll() throws SchedulerException {
        try {
            this.sched.pauseAll(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void resumeAll() throws SchedulerException {
        try {
            this.sched.resumeAll(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getJobGroupNames() throws SchedulerException {
        try {
            return this.sched.getJobGroupNames(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getJobNames(String groupName) throws SchedulerException {
        try {
            return this.sched.getJobNames(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
        try {
            return this.sched.getTriggersOfJob(this.schedCtxt, jobName, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getTriggerGroupNames() throws SchedulerException {
        try {
            return this.sched.getTriggerGroupNames(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getTriggerNames(String groupName) throws SchedulerException {
        try {
            return this.sched.getTriggerNames(this.schedCtxt, groupName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        try {
            return this.sched.getJobDetail(this.schedCtxt, jobName, jobGroup);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        try {
            return this.sched.getTrigger(this.schedCtxt, triggerName, triggerGroup);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
        try {
            return this.sched.getTriggerState(this.schedCtxt, triggerName, triggerGroup);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void addCalendar(String calName, Calendar calendar, boolean replace) throws SchedulerException {
        try {
            this.sched.addCalendar(this.schedCtxt, calName, calendar, replace);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public boolean deleteCalendar(String calName) throws SchedulerException {
        try {
            return this.sched.deleteCalendar(this.schedCtxt, calName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public Calendar getCalendar(String calName) throws SchedulerException {
        try {
            return this.sched.getCalendar(this.schedCtxt, calName);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public String[] getCalendarNames() throws SchedulerException {
        try {
            return this.sched.getCalendarNames(this.schedCtxt);
        }
        catch (RemoteException re) {
            throw new SchedulerException("Error communicating with remote scheduler.", re);
        }
    }

    public void addGlobalJobListener(JobListener jobListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addJobListener(JobListener jobListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeGlobalJobListener(JobListener jobListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeJobListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public List getGlobalJobListeners() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public Set getJobListenerNames() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public JobListener getJobListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeTriggerListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public List getGlobalTriggerListeners() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public Set getTriggerListenerNames() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public TriggerListener getTriggerListener(String name) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public void addSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public boolean removeSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }

    public List getSchedulerListeners() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.", 210);
    }
}

