/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdJobRunShellFactory;
import org.quartz.impl.StdScheduler;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;

public class DirectSchedulerFactory
implements SchedulerFactory {
    public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
    public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
    private SchedulerException initException = null;
    private boolean initialized = false;
    private static DirectSchedulerFactory instance = new DirectSchedulerFactory();
    static /* synthetic */ Class class$org$quartz$impl$DirectSchedulerFactory;

    private Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$impl$DirectSchedulerFactory == null ? (class$org$quartz$impl$DirectSchedulerFactory = DirectSchedulerFactory.class$("org.quartz.impl.DirectSchedulerFactory")) : class$org$quartz$impl$DirectSchedulerFactory));
    }

    protected DirectSchedulerFactory() {
    }

    public static DirectSchedulerFactory getInstance() {
        return instance;
    }

    public void createVolatileSchduler(int maxThreads) throws SchedulerException {
        SimpleThreadPool threadPool = new SimpleThreadPool(maxThreads, 5);
        threadPool.initialize();
        RAMJobStore jobStore = new RAMJobStore();
        this.createScheduler(threadPool, jobStore);
    }

    public void createRemoteScheduler(String rmiHost, int rmiPort) throws SchedulerException {
        this.createRemoteScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, rmiHost, rmiPort);
        this.initialized = true;
    }

    protected void createRemoteScheduler(String schedulerName, String schedulerInstanceId, String rmiHost, int rmiPort) throws SchedulerException {
        SchedulingContext schedCtxt = null;
        schedCtxt = new SchedulingContext();
        schedCtxt.setInstanceId(schedulerInstanceId);
        RemotableQuartzScheduler rqs = null;
        try {
            Registry registry = LocateRegistry.getRegistry(rmiHost, rmiPort);
            String uid = QuartzSchedulerResources.getUniqueIdentifier(schedulerName, schedulerInstanceId);
            rqs = (RemotableQuartzScheduler)registry.lookup(uid);
        }
        catch (Exception e) {
            this.initException = new SchedulerException("Could not get handle to remote scheduler.", e);
            this.initException.setErrorCode(50);
            throw this.initException;
        }
        RemoteScheduler remoteScheduler = new RemoteScheduler(rqs, schedCtxt);
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        schedRep.bind(remoteScheduler);
    }

    public void createScheduler(ThreadPool threadPool, JobStore jobStore) throws SchedulerException {
        this.createScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, threadPool, jobStore);
        this.initialized = true;
    }

    public void createScheduler(String schedulerName, String schedulerInstanceId, ThreadPool threadPool, JobStore jobStore) throws SchedulerException {
        this.createScheduler(schedulerName, schedulerInstanceId, threadPool, jobStore, null, 0, -1);
    }

    public void createScheduler(String schedulerName, String schedulerInstanceId, ThreadPool threadPool, JobStore jobStore, String rmiRegistryHost, int rmiRegistryPort, int idleWaitTime) throws SchedulerException {
        StdJobRunShellFactory jrsf = new StdJobRunShellFactory();
        SchedulingContext schedCtxt = new SchedulingContext();
        schedCtxt.setInstanceId(schedulerInstanceId);
        QuartzSchedulerResources qrs = new QuartzSchedulerResources();
        qrs.setName(schedulerName);
        qrs.setInstanceId(schedulerInstanceId);
        qrs.setJobRunShellFactory(jrsf);
        qrs.setThreadPool(threadPool);
        qrs.setJobStore(jobStore);
        qrs.setRMIRegistryHost(rmiRegistryHost);
        qrs.setRMIRegistryPort(rmiRegistryPort);
        QuartzScheduler qs = new QuartzScheduler(qrs, schedCtxt, idleWaitTime);
        CascadingClassLoadHelper cch = new CascadingClassLoadHelper();
        cch.initialize();
        jobStore.initialize(cch, qs.getSchedulerSignaler());
        StdScheduler scheduler = new StdScheduler(qs, schedCtxt);
        jrsf.initialize(scheduler, schedCtxt);
        this.getLog().info((Object)("Quartz scheduler '" + scheduler.getSchedulerName()));
        this.getLog().info((Object)("Quartz scheduler version: " + qs.getVersion()));
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        qs.addNoGCObject(schedRep);
        schedRep.bind(scheduler);
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (!this.initialized) {
            throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
        }
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        Scheduler sched = schedRep.lookup(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID);
        return sched;
    }

    public Scheduler getScheduler(String schedName, String schedInstId) throws SchedulerException {
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        Scheduler sched = schedRep.lookup(schedName, schedInstId);
        return sched;
    }

    public Scheduler[] getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

