/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.transaction.UserTransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.JobRunShell;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.SchedulingContext;
import org.quartz.ee.jta.UserTransactionHelper;

public class JTAJobRunShell
extends JobRunShell {
    private UserTransaction ut;
    private UserTransactionHelper userTxHelper;

    public JTAJobRunShell(JobRunShellFactory jobRunShellFactory, Scheduler scheduler, SchedulingContext schdCtxt, UserTransactionHelper userTxHelper) {
        super(jobRunShellFactory, scheduler, schdCtxt);
        this.userTxHelper = userTxHelper;
    }

    protected void begin() throws SchedulerException {
        try {
            this.ut = this.userTxHelper.lookup();
            this.ut.begin();
        }
        catch (SchedulerException se) {
            throw se;
        }
        catch (Exception nse) {
            throw new SchedulerException("JTAJobRunShell could not start UserTransaction.", nse);
        }
    }

    protected void complete(boolean successfulExecution) throws SchedulerException {
        if (this.ut != null && successfulExecution) {
            try {
                this.ut.commit();
            }
            catch (Exception nse) {
                throw new SchedulerException("JTAJobRunShell could not commit UserTransaction.", nse);
            }
        }
        if (this.ut != null && !successfulExecution) {
            try {
                this.ut.rollback();
            }
            catch (Exception nse) {
                throw new SchedulerException("JTAJobRunShell could not rollback UserTransaction.", nse);
            }
        }
        this.ut = null;
    }
}

