/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.spi.SchedulerSignaler;

public class SchedulerSignalerImpl
implements SchedulerSignaler {
    private QuartzScheduler sched;
    private QuartzSchedulerThread schedThread;

    SchedulerSignalerImpl(QuartzScheduler sched, QuartzSchedulerThread schedThread) {
        this.sched = sched;
        this.schedThread = schedThread;
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) {
        try {
            this.sched.notifyTriggerListenersMisfired(trigger);
        }
        catch (SchedulerException se) {
            QuartzScheduler.getLog().error((Object)"Error notifying listeners of trigger misfire.", (Throwable)se);
            this.sched.notifySchedulerListenersError("Error notifying listeners of trigger misfire.", se);
        }
    }

    public void signalSchedulingChange() {
        this.schedThread.signalSchedulingChange();
    }
}

