/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.JobPersistenceException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.JobRunShell;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.SchedulingContext;
import org.quartz.spi.TriggerFiredBundle;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private Object pauseLock = new Object();
    private Object idleLock = new Object();
    private boolean signaled;
    private boolean paused;
    private boolean halted;
    private SchedulingContext ctxt = null;
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt) {
        this(qs, qsRsrcs, ctxt, false, 5);
    }

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt, boolean setDaemon, int threadPrio) {
        super(qs.getSchedulerThreadGroup(), "QuartzSchedulerThread");
        this.qs = qs;
        this.qsRsrcs = qsRsrcs;
        this.ctxt = ctxt;
        this.setDaemon(setDaemon);
        this.setPriority(threadPrio);
        this.paused = true;
        this.halted = false;
        this.start();
    }

    void setIdleWaitTime(long waitTime) {
        this.idleWaitTime = waitTime;
    }

    void togglePause(boolean pause) {
        Object object = this.pauseLock;
        synchronized (object) {
            this.paused = pause;
            if (this.paused) {
                this.signalSchedulingChange();
            } else {
                this.pauseLock.notify();
            }
        }
    }

    void halt() {
        Object object = this.pauseLock;
        synchronized (object) {
            this.halted = true;
            if (this.paused) {
                this.pauseLock.notify();
            } else {
                this.signalSchedulingChange();
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    void signalSchedulingChange() {
        Object object = this.idleLock;
        synchronized (object) {
            this.signaled = true;
            this.idleLock.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.halted) {
            Object object = this.pauseLock;
            synchronized (object) {
                while (this.paused && !this.halted) {
                    try {
                        this.pauseLock.wait(200L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                if (this.halted) {
                    break;
                }
            }
            Trigger trigger = null;
            Object jobDetail = null;
            Object cal = null;
            boolean idleWait = true;
            try {
                trigger = this.qsRsrcs.getJobStore().acquireNextTrigger(this.ctxt);
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while scanning for the next trigger to fire.", jpe);
            }
            if (trigger != null) {
                long now = System.currentTimeMillis();
                long timeUntilTrigger = trigger.getNextFireTime().getTime() - now;
                if (timeUntilTrigger <= this.idleWaitTime) {
                    if (timeUntilTrigger > 10L) {
                        Object object2 = this.idleLock;
                        synchronized (object2) {
                            try {
                                if (!this.signaled) {
                                    this.idleLock.wait(timeUntilTrigger);
                                }
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                            if (this.signaled) {
                                try {
                                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                                }
                                catch (JobPersistenceException jpe) {
                                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                                    this.releaseTriggerRetryLoop(trigger);
                                }
                                this.signaled = false;
                                continue;
                            }
                        }
                    }
                    TriggerFiredBundle bndle = null;
                    try {
                        bndle = this.qsRsrcs.getJobStore().triggerFired(this.ctxt, trigger);
                    }
                    catch (SchedulerException se) {
                        this.qs.notifySchedulerListenersError("An error occured while firing trigger '" + trigger.getFullName() + "'", se);
                    }
                    if (bndle == null) {
                        try {
                            this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                        }
                        catch (SchedulerException se) {
                            this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se);
                            this.releaseTriggerRetryLoop(trigger);
                        }
                        continue;
                    }
                    JobRunShell shell = this.qsRsrcs.getJobRunShellFactory().borrowJobRunShell();
                    shell.initialize(this.qs, trigger, bndle.getCalendar(), bndle.getJobDetail(), bndle.isRecovering());
                    this.qsRsrcs.getThreadPool().runInThread(shell);
                    idleWait = false;
                } else {
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (JobPersistenceException jpe) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    idleWait = true;
                }
            }
            Object object3 = this.idleLock;
            synchronized (object3) {
                if (idleWait && !this.signaled) {
                    try {
                        this.idleLock.wait(this.idleWaitTime);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                this.signaled = false;
            }
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    public void releaseTriggerRetryLoop(Trigger trigger) {
        while (!this.halted) {
            try {
                Thread.sleep(5000L);
                this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                break;
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

