/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.util.system;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.excalibur.util.CPUParser;

public final class Linux
implements CPUParser {
    private final int m_processors;
    private final String m_cpuInfo;

    public Linux() {
        int procs = 1;
        String info = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader("/proc/cpuinfo"));
            procs = 0;
            Properties props = new Properties();
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] args = Linux.split(line, ":\t");
                if (args.length <= 1) continue;
                props.setProperty(args[0].trim(), args[1].trim());
                if (!args[0].trim().equals("processor")) continue;
                ++procs;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(props.getProperty("model name"));
            buf.append(" Family ");
            buf.append(props.getProperty("cpu family"));
            buf.append(" Model ");
            buf.append(props.getProperty("model"));
            buf.append(" Stepping ");
            buf.append(props.getProperty("stepping"));
            buf.append(", ");
            buf.append(props.getProperty("vendor_id"));
            info = buf.toString();
        }
        catch (Exception e) {
            procs = 1;
            e.printStackTrace();
        }
        this.m_processors = procs;
        this.m_cpuInfo = info;
    }

    public int numProcessors() {
        return this.m_processors;
    }

    public String cpuInfo() {
        return this.m_cpuInfo;
    }

    private static final String[] split(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }
}

