/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.altrmi.common.AltrmiRuntimeException;
import org.apache.altrmi.common.ThreadContext;
import org.apache.altrmi.server.ServerException;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.adapters.InvocationHandlerAdapter;
import org.apache.altrmi.server.impl.socket.SocketStreamServerConnection;

public abstract class AbstractCompleteSocketStreamServer
extends AbstractServer
implements Runnable {
    private ServerSocket m_serverSocket;
    private ThreadContext m_threadContext;

    public AbstractCompleteSocketStreamServer(int port) throws ServerException {
        this(new InvocationHandlerAdapter(), port);
    }

    public AbstractCompleteSocketStreamServer(InvocationHandlerAdapter invocationHandlerAdapter, int port) throws ServerException {
        super(invocationHandlerAdapter);
        try {
            this.m_serverSocket = new ServerSocket(port);
        }
        catch (IOException ioe) {
            throw new ServerException("Could not bind to a socket when setting up the server", (Throwable)ioe);
        }
    }

    public void run() {
        block3: {
            boolean accepting = false;
            try {
                while (this.getState() == 303) {
                    accepting = true;
                    Socket sock = this.m_serverSocket.accept();
                    accepting = false;
                    sock.setSoTimeout(36000);
                    AbstractServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
                    ssrw.setStreams(sock.getInputStream(), sock.getOutputStream(), sock);
                    SocketStreamServerConnection sssc = new SocketStreamServerConnection(this, sock, ssrw);
                    sssc.setServerMonitor(this.getServerMonitor());
                    ThreadContext threadContext = this.getThreadPool().getThreadContext((Runnable)sssc);
                    threadContext.start();
                }
            }
            catch (IOException ioe) {
                if (accepting & ioe.getMessage().equals("socket closed")) break block3;
                this.getServerMonitor().connectionProblem(this.getClass(), "AbstractCompleteSocketStreamServer.run(): Some problem connecting client via sockets: ", ioe);
            }
        }
    }

    public void start() {
        this.setState(202);
        this.getThreadContext().start();
        this.setState(303);
    }

    public void stop() {
        this.setState(101);
        try {
            this.m_serverSocket.close();
        }
        catch (IOException ioe) {
            throw new AltrmiRuntimeException("Error stopping Complete Socket server", (Throwable)ioe);
        }
        this.killAllConnections();
        this.getThreadContext().interrupt();
        this.setState(404);
    }

    private ThreadContext getThreadContext() {
        if (this.m_threadContext == null) {
            this.m_threadContext = this.getThreadPool().getThreadContext((Runnable)this);
        }
        return this.m_threadContext;
    }

    protected abstract AbstractServerStreamReadWriter createServerStreamReadWriter();
}

