/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.piped;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ThreadContext;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.adapters.InvocationHandlerAdapter;
import org.apache.altrmi.server.impl.piped.PipedStreamServerConnection;

public abstract class AbstractPipedServer
extends AbstractServer {
    public AbstractPipedServer() {
        this(new InvocationHandlerAdapter());
    }

    public AbstractPipedServer(InvocationHandlerAdapter invocationHandlerAdapter) {
        super(invocationHandlerAdapter);
    }

    public void makeNewConnection(PipedInputStream in, PipedOutputStream out) throws ConnectionException {
        if (this.getState() == 505 | this.getState() == 202) {
            throw new ConnectionException("Server not started yet");
        }
        if (this.getState() == 101) {
            throw new ConnectionException("Server is Shutting down");
        }
        try {
            PipedInputStream pIS = new PipedInputStream();
            PipedOutputStream pOS = new PipedOutputStream();
            pIS.connect(out);
            in.connect(pOS);
            AbstractServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
            ssrw.setStreams(pIS, pOS, "piped");
            PipedStreamServerConnection pssc = new PipedStreamServerConnection(this, pIS, pOS, ssrw);
            pssc.setServerMonitor(this.getServerMonitor());
            ThreadContext thread = this.getThreadPool().getThreadContext((Runnable)pssc);
            thread.start();
        }
        catch (IOException pe) {
            throw new ConnectionException("Some problem setting up server : " + pe.getMessage());
        }
    }

    public void start() {
        this.setState(303);
    }

    public void stop() {
        this.setState(101);
        this.killAllConnections();
        this.setState(404);
    }

    protected abstract AbstractServerStreamReadWriter createServerStreamReadWriter();
}

