/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.classretrievers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.altrmi.server.ClassRetrievalException;
import org.apache.altrmi.server.impl.classretrievers.AbstractClassRetriever;

public class PlainClassRetriever
extends AbstractClassRetriever {
    private ClassLoader m_classLoader;

    public PlainClassRetriever() {
        this.m_classLoader = this.getClass().getClassLoader();
    }

    public PlainClassRetriever(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    protected byte[] getThingBytes(String thingName) throws ClassRetrievalException {
        InputStream is = null;
        is = this.m_classLoader.getResourceAsStream(thingName + ".class");
        if (is == null) {
            throw new ClassRetrievalException("Generated class for " + thingName + " not found in specified classloader ");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        try {
            while (-1 != (i = is.read())) {
                baos.write(i);
            }
            is.close();
        }
        catch (IOException e) {
            throw new ClassRetrievalException("Error retrieving generated class bytes : " + e.getMessage());
        }
        return baos.toByteArray();
    }
}

