/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.callback.stream;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.altrmi.client.ConnectionClosedException;
import org.apache.altrmi.client.HostContext;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ExposedObjectProxy;
import org.apache.altrmi.common.InvocationExceptionReply;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.ReqRepBytes;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.SerializationHelper;
import org.apache.altrmi.common.ThreadContext;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.callback.CallbackHostContext;
import org.apache.altrmi.server.impl.callback.CallbackServerClassFactory;
import org.apache.altrmi.server.impl.callback.socket.CallbackServerClientReadWriter;
import org.apache.altrmi.server.impl.callback.stream.CallbackStreamInvocationHandler;

public class CallbackEnabledCustomStreamReadWriter
extends AbstractServerStreamReadWriter
implements Runnable {
    private DataInputStream m_dataInputStream;
    private DataOutputStream m_dataOutputStream;
    private ThreadContext m_messageLoopThread = null;
    private boolean m_isStopped = false;
    private Object m_requestLock = new Object();
    private Object m_replyLock = new Object();
    private Request m_request = null;
    private Reply m_reply = null;
    private CallbackServerClientReadWriter m_callbackServerClientReadWriter;
    private CallbackStreamInvocationHandler m_callbackStreamInvocationHandler;
    private CallbackHostContext m_callbackHostContext;
    private CallbackServerClassFactory m_altrmiFactory;

    protected void initialize() throws IOException {
        this.m_dataInputStream = new DataInputStream(this.getInputStream());
        this.m_dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.getOutputStream()));
        this.m_messageLoopThread = this.getThreadPool().getThreadContext((Runnable)this);
        this.m_messageLoopThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_callbackServerClientReadWriter = new CallbackServerClientReadWriter(this);
        this.m_callbackStreamInvocationHandler = new CallbackStreamInvocationHandler(this.getClass().getClassLoader());
        this.m_callbackStreamInvocationHandler.setObjectReadWriter(this.m_callbackServerClientReadWriter);
        this.m_callbackHostContext = new CallbackHostContext(this.m_callbackStreamInvocationHandler);
        this.m_altrmiFactory = new CallbackServerClassFactory();
        this.m_altrmiFactory.setInitializedHostContext((HostContext)this.m_callbackHostContext);
        while (!this.m_isStopped) {
            Object obj;
            ReqRepBytes reqRepBytes = ReqRepBytes.getRequestReplyBytesFromDataStream((DataInputStream)this.m_dataInputStream);
            if (reqRepBytes.getIOException() != null) {
                IOException ioe = reqRepBytes.getIOException();
                if (ioe != null && (ioe instanceof EOFException && reqRepBytes.ioeDuringReadInt() || ioe instanceof SocketException)) {
                    this.m_serverMonitor.closeError(this.getClass(), "Close During callback operation", ioe);
                    this.m_isStopped = true;
                    this.notifyBoth();
                    return;
                }
                this.m_serverMonitor.unexpectedException(this.getClass(), "Problem during reading of bytes", (Exception)ioe);
            }
            if (reqRepBytes.isRequest()) {
                try {
                    obj = SerializationHelper.getInstanceFromBytes((byte[])reqRepBytes.getBytes());
                    this.m_request = (Request)obj;
                }
                catch (ClassNotFoundException e) {
                    this.m_serverMonitor.classNotFound(this.getClass(), e);
                    this.m_request = null;
                    this.m_isStopped = true;
                    return;
                }
                Object e = this.m_requestLock;
                synchronized (e) {
                    this.m_requestLock.notify();
                    continue;
                }
            }
            try {
                obj = SerializationHelper.getInstanceFromBytes((byte[])reqRepBytes.getBytes());
                this.m_reply = (Reply)obj;
            }
            catch (ClassNotFoundException e) {
                this.m_serverMonitor.classNotFound(this.getClass(), e);
                this.m_reply = new InvocationExceptionReply("ClassNotFoundException " + e.getMessage());
            }
            Object object = this.m_replyLock;
            synchronized (object) {
                this.m_replyLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBoth() {
        this.m_isStopped = true;
        Object object = this.m_requestLock;
        synchronized (object) {
            this.m_requestLock.notify();
        }
        Object object2 = this.m_replyLock;
        synchronized (object2) {
            this.m_replyLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request getRequestFromMessageLoop() {
        if (this.m_request == null) {
            Object object = this.m_requestLock;
            synchronized (object) {
                try {
                    this.m_requestLock.wait();
                }
                catch (InterruptedException e) {
                    this.m_serverMonitor.unexpectedException(this.getClass(), "Wait issue", (Exception)e);
                }
            }
        }
        return this.m_request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reply getReplyFromMessageLoop() {
        if (this.m_reply == null) {
            Object object = this.m_replyLock;
            synchronized (object) {
                try {
                    this.m_replyLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.m_reply;
    }

    protected Request writeReplyAndGetRequest(Reply altrmiReply) throws IOException, ClassNotFoundException {
        if (altrmiReply != null) {
            this.writeReply(altrmiReply);
        }
        Request req = this.readRequest();
        this.m_request = null;
        return req;
    }

    private void writeReply(Reply altrmiReply) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiReply);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.writeBoolean(false);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    private Request readRequest() {
        Request altrmiRequest = this.getRequestFromMessageLoop();
        if (altrmiRequest instanceof MethodRequest) {
            this.correctArgs(((MethodRequest)altrmiRequest).getArgs());
        }
        return altrmiRequest;
    }

    public Reply postRequest(Request altrmiRequest) throws IOException, ClassNotFoundException {
        if (this.m_isStopped) {
            throw new ConnectionClosedException("Client Closed Connection");
        }
        this.writeRequest(altrmiRequest);
        Reply r = this.getReplyFromMessageLoop();
        if (r == null) {
            throw new InterruptedIOException("Client Connection Closed");
        }
        this.m_reply = null;
        return r;
    }

    private void writeRequest(Request altrmiRequest) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiRequest);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.writeBoolean(true);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    public void correctArgs(Object[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof ExposedObjectProxy) {
                ExposedObjectProxy exposedObjectProxy = (ExposedObjectProxy)args[i];
                try {
                    Object obj;
                    args[i] = obj = this.m_altrmiFactory.lookup(exposedObjectProxy.getPublishedName());
                }
                catch (ConnectionException connectionException) {
                    this.m_serverMonitor.connectionProblem(this.getClass(), "Connection issue on lookup", (IOException)((Object)connectionException));
                }
            }
            ++i;
        }
    }
}

