/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.altrmi.common.BadConnectionException;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.SerializationHelper;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;

public class ServerCustomStreamReadWriter
extends AbstractServerStreamReadWriter {
    private DataInputStream m_dataInputStream;
    private DataOutputStream m_dataOutputStream;

    protected void initialize() throws IOException {
        this.m_dataInputStream = new DataInputStream(this.getInputStream());
        this.m_dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.getOutputStream()));
    }

    protected synchronized Request writeReplyAndGetRequest(Reply altrmiReply) throws IOException, ClassNotFoundException, ConnectionException {
        if (altrmiReply != null) {
            this.writeReply(altrmiReply);
        }
        return this.readRequest();
    }

    private void writeReply(Reply altrmiReply) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiReply);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    protected void close() {
        try {
            this.m_dataInputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.m_dataOutputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        super.close();
    }

    private Request readRequest() throws IOException, ClassNotFoundException, ConnectionException {
        int byteArraySize = this.m_dataInputStream.readInt();
        if (byteArraySize < 0) {
            throw new BadConnectionException("Transport mismatch, Unable to read packet of data from CustomStream.");
        }
        byte[] byteArray = new byte[byteArraySize];
        int pos = 0;
        int cnt = 0;
        while (pos < byteArraySize) {
            int read = this.m_dataInputStream.read(byteArray, pos, byteArraySize - pos);
            pos += read;
            ++cnt;
        }
        return (Request)SerializationHelper.getInstanceFromBytes((byte[])byteArray);
    }
}

