/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl;

import java.util.Vector;
import org.apache.altrmi.common.DefaultThreadPool;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.common.ThreadPoolAware;
import org.apache.altrmi.server.Authenticator;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.MethodInvocationHandler;
import org.apache.altrmi.server.PublicationDescription;
import org.apache.altrmi.server.PublicationException;
import org.apache.altrmi.server.Server;
import org.apache.altrmi.server.ServerConnection;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.impl.ConsoleServerMonitor;
import org.apache.altrmi.server.impl.adapters.InvocationHandlerAdapter;

public abstract class AbstractServer
implements Server,
ThreadPoolAware {
    private Vector m_connections = new Vector();
    private InvocationHandlerAdapter m_invocationHandlerAdapter;
    private int m_state = 505;
    private ServerMonitor m_serverMonitor;
    private ThreadPool m_threadPool;

    public AbstractServer(InvocationHandlerAdapter invocationHandlerAdapter) {
        this.m_invocationHandlerAdapter = invocationHandlerAdapter;
    }

    public void setServerMonitor(ServerMonitor serverMonitor) {
        this.m_serverMonitor = serverMonitor;
    }

    protected synchronized ServerMonitor getServerMonitor() {
        if (this.m_serverMonitor == null) {
            this.m_serverMonitor = new ConsoleServerMonitor();
        }
        return this.m_serverMonitor;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.m_threadPool = threadPool;
    }

    public synchronized ThreadPool getThreadPool() {
        if (this.m_threadPool == null) {
            this.m_threadPool = new DefaultThreadPool();
        }
        return this.m_threadPool;
    }

    public final void setClassRetriever(ClassRetriever classRetriever) {
        this.m_invocationHandlerAdapter.setClassRetriever(classRetriever);
    }

    public final void setAuthenticator(Authenticator altrmiAuthenticator) {
        this.m_invocationHandlerAdapter.setAuthenticator(altrmiAuthenticator);
    }

    public Reply handleInvocation(Request request, Object connectionDetails) {
        return this.m_invocationHandlerAdapter.handleInvocation(request, connectionDetails);
    }

    public void suspend() {
        this.m_invocationHandlerAdapter.suspend();
    }

    public void resume() {
        this.m_invocationHandlerAdapter.resume();
    }

    protected void connectionStart(ServerConnection altrmiConnection) {
        this.m_connections.add(altrmiConnection);
    }

    protected void connectionCompleted(ServerConnection altrmiConnection) {
        this.m_connections.remove(altrmiConnection);
    }

    protected void killAllConnections() {
        ServerConnection[] connections = this.m_connections.toArray(new ServerConnection[0]);
        int i = 0;
        while (i < connections.length) {
            connections[i].endConnection();
            ++i;
        }
    }

    public void publish(Object impl, String asName, Class interfaceToExpose) throws PublicationException {
        this.m_invocationHandlerAdapter.publish(impl, asName, interfaceToExpose);
    }

    public void publish(Object impl, String asName, PublicationDescription publicationDescription) throws PublicationException {
        this.m_invocationHandlerAdapter.publish(impl, asName, publicationDescription);
    }

    public void unPublish(Object impl, String asName) throws PublicationException {
        this.m_invocationHandlerAdapter.unPublish(impl, asName);
    }

    public void replacePublished(Object oldImpl, String publishedName, Object withImpl) throws PublicationException {
        this.m_invocationHandlerAdapter.replacePublished(oldImpl, publishedName, withImpl);
    }

    public MethodInvocationHandler getMethodInvocationHandler(MethodRequest methodRequest, String objectName) {
        return this.m_invocationHandlerAdapter.getMethodInvocationHandler(methodRequest, objectName);
    }

    public MethodInvocationHandler getMethodInvocationHandler(String publishedName) {
        return this.m_invocationHandlerAdapter.getMethodInvocationHandler(publishedName);
    }

    public InvocationHandlerAdapter getInovcationHandlerAdapter() {
        return this.m_invocationHandlerAdapter;
    }

    protected void setState(int state) {
        this.m_state = state;
    }

    protected int getState() {
        return this.m_state;
    }
}

