/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.configuration;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class NamingConfigurationBuilder {
    private final boolean m_enableNamespaces;

    public NamingConfigurationBuilder() {
        this(false);
    }

    public NamingConfigurationBuilder(boolean enableNamespaces) {
        this.m_enableNamespaces = enableNamespaces;
    }

    public Configuration build(String uri) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.provider.url", uri);
        InitialDirContext context = new InitialDirContext(env);
        return this.build(context);
    }

    public Configuration build(Context context) throws NamingException {
        DefaultConfiguration configuration;
        String absoluteName = context.getNameInNamespace();
        NameParser parser = context.getNameParser(absoluteName);
        Name parsedName = parser.parse(absoluteName);
        String name = absoluteName;
        String prefix = "";
        int position = parsedName.size();
        if (position > 0) {
            name = parsedName.get(position - 1);
        }
        if (context instanceof DirContext) {
            Attributes attrs = ((DirContext)context).getAttributes("");
            NamingEnumeration<? extends Attribute> attributes = attrs.getAll();
            while (attributes.hasMore()) {
                Attribute attribute = attributes.next();
                String id = attribute.getID();
                if (!name.startsWith(id)) continue;
                name = (String)attribute.get();
                if (this.m_enableNamespaces) {
                    prefix = id;
                }
                attrs.remove(id);
                break;
            }
            configuration = new DefaultConfiguration(name, null, "", prefix);
            this.copyAttributes(attrs, configuration);
        } else {
            configuration = new DefaultConfiguration(name, null, "", prefix);
        }
        NamingEnumeration<Binding> bindings = context.listBindings("");
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            Object object = binding.getObject();
            if (object instanceof Number || object instanceof String) {
                configuration.setValue(object.toString());
            }
            if (!(object instanceof Context)) continue;
            Context child = (Context)object;
            configuration.addChild(this.build(child));
        }
        return configuration;
    }

    private void copyAttributes(Attributes attrs, DefaultConfiguration configuration) throws NamingException {
        NamingEnumeration<? extends Attribute> attributes = attrs.getAll();
        while (attributes.hasMore()) {
            Attribute attribute = attributes.next();
            String attrName = attribute.getID();
            Object attrValue = attribute.get();
            configuration.setAttribute(attrName, attrValue.toString());
        }
    }
}

