/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import com.coyotegulch.jisp.BTreeIndex;
import com.coyotegulch.jisp.BTreeIterator;
import com.coyotegulch.jisp.IndexedObjectDatabase;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.impl.AbstractReadWriteStore;
import org.apache.excalibur.store.impl.JispKey;

public abstract class AbstractJispFilesystemStore
extends AbstractReadWriteStore
implements Store,
ThreadSafe {
    protected File m_directoryFile;
    protected IndexedObjectDatabase m_Database;
    protected BTreeIndex m_Index;

    public void setDirectory(File directory) throws IOException {
        this.m_directoryFile = directory;
        if (!this.m_directoryFile.exists() && !this.m_directoryFile.mkdirs()) {
            throw new IOException("Error creating store directory '" + this.m_directoryFile.getAbsolutePath() + "'. ");
        }
        if (!this.m_directoryFile.isDirectory()) {
            throw new IOException("'" + this.m_directoryFile.getAbsolutePath() + "' is not a directory");
        }
        if (!this.m_directoryFile.canRead() || !this.m_directoryFile.canWrite()) {
            throw new IOException("Directory '" + this.m_directoryFile.getAbsolutePath() + "' is not readable/writable");
        }
    }

    protected Object doGet(Object key) {
        Object value;
        block3: {
            value = null;
            try {
                value = this.m_Database.read(this.wrapKeyObject(key), (ObjectIndex)this.m_Index);
                if (!this.getLogger().isDebugEnabled()) break block3;
                if (value != null) {
                    this.getLogger().debug("Found key: " + key);
                    break block3;
                }
                this.getLogger().debug("NOT Found key: " + key);
            }
            catch (Exception e) {
                this.getLogger().error("get(..): Exception", (Throwable)e);
            }
        }
        return value;
    }

    protected void doStore(Object key, Object value) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("store(): Store file with key: " + key.toString());
            this.getLogger().debug("store(): Store file with value: " + value.toString());
        }
        if (value instanceof Serializable) {
            try {
                KeyObject[] keyArray = new KeyObject[]{this.wrapKeyObject(key)};
                this.m_Database.write(keyArray, (Serializable)value);
            }
            catch (Exception e) {
                this.getLogger().error("store(..): Exception", (Throwable)e);
            }
        } else {
            throw new IOException("Object not Serializable");
        }
    }

    public void free() {
    }

    protected void doFree() {
    }

    protected void doClear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("clear(): Clearing the database ");
        }
        try {
            Object tmp;
            BTreeIterator iter = new BTreeIterator(this.m_Index);
            do {
                if ((tmp = iter.getKey()) == null) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("clear(): Removing key: " + tmp.toString());
                }
                iter.moveNext();
                this.remove(tmp);
            } while (tmp != null);
        }
        catch (Exception ignore) {
            this.getLogger().error("store(..): Exception", (Throwable)ignore);
        }
    }

    protected void doRemove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("remove(..) Remove item");
        }
        try {
            KeyObject[] keyArray = new KeyObject[]{this.wrapKeyObject(key)};
            this.m_Database.remove(keyArray);
        }
        catch (KeyNotFound ignore) {
        }
        catch (Exception e) {
            this.getLogger().error("remove(..): Exception", (Throwable)e);
        }
    }

    protected boolean doContainsKey(Object key) {
        long res = -1L;
        try {
            res = this.m_Index.findKey(this.wrapKeyObject(key));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("containsKey(..): res=" + res);
            }
        }
        catch (KeyNotFound ignore) {
        }
        catch (Exception e) {
            this.getLogger().error("containsKey(..): Exception", (Throwable)e);
        }
        return res > 0L;
    }

    protected Enumeration doGetKeys() {
        try {
            return new BTreeObjectEnumeration(new BTreeIterator(this.m_Index), this);
        }
        catch (Exception ignore) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    }

    protected int doGetSize() {
        return this.m_Index.count();
    }

    protected KeyObject wrapKeyObject(Object key) {
        return new JispKey(key);
    }

    protected KeyObject getNullKey() {
        return new JispKey().makeNullKey();
    }

    class BTreeObjectEnumeration
    implements Enumeration {
        private Object m_Next;
        private BTreeIterator m_Iterator;
        private AbstractJispFilesystemStore m_Store;

        public BTreeObjectEnumeration(BTreeIterator iterator, AbstractJispFilesystemStore store) {
            this.m_Iterator = iterator;
            this.m_Store = store;
            try {
                this.m_Next = this.m_Iterator.getKey();
            }
            catch (IOException ioe) {
                this.m_Store.getLogger().error("store(..): Exception", (Throwable)ioe);
                this.m_Next = null;
            }
        }

        public boolean hasMoreElements() {
            return this.m_Next != null;
        }

        public Object nextElement() throws NoSuchElementException {
            Object tmp;
            block5: {
                if (this.m_Next == null) {
                    throw new NoSuchElementException();
                }
                tmp = this.m_Next;
                try {
                    if (this.m_Iterator.moveNext()) {
                        this.m_Next = this.m_Iterator.getKey();
                        break block5;
                    }
                    this.m_Next = null;
                }
                catch (IOException ioe) {
                    this.m_Store.getLogger().error("store(..): Exception", (Throwable)ioe);
                    this.m_Next = null;
                }
                catch (ClassNotFoundException cnfe) {
                    this.m_Store.getLogger().error("store(..): Exception", (Throwable)cnfe);
                    this.m_Next = null;
                }
            }
            return ((JispKey)((Object)tmp)).getKey();
        }
    }
}

