/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.xpath;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.jaxen.JaxenException;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.saxpath.SAXPathException;

class JaxenXPath
extends XPath {
    private transient JDOMXPath xPath;

    public JaxenXPath(String expr) throws JDOMException {
        super(expr);
        this.setXPath(expr);
    }

    public boolean equals(Object o) {
        if (o instanceof JaxenXPath) {
            JaxenXPath x = (JaxenXPath)o;
            return super.equals(o) && this.xPath.toString().equals(x.xPath.toString());
        }
        return false;
    }

    public String getXPath() {
        return this.xPath.toString();
    }

    public int hashCode() {
        return this.xPath.hashCode();
    }

    public Number numberValueOf(Object context) throws JDOMException {
        try {
            return this.xPath.numberValueOf(context);
        }
        catch (JaxenException ex1) {
            throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            this.setXPath(in.readUTF());
        }
        catch (JDOMException ex1) {
            throw new IOException(ex1.toString());
        }
    }

    public List selectNodes(Object context) throws JDOMException {
        try {
            return this.xPath.selectNodes(context);
        }
        catch (JaxenException ex1) {
            throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
        }
    }

    public Object selectSingleNode(Object context) throws JDOMException {
        try {
            return this.xPath.selectSingleNode(context);
        }
        catch (JaxenException ex1) {
            throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
        }
    }

    public void setVariable(String name, Object value) throws IllegalArgumentException {
        VariableContext o = this.xPath.getVariableContext();
        if (o instanceof SimpleVariableContext) {
            ((SimpleVariableContext)o).setVariableValue(null, name, value);
        }
    }

    private void setXPath(String expr) throws JDOMException {
        try {
            this.xPath = new JDOMXPath(expr);
        }
        catch (SAXPathException ex1) {
            throw new JDOMException("Invalid XPath expression: \"" + expr + "\"", ex1);
        }
    }

    public String toString() {
        return this.xPath.toString();
    }

    public String valueOf(Object context) throws JDOMException {
        try {
            return this.xPath.valueOf(context);
        }
        catch (JaxenException ex1) {
            throw new JDOMException("XPath error while evaluating \"" + this.xPath.toString() + "\": " + ex1.getMessage(), ex1);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.getXPath());
    }
}

