/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.Filter;

public class ElementFilter
implements Filter {
    private static final String CVS_ID = "@(#) $RCSfile: ElementFilter.java,v $ $Revision: 1.7 $ $Date: 2002/05/11 07:42:28 $ $Name:  $";
    protected String name;
    protected Namespace namespace;

    public ElementFilter() {
    }

    public ElementFilter(String name) {
        this.name = name;
    }

    public ElementFilter(String name, Namespace namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public ElementFilter(Namespace namespace) {
        this.namespace = namespace;
    }

    public boolean canAdd(Object obj) {
        return this.matches(obj);
    }

    public boolean canRemove(Object obj) {
        return obj instanceof Element;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ElementFilter) {
            ElementFilter filter = (ElementFilter)obj;
            if (this.namespace == filter.namespace) {
                if (this.name == filter.name) {
                    return true;
                }
                return this.name == null ? false : this.name.equals(filter.name);
            }
        }
        return false;
    }

    public boolean matches(Object obj) {
        if (obj instanceof Element) {
            Element element = (Element)obj;
            if (this.name == null) {
                if (this.namespace == null) {
                    return true;
                }
                return this.namespace.equals(element.getNamespace());
            }
            if (this.name.equals(element.getName())) {
                if (this.namespace == null) {
                    return true;
                }
                return this.namespace.equals(element.getNamespace());
            }
        }
        return false;
    }
}

