/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringPart
extends Part {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$methods$multipart$StringPart != null ? class$org$apache$commons$httpclient$methods$multipart$StringPart : (class$org$apache$commons$httpclient$methods$multipart$StringPart = StringPart.class$("org.apache.commons.httpclient.methods.multipart.StringPart"))));
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_CHARSET = "US-ASCII";
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private String name;
    private byte[] content;
    private String charset;
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$multipart$StringPart;

    public StringPart(String name, String value) {
        this(name, value, null);
    }

    public StringPart(String name, String value, String charset) {
        LOG.trace((Object)"enter StringPart(String, String, String)");
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.charset = charset != null ? charset : DEFAULT_CHARSET;
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.content = HttpConstants.getContentBytes(value, this.charset);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getCharSet() {
        return this.charset;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public String getName() {
        return this.name;
    }

    public String getTransferEncoding() {
        return DEFAULT_TRANSFER_ENCODING;
    }

    protected long lengthOfData() throws IOException {
        LOG.trace((Object)"enter lengthOfData()");
        return this.content.length;
    }

    protected void sendData(OutputStream out) throws IOException {
        LOG.trace((Object)"enter sendData(OutputStream)");
        out.write(this.content);
    }
}

