/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;

public class Main {
    protected static ToolErrorReporter errorReporter;
    protected static Global global;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static Vector fileList;

    public static void main(String[] args) {
        int result = Main.exec(args);
        if (result != 0) {
            System.exit(result);
        }
    }

    public static int exec(String[] args) {
        Context cx = Context.enter();
        global = Main.getGlobal();
        errorReporter = new ToolErrorReporter(false, global.getErr());
        cx.setErrorReporter(errorReporter);
        args = Main.processOptions(cx, args);
        if (processStdin) {
            fileList.addElement(null);
        }
        String[] array = args;
        Scriptable argsObj = cx.newArray((Scriptable)global, args);
        global.defineProperty("arguments", argsObj, 2);
        int i = 0;
        while (i < fileList.size()) {
            Main.processSource(cx, (String)fileList.elementAt(i));
            ++i;
        }
        cx.exit();
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Global getGlobal() {
        if (global == null) {
            try {
                global = new Global(Context.enter());
                Object var1 = null;
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            {
            }
        }
        return global;
    }

    public static String[] processOptions(Context cx, String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                processStdin = false;
                fileList.addElement(arg);
                String[] result = new String[args.length - i - 1];
                System.arraycopy(args, i + 1, result, 0, args.length - i - 1);
                return result;
            }
            if (arg.equals("-version")) {
                double d;
                if (++i == args.length) {
                    Main.usage(arg);
                }
                if ((d = Context.toNumber(args[i])) != d) {
                    Main.usage(arg);
                }
                cx.setLanguageVersion((int)d);
            } else if (arg.equals("-opt") || arg.equals("-O")) {
                double d;
                if (++i == args.length) {
                    Main.usage(arg);
                }
                if ((d = Context.toNumber(args[i])) != d) {
                    Main.usage(arg);
                }
                cx.setOptimizationLevel((int)d);
            } else if (arg.equals("-e")) {
                processStdin = false;
                if (++i == args.length) {
                    Main.usage(arg);
                }
                StringReader reader = new StringReader(args[i]);
                Main.evaluateReader(cx, global, reader, "<command>", 1);
            } else if (arg.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (arg.equals("-f")) {
                processStdin = false;
                if (++i == args.length) {
                    Main.usage(arg);
                }
                fileList.addElement(args[i].equals("-") ? null : args[i]);
            } else {
                Main.usage(arg);
            }
            ++i;
        }
        return new String[0];
    }

    public static void usage(String s) {
        Main.p(ToolErrorReporter.getMessage("msg.shell.usage", s));
        System.exit(1);
    }

    public static void processSource(Context cx, String filename) {
        if (filename == null || filename.equals("-")) {
            if (filename == null) {
                Main.getOut().println(cx.getImplementationVersion());
            }
            if (cx.getOptimizationLevel() >= 0) {
                cx.setOptimizationLevel(-1);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(global.getIn()));
            int lineno = 1;
            boolean hitEOF = false;
            while (!hitEOF) {
                int startline = lineno;
                if (filename == null) {
                    global.getErr().print("js> ");
                }
                global.getErr().flush();
                String source = "";
                do {
                    String newline;
                    try {
                        newline = in.readLine();
                    }
                    catch (IOException ioe) {
                        global.getErr().println(ioe.toString());
                        break;
                    }
                    if (newline == null) {
                        hitEOF = true;
                        break;
                    }
                    source = source + newline + "\n";
                    ++lineno;
                } while (!cx.stringIsCompilableUnit(source));
                StringReader reader = new StringReader(source);
                Object result = Main.evaluateReader(cx, global, reader, "<stdin>", startline);
                if (result != cx.getUndefinedValue()) {
                    try {
                        global.getErr().println(Context.toString(result));
                    }
                    catch (EcmaError ee) {
                        String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ee.toString());
                        exitCode = 3;
                        if (ee.getSourceName() != null) {
                            Context.reportError(msg, ee.getSourceName(), ee.getLineNumber(), ee.getLineSource(), ee.getColumnNumber());
                        }
                        Context.reportError(msg);
                    }
                }
                NativeArray h = Main.global.history;
                h.put((int)h.jsGet_length(), (Scriptable)h, (Object)source);
            }
            global.getErr().println();
        } else {
            Main.processFile(cx, global, filename);
        }
        System.gc();
    }

    public static void processFile(Context cx, Scriptable scope, String filename) {
        Reader in = null;
        try {
            URL url = new URL(filename);
            InputStream is = url.openStream();
            in = new BufferedReader(new InputStreamReader(is));
        }
        catch (MalformedURLException mfex) {
            in = null;
        }
        catch (IOException ioex) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open.url", filename, ioex.toString()));
            exitCode = 4;
            return;
        }
        if (in == null) {
            try {
                in = new PushbackReader(new FileReader(filename));
                int c = in.read();
                if (c == 35) {
                    while ((c = in.read()) != -1) {
                        if (c == 10 || c == 13) break;
                    }
                    ((PushbackReader)in).unread(c);
                } else {
                    in.close();
                    in = new FileReader(filename);
                }
                filename = new File(filename).getCanonicalPath();
            }
            catch (FileNotFoundException ex) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", filename));
                exitCode = 4;
                return;
            }
            catch (IOException ioe) {
                global.getErr().println(ioe.toString());
            }
        }
        Main.evaluateReader(cx, scope, in, filename, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object evaluateReader(Context cx, Scriptable scope, Reader in, String sourceName, int lineno) {
        Object result;
        block19: {
            result = cx.getUndefinedValue();
            result = cx.evaluateReader(scope, in, sourceName, lineno, null);
            Object var12_6 = null;
            try {
                in.close();
            }
            catch (IOException ioe2) {
                global.getErr().println(ioe2.toString());
            }
            break block19;
            {
                catch (WrappedException we) {
                    global.getErr().println(we.getWrappedException().toString());
                    we.printStackTrace();
                    Object var12_7 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        global.getErr().println(ioe2.toString());
                    }
                    break block19;
                }
                catch (EcmaError ee) {
                    String msg = ToolErrorReporter.getMessage("msg.uncaughtJSException", ee.toString());
                    exitCode = 3;
                    if (ee.getSourceName() != null) {
                        Context.reportError(msg, ee.getSourceName(), ee.getLineNumber(), ee.getLineSource(), ee.getColumnNumber());
                    } else {
                        Context.reportError(msg);
                    }
                    Object var12_8 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        global.getErr().println(ioe2.toString());
                    }
                    break block19;
                }
                catch (EvaluatorException ee) {
                    exitCode = 3;
                    Object var12_9 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        global.getErr().println(ioe2.toString());
                    }
                    break block19;
                }
                catch (JavaScriptException jse) {
                    Object value = jse.getValue();
                    if (value instanceof ThreadDeath) {
                        throw (ThreadDeath)value;
                    }
                    exitCode = 3;
                    Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", jse.getMessage()));
                    Object var12_10 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        global.getErr().println(ioe2.toString());
                    }
                    break block19;
                }
                catch (IOException ioe) {
                    global.getErr().println(ioe.toString());
                    Object var12_11 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ioe2) {
                        global.getErr().println(ioe2.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    in.close();
                }
                catch (IOException ioe2) {
                    global.getErr().println(ioe2.toString());
                }
                throw throwable;
            }
        }
        return result;
    }

    private static void p(String s) {
        global.getOut().println(s);
    }

    public static ScriptableObject getScope() {
        return global;
    }

    public static InputStream getIn() {
        return Global.getInstance(Main.getGlobal()).getIn();
    }

    public static void setIn(InputStream in) {
        Global.getInstance(Main.getGlobal()).setIn(in);
    }

    public static PrintStream getOut() {
        return Global.getInstance(Main.getGlobal()).getOut();
    }

    public static void setOut(PrintStream out) {
        Global.getInstance(Main.getGlobal()).setOut(out);
    }

    public static PrintStream getErr() {
        return Global.getInstance(Main.getGlobal()).getErr();
    }

    public static void setErr(PrintStream err) {
        Global.getInstance(Main.getGlobal()).setErr(err);
    }

    static {
        exitCode = 0;
        processStdin = true;
        fileList = new Vector(5);
    }
}

