/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.jsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Main {
    private static boolean hasOutOption = false;
    private static ToolErrorReporter reporter;

    public static void main(String[] args) {
        Context cx = Context.enter();
        reporter = new ToolErrorReporter(true);
        cx.setErrorReporter(reporter);
        args = Main.processOptions(cx, args);
        if (!reporter.hasReportedError()) {
            Main.processSource(cx, args);
        }
        cx.exit();
    }

    public static String[] processOptions(Context cx, String[] args) {
        cx.setTargetPackage("");
        cx.setGeneratingDebug(false);
        int i = 0;
        while (i < args.length) {
            block33: {
                String arg;
                block34: {
                    arg = args[i];
                    if (!arg.startsWith("-")) {
                        String[] result = new String[args.length - i];
                        int j = i;
                        while (j < args.length) {
                            result[j - i] = args[j];
                            ++j;
                        }
                        return result;
                    }
                    try {
                        if (arg.equals("-version") && ++i < args.length) {
                            int version = Integer.parseInt(args[i]);
                            cx.setLanguageVersion(version);
                            break block33;
                        }
                        if ((arg.equals("-opt") || arg.equals("-O")) && ++i < args.length) {
                            int optLevel = Integer.parseInt(args[i]);
                            cx.setOptimizationLevel(optLevel);
                        }
                        break block34;
                    }
                    catch (NumberFormatException e) {
                        Context.reportError(ToolErrorReporter.getMessage("msg.jsc.usage", args[i]));
                    }
                    break block33;
                }
                if (arg.equals("-nosource")) {
                    cx.setGeneratingSource(false);
                } else if (arg.equals("-debug") || arg.equals("-g")) {
                    cx.setGeneratingDebug(true);
                } else if (arg.equals("-o") && ++i < args.length) {
                    String outFile = args[i];
                    if (!Character.isJavaIdentifierStart(outFile.charAt(0))) {
                        Context.reportError(ToolErrorReporter.getMessage("msg.invalid.classfile.name", outFile));
                    } else {
                        int j = 1;
                        while (j < outFile.length()) {
                            if (!Character.isJavaIdentifierPart(outFile.charAt(j)) && outFile.charAt(j) != '.' || outFile.charAt(j) == '.' && (!outFile.endsWith(".class") || j != outFile.length() - 6)) {
                                Context.reportError(ToolErrorReporter.getMessage("msg.invalid.classfile.name", outFile));
                                break;
                            }
                            ++j;
                        }
                        cx.setTargetClassFileName(outFile);
                        hasOutOption = true;
                    }
                } else if (arg.equals("-package") && ++i < args.length) {
                    String targetPackage = args[i];
                    int j = 0;
                    while (j < targetPackage.length()) {
                        if (!Character.isJavaIdentifierStart(targetPackage.charAt(j))) {
                            Context.reportError(ToolErrorReporter.getMessage("msg.package.name", targetPackage));
                        } else {
                            int k = ++j;
                            while (k < targetPackage.length()) {
                                if (!(targetPackage.charAt(k) == '.' && targetPackage.charAt(k - 1) != '.' && k != targetPackage.length() - 1 || Character.isJavaIdentifierPart(targetPackage.charAt(k)))) {
                                    Context.reportError(ToolErrorReporter.getMessage("msg.package.name", targetPackage));
                                }
                                ++k;
                                ++j;
                            }
                        }
                        ++j;
                    }
                    cx.setTargetPackage(targetPackage);
                } else if (arg.equals("-extends") && ++i < args.length) {
                    String targetExtends = args[i];
                    try {
                        cx.setTargetExtends(Class.forName(targetExtends));
                    }
                    catch (ClassNotFoundException e) {
                        throw new Error(e.toString());
                    }
                } else if (arg.equals("-implements") && ++i < args.length) {
                    String targetImplements = args[i];
                    StringTokenizer st = new StringTokenizer(targetImplements, ",");
                    Vector v = new Vector();
                    while (st.hasMoreTokens()) {
                        String className = st.nextToken();
                        try {
                            v.addElement(Class.forName(className));
                        }
                        catch (ClassNotFoundException e) {
                            throw new Error(e.toString());
                        }
                    }
                    Object[] implementsClasses = new Class[v.size()];
                    v.copyInto(implementsClasses);
                    cx.setTargetImplements((Class[])implementsClasses);
                } else {
                    Main.usage(arg);
                }
            }
            ++i;
        }
        Main.p(ToolErrorReporter.getMessage("msg.no.file"));
        System.exit(1);
        return null;
    }

    public static void usage(String s) {
        Main.p(ToolErrorReporter.getMessage("msg.jsc.usage", s));
        System.exit(1);
    }

    public static void processSource(Context cx, String[] filenames) {
        if (hasOutOption && filenames.length > 1) {
            Context.reportError(ToolErrorReporter.getMessage("msg.multiple.js.to.file", cx.getTargetClassFileName()));
        }
        int i = 0;
        while (i < filenames.length) {
            String filename = filenames[i];
            File f = new File(filename);
            if (!f.exists()) {
                Context.reportError(ToolErrorReporter.getMessage("msg.jsfile.not.found", filename));
                return;
            }
            if (!filename.endsWith(".js")) {
                Context.reportError(ToolErrorReporter.getMessage("msg.extension.not.js", filename));
                return;
            }
            if (!hasOutOption) {
                String name = f.getName();
                String nojs = name.substring(0, name.length() - 3);
                String className = Main.getClassName(nojs) + ".class";
                String out = f.getParent() == null ? className : f.getParent() + File.separator + className;
                cx.setTargetClassFileName(out);
            }
            if (cx.getTargetClassFileName() == null) {
                Context.reportError(ToolErrorReporter.getMessage("msg.no-opt"));
            }
            try {
                FileReader in = new FileReader(filename);
                cx.compileReader(null, in, filename, 1, null);
            }
            catch (FileNotFoundException ex) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", filename));
                return;
            }
            catch (IOException ioe) {
                Context.reportError(ioe.toString());
            }
            ++i;
        }
    }

    static String getClassName(String name) {
        char[] s = new char[name.length() + 1];
        int j = 0;
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            s[j++] = 95;
        }
        int i = 0;
        while (i < name.length()) {
            int c = name.charAt(i);
            s[j] = Character.isJavaIdentifierPart((char)c) ? c : 95;
            ++i;
            ++j;
        }
        return new String(s).trim();
    }

    private static void p(String s) {
        System.out.println(s);
    }
}

