/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.Main;

class SetFilePosition
implements Runnable {
    Main db;
    FileWindow w;
    int line;
    boolean activate;

    SetFilePosition(Main db, FileWindow w, int line) {
        this.db = db;
        this.w = w;
        this.line = line;
        this.activate = true;
    }

    SetFilePosition(Main db, FileWindow w, int line, boolean activate) {
        this.db = db;
        this.w = w;
        this.line = line;
        this.activate = activate;
    }

    public void run() {
        block9: {
            FileTextArea ta = this.w.textArea;
            try {
                if (this.line == -1) {
                    this.w.setPosition(-1);
                    if (this.db.currentWindow == this.w) {
                        this.db.currentWindow = null;
                    }
                } else {
                    int loc = ta.getLineStartOffset(this.line - 1);
                    if (this.db.currentWindow != null && this.db.currentWindow != this.w) {
                        this.db.currentWindow.setPosition(-1);
                    }
                    this.w.setPosition(loc);
                    this.db.currentWindow = this.w;
                }
            }
            catch (BadLocationException exc) {
                // empty catch block
            }
            if (!this.activate) break block9;
            if (this.w.isIcon()) {
                this.db.desk.getDesktopManager().deiconifyFrame(this.w);
            }
            try {
                this.w.show();
                this.w.toFront();
                this.w.setSelected(true);
            }
            catch (Exception exc) {}
        }
    }
}

