/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.mozilla.javascript.tools.debugger.Main;

class Menubar
extends JMenuBar
implements ActionListener {
    Main db;
    JMenu windowMenu;
    JCheckBoxMenuItem breakOnExceptions;
    JCheckBoxMenuItem breakOnEnter;
    JCheckBoxMenuItem breakOnReturn;

    JMenu getDebugMenu() {
        return this.getMenu(2);
    }

    Menubar(Main db) {
        JMenuItem item;
        this.db = db;
        String[] fileItems = new String[]{"Open...", "Run...", "", "Exit"};
        String[] fileCmds = new String[]{"Open", "Load", "", "Exit"};
        char[] fileShortCuts = new char[]{'0', 'N', '\u0000', 'X'};
        int[] fileAccelerators = new int[]{79, 78, 0, 81};
        String[] editItems = new String[]{"Cut", "Copy", "Paste", "Go to function..."};
        char[] editShortCuts = new char[]{'T', 'C', 'P', 'F'};
        String[] debugItems = new String[]{"Break", "Go", "Step Into", "Step Over", "Step Out"};
        char[] debugShortCuts = new char[]{'B', 'G', 'I', 'O', 'T'};
        String[] plafItems = new String[]{"Metal", "Windows", "Motif"};
        char[] plafShortCuts = new char[]{'M', 'W', 'F'};
        int[] debugAccelerators = new int[]{19, 116, 122, 118, 119, 0, 0};
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenu plafMenu = new JMenu("Platform");
        plafMenu.setMnemonic('P');
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.setMnemonic('D');
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic('W');
        int i = 0;
        while (i < fileItems.length) {
            if (fileItems[i].length() == 0) {
                fileMenu.addSeparator();
            } else {
                JMenuItem item2 = new JMenuItem(fileItems[i], fileShortCuts[i]);
                item2.setActionCommand(fileCmds[i]);
                item2.addActionListener(this);
                fileMenu.add(item2);
                if (fileAccelerators[i] != 0) {
                    KeyStroke k = KeyStroke.getKeyStroke(fileAccelerators[i], 2);
                    item2.setAccelerator(k);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < editItems.length) {
            JMenuItem item3 = new JMenuItem(editItems[i2], editShortCuts[i2]);
            item3.addActionListener(this);
            editMenu.add(item3);
            ++i2;
        }
        int i3 = 0;
        while (i3 < plafItems.length) {
            JMenuItem item4 = new JMenuItem(plafItems[i3], plafShortCuts[i3]);
            item4.addActionListener(this);
            plafMenu.add(item4);
            ++i3;
        }
        int i4 = 0;
        while (i4 < debugItems.length) {
            item = new JMenuItem(debugItems[i4], debugShortCuts[i4]);
            item.addActionListener(this);
            if (debugAccelerators[i4] != 0) {
                KeyStroke k = KeyStroke.getKeyStroke(debugAccelerators[i4], 0);
                item.setAccelerator(k);
            }
            if (i4 != 0) {
                item.setEnabled(false);
            }
            debugMenu.add(item);
            ++i4;
        }
        this.breakOnExceptions = new JCheckBoxMenuItem("Break on Exceptions");
        this.breakOnExceptions.setMnemonic('X');
        this.breakOnExceptions.addActionListener(this);
        this.breakOnExceptions.setSelected(false);
        debugMenu.add(this.breakOnExceptions);
        this.breakOnEnter = new JCheckBoxMenuItem("Break on Function Enter");
        this.breakOnEnter.setMnemonic('E');
        this.breakOnEnter.addActionListener(this);
        this.breakOnEnter.setSelected(false);
        debugMenu.add(this.breakOnEnter);
        this.breakOnReturn = new JCheckBoxMenuItem("Break on Function Return");
        this.breakOnReturn.setMnemonic('R');
        this.breakOnReturn.addActionListener(this);
        this.breakOnReturn.setSelected(false);
        debugMenu.add(this.breakOnReturn);
        this.add(fileMenu);
        this.add(editMenu);
        this.add(debugMenu);
        item = new JMenuItem("Cascade", 65);
        this.windowMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Tile", 84);
        this.windowMenu.add(item);
        item.addActionListener(this);
        this.windowMenu.addSeparator();
        item = new JMenuItem("Console", 67);
        this.windowMenu.add(item);
        item.addActionListener(this);
        this.add(this.windowMenu);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String plaf_name = null;
        if (cmd.equals("Metal")) {
            plaf_name = "javax.swing.plaf.metal.MetalLookAndFeel";
        } else if (cmd.equals("Windows")) {
            plaf_name = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if (cmd.equals("Motif")) {
            plaf_name = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else {
            Object source = e.getSource();
            if (source == this.breakOnExceptions) {
                this.db.setBreakOnExceptions(this.breakOnExceptions.isSelected());
            } else if (source == this.breakOnEnter) {
                this.db.breakOnEnter = this.breakOnEnter.isSelected();
            } else if (source == this.breakOnReturn) {
                this.db.breakOnReturn = this.breakOnReturn.isSelected();
            } else {
                this.db.actionPerformed(e);
            }
            return;
        }
        try {
            UIManager.setLookAndFeel(plaf_name);
            SwingUtilities.updateComponentTreeUI(this.db);
            SwingUtilities.updateComponentTreeUI(this.db.dlg);
        }
        catch (Exception ignored) {}
    }

    public void addFile(String fileName) {
        JMenuItem item2;
        int count = this.windowMenu.getItemCount();
        if (count == 4) {
            this.windowMenu.addSeparator();
            ++count;
        }
        JMenuItem lastItem = this.windowMenu.getItem(count - 1);
        boolean hasMoreWin = false;
        int maxWin = 5;
        if (lastItem != null && lastItem.getText().equals("More Windows...")) {
            hasMoreWin = true;
            ++maxWin;
        }
        if (!hasMoreWin && count - 4 == 5) {
            JMenuItem item2 = new JMenuItem("More Windows...", 77);
            this.windowMenu.add(item2);
            item2.setActionCommand("More Windows...");
            item2.addActionListener(this);
            return;
        }
        if (count - 4 <= maxWin) {
            if (hasMoreWin) {
                --count;
                this.windowMenu.remove(lastItem);
            }
            File f = new File(fileName);
            item2 = new JMenuItem((char)(48 + (count - 4)) + " " + f.getName(), 48 + (count - 4));
            this.windowMenu.add(item2);
            if (hasMoreWin) {
                this.windowMenu.add(lastItem);
            }
        } else {
            return;
        }
        item2.setActionCommand(fileName);
        item2.addActionListener(this);
    }
}

