/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.ContextHelper;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.EnterInterrupt;
import org.mozilla.javascript.tools.debugger.EvalWindow;
import org.mozilla.javascript.tools.debugger.ExitInterrupt;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.OpenFile;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SetFilePosition;
import org.mozilla.javascript.tools.debugger.SetFileText;
import org.mozilla.javascript.tools.debugger.UpdateContext;

public class Main
extends JFrame
implements Debugger,
ContextListener {
    HashSet contexts = new HashSet();
    static Thread mainThread;
    int optimizationLevel = -1;
    boolean breakFlag = false;
    static final int STEP_OVER = 0;
    static final int STEP_INTO = 1;
    static final int STEP_OUT = 2;
    static final int GO = 3;
    static final int BREAK = 4;
    static final int RUN_TO_CURSOR = 5;
    static final int EXIT = 6;
    private Hashtable threadState = new Hashtable();
    private Thread runToCursorThread;
    private int runToCursorLine;
    private String runToCursorFile;
    private Hashtable sourceNames = new Hashtable();
    Hashtable functionMap = new Hashtable();
    Hashtable breakpointsMap = new Hashtable();
    JDesktopPane desk;
    ContextWindow context;
    Menubar menubar;
    JToolBar toolBar;
    JSInternalConsole console;
    EvalWindow evalWindow;
    JSplitPane split1;
    JLabel statusBar;
    ScopeProvider scopeProvider;
    Runnable exitAction;
    int frameIndex = -1;
    boolean isInterrupted = false;
    boolean nonDispatcherWaiting = false;
    int dispatcherIsWaiting = 0;
    Context currentContext = null;
    JFileChooser dlg;
    Map breakPoints = new HashMap();
    Hashtable fileWindows = new Hashtable();
    FileWindow currentWindow;
    Object monitor = new Object();
    Object swingMonitor = new Object();
    int returnValue = -1;
    boolean breakOnExceptions;
    boolean breakOnEnter;
    boolean breakOnReturn;
    Hashtable toplevels = new Hashtable();
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextCreated(Context cx) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            ContextData contextData = new ContextData();
            cx.setDebugger(this, contextData);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(this.optimizationLevel);
            if (this.breakFlag || Thread.currentThread() == mainThread) {
                contextData.breakNextLine = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextEntered(Context cx) {
        cx.setGeneratingDebug(true);
        cx.setOptimizationLevel(this.optimizationLevel);
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            if (!this.contexts.contains(cx) && cx.getDebugger() == this) {
                this.contexts.add(cx);
            }
        }
    }

    public void contextExited(Context cx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextReleased(Context cx) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            this.contexts.remove(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBreak() {
        this.breakFlag = true;
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            Iterator iter = this.contexts.iterator();
            while (iter.hasNext()) {
                Context cx = (Context)iter.next();
                ContextData.get((Context)cx).breakNextLine = true;
            }
        }
    }

    public void setVisible(boolean b) {
        block2: {
            super.setVisible(b);
            if (!b) break block2;
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.toFront();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exc) {}
        }
    }

    void doClearBreakpoints() {
        Enumeration e = this.breakpointsMap.keys();
        while (e.hasMoreElements()) {
            String url = (String)e.nextElement();
            Hashtable h = (Hashtable)this.breakpointsMap.get(url);
            Enumeration he = h.keys();
            while (he.hasMoreElements()) {
                Integer line = (Integer)h.get(he.nextElement());
                this.clearBreakPoint(url, line);
            }
        }
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, StringBuffer source) {
        NativeFunction f;
        String name;
        String origSourceName;
        Vector v;
        String sourceName = fnOrScript.getSourceName();
        if (sourceName == null) {
            sourceName = "<stdin>";
        }
        if (sourceName.endsWith("(eval)") && (v = (Vector)this.sourceNames.get(origSourceName = sourceName.substring(0, sourceName.length() - 6))) != null) {
            SourceEntry prev = (SourceEntry)v.get(v.size() - 1);
            source = prev.source;
            SourceEntry entry = new SourceEntry(source, fnOrScript);
            v.addElement(entry);
            return;
        }
        Vector<SourceEntry> v2 = (Vector<SourceEntry>)this.sourceNames.get(sourceName);
        if (v2 == null) {
            v2 = new Vector<SourceEntry>();
            this.sourceNames.put(sourceName, v2);
        }
        SourceEntry entry = new SourceEntry(source, fnOrScript);
        v2.addElement(entry);
        if (fnOrScript.getScriptable() instanceof NativeFunction && (name = (f = (NativeFunction)fnOrScript.getScriptable()).getFunctionName()).length() > 0 && !name.equals("anonymous")) {
            this.functionMap.put(name, entry);
        }
        this.loadedFile(sourceName, source.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLineChange(Context cx, String sourceName, int lineNumber, boolean breakpoint) {
        if (!breakpoint) {
            Map map = this.breakPoints;
            synchronized (map) {
                Set lines = (Set)this.breakPoints.get(sourceName);
                if (lines != null && lines.contains(new Integer(lineNumber))) {
                    breakpoint = true;
                }
            }
        }
        if (breakpoint) {
            this.handleBreakpointHit(cx);
        }
    }

    void handleBreakpointHit(Context cx) {
        this.breakFlag = false;
        this.interrupted(cx);
    }

    private static Object unwrapException(Object ex) {
        while (true) {
            Object w;
            if (ex instanceof JavaScriptException) {
                ex = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)ex);
                continue;
            }
            if (ex instanceof EcmaError) {
                ex = ((EcmaError)ex).getErrorObject();
                continue;
            }
            if (ex instanceof NativeJavaObject) {
                ex = ((NativeJavaObject)ex).unwrap();
                break;
            }
            if (!(ex instanceof WrappedException) || !((w = ((WrappedException)ex).unwrap()) instanceof Throwable)) break;
            ex = w;
        }
        return ex;
    }

    void handleExceptionThrown(Context cx, Throwable ex, FrameHelper frame) {
        if (this.breakOnExceptions) {
            String sourceName = frame.getSourceName();
            if (sourceName != null && sourceName.endsWith("(eval)")) {
                sourceName = sourceName.substring(0, sourceName.length() - 6);
            }
            int lineNumber = frame.getLineNumber();
            FileWindow w = null;
            if (sourceName == null) {
                sourceName = lineNumber == -1 ? "<eval>" : "<stdin>";
            } else {
                w = this.getFileWindow(sourceName);
            }
            Object e = Main.unwrapException(ex);
            String msg = e.toString();
            if (msg == null || msg.length() == 0) {
                msg = e.getClass().toString();
            }
            msg = msg + " (" + sourceName + ", line " + lineNumber + ")";
            if (w != null) {
                Main.swingInvoke(new SetFilePosition(this, w, lineNumber));
            }
            MessageDialogWrapper.showMessageDialog(this, msg, "Exception in Script", 0);
            this.interrupted(cx);
        }
    }

    public DebugFrame enterFrame(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, DebuggableScript fnOrScript) {
        FrameHelper frame = new FrameHelper(cx, this, scope, thisObj, fnOrScript);
        if (this.breakOnEnter) {
            this.handleBreakpointHit(cx);
        }
        return frame;
    }

    void init() {
        JButton stepOutButton;
        JButton stepOverButton;
        JButton stepIntoButton;
        JButton goButton;
        JButton breakButton;
        JButton button;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] toolTips = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int count = 0;
        JButton focusButton = button = (breakButton = new JButton("Break"));
        button.setToolTipText("Break");
        button.setActionCommand("Break");
        button.addActionListener(this.menubar);
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button = goButton = new JButton("Go");
        button.setToolTipText("Go");
        button.setActionCommand("Go");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepIntoButton = new JButton("Step Into");
        button.setToolTipText("Step Into");
        button.setActionCommand("Step Into");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepOverButton = new JButton("Step Over");
        button.setToolTipText("Step Over");
        button.setActionCommand("Step Over");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count++]);
        button = stepOutButton = new JButton("Step Out");
        button.setToolTipText("Step Out");
        button.setActionCommand("Step Out");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count++]);
        Dimension dim = stepOverButton.getPreferredSize();
        breakButton.setPreferredSize(dim);
        breakButton.setMinimumSize(dim);
        breakButton.setMaximumSize(dim);
        breakButton.setSize(dim);
        goButton.setPreferredSize(dim);
        goButton.setMinimumSize(dim);
        goButton.setMaximumSize(dim);
        stepIntoButton.setPreferredSize(dim);
        stepIntoButton.setMinimumSize(dim);
        stepIntoButton.setMaximumSize(dim);
        stepOverButton.setPreferredSize(dim);
        stepOverButton.setMinimumSize(dim);
        stepOverButton.setMaximumSize(dim);
        stepOutButton.setPreferredSize(dim);
        stepOutButton.setMinimumSize(dim);
        stepOutButton.setMaximumSize(dim);
        this.toolBar.add(breakButton);
        this.toolBar.add(goButton);
        this.toolBar.add(stepIntoButton);
        this.toolBar.add(stepOverButton);
        this.toolBar.add(stepOutButton);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        Main.setResizeWeight(this.split1, 0.66);
        contentPane.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        contentPane.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                String ext;
                if (f.isDirectory()) {
                    return true;
                }
                String n = f.getName();
                int i = n.lastIndexOf(46);
                return i > 0 && i < n.length() - 1 && (ext = n.substring(i + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(filter);
        final Main self = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                self.Exit();
            }
        });
    }

    Scriptable getScope() {
        return this.scopeProvider != null ? this.scopeProvider.getScope() : null;
    }

    FileWindow getFileWindow(String fileName) {
        if (fileName == null || fileName.equals("<stdin>") || fileName.equals("<eval>")) {
            return null;
        }
        String file = fileName;
        Enumeration e = this.fileWindows.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!file.equals(name)) continue;
            FileWindow w = (FileWindow)this.fileWindows.get(name);
            w.setUrl(fileName);
            return w;
        }
        return (FileWindow)this.fileWindows.get(fileName);
    }

    void loadedFile(String fileName, String text) {
        FileWindow w = this.getFileWindow(fileName);
        if (w != null) {
            Main.swingInvoke(new SetFileText(w, text));
            w.show();
            w.toFront();
        } else if (!fileName.equals("<stdin>")) {
            Main.swingInvoke(new CreateFileWindow(this, fileName, text, -1));
        }
    }

    static void swingInvoke(Runnable f) {
        if (EventQueue.isDispatchThread()) {
            f.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(f);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    static void swingInvokeLater(Runnable f) {
        try {
            SwingUtilities.invokeLater(f);
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
        }
    }

    void contextSwitch(int frameIndex) {
        Context cx = this.getCurrentContext();
        ContextData contextData = ContextData.get(cx);
        ContextHelper helper = new ContextHelper();
        helper.attach(cx);
        if (cx != null) {
            int frameCount = contextData.getFrameCount();
            if (frameIndex < 0 || frameIndex >= frameCount) {
                helper.reset();
                return;
            }
            this.frameIndex = frameIndex;
            FrameHelper frame = contextData.getFrame(frameIndex);
            String sourceName = frame.getSourceName();
            if (sourceName == null || sourceName.equals("<stdin>")) {
                this.console.show();
                this.console.toFront();
                helper.reset();
                return;
            }
            if (sourceName == "<eval>") {
                helper.reset();
                return;
            }
            if (sourceName.endsWith("(eval)")) {
                sourceName = sourceName.substring(0, sourceName.length() - 6);
            }
            int lineNumber = frame.getLineNumber();
            this.frameIndex = frameIndex;
            FileWindow w = this.getFileWindow(sourceName);
            if (w != null) {
                SetFilePosition action = new SetFilePosition(this, w, lineNumber);
                action.run();
            } else {
                Vector v = (Vector)this.sourceNames.get(sourceName);
                String source = ((SourceEntry)v.elementAt((int)0)).source.toString();
                CreateFileWindow action = new CreateFileWindow(this, sourceName, source, lineNumber);
                action.run();
            }
            helper.reset();
        }
    }

    Context getCurrentContext() {
        return this.currentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void interrupted(Context cx) {
        block61: {
            var2_2 = this.swingMonitor;
            synchronized (var2_2) {
                block62: {
                    if (!EventQueue.isDispatchThread()) ** GOTO lbl-1000
                    ++this.dispatcherIsWaiting;
                    if (!this.nonDispatcherWaiting) break block62;
                    eventQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    while (this.nonDispatcherWaiting) {
                        try {
                            event = eventQ.getNextEvent();
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)event).dispatch();
                            } else {
                                source = event.getSource();
                                if (source instanceof Component) {
                                    comp = (Component)source;
                                    comp.dispatchEvent(event);
                                } else if (source instanceof MenuComponent) {
                                    ((MenuComponent)source).dispatchEvent(event);
                                }
                            }
                            if (this.returnValue == 6) {
                                return;
                            }
                            this.swingMonitor.wait(1L);
                        }
                        catch (InterruptedException exc) {
                            return;
                        }
                    }
                    break block62;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.swingMonitor.wait();
                            continue;
                        }
                        catch (InterruptedException exc) {
                            return;
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** while (this.isInterrupted || this.dispatcherIsWaiting > 0)
                    }
lbl35:
                    // 1 sources

                    this.nonDispatcherWaiting = true;
                }
                this.isInterrupted = true;
            }
            this.currentContext = cx;
            contextData = ContextData.get(cx);
            thread = Thread.currentThread();
            this.statusBar.setText("Thread: " + thread.toString());
            state = (ThreadState)this.threadState.get(thread);
            stopAtFrameDepth = -1;
            if (state != null) {
                stopAtFrameDepth = ThreadState.access$000(state);
            }
            if (this.runToCursorFile != null && thread == this.runToCursorThread && (frameCount = contextData.getFrameCount()) > 0 && (sourceName = (frame = contextData.getFrame(0)).getSourceName()) != null) {
                if (sourceName.endsWith("(eval)")) {
                    sourceName = sourceName.substring(0, sourceName.length() - 6);
                }
                if (sourceName.equals(this.runToCursorFile)) {
                    lineNumber = frame.getLineNumber();
                    if (lineNumber == this.runToCursorLine) {
                        stopAtFrameDepth = -1;
                        this.runToCursorFile = null;
                    } else {
                        w = this.getFileWindow(sourceName);
                        if (w == null || !w.isBreakPoint(lineNumber)) {
                            return;
                        }
                        this.runToCursorFile = null;
                    }
                }
            }
            if (stopAtFrameDepth <= 0 || contextData.getFrameCount() <= stopAtFrameDepth) {
                if (state != null) {
                    ThreadState.access$002(state, -1);
                }
                this.threadState.remove(thread);
                frameCount = contextData.getFrameCount();
                this.frameIndex = frameCount - 1;
                line = 0;
                if (frameCount != 0) {
                    frame = contextData.getFrame(0);
                    fileName = frame.getSourceName();
                    if (fileName.endsWith("(eval)")) {
                        fileName = fileName.substring(0, fileName.length() - 6);
                    }
                    contextData.breakNextLine = false;
                    line = frame.getLineNumber();
                    enterCount = 0;
                    isDispatchThread = EventQueue.isDispatchThread();
                    if (!isDispatchThread) {
                        cx.exit();
                        while (Context.getCurrentContext() != null) {
                            Context.exit();
                            ++enterCount;
                        }
                    }
                    if (fileName != null && !fileName.equals("<stdin>")) {
                        w = this.getFileWindow(fileName);
                        if (w != null) {
                            action = new SetFilePosition(this, w, line);
                            Main.swingInvoke(action);
                        } else {
                            v = (Vector)this.sourceNames.get(fileName);
                            source = ((SourceEntry)v.elementAt((int)0)).source.toString();
                            action = new CreateFileWindow(this, fileName, source, line);
                            Main.swingInvoke(action);
                        }
                    } else if (this.console.isVisible()) {
                        finalConsole = this.console;
                        Main.swingInvoke(new Runnable(){

                            public void run() {
                                finalConsole.show();
                            }
                        });
                    }
                    Main.swingInvoke(new EnterInterrupt(this, cx));
                    Main.swingInvoke(new UpdateContext(this, cx));
                    if (!isDispatchThread) {
                        v = this.monitor;
                        synchronized (v) {
                            this.returnValue = -1;
                            try {
                                while (this.returnValue == -1) {
                                    this.monitor.wait();
                                }
                                returnValue = this.returnValue;
                            }
                            catch (InterruptedException exc) {
                                break block61;
                            }
                        }
                    }
                    eventQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    this.returnValue = -1;
                    while (this.returnValue == -1) {
                        try {
                            event = eventQ.getNextEvent();
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)event).dispatch();
                                continue;
                            }
                            source = event.getSource();
                            if (source instanceof Component) {
                                comp = (Component)source;
                                comp.dispatchEvent(event);
                                continue;
                            }
                            if (!(source instanceof MenuComponent)) continue;
                            ((MenuComponent)source).dispatchEvent(event);
                        }
                        catch (InterruptedException exc) {
                            // empty catch block
                        }
                    }
                    returnValue = this.returnValue;
                    Main.swingInvoke(new ExitInterrupt(this, returnValue));
                    if (!isDispatchThread) {
                        current = Context.enter(cx);
                        if (current != cx) {
                            System.out.println("debugger error: cx = " + cx + " current = " + current);
                        }
                        while (enterCount > 0) {
                            Context.enter();
                            --enterCount;
                        }
                    }
                    switch (returnValue) {
                        case 0: {
                            contextData.breakNextLine = true;
                            stopAtFrameDepth = contextData.getFrameCount();
                            if (state == null) {
                                state = new ThreadState();
                            }
                            ThreadState.access$002(state, stopAtFrameDepth);
                            this.threadState.put(thread, state);
                            break;
                        }
                        case 1: {
                            contextData.breakNextLine = true;
                            if (state == null) break;
                            ThreadState.access$002(state, -1);
                            break;
                        }
                        case 2: {
                            stopAtFrameDepth = contextData.getFrameCount() - 1;
                            if (stopAtFrameDepth <= 0) break;
                            contextData.breakNextLine = true;
                            if (state == null) {
                                state = new ThreadState();
                            }
                            ThreadState.access$002(state, stopAtFrameDepth);
                            this.threadState.put(thread, state);
                            break;
                        }
                        case 5: {
                            contextData.breakNextLine = true;
                            if (state == null) break;
                            ThreadState.access$002(state, -1);
                        }
                    }
                }
            }
        }
        var3_3 = this.swingMonitor;
        synchronized (var3_3) {
            this.isInterrupted = false;
            if (EventQueue.isDispatchThread()) {
                --this.dispatcherIsWaiting;
            } else {
                this.nonDispatcherWaiting = false;
            }
            this.swingMonitor.notifyAll();
        }
    }

    String chooseFile(String title) {
        int returnVal;
        this.dlg.setDialogTitle(title);
        File CWD = null;
        String dir = System.getProperty("user.dir");
        if (dir != null) {
            CWD = new File(dir);
        }
        if (CWD != null) {
            this.dlg.setCurrentDirectory(CWD);
        }
        if ((returnVal = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String result = this.dlg.getSelectedFile().getCanonicalPath();
                CWD = this.dlg.getSelectedFile().getParentFile();
                System.setProperty("user.dir", CWD.getPath());
                return result;
            }
            catch (IOException ignored) {
            }
        }
        return null;
    }

    JInternalFrame getSelectedFrame() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                return frames[i];
            }
            ++i;
        }
        return frames[frames.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actionPerformed(ActionEvent e) {
        JDialog dlg;
        Scriptable scope;
        String cmd = e.getActionCommand();
        int returnValue = -1;
        if (cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste")) {
            JInternalFrame f = this.getSelectedFrame();
            if (f != null && f instanceof ActionListener) {
                ((ActionListener)((Object)f)).actionPerformed(e);
            }
        } else if (cmd.equals("Step Over")) {
            returnValue = 0;
        } else if (cmd.equals("Step Into")) {
            returnValue = 1;
        } else if (cmd.equals("Step Out")) {
            returnValue = 2;
        } else if (cmd.equals("Go")) {
            returnValue = 3;
        } else if (cmd.equals("Break")) {
            this.doBreak();
        } else if (cmd.equals("Run to Cursor")) {
            returnValue = 5;
        } else if (cmd.equals("Exit")) {
            this.Exit();
        } else if (cmd.equals("Open")) {
            scope = this.getScope();
            if (scope == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
            } else {
                String fileName = this.chooseFile("Select a file to compile");
                if (fileName != null) {
                    new Thread(new OpenFile(this, scope, fileName)).start();
                }
            }
        } else if (cmd.equals("Load")) {
            scope = this.getScope();
            if (scope == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't run scripts: no scope available", "Run", 0);
            } else {
                String fileName = this.chooseFile("Select a file to execute");
                if (fileName != null) {
                    new Thread(new LoadFile(this, scope, fileName)).start();
                }
            }
        } else if (cmd.equals("More Windows...")) {
            dlg = new MoreWindows(this, this.fileWindows, "Window", "Files");
            ((MoreWindows)dlg).showDialog(this);
        } else if (cmd.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste"))) {
            JInternalFrame[] frames;
            if (cmd.equals("Go to function...")) {
                dlg = new FindFunction(this, this.functionMap, "Go to function", "Function");
                ((FindFunction)dlg).showDialog(this);
            } else if (cmd.equals("Tile")) {
                frames = this.desk.getAllFrames();
                int count = frames.length;
                int cols = (int)Math.sqrt(count);
                int rows = cols;
                if (rows * cols < count && rows * ++cols < count) {
                    ++rows;
                }
                Dimension size = this.desk.getSize();
                int w = size.width / cols;
                int h = size.height / rows;
                int x = 0;
                int y = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < cols) {
                        int index = i * cols + j;
                        if (index >= frames.length) break;
                        JInternalFrame f = frames[index];
                        try {
                            f.setIcon(false);
                            f.setMaximum(false);
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                        x += w;
                        ++j;
                    }
                    y += h;
                    x = 0;
                    ++i;
                }
            } else if (cmd.equals("Cascade")) {
                frames = this.desk.getAllFrames();
                int count = frames.length;
                int y = 0;
                int x = 0;
                int h = this.desk.getHeight();
                int d = h / count;
                if (d > 30) {
                    d = 30;
                }
                int i = count - 1;
                while (i >= 0) {
                    JInternalFrame f = frames[i];
                    try {
                        f.setIcon(false);
                        f.setMaximum(false);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    Dimension dimen = f.getPreferredSize();
                    int w = dimen.width;
                    h = dimen.height;
                    this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                    --i;
                    x += d;
                    y += d;
                }
            } else {
                FileWindow obj = this.getFileWindow(cmd);
                if (obj != null) {
                    FileWindow w = obj;
                    try {
                        if (w.isIcon()) {
                            w.setIcon(false);
                        }
                        w.setVisible(true);
                        w.moveToFront();
                        w.setSelected(true);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
            }
        }
        if (returnValue != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            Object object = this.monitor;
            synchronized (object) {
                this.returnValue = returnValue;
                this.monitor.notify();
            }
        }
    }

    void runToCursor(String fileName, int lineNumber, ActionEvent evt) {
        Vector v = (Vector)this.sourceNames.get(fileName);
        if (v == null) {
            System.out.println("debugger error: Couldn't find source: " + fileName);
        }
        SourceEntry se = null;
        int i = v.size() - 1;
        while (i >= 0) {
            se = (SourceEntry)v.elementAt(i);
            if (se.fnOrScript.removeBreakpoint(lineNumber)) {
                se.fnOrScript.placeBreakpoint(lineNumber);
                break;
            }
            if (se.fnOrScript.placeBreakpoint(lineNumber)) {
                se.fnOrScript.removeBreakpoint(lineNumber);
                break;
            }
            --i;
        }
        if (i >= 0) {
            this.runToCursorFile = fileName;
            this.runToCursorLine = lineNumber;
            this.actionPerformed(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setBreakPoint(String sourceName, int lineNumber) {
        Vector v = (Vector)this.sourceNames.get(sourceName);
        if (v == null) {
            return -1;
        }
        int i = 0;
        int result = -1;
        i = v.size() - 1;
        while (i >= 0) {
            SourceEntry se = (SourceEntry)v.elementAt(i);
            if (se.fnOrScript.placeBreakpoint(lineNumber)) {
                result = lineNumber;
                break;
            }
            --i;
        }
        if (result != -1) {
            Map map = this.breakPoints;
            synchronized (map) {
                HashSet<Integer> lines = (HashSet<Integer>)this.breakPoints.get(sourceName);
                if (lines == null) {
                    lines = new HashSet<Integer>();
                    this.breakPoints.put(sourceName, lines);
                }
                lines.add(new Integer(result));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBreakPoint(String sourceName, int lineNumber) {
        Map map = this.breakPoints;
        synchronized (map) {
            Set lines = (Set)this.breakPoints.get(sourceName);
            if (lines != null) {
                lines.remove(new Integer(lineNumber));
            }
        }
        Vector v = (Vector)this.sourceNames.get(sourceName);
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            SourceEntry se = (SourceEntry)v.elementAt(i);
            se.fnOrScript.removeBreakpoint(lineNumber);
            ++i;
        }
    }

    JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    void removeWindow(FileWindow w) {
        this.fileWindows.remove(w.getUrl());
        JMenu windowMenu = this.getWindowMenu();
        int count = windowMenu.getItemCount();
        JMenuItem lastItem = windowMenu.getItem(count - 1);
        String name = new File(w.getUrl()).getName();
        int i = 5;
        while (i < count) {
            int pos;
            String text;
            JMenuItem item = windowMenu.getItem(i);
            if (item != null && (text = item.getText()).substring((pos = text.indexOf(32)) + 1).equals(name)) {
                windowMenu.remove(item);
                if (count == 6) {
                    windowMenu.remove(4);
                    break;
                }
                int j = i - 4;
                while (i < count - 1) {
                    JMenuItem thisItem = windowMenu.getItem(i);
                    if (thisItem != null) {
                        text = thisItem.getText();
                        if (text.equals("More Windows...")) break;
                        pos = text.indexOf(32);
                        thisItem.setText((char)(48 + j) + " " + text.substring(pos + 1));
                        thisItem.setMnemonic(48 + j);
                        ++j;
                    }
                    ++i;
                }
                if (count - 6 != 0 || lastItem == item || !lastItem.getText().equals("More Windows...")) break;
                windowMenu.remove(lastItem);
                break;
            }
            ++i;
        }
        windowMenu.revalidate();
    }

    boolean stringIsCompilableUnit(String expr) {
        Context cx = Context.enter();
        boolean result = cx.stringIsCompilableUnit(expr);
        cx.exit();
        return result;
    }

    String eval(String expr) {
        String resultString;
        Context cx = this.getCurrentContext();
        if (cx == null) {
            return "undefined";
        }
        ContextData contextData = ContextData.get(cx);
        ContextHelper helper = new ContextHelper();
        helper.attach(cx);
        if (this.frameIndex >= contextData.getFrameCount()) {
            helper.reset();
            return "undefined";
        }
        cx.setDebugger(null, null);
        cx.setGeneratingDebug(true);
        cx.setOptimizationLevel(this.optimizationLevel);
        boolean savedBreakNextLine = contextData.breakNextLine;
        contextData.breakNextLine = false;
        try {
            Object result;
            FrameHelper frame = contextData.getFrame(this.frameIndex);
            Scriptable scope = frame.getVariableObject();
            if (scope instanceof NativeCall) {
                NativeCall call = (NativeCall)scope;
                result = NativeGlobal.evalSpecial(cx, call, call.getThisObj(), new Object[]{expr}, "", 1);
            } else {
                result = cx.evaluateString(scope, expr, "", 0, null);
            }
            if (result == Undefined.instance) {
                result = "";
            }
            try {
                resultString = ScriptRuntime.toString(result);
            }
            catch (RuntimeException exc) {
                resultString = result.toString();
            }
        }
        catch (Exception exc) {
            resultString = exc.getMessage();
        }
        if (resultString == null) {
            resultString = "null";
        }
        cx.setDebugger(this, contextData);
        contextData.breakNextLine = savedBreakNextLine;
        helper.reset();
        return resultString;
    }

    void Exit() {
        this.returnValue = 6;
        if (this.exitAction != null) {
            Main.swingInvokeLater(this.exitAction);
        }
    }

    static void setResizeWeight(JSplitPane pane, double weight) {
        try {
            Method m = (class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = Main.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane).getMethod("setResizeWeight", Double.TYPE);
            m.invoke((Object)pane, new Double(weight));
        }
        catch (NoSuchMethodException exc) {
        }
        catch (IllegalAccessException exc) {
        }
        catch (InvocationTargetException exc) {}
    }

    boolean shouldDispatchTo(Component source) {
        Component root = SwingUtilities.getRoot(source);
        if (root == this) {
            return true;
        }
        Enumeration e = this.toplevels.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JFrame frame = (JFrame)this.toplevels.get(key);
            if (root != frame) continue;
            return true;
        }
        return false;
    }

    void addTopLevel(String key, JFrame frame) {
        if (frame != this) {
            this.toplevels.put(key, frame);
        }
    }

    void setBreakOnExceptions(boolean value) {
        this.breakOnExceptions = value;
    }

    public Main(String title) {
        super(title);
        this.init();
    }

    public void clearAllBreakpoints() {
        this.doClearBreakpoints();
    }

    public void setScopeProvider(ScopeProvider p) {
        this.scopeProvider = p;
    }

    public void setExitAction(Runnable r) {
        this.exitAction = r;
    }

    public InputStream getIn() {
        return this.console.getIn();
    }

    public PrintStream getOut() {
        return this.console.getOut();
    }

    public PrintStream getErr() {
        return this.console.getErr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            int optLevel = -1;
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.equals("-opt") || arg.equals("-O")) {
                    if (++i == args.length) {
                        org.mozilla.javascript.tools.shell.Main.usage(arg);
                    }
                    try {
                        double d = Double.parseDouble(args[i]);
                        optLevel = (int)d;
                    }
                    catch (Exception e) {
                        org.mozilla.javascript.tools.shell.Main.usage(arg);
                    }
                }
                ++i;
            }
            mainThread = Thread.currentThread();
            final Main sdb = new Main("Rhino JavaScript Debugger");
            Main.swingInvoke(new Runnable(){

                public void run() {
                    sdb.pack();
                    sdb.setSize(600, 460);
                    sdb.setVisible(true);
                }
            });
            sdb.setExitAction(new Runnable(){

                public void run() {
                    System.exit(0);
                }
            });
            System.setIn(sdb.getIn());
            System.setOut(sdb.getOut());
            System.setErr(sdb.getErr());
            Context.addContextListener(sdb);
            sdb.setScopeProvider(new ScopeProvider(){

                public Scriptable getScope() {
                    return org.mozilla.javascript.tools.shell.Main.getScope();
                }
            });
            sdb.setOptimizationLevel(optLevel);
            Context cx = Context.enter();
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
            try {
                org.mozilla.javascript.tools.shell.Main.exec(args);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                cx.exit();
                throw throwable;
            }
            cx.exit();
            {
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setOptimizationLevel(int i) {
        if (i < 0) {
            this.optimizationLevel = i;
        }
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SourceEntry {
        StringBuffer source;
        DebuggableScript fnOrScript;

        SourceEntry(StringBuffer source, DebuggableScript fnOrScript) {
            this.source = source;
            this.fnOrScript = fnOrScript;
        }
    }

    class ThreadState {
        private int stopAtFrameDepth = -1;

        ThreadState() {
        }

        static /* synthetic */ int access$000(ThreadState x0) {
            return x0.stopAtFrameDepth;
        }

        static /* synthetic */ int access$002(ThreadState x0, int x1) {
            x0.stopAtFrameDepth = x1;
            return x0.stopAtFrameDepth;
        }
    }
}

