/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;

class FrameHelper
implements DebugFrame {
    private Main master;
    private ContextData contextData;
    private Scriptable scope;
    private Scriptable thisObj;
    private DebuggableScript fnOrScript;
    private int lineNumber;

    FrameHelper(Context cx, Main master, Scriptable scope, Scriptable thisObj, DebuggableScript fnOrScript) {
        this.master = master;
        this.contextData = ContextData.get(cx);
        this.scope = scope;
        this.thisObj = thisObj;
        this.fnOrScript = fnOrScript;
        this.lineNumber = FrameHelper.getFirstLine(fnOrScript);
        this.contextData.pushFrame(this);
    }

    static int getFirstLine(DebuggableScript fnOrScript) {
        int[] lns = fnOrScript.getLineNumbers();
        int lineNumber = -1;
        int i = 0;
        while (i != lns.length) {
            if (lineNumber == -1) {
                lineNumber = lns[i];
            } else if (lns[i] < lineNumber) {
                lineNumber = lns[i];
            }
            ++i;
        }
        return lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void onLineChange(Context cx, int lineNumber, boolean breakpoint) {
        this.lineNumber = lineNumber;
        this.master.onLineChange(cx, this.getSourceName(), lineNumber, breakpoint || this.contextData.breakNextLine);
    }

    public void onExceptionThrown(Context cx, Throwable exception) {
        this.master.handleExceptionThrown(cx, exception, this);
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        if (this.master.breakOnReturn && !byThrow) {
            this.master.handleBreakpointHit(cx);
        }
        this.contextData.popFrame();
    }

    Scriptable getVariableObject() {
        if (this.scope instanceof NativeCall) {
            return this.scope;
        }
        return this.thisObj;
    }

    String getSourceName() {
        return this.fnOrScript.getSourceName();
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    DebuggableScript getScript() {
        return this.fnOrScript;
    }
}

