/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.Main;

class FindFunction
extends JDialog
implements ActionListener {
    private String value = null;
    private JList list;
    Hashtable functionMap;
    Main db;
    JButton setButton;
    JButton refreshButton;
    JButton cancelButton;

    public String showDialog(Component comp) {
        this.value = null;
        this.setLocationRelativeTo(comp);
        this.setVisible(true);
        return this.value;
    }

    private void setValue(String newValue) {
        this.value = newValue;
        this.list.setSelectedValue(this.value, true);
    }

    public void actionPerformed(ActionEvent e) {
        block8: {
            String cmd;
            block7: {
                cmd = e.getActionCommand();
                if (!cmd.equals("Cancel")) break block7;
                this.setVisible(false);
                this.value = null;
                break block8;
            }
            if (!cmd.equals("Select")) break block8;
            if (this.list.getSelectedIndex() < 0) {
                return;
            }
            try {
                this.value = (String)this.list.getSelectedValue();
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                return;
            }
            this.setVisible(false);
            Main.SourceEntry sourceEntry = (Main.SourceEntry)this.functionMap.get(this.value);
            DebuggableScript script = sourceEntry.fnOrScript;
            if (script != null) {
                String sourceName = script.getSourceName();
                int lineNumber = FrameHelper.getFirstLine(script);
                FileWindow w = this.db.getFileWindow(sourceName);
                if (w == null) {
                    new CreateFileWindow(this.db, sourceName, sourceEntry.source.toString(), lineNumber).run();
                    w = this.db.getFileWindow(sourceName);
                    w.setPosition(-1);
                }
                int start = w.getPosition(lineNumber - 1);
                int end = w.getPosition(lineNumber) - 1;
                w.textArea.select(start);
                w.textArea.setCaretPosition(start);
                w.textArea.moveCaretPosition(end);
                try {
                    w.show();
                    w.toFront();
                    this.db.requestFocus();
                    w.requestFocus();
                    w.textArea.requestFocus();
                }
                catch (Exception exc) {}
            }
        }
    }

    FindFunction(Main db, Hashtable functionMap, String title, String labelText) {
        super(db, title, true);
        this.functionMap = functionMap;
        this.db = db;
        this.cancelButton = new JButton("Cancel");
        this.setButton = new JButton("Select");
        this.cancelButton.addActionListener(this);
        this.setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.setButton);
        this.list = new JList(new DefaultListModel());
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.clear();
        Enumeration e = functionMap.keys();
        Object[] a = new String[functionMap.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            a[i++] = e.nextElement().toString();
        }
        Arrays.sort(a);
        i = 0;
        while (i < a.length) {
            model.addElement(a[i]);
            ++i;
        }
        this.list.setSelectedIndex(0);
        this.setButton.setEnabled(a.length > 0);
        this.list.setSelectionMode(1);
        this.list.addMouseListener(new MouseHandler());
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(320, 240));
        listScroller.setMinimumSize(new Dimension(250, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 1));
        JLabel label = new JLabel(labelText);
        label.setLabelFor(this.list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.setButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                int code = ke.getKeyCode();
                if (code == 27) {
                    ke.consume();
                    FindFunction.this.value = null;
                    FindFunction.this.setVisible(false);
                }
            }
        });
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                FindFunction.this.setButton.doClick();
            }
        }
    }
}

