/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.AbstractTreeTableModel;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.ContextHelper;
import org.mozilla.javascript.tools.debugger.EvalTextArea;
import org.mozilla.javascript.tools.debugger.Evaluator;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MyTableModel;
import org.mozilla.javascript.tools.debugger.MyTreeTable;
import org.mozilla.javascript.tools.debugger.VariableModel;

class ContextWindow
extends JPanel
implements ActionListener {
    JComboBox context;
    Vector toolTips;
    JTabbedPane tabs;
    JTabbedPane tabs2;
    MyTreeTable thisTable;
    MyTreeTable localsTable;
    VariableModel model;
    MyTableModel tableModel;
    Evaluator evaluator;
    EvalTextArea cmdLine;
    JSplitPane split;
    Main db;
    boolean enabled;
    static /* synthetic */ Class class$java$awt$event$WindowListener;

    ContextWindow(Main db) {
        this.db = db;
        this.enabled = false;
        JPanel left = new JPanel();
        JToolBar t1 = new JToolBar();
        t1.setName("Variables");
        t1.setLayout(new GridLayout());
        t1.add(left);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout());
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout());
        p1.add(t1);
        JLabel label = new JLabel("Context:");
        this.context = new JComboBox();
        this.context.setLightWeightPopupEnabled(false);
        this.toolTips = new Vector();
        label.setBorder(this.context.getBorder());
        this.context.addActionListener(this);
        this.context.setActionCommand("ContextSwitch");
        GridBagLayout layout = new GridBagLayout();
        left.setLayout(layout);
        GridBagConstraints lc = new GridBagConstraints();
        lc.insets.left = 5;
        lc.anchor = 17;
        lc.ipadx = 5;
        layout.setConstraints(label, lc);
        left.add(label);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 17;
        layout.setConstraints(this.context, c);
        left.add(this.context);
        this.tabs = new JTabbedPane(3);
        this.tabs.setPreferredSize(new Dimension(500, 300));
        this.thisTable = new MyTreeTable(new AbstractTreeTableModel(new DefaultMutableTreeNode()){

            public Object getChild(Object parent, int index) {
                return null;
            }

            public int getChildCount(Object parent) {
                return 0;
            }

            public int getColumnCount() {
                return 2;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return " Name";
                    }
                    case 1: {
                        return " Value";
                    }
                }
                return null;
            }

            public Object getValueAt(Object node, int column) {
                return null;
            }
        });
        JScrollPane jsp = new JScrollPane(this.thisTable);
        jsp.getViewport().setViewSize(new Dimension(5, 2));
        this.tabs.add("this", jsp);
        this.localsTable = new MyTreeTable(new AbstractTreeTableModel(new DefaultMutableTreeNode()){

            public Object getChild(Object parent, int index) {
                return null;
            }

            public int getChildCount(Object parent) {
                return 0;
            }

            public int getColumnCount() {
                return 2;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return " Name";
                    }
                    case 1: {
                        return " Value";
                    }
                }
                return null;
            }

            public Object getValueAt(Object node, int column) {
                return null;
            }
        });
        this.localsTable.setAutoResizeMode(4);
        this.localsTable.setPreferredSize(null);
        jsp = new JScrollPane(this.localsTable);
        this.tabs.add("Locals", jsp);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridheight = 0;
        c.fill = 1;
        c.anchor = 17;
        layout.setConstraints(this.tabs, c);
        left.add(this.tabs);
        this.evaluator = new Evaluator(db);
        this.cmdLine = new EvalTextArea(db);
        this.tableModel = this.evaluator.tableModel;
        jsp = new JScrollPane(this.evaluator);
        JToolBar t2 = new JToolBar();
        t2.setName("Evaluate");
        this.tabs2 = new JTabbedPane(3);
        this.tabs2.add("Watch", jsp);
        this.tabs2.add("Evaluate", new JScrollPane(this.cmdLine));
        this.tabs2.setPreferredSize(new Dimension(500, 300));
        t2.setLayout(new GridLayout());
        t2.add(this.tabs2);
        p2.add(t2);
        this.evaluator.setAutoResizeMode(4);
        this.split = new JSplitPane(1, p1, p2);
        this.split.setOneTouchExpandable(true);
        Main.setResizeWeight(this.split, 0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        final JToolBar finalT1 = t1;
        final JToolBar finalT2 = t2;
        final JPanel finalP1 = p1;
        final JPanel finalP2 = p2;
        final JSplitPane finalSplit = this.split;
        final ContextWindow finalThis = this;
        Main finalDb = db;
        ComponentListener clistener = new ComponentListener(){
            boolean t1Docked = true;
            boolean t2Docked = true;

            void check(Component comp) {
                JDialog dlg;
                JFrame frame;
                Container thisParent = finalThis.getParent();
                if (thisParent == null) {
                    return;
                }
                Container parent = finalT1.getParent();
                boolean leftDocked = true;
                boolean rightDocked = true;
                boolean adjustVerticalSplit = false;
                if (parent != null) {
                    if (parent != finalP1) {
                        while (!(parent instanceof JFrame) && !(parent instanceof JDialog)) {
                            parent = parent.getParent();
                        }
                        if (parent instanceof JFrame) {
                            frame = (JFrame)parent;
                            if (!frame.isResizable()) {
                                frame.setResizable(true);
                                frame.setDefaultCloseOperation(0);
                                EventListener[] l = frame.getListeners(class$java$awt$event$WindowListener == null ? (class$java$awt$event$WindowListener = ContextWindow.class$("java.awt.event.WindowListener")) : class$java$awt$event$WindowListener);
                                frame.removeWindowListener((WindowListener)l[0]);
                                frame.addWindowListener(new WindowAdapter(this, l){
                                    private final /* synthetic */ EventListener[] val$l;
                                    private final /* synthetic */ 3 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$l = val$l;
                                    }

                                    public void windowClosing(WindowEvent e) {
                                        3.access$000(this.this$1).context.hidePopup();
                                        ((WindowListener)this.val$l[0]).windowClosing(e);
                                    }
                                });
                            }
                        } else {
                            dlg = (JDialog)parent;
                            dlg.setResizable(true);
                        }
                        leftDocked = false;
                    } else {
                        leftDocked = true;
                    }
                }
                if ((parent = finalT2.getParent()) != null) {
                    if (parent != finalP2) {
                        while (!(parent instanceof JDialog) && !(parent instanceof JFrame)) {
                            parent = parent.getParent();
                        }
                        if (parent instanceof JFrame) {
                            frame = (JFrame)parent;
                            frame.setResizable(true);
                        } else {
                            dlg = (JDialog)parent;
                            dlg.setResizable(true);
                        }
                        rightDocked = false;
                    } else {
                        rightDocked = true;
                    }
                }
                if (leftDocked && this.t2Docked && rightDocked && this.t2Docked) {
                    return;
                }
                this.t1Docked = leftDocked;
                this.t2Docked = rightDocked;
                JSplitPane split = (JSplitPane)thisParent;
                if (leftDocked) {
                    if (rightDocked) {
                        finalSplit.setDividerLocation(0.5);
                    } else {
                        finalSplit.setDividerLocation(1.0);
                    }
                    if (adjustVerticalSplit) {
                        split.setDividerLocation(0.66);
                    }
                } else if (rightDocked) {
                    finalSplit.setDividerLocation(0.0);
                    split.setDividerLocation(0.66);
                } else {
                    split.setDividerLocation(1.0);
                }
            }

            public void componentHidden(ComponentEvent e) {
                this.check(e.getComponent());
            }

            public void componentMoved(ComponentEvent e) {
                this.check(e.getComponent());
            }

            public void componentResized(ComponentEvent e) {
                this.check(e.getComponent());
            }

            public void componentShown(ComponentEvent e) {
                this.check(e.getComponent());
            }

            static /* synthetic */ ContextWindow access$000(3 x0) {
                return x0.ContextWindow.this;
            }
        };
        p1.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                Container thisParent = finalThis.getParent();
                JSplitPane split = (JSplitPane)thisParent;
                if (e.getChild() == finalT1) {
                    if (finalT2.getParent() == finalP2) {
                        finalSplit.setDividerLocation(0.5);
                    } else {
                        finalSplit.setDividerLocation(1.0);
                    }
                    split.setDividerLocation(0.66);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Container thisParent = finalThis.getParent();
                JSplitPane split = (JSplitPane)thisParent;
                if (e.getChild() == finalT1) {
                    if (finalT2.getParent() == finalP2) {
                        finalSplit.setDividerLocation(0.0);
                        split.setDividerLocation(0.66);
                    } else {
                        split.setDividerLocation(1.0);
                    }
                }
            }
        });
        p2.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                Container thisParent = finalThis.getParent();
                JSplitPane split = (JSplitPane)thisParent;
                if (e.getChild() == finalT2) {
                    if (finalT1.getParent() == finalP1) {
                        finalSplit.setDividerLocation(0.5);
                    } else {
                        finalSplit.setDividerLocation(1.0);
                    }
                    split.setDividerLocation(0.66);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Container thisParent = finalThis.getParent();
                JSplitPane split = (JSplitPane)thisParent;
                if (e.getChild() == finalT2) {
                    if (finalT1.getParent() == finalP1) {
                        finalSplit.setDividerLocation(0.0);
                        split.setDividerLocation(0.66);
                    } else {
                        split.setDividerLocation(1.0);
                    }
                }
            }
        });
        t1.addComponentListener(clistener);
        t2.addComponentListener(clistener);
        this.disable_();
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.enabled) {
            return;
        }
        if (e.getActionCommand().equals("ContextSwitch")) {
            ContextHelper helper = new ContextHelper();
            Context cx = this.db.getCurrentContext();
            ContextData contextData = ContextData.get(cx);
            helper.attach(cx);
            int frameIndex = this.context.getSelectedIndex();
            this.context.setToolTipText(this.toolTips.elementAt(frameIndex).toString());
            int frameCount = contextData.getFrameCount();
            if (frameIndex >= frameCount) {
                helper.reset();
                return;
            }
            FrameHelper frame = contextData.getFrame(frameIndex);
            Scriptable obj = frame.getVariableObject();
            NativeCall call = null;
            if (obj instanceof NativeCall) {
                call = (NativeCall)obj;
                obj = call.getThisObj();
            }
            this.model = new VariableModel(obj);
            JTree tree = this.thisTable.resetTree(this.model);
            if (call == null) {
                tree = this.localsTable.resetTree(new AbstractTreeTableModel(new DefaultMutableTreeNode()){

                    public Object getChild(Object parent, int index) {
                        return null;
                    }

                    public int getChildCount(Object parent) {
                        return 0;
                    }

                    public int getColumnCount() {
                        return 2;
                    }

                    public String getColumnName(int column) {
                        switch (column) {
                            case 0: {
                                return " Name";
                            }
                            case 1: {
                                return " Value";
                            }
                        }
                        return null;
                    }

                    public Object getValueAt(Object node, int column) {
                        return null;
                    }
                });
            } else {
                this.model = new VariableModel(call);
                tree = this.localsTable.resetTree(this.model);
            }
            helper.reset();
            this.db.contextSwitch(frameIndex);
            this.tableModel.updateModel();
        }
    }

    public void disable_() {
        this.context.setEnabled(false);
        this.thisTable.setEnabled(false);
        this.localsTable.setEnabled(false);
        this.evaluator.setEnabled(false);
        this.cmdLine.setEnabled(false);
    }

    public void enable_() {
        this.context.setEnabled(true);
        this.thisTable.setEnabled(true);
        this.localsTable.setEnabled(true);
        this.evaluator.setEnabled(true);
        this.cmdLine.setEnabled(true);
    }

    public void disableUpdate() {
        this.enabled = false;
    }

    public void enableUpdate() {
        this.enabled = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

