/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptableOutputStream
extends ObjectOutputStream {
    private Scriptable scope;
    private Hashtable table;

    public ScriptableOutputStream(OutputStream out, Scriptable scope) throws IOException {
        super(out);
        this.scope = scope;
        this.table = new Hashtable(31);
        this.table.put(scope, "");
        this.enableReplaceObject(true);
        if (scope == ScriptableObject.getTopLevelScope(scope)) {
            this.excludeStandardObjectNames();
        }
    }

    public void addExcludedName(String name) {
        Object obj = ScriptableOutputStream.lookupQualifiedName(this.scope, name);
        if (!(obj instanceof Scriptable)) {
            throw new IllegalArgumentException("Object for excluded name " + name + " not found.");
        }
        this.table.put(obj, name);
    }

    public boolean hasExcludedName(String name) {
        return this.table.get(name) != null;
    }

    public void removeExcludedName(String name) {
        this.table.remove(name);
    }

    public void excludeStandardObjectNames() {
        String[] names = new String[]{"Object", "Object.prototype", "Function", "Function.prototype", "String", "String.prototype", "Math", "Array", "Array.prototype", "Error", "Error.prototype", "Number", "Number.prototype", "Date", "Date.prototype", "RegExp", "RegExp.prototype", "Script", "Script.prototype"};
        int i = 0;
        while (i < names.length) {
            this.addExcludedName(names[i]);
            ++i;
        }
    }

    static Object lookupQualifiedName(Scriptable scope, String qualifiedName) {
        StringTokenizer st = new StringTokenizer(qualifiedName, ".");
        Object result = scope;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if ((result = result.get(s, (Scriptable)result)) == null || !(result instanceof Scriptable)) break;
        }
        return result;
    }

    protected Object replaceObject(Object obj) throws IOException {
        String name = (String)this.table.get(obj);
        if (name == null) {
            return obj;
        }
        return new PendingLookup(name);
    }

    static class PendingLookup
    implements Serializable {
        private String name;

        PendingLookup(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

