/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.Block;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;
import org.mozilla.javascript.optimizer.OptVariableTable;
import org.mozilla.javascript.optimizer.StmtNodeIterator;

public class Optimizer {
    private static final boolean DEBUG_OPTIMIZER = false;
    private static final boolean DO_CONSTANT_FOLDING = true;
    static int blockCount = 0;
    boolean inDirectCallFunction;
    boolean parameterUsedInNumberContext;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;
    int itsOptLevel;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void optimizeFunction(OptFunctionNode theFunction) {
        if (theFunction.requiresActivation()) {
            return;
        }
        this.inDirectCallFunction = theFunction.isTargetOfDirectCall();
        Node[] theStatementNodes = this.buildStatementList(theFunction);
        Block[] theBlocks = Block.buildBlocks(theStatementNodes);
        Object pw = null;
        try {
            block7: {
                try {
                    OptVariableTable vars = (OptVariableTable)theFunction.getVariableTable();
                    if (vars == null) break block7;
                    vars.establishIndices();
                    int i = 0;
                    while (i < theStatementNodes.length) {
                        this.replaceVariableAccess(theStatementNodes[i], vars);
                        ++i;
                    }
                    this.foldConstants(theFunction, null);
                    this.reachingDefDataFlow(vars, theBlocks);
                    this.typeFlow(vars, theBlocks);
                    this.findSinglyTypedVars(vars, theBlocks);
                    this.localCSE(theBlocks, theFunction);
                    if (theFunction.requiresActivation()) break block7;
                    this.parameterUsedInNumberContext = false;
                    int i2 = 0;
                    while (i2 < theStatementNodes.length) {
                        this.rewriteForNumberVariables(theStatementNodes[i2]);
                        ++i2;
                    }
                    theFunction.setParameterNumberContext(this.parameterUsedInNumberContext);
                }
                catch (IOException x) {
                    Object var9_10 = null;
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void optimize(Node tree, int optLevel) {
        Node node;
        this.itsOptLevel = optLevel;
        PreorderNodeIterator iterator = tree.getPreorderIterator();
        while ((node = iterator.nextNode()) != null) {
            OptFunctionNode theFunction;
            void var4_4;
            if (var4_4.getType() != 110 || (theFunction = (OptFunctionNode)var4_4.getProp(5)) == null) continue;
            this.optimizeFunction(theFunction);
        }
    }

    void findSinglyTypedVars(VariableTable theVariables, Block[] theBlocks) {
        int i = 0;
        while (i < theVariables.size()) {
            int theType;
            OptLocalVariable lVar = (OptLocalVariable)theVariables.getVariable(i);
            if (!lVar.isParameter() && (theType = lVar.getTypeUnion()) == 1) {
                lVar.setIsNumber();
            }
            ++i;
        }
    }

    void doBlockLocalCSE(Block[] theBlocks, Block b, Hashtable theCSETable, boolean[] beenThere, OptFunctionNode theFunction) {
        if (!beenThere[b.getBlockID()]) {
            beenThere[b.getBlockID()] = true;
            theCSETable = b.localCSE(theCSETable, theFunction);
            Block[] succ = theBlocks[b.getBlockID()].getSuccessorList();
            if (succ != null) {
                int i = 0;
                while (i < succ.length) {
                    int index = succ[i].getBlockID();
                    Block[] pred = theBlocks[index].getPredecessorList();
                    if (pred.length == 1) {
                        this.doBlockLocalCSE(theBlocks, succ[i], (Hashtable)theCSETable.clone(), beenThere, theFunction);
                    }
                    ++i;
                }
            }
        }
    }

    void localCSE(Block[] theBlocks, OptFunctionNode theFunction) {
        boolean[] beenThere = new boolean[theBlocks.length];
        this.doBlockLocalCSE(theBlocks, theBlocks[0], null, beenThere, theFunction);
        int i = 0;
        while (i < theBlocks.length) {
            if (!beenThere[i]) {
                theBlocks[i].localCSE(null, theFunction);
            }
            ++i;
        }
    }

    void typeFlow(VariableTable theVariables, Block[] theBlocks) {
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = 0;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] succ;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doTypeFlow() && (succ = theBlocks[vIndex].getSuccessorList()) != null) {
                    int i = 0;
                    while (i < succ.length) {
                        int index = succ[i].getBlockID();
                        visit[index] = true;
                        needRescan |= index < vIndex;
                        ++i;
                    }
                }
            }
            if (vIndex == theBlocks.length - 1) {
                if (!needRescan) break;
                vIndex = 0;
                needRescan = false;
                continue;
            }
            ++vIndex;
        }
    }

    void reachingDefDataFlow(VariableTable theVariables, Block[] theBlocks) {
        int i = 0;
        while (i < theBlocks.length) {
            theBlocks[i].initLiveOnEntrySets(theVariables);
            ++i;
        }
        boolean[] visit = new boolean[theBlocks.length];
        boolean[] doneOnce = new boolean[theBlocks.length];
        int vIndex = theBlocks.length - 1;
        boolean needRescan = false;
        visit[vIndex] = true;
        while (true) {
            if (visit[vIndex] || !doneOnce[vIndex]) {
                Block[] pred;
                doneOnce[vIndex] = true;
                visit[vIndex] = false;
                if (theBlocks[vIndex].doReachedUseDataFlow() && (pred = theBlocks[vIndex].getPredecessorList()) != null) {
                    int i2 = 0;
                    while (i2 < pred.length) {
                        int index = pred[i2].getBlockID();
                        visit[index] = true;
                        needRescan |= index > vIndex;
                        ++i2;
                    }
                }
            }
            if (vIndex == 0) {
                if (!needRescan) break;
                vIndex = theBlocks.length - 1;
                needRescan = false;
                continue;
            }
            --vIndex;
        }
        int i3 = 0;
        while (i3 < theBlocks.length) {
            theBlocks[i3].markVolatileVariables(theVariables);
            ++i3;
        }
        theBlocks[0].markAnyTypeVariables(theVariables);
    }

    void markDCPNumberContext(Node n) {
        OptLocalVariable theVar;
        if (this.inDirectCallFunction && n.getType() == 72 && (theVar = (OptLocalVariable)n.getProp(24)) != null && theVar.isParameter()) {
            this.parameterUsedInNumberContext = true;
        }
    }

    boolean convertParameter(Node n) {
        OptLocalVariable theVar;
        if (this.inDirectCallFunction && n.getType() == 72 && (theVar = (OptLocalVariable)n.getProp(24)) != null && theVar.isParameter()) {
            n.removeProp(26);
            return true;
        }
        return false;
    }

    int rewriteForNumberVariables(Node n) {
        switch (n.getType()) {
            case 57: {
                Node child = n.getFirstChild();
                int type = this.rewriteForNumberVariables(child);
                if (type == 1) {
                    n.putIntProp(26, 0);
                }
                return 0;
            }
            case 45: {
                n.putIntProp(26, 0);
                return 1;
            }
            case 72: {
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(24);
                if (theVar != null) {
                    if (this.inDirectCallFunction && theVar.isParameter()) {
                        n.putIntProp(26, 0);
                        return 1;
                    }
                    if (theVar.isNumber()) {
                        n.putIntProp(26, 0);
                        return 1;
                    }
                }
                return 0;
            }
            case 106: 
            case 107: {
                Node child = n.getFirstChild();
                if (child.getType() == 72) {
                    OptLocalVariable theVar = (OptLocalVariable)child.getProp(24);
                    if (theVar != null && theVar.isNumber()) {
                        n.putIntProp(26, 0);
                        this.markDCPNumberContext(child);
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
            case 73: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNextSibling();
                int rType = this.rewriteForNumberVariables(rChild);
                OptLocalVariable theVar = (OptLocalVariable)n.getProp(24);
                if (this.inDirectCallFunction && theVar.isParameter()) {
                    if (rType == 1) {
                        if (!this.convertParameter(rChild)) {
                            n.putIntProp(26, 0);
                            return 1;
                        }
                        this.markDCPNumberContext(rChild);
                        return 0;
                    }
                    return rType;
                }
                if (theVar != null && theVar.isNumber()) {
                    if (rType != 1) {
                        n.removeChild(rChild);
                        Node newRChild = new Node(142, rChild);
                        newRChild.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                        n.addChildToBack(newRChild);
                    }
                    n.putIntProp(26, 0);
                    this.markDCPNumberContext(rChild);
                    return 1;
                }
                if (rType == 1 && !this.convertParameter(rChild)) {
                    n.removeChild(rChild);
                    Node newRChild = new Node(142, rChild);
                    newRChild.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    n.addChildToBack(newRChild);
                }
                return 0;
            }
            case 103: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNextSibling();
                int lType = this.rewriteForNumberVariables(lChild);
                int rType = this.rewriteForNumberVariables(rChild);
                this.markDCPNumberContext(lChild);
                this.markDCPNumberContext(rChild);
                if (n.getInt() == 64 || n.getInt() == 63) {
                    Node nuChild;
                    if (lType == 1 && !this.convertParameter(lChild)) {
                        n.removeChild(lChild);
                        nuChild = new Node(142, lChild);
                        nuChild.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                        n.addChildToFront(nuChild);
                    }
                    if (rType == 1 && !this.convertParameter(rChild)) {
                        n.removeChild(rChild);
                        nuChild = new Node(142, rChild);
                        nuChild.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                        n.addChildToBack(nuChild);
                    }
                } else if (this.convertParameter(lChild)) {
                    if (this.convertParameter(rChild)) {
                        return 0;
                    }
                    if (rType == 1) {
                        n.putIntProp(26, 2);
                    }
                } else if (this.convertParameter(rChild)) {
                    if (lType == 1) {
                        n.putIntProp(26, 1);
                    }
                } else if (lType == 1) {
                    if (rType == 1) {
                        n.putIntProp(26, 0);
                    } else {
                        n.putIntProp(26, 1);
                    }
                } else if (rType == 1) {
                    n.putIntProp(26, 2);
                }
                return 0;
            }
            case 23: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNextSibling();
                int lType = this.rewriteForNumberVariables(lChild);
                int rType = this.rewriteForNumberVariables(rChild);
                if (this.convertParameter(lChild)) {
                    if (this.convertParameter(rChild)) {
                        return 0;
                    }
                    if (rType == 1) {
                        n.putIntProp(26, 2);
                    }
                } else if (this.convertParameter(rChild)) {
                    if (lType == 1) {
                        n.putIntProp(26, 1);
                    }
                } else if (lType == 1) {
                    if (rType == 1) {
                        n.putIntProp(26, 0);
                        return 1;
                    }
                    n.putIntProp(26, 1);
                } else if (rType == 1) {
                    n.putIntProp(26, 2);
                }
                return 0;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                Node lChild = n.getFirstChild();
                Node rChild = lChild.getNextSibling();
                int lType = this.rewriteForNumberVariables(lChild);
                int rType = this.rewriteForNumberVariables(rChild);
                this.markDCPNumberContext(lChild);
                this.markDCPNumberContext(rChild);
                if (lType == 1) {
                    if (rType == 1) {
                        n.putIntProp(26, 0);
                        return 1;
                    }
                    if (!this.convertParameter(rChild)) {
                        n.removeChild(rChild);
                        Node newRChild = new Node(142, rChild);
                        newRChild.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                        n.addChildToBack(newRChild);
                        n.putIntProp(26, 0);
                    }
                    return 1;
                }
                if (rType == 1) {
                    if (!this.convertParameter(lChild)) {
                        n.removeChild(lChild);
                        Node newLChild = new Node(142, lChild);
                        newLChild.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                        n.addChildToFront(newLChild);
                        n.putIntProp(26, 0);
                    }
                    return 1;
                }
                if (!this.convertParameter(lChild)) {
                    n.removeChild(lChild);
                    Node newLChild = new Node(142, lChild);
                    newLChild.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                    n.addChildToFront(newLChild);
                }
                if (!this.convertParameter(rChild)) {
                    n.removeChild(rChild);
                    Node newRChild = new Node(142, rChild);
                    newRChild.putProp(18, class$java$lang$Double == null ? (class$java$lang$Double = Optimizer.class$("java.lang.Double")) : class$java$lang$Double);
                    n.addChildToBack(newRChild);
                }
                n.putIntProp(26, 0);
                return 1;
            }
            case 42: {
                int rValueType;
                int indexType;
                Node arrayBase = n.getFirstChild();
                Node arrayIndex = arrayBase.getNextSibling();
                Node rValue = arrayIndex.getNextSibling();
                int baseType = this.rewriteForNumberVariables(arrayBase);
                if (baseType == 1 && !this.convertParameter(arrayBase)) {
                    n.removeChild(arrayBase);
                    Node nuChild = new Node(142, arrayBase);
                    nuChild.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    n.addChildToFront(nuChild);
                }
                if ((indexType = this.rewriteForNumberVariables(arrayIndex)) == 1) {
                    n.putIntProp(26, 1);
                    this.markDCPNumberContext(arrayIndex);
                }
                if ((rValueType = this.rewriteForNumberVariables(rValue)) == 1 && !this.convertParameter(rValue)) {
                    n.removeChild(rValue);
                    Node nuChild = new Node(142, rValue);
                    nuChild.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    n.addChildToBack(nuChild);
                }
                return 0;
            }
            case 41: {
                int indexType;
                Node arrayBase = n.getFirstChild();
                Node arrayIndex = arrayBase.getNextSibling();
                int baseType = this.rewriteForNumberVariables(arrayBase);
                if (baseType == 1 && !this.convertParameter(arrayBase)) {
                    n.removeChild(arrayBase);
                    Node nuChild = new Node(142, arrayBase);
                    nuChild.putProp(18, class$java$lang$Object == null ? (class$java$lang$Object = Optimizer.class$("java.lang.Object")) : class$java$lang$Object);
                    n.addChildToFront(nuChild);
                }
                if ((indexType = this.rewriteForNumberVariables(arrayIndex)) == 1) {
                    n.putIntProp(26, 2);
                    this.markDCPNumberContext(arrayIndex);
                }
                return 0;
            }
            case 43: {
                FunctionNode target = (FunctionNode)n.getProp(27);
                if (target == null) break;
                Node child = n.getFirstChild();
                this.rewriteForNumberVariables(child);
                child = child.getNextSibling();
                this.rewriteForNumberVariables(child);
                child = child.getNextSibling();
                while (child != null) {
                    int type = this.rewriteForNumberVariables(child);
                    if (type == 1) {
                        this.markDCPNumberContext(child);
                    }
                    child = child.getNextSibling();
                }
                return 0;
            }
        }
        Node child = n.getFirstChild();
        while (child != null) {
            Node nextChild = child.getNextSibling();
            int type = this.rewriteForNumberVariables(child);
            if (type == 1 && !this.convertParameter(child)) {
                n.removeChild(child);
                Node nuChild = new Node(142, child);
                nuChild.putProp(18, class$java$lang$Object == null ? Optimizer.class$("java.lang.Object") : class$java$lang$Object);
                if (nextChild == null) {
                    n.addChildToBack(nuChild);
                } else {
                    n.addChildBefore(nuChild, nextChild);
                }
            }
            child = nextChild;
        }
        return 0;
    }

    void foldConstants(Node n, Node parent) {
        Node rChild = null;
        Node lChild = n.getFirstChild();
        if (lChild == null) {
            return;
        }
        rChild = lChild.getNextSibling();
        if (rChild == null) {
            this.foldConstants(lChild, n);
            return;
        }
        this.foldConstants(lChild, n);
        this.foldConstants(rChild, n);
        Node child = rChild.getNextSibling();
        while (child != null) {
            this.foldConstants(child, n);
            child = child.getNextSibling();
        }
        lChild = n.getFirstChild();
        if (lChild == null) {
            return;
        }
        rChild = lChild.getNextSibling();
        if (rChild == null) {
            return;
        }
        int lt = lChild.getType();
        int rt = rChild.getType();
        Node replace = null;
        switch (n.getType()) {
            case 23: {
                if (lt == 45 && rt == 45) {
                    replace = new Node(45, lChild.getDouble() + rChild.getDouble());
                    break;
                }
                if (lt == 46 && rt == 46) {
                    replace = new Node(46, lChild.getString() + rChild.getString());
                    break;
                }
                if (lt == 46 && rt == 45) {
                    replace = new Node(46, lChild.getString() + ScriptRuntime.numberToString(rChild.getDouble(), 10));
                    break;
                }
                if (lt != 45 || rt != 46) break;
                replace = new Node(46, ScriptRuntime.numberToString(lChild.getDouble(), 10) + rChild.getString());
                break;
            }
            case 24: {
                if (lt == 45 && rt == 45) {
                    replace = new Node(45, lChild.getDouble() - rChild.getDouble());
                    break;
                }
                if (lt == 45 && lChild.getDouble() == 0.0) {
                    replace = new Node(105, rChild, 24);
                    break;
                }
                if (rt != 45 || rChild.getDouble() != 0.0) break;
                replace = new Node(105, lChild, 23);
                break;
            }
            case 25: {
                if (lt == 45 && rt == 45) {
                    replace = new Node(45, lChild.getDouble() * rChild.getDouble());
                    break;
                }
                if (lt == 45 && lChild.getDouble() == 1.0) {
                    replace = new Node(105, rChild, 23);
                    break;
                }
                if (rt != 45 || rChild.getDouble() != 1.0) break;
                replace = new Node(105, lChild, 23);
                break;
            }
            case 26: {
                if (lt == 45 && rt == 45) {
                    replace = new Node(45, lChild.getDouble() / rChild.getDouble());
                    break;
                }
                if (rt != 45 || rChild.getDouble() != 1.0) break;
                replace = new Node(105, lChild, 23);
                break;
            }
            case 101: {
                int isRDefined;
                int isLDefined = Optimizer.isAlwaysDefinedBoolean(lChild);
                if (isLDefined == -1 && !IRFactory.hasSideEffects(rChild)) {
                    replace = new Node(109, 51);
                }
                if ((isRDefined = Optimizer.isAlwaysDefinedBoolean(rChild)) == -1) {
                    if (!IRFactory.hasSideEffects(lChild)) {
                        replace = new Node(109, 51);
                    }
                } else if (isRDefined == 1) {
                    replace = lChild;
                }
                if (isLDefined != 1) break;
                replace = rChild;
                break;
            }
            case 100: {
                int isRDefined;
                int isLDefined = Optimizer.isAlwaysDefinedBoolean(lChild);
                if (isLDefined == 1 && !IRFactory.hasSideEffects(rChild)) {
                    replace = new Node(109, 52);
                }
                if ((isRDefined = Optimizer.isAlwaysDefinedBoolean(rChild)) == 1) {
                    if (!IRFactory.hasSideEffects(lChild)) {
                        replace = new Node(109, 52);
                    }
                } else if (isRDefined == -1) {
                    replace = lChild;
                }
                if (isLDefined != -1) break;
                replace = rChild;
                break;
            }
            case 133: {
                if (lChild.getType() != 8) break;
                Node condition = lChild.getFirstChild();
                int definedBoolean = Optimizer.isAlwaysDefinedBoolean(condition);
                if (definedBoolean == -1) {
                    Node elseClause;
                    Node next3;
                    Node next2;
                    Node next1 = rChild.getNextSibling();
                    if (next1 == null || (next2 = next1.getNextSibling()) == null || (next3 = next2.getNextSibling()) == null || (elseClause = next3.getFirstChild()) == null) break;
                    replace = elseClause;
                    break;
                }
                if (definedBoolean != 1 || rChild.getType() != 133) break;
                replace = rChild.getFirstChild();
            }
        }
        if (replace != null) {
            parent.replaceChild(n, replace);
        }
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        int result = 0;
        int type = node.getType();
        if (type == 109) {
            int id = node.getInt();
            if (id == 51 || id == 49 || id == 74) {
                result = -1;
            } else if (id == 52) {
                result = 1;
            }
        } else if (type == 45) {
            double num = node.getDouble();
            if (num == 0.0) {
                if (1.0 / num > 0.0) {
                    result = -1;
                }
            } else {
                result = 1;
            }
        }
        return result;
    }

    void replaceVariableAccess(Node n, VariableTable theVariables) {
        Node child = n.getFirstChild();
        while (child != null) {
            this.replaceVariableAccess(child, theVariables);
            child = child.getNextSibling();
        }
        switch (n.getType()) {
            case 73: {
                String name = n.getFirstChild().getString();
                OptLocalVariable theVar = (OptLocalVariable)theVariables.getVariable(name);
                if (theVar == null) break;
                n.putProp(24, theVar);
                break;
            }
            case 72: {
                String name = n.getString();
                OptLocalVariable theVar = (OptLocalVariable)theVariables.getVariable(name);
                if (theVar == null) break;
                n.putProp(24, theVar);
                break;
            }
        }
    }

    private Node[] buildStatementList(FunctionNode theFunction) {
        Vector<Node> nodeList = new Vector<Node>();
        StmtNodeIterator iterator = new StmtNodeIterator(theFunction);
        Node node = iterator.nextNode();
        while (node != null) {
            nodeList.addElement(node);
            node = iterator.nextNode();
        }
        Node[] result = new Node[nodeList.size()];
        int i = 0;
        while (i < nodeList.size()) {
            result[i] = (Node)nodeList.elementAt(i);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

