/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class OptRuntime
extends ScriptRuntime {
    private OptRuntime() {
    }

    /*
     * Unable to fully structure code
     */
    public static Object getElem(Object obj, double dblIndex, Scriptable scope) {
        block4: {
            index = (int)dblIndex;
            m = start = obj instanceof Scriptable != false ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
            if ((double)index == dblIndex) ** GOTO lbl16
            s = ScriptRuntime.toString(dblIndex);
            while (m != null) {
                result = m.get(s, start);
                if (result != Scriptable.NOT_FOUND) {
                    return result;
                }
                m = m.getPrototype();
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                result = m.get(index, start);
                if (result != Scriptable.NOT_FOUND) {
                    return result;
                }
                m = m.getPrototype();
lbl16:
                // 2 sources

                ** while (m != null)
            }
        }
        return Undefined.instance;
    }

    public static Object setElem(Object obj, double dblIndex, Object value, Scriptable scope) {
        Scriptable start;
        int index = (int)dblIndex;
        Scriptable m = start = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        if ((double)index != dblIndex) {
            String s = ScriptRuntime.toString(dblIndex);
            do {
                if (!m.has(s, start)) continue;
                m.put(s, start, value);
                return value;
            } while ((m = m.getPrototype()) != null);
            start.put(s, start, value);
        } else {
            do {
                if (!m.has(index, start)) continue;
                m.put(index, start, value);
                return value;
            } while ((m = m.getPrototype()) != null);
            start.put(index, start, value);
        }
        return value;
    }

    public static Object add(Object val1, double val2) {
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(null);
        }
        if (!(val1 instanceof String)) {
            return new Double(ScriptRuntime.toNumber(val1) + val2);
        }
        return ScriptRuntime.toString(val1) + ScriptRuntime.toString(val2);
    }

    public static Object add(double val1, Object val2) {
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(null);
        }
        if (!(val2 instanceof String)) {
            return new Double(ScriptRuntime.toNumber(val2) + val1);
        }
        return ScriptRuntime.toString(val1) + ScriptRuntime.toString(val2);
    }

    public static boolean neq(Object x, Object y) {
        return !ScriptRuntime.eq(x, y);
    }

    public static boolean shallowNeq(Object x, Object y) {
        return !ScriptRuntime.shallowEq(x, y);
    }

    public static Boolean cmp_LTB(double d1, Object val2) {
        if (OptRuntime.cmp_LT(d1, val2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(double d1, Object val2) {
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(ScriptRuntime.NumberClass);
        }
        if (!(val2 instanceof String)) {
            if (d1 != d1) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(val2);
            if (d2 != d2) {
                return 0;
            }
            return d1 < d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(d1).compareTo(ScriptRuntime.toString(val2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LTB(Object val1, double d2) {
        if (OptRuntime.cmp_LT(val1, d2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object val1, double d2) {
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(ScriptRuntime.NumberClass);
        }
        if (!(val1 instanceof String)) {
            double d1 = ScriptRuntime.toNumber(val1);
            if (d1 != d1) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d1 < d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(val1).compareTo(ScriptRuntime.toString(d2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(double d1, Object val2) {
        if (OptRuntime.cmp_LE(d1, val2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(double d1, Object val2) {
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(ScriptRuntime.NumberClass);
        }
        if (!(val2 instanceof String)) {
            if (d1 != d1) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(val2);
            if (d2 != d2) {
                return 0;
            }
            return d1 <= d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(d1).compareTo(ScriptRuntime.toString(val2)) <= 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object val1, double d2) {
        if (OptRuntime.cmp_LE(val1, d2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(Object val1, double d2) {
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(ScriptRuntime.NumberClass);
        }
        if (!(val1 instanceof String)) {
            double d1 = ScriptRuntime.toNumber(val1);
            if (d1 != d1) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d1 <= d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(val1).compareTo(ScriptRuntime.toString(d2)) <= 0 ? 1 : 0;
    }

    public static int cmp(Object val1, Object val2) {
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(ScriptRuntime.NumberClass);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(ScriptRuntime.NumberClass);
        }
        if (!(val1 instanceof String) || !(val2 instanceof String)) {
            double d1 = ScriptRuntime.toNumber(val1);
            if (d1 != d1) {
                return -1;
            }
            double d2 = ScriptRuntime.toNumber(val2);
            if (d2 != d2) {
                return -1;
            }
            return d1 < d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(val1).compareTo(ScriptRuntime.toString(val2)) < 0 ? 1 : 0;
    }

    /*
     * Unable to fully structure code
     */
    public static Object callSimple(Context cx, String id, Scriptable scope, Object[] args) throws JavaScriptException {
        obj = scope;
        prop = null;
        thisArg = null;
        block2: while (obj != null) {
            m = obj;
            do {
                if ((prop = m.get(id, obj)) == Scriptable.NOT_FOUND) continue;
                thisArg = obj;
                break block2;
            } while ((m = m.getPrototype()) != null);
            obj = obj.getParentScope();
        }
        if (prop != null && prop != Scriptable.NOT_FOUND) ** GOTO lbl17
        errorArgs = new Object[]{id};
        throw NativeGlobal.constructError(cx, "ReferenceError", ScriptRuntime.getMessage("msg.is.not.defined", errorArgs), scope);
lbl-1000:
        // 1 sources

        {
            thisArg = thisArg.getPrototype();
lbl17:
            // 2 sources

            ** while (thisArg instanceof NativeWith)
        }
lbl18:
        // 1 sources

        if (thisArg instanceof NativeCall) {
            thisArg = ScriptableObject.getTopLevelScope(thisArg);
        }
        try {
            function = (Function)prop;
        }
        catch (ClassCastException e) {
            errorArgs = new Object[]{ScriptRuntime.toString(prop)};
            throw Context.reportRuntimeError(ScriptRuntime.getMessage("msg.isnt.function", errorArgs));
        }
        return function.call(cx, scope, thisArg, args);
    }

    public static Object thisGet(Scriptable thisObj, String id, Scriptable scope) {
        if (thisObj == null) {
            throw Context.reportRuntimeError(ScriptRuntime.getMessage("msg.null.to.object", null));
        }
        Object result = thisObj.get(id, thisObj);
        if (result != Scriptable.NOT_FOUND) {
            return result;
        }
        Scriptable m = thisObj.getPrototype();
        while (m != null) {
            result = m.get(id, thisObj);
            if (result != Scriptable.NOT_FOUND) {
                return result;
            }
            m = m.getPrototype();
        }
        return Undefined.instance;
    }

    public static Object[] padStart(Object[] currentArgs, int count) {
        Object[] result = new Object[currentArgs.length + count];
        System.arraycopy(currentArgs, 0, result, count, currentArgs.length);
        return result;
    }
}

