/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Hashtable;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassRepository;

public class OptClassNameHelper
implements ClassNameHelper {
    private boolean appendFunctionName;
    private String packageName;
    private String initialName;
    private static int globalSerial = 1;
    private int serial;
    private int fserial;
    private Class targetExtends;
    private Class[] targetImplements;
    private ClassRepository classRepository;
    private Hashtable classNames;
    private static ClassRepository defaultRepository = new DefaultRepository();

    public OptClassNameHelper() {
        this.setClassName(null);
    }

    public synchronized void reset() {
        this.classNames = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getJavaScriptClassName(String functionName, boolean primary) {
        String lowerResult;
        StringBuffer s = new StringBuffer();
        if (this.packageName != null && this.packageName.length() > 0) {
            s.append(this.packageName);
            s.append('.');
        }
        s.append(this.initialName);
        if (this.appendFunctionName) {
            if (functionName != null) {
                s.append('$');
                if (functionName.length() > 0) {
                    s.append(functionName);
                } else {
                    s.append(++this.fserial);
                }
            } else if (!primary) {
                s.append(++this.serial);
            }
        } else {
            ClassRepository classRepository = defaultRepository;
            synchronized (classRepository) {
                s.append(globalSerial++);
            }
        }
        String result = s.toString();
        String base = lowerResult = result.toLowerCase();
        int count = 0;
        if (this.classNames == null) {
            this.classNames = new Hashtable();
        }
        while (this.classNames.get(lowerResult) != null) {
            lowerResult = base + ++count;
        }
        this.classNames.put(lowerResult, Boolean.TRUE);
        return count == 0 ? result : result + count;
    }

    public String getTargetPackage() {
        return this.packageName;
    }

    public void setTargetPackage(String targetPackage) {
        this.packageName = targetPackage;
    }

    public Class getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class extendsClass) {
        this.targetExtends = extendsClass;
    }

    public Class[] getTargetImplements() {
        return this.targetImplements;
    }

    public void setTargetImplements(Class[] implementsClasses) {
        this.targetImplements = implementsClasses;
    }

    public String getClassName() {
        return this.initialName;
    }

    public void setClassName(String initialName) {
        if (initialName != null) {
            this.initialName = initialName;
            this.appendFunctionName = true;
        } else {
            this.packageName = "org.mozilla.javascript.gen";
            this.initialName = "c";
            this.classRepository = defaultRepository;
            this.appendFunctionName = false;
        }
        this.fserial = 0;
        this.serial = 0;
    }

    public ClassRepository getClassRepository() {
        return this.classRepository;
    }

    public void setClassRepository(ClassRepository classRepository) {
        this.classRepository = classRepository != null ? classRepository : defaultRepository;
    }

    static class DefaultRepository
    implements ClassRepository {
        DefaultRepository() {
        }

        public boolean storeClass(String name, byte[] bytes, boolean tl) {
            return true;
        }
    }
}

