/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.continuations;

import java.io.IOException;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.continuations.ContinuationInterpreter;
import org.mozilla.javascript.continuations.Interpreted;
import org.mozilla.javascript.continuations.InterpreterState;

public final class InterpretedScriptImpl
extends InterpretedScript
implements Interpreted {
    InterpretedScriptImpl(Context cx, InterpreterData theData, String[] argNames, short argCount) {
        super(cx, theData, argNames, argCount);
    }

    public final void init(InterpreterState state, Context cx, Object thisArg, Object[] args, Scriptable scope) throws JavaScriptException {
        Scriptable thisObj = thisArg instanceof Scriptable || thisArg == null ? (Scriptable)thisArg : ScriptRuntime.toObject(cx, scope, thisArg);
        scope = ScriptRuntime.initScript(cx, scope, this, thisObj, this.itsData.itsFromEvalCode);
        state.init(cx, scope, thisObj, args, this, this.itsData);
    }

    public static InterpretedScriptImpl createEvalSpecial(Context cx, Scriptable scope, Object thisArg, Object[] args, String filename, int lineNumber) throws JavaScriptException {
        if (args.length < 1) {
            return null;
        }
        Object x = args[0];
        if (!(x instanceof String)) {
            String message = Context.getMessage0("msg.eval.nonstring");
            Context.reportWarning(message);
            return null;
        }
        int[] linep = new int[]{lineNumber};
        if (filename == null && (filename = Context.getSourcePositionFromStack(linep)) == null) {
            filename = "";
            linep[0] = 1;
        }
        filename = filename + "(eval)";
        try {
            StringReader in = new StringReader((String)x);
            Object securityDomain = cx.getSecurityDomainForStackDepth(3);
            int oldOptLevel = cx.getOptimizationLevel();
            cx.setOptimizationLevel(-2);
            Script script = cx.compileReader(scope, in, filename, linep[0], securityDomain);
            cx.setOptimizationLevel(oldOptLevel);
            if (script == null) {
                String message = Context.getMessage0("msg.syntax");
                throw new EvaluatorException(message);
            }
            InterpretedScriptImpl is = (InterpretedScriptImpl)script;
            is.itsData.itsFromEvalCode = true;
            return is;
        }
        catch (IOException ioe) {
            throw new RuntimeException("unexpected io exception");
        }
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return ContinuationInterpreter.interpret(cx, scope, thisObj, args, this, this.itsData);
    }
}

