/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.continuations;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.continuations.ContinuationInterpreter;
import org.mozilla.javascript.continuations.Interpreted;
import org.mozilla.javascript.continuations.InterpreterState;

final class InterpretedFunctionImpl
extends InterpretedFunction
implements Interpreted {
    InterpretedFunctionImpl(Context cx, InterpreterData theData, String[] argNames, short argCount) {
        super(cx, theData, argNames, argCount);
    }

    InterpretedFunctionImpl(InterpretedFunction theOther, Scriptable theScope, Context cx) {
        super(theOther, theScope, cx);
    }

    public final void init(InterpreterState state, Context cx, Object thisArg, Object[] args, Scriptable scope) throws JavaScriptException {
        Scriptable thisObj;
        try {
            thisObj = (Scriptable)thisArg;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            thisObj = ScriptRuntime.toObject(cx, scope, thisArg);
        }
        if (this.itsClosure != null) {
            scope = this.itsClosure;
        } else if (!this.itsData.itsUseDynamicScope) {
            scope = this.getParentScope();
        }
        if (this.itsData.itsCheckThis) {
            thisObj = ScriptRuntime.getThis(thisObj);
        }
        if (this.itsData.itsNeedsActivation) {
            scope = ScriptRuntime.initVarObj(cx, scope, this, thisObj, args);
        }
        state.init(cx, scope, thisObj, args, this, this.itsData);
    }

    public void newInstance(InterpreterState state, Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        NativeObject newInstance = new NativeObject();
        newInstance.setPrototype(this.getClassPrototype());
        newInstance.setParentScope(this.getParentScope());
        this.init(state, cx, newInstance, args, scope);
        state.ctor = true;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.itsClosure != null) {
            scope = this.itsClosure;
        } else if (!this.itsData.itsUseDynamicScope) {
            scope = this.getParentScope();
        }
        if (this.itsData.itsCheckThis) {
            thisObj = ScriptRuntime.getThis(thisObj);
        }
        if (this.itsData.itsNeedsActivation) {
            scope = ScriptRuntime.initVarObj(cx, scope, this, thisObj, args);
        }
        return ContinuationInterpreter.interpret(cx, scope, thisObj, args, this, this.itsData);
    }
}

