/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.continuations;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.continuations.Continuation;
import org.mozilla.javascript.continuations.ContinuationException;
import org.mozilla.javascript.continuations.ContinuationParser;
import org.mozilla.javascript.continuations.Interpreted;
import org.mozilla.javascript.continuations.InterpretedFunctionImpl;
import org.mozilla.javascript.continuations.InterpretedScriptImpl;
import org.mozilla.javascript.continuations.InterpreterStack;
import org.mozilla.javascript.continuations.InterpreterState;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;

public class ContinuationInterpreter
extends Interpreter {
    static final int START_PC = 6;
    static final int LAST_INSN = 254;
    static final int TAIL_CALL = 254;
    static final int NON_TAIL_CALL = 253;
    static final int XGETVAR = 252;
    static final int XENUMNEXT = 251;
    static final int XUSETEMP = 250;
    static final int END_RESTORE_CONTINUATION = 249;
    static final int END_SAVE_CONTINUATION = 248;
    static final int END_RETURN_CONTINUATION = 247;
    Vector itsBefore;
    Vector itsAfter;
    Vector itsReturn;
    static /* synthetic */ Class class$org$mozilla$javascript$continuations$Continuation;
    static /* synthetic */ Class class$org$mozilla$javascript$continuations$ContinuationException;

    public Parser createParser(TokenStream ts, ClassNameHelper nameHelper, Scriptable scope) {
        return new ContinuationParser(this.createIRFactory(ts, null, scope));
    }

    static InterpreterState newInterpreterState(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) {
        InterpreterState result = ContinuationInterpreter.newInterpreterState();
        result.init(cx, scope, thisObj, args, fnOrScript, theData);
        return result;
    }

    static InterpreterState newInterpreterState() {
        return new InterpreterState();
    }

    public static void init(Context cx, ScriptableObject scope, boolean sealed) {
        new LazilyLoadedCtor(scope, "Continuation", "org.mozilla.javascript.continuations.Continuation", sealed);
    }

    public static Object interpret(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) throws JavaScriptException {
        if (theData.isFunction) {
            if (fnOrScript.itsClosure != null) {
                scope = fnOrScript.itsClosure;
            } else if (!theData.itsUseDynamicScope) {
                scope = fnOrScript.getParentScope();
            }
            if (theData.itsCheckThis) {
                thisObj = ScriptRuntime.getThis(thisObj);
            }
            if (theData.itsNeedsActivation) {
                scope = ScriptRuntime.initVarObj(cx, scope, fnOrScript, thisObj, args);
            }
        } else {
            scope = ScriptRuntime.initScript(cx, scope, fnOrScript, thisObj, theData.itsFromEvalCode);
        }
        InterpreterState state = ContinuationInterpreter.newInterpreterState(cx, scope, thisObj, args, fnOrScript, theData);
        return ContinuationInterpreter.interpret(cx, state);
    }

    static String tokenToName(int ic) {
        String t;
        switch (ic) {
            case 252: {
                t = "xgetvar";
                break;
            }
            case 251: {
                t = "xenumnext";
                break;
            }
            case 250: {
                t = "xusetemp";
                break;
            }
            case 254: {
                t = "tail-call";
                break;
            }
            case 253: {
                t = "non-tail-call";
                break;
            }
            case 249: {
                t = "end-catch-continue";
                break;
            }
            case 248: {
                t = "end-catch-break";
                break;
            }
            case 247: {
                t = "end-catch-return";
                break;
            }
            default: {
                t = Interpreter.icodeToName(ic);
            }
        }
        return t;
    }

    public static Object interpret(Context cx, InterpreterState startState) throws JavaScriptException {
        return ContinuationInterpreter.interpret(cx, startState, false);
    }

    static DebugFrame enterFrame(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, DebuggableScript fnOrScript, InterpreterData itsData) {
        if (itsData.itsLineNumberTable != null) {
            return cx.getDebugger().enterFrame(cx, scope, thisObj, args, fnOrScript);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Object interpret(Context cx, InterpreterState startState, boolean continuation) throws JavaScriptException {
        DBL_MRK = Interpreter.DBL_MRK;
        undefined = Undefined.instance;
        topScope = ScriptableObject.getTopLevelScope(startState.scope);
        Function_prototype = ScriptableObject.getClassPrototype(topScope, "Function");
        Function_call = (Function)Function_prototype.get("call", Function_prototype);
        Function_apply = (Function)Function_prototype.get("apply", Function_prototype);
        Function_eval = (Function)ScriptableObject.getProperty(topScope, "eval");
        Continuation_prototype = ScriptableObject.getClassPrototype(topScope, "Continuation");
        if (Continuation_prototype == null) {
            try {
                ScriptableObject.defineClass(Function_eval.getParentScope(), ContinuationInterpreter.class$org$mozilla$javascript$continuations$Continuation == null ? (ContinuationInterpreter.class$org$mozilla$javascript$continuations$Continuation = ContinuationInterpreter.class$("org.mozilla.javascript.continuations.Continuation")) : ContinuationInterpreter.class$org$mozilla$javascript$continuations$Continuation);
                ScriptableObject.defineClass(Function_eval.getParentScope(), ContinuationInterpreter.class$org$mozilla$javascript$continuations$ContinuationException == null ? (ContinuationInterpreter.class$org$mozilla$javascript$continuations$ContinuationException = ContinuationInterpreter.class$("org.mozilla.javascript.continuations.ContinuationException")) : ContinuationInterpreter.class$org$mozilla$javascript$continuations$ContinuationException);
            }
            catch (Exception e) {
                throw WrappedException.wrapException(e);
            }
        }
        ContinuationException_prototype = ScriptableObject.getClassPrototype(topScope, "ContinuationException");
        Continuation_prototype = (Function)ScriptableObject.getClassPrototype(topScope, "Continuation");
        Continuation_ctor = ScriptableObject.getProperty(Continuation_prototype, "constructor");
        ContinuationException_ctor = ScriptableObject.getProperty(ContinuationException_prototype, "constructor");
        caller = null;
        callee = null;
        s = startState;
        while (s != null) {
            if (s.scope instanceof NativeCall && (tmp = (NativeCall)s.scope) != caller) {
                tmp.caller = caller;
                caller = tmp;
                if (callee == null) {
                    callee = tmp;
                }
            }
            s = s.caller;
        }
        if (cx.getDebugger() != null) {
            s = startState;
            while (s != null) {
                s.frame = ContinuationInterpreter.enterFrame(cx, s.scope, s.thisObj, s.getArguments(), (DebuggableScript)s.fnOrScript, s.theData);
                if (continuation) break;
                s = s.caller;
            }
        }
        if (caller != null && Interpreter.getCurrentActivation(cx) != callee) {
            caller.caller = Interpreter.getCurrentActivation(cx);
            Interpreter.setCurrentActivation(cx, callee);
        }
        stk = new InterpreterStack();
        stk.replace(startState);
        result = undefined;
        continuationException = null;
        block108: while ((state = stk.top()) != null) {
            block248: {
                block251: {
                    block252: {
                        topScope = ScriptableObject.getTopLevelScope(callee.scope);
                        Interpreter.setInterpreterSourceFile(cx, callee.theData.itsSourceFile);
                        iCode = callee.theData.itsICode;
                        strings = callee.theData.itsStringTable;
                        iCodeLength = callee.theData.itsICodeTop;
                        name = null;
                        LOCAL_SHFT = callee.LOCAL_SHFT();
                        TRY_SCOPE_SHFT = callee.TRY_SCOPE_SHFT();
                        block109: while (true) {
                            try {
                                block110: while (true) {
                                    if (continuationException != null) {
                                        exc = continuationException.getException();
                                        continuationException = null;
                                        throw new JavaScriptException(exc);
                                    }
                                    ic = iCode[callee.pc] & 255;
                                    switch (ic) {
                                        case 247: 
                                        case 248: 
                                        case 249: {
                                            if (callee.scope instanceof NativeCall) {
                                                ScriptRuntime.popActivation(cx);
                                            }
                                            if (cx.getDebugger() != null && callee.frame != null) {
                                                callee.frame.onExit(cx, false, Undefined.instance);
                                                callee.frame = null;
                                            }
                                            return null;
                                        }
                                        case 76: {
                                            tryStackTop = callee.tryStackTop + TRY_SCOPE_SHFT;
                                            if (tryStackTop >= 0 && tryStackTop < callee.stack.length) {
                                                callee.stack[callee.tryStackTop + TRY_SCOPE_SHFT] = null;
                                            }
                                            --callee.tryStackTop;
                                            break block110;
                                        }
                                        case 75: {
                                            i = Interpreter.getTarget(iCode, callee.pc + 1);
                                            if (i == callee.pc) {
                                                i = 0;
                                            }
                                            callee.catchStack[callee.tryStackTop * 2] = i;
                                            i = Interpreter.getTarget(iCode, callee.pc + 3);
                                            if (i == callee.pc + 2) {
                                                i = 0;
                                            }
                                            callee.catchStack[callee.tryStackTop * 2 + 1] = i;
                                            callee.stack[TRY_SCOPE_SHFT + callee.tryStackTop] = callee.scope;
                                            ++callee.tryStackTop;
                                            callee.pc += 4;
                                            break block110;
                                        }
                                        case 19: {
                                            rhs = callee.stack[callee.stackTop];
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                                rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop + 1);
                                                lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl <= lDbl;
                                            } else {
                                                valBln = 1 == ScriptRuntime.cmp_LE(rhs, lhs);
                                            }
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 17: {
                                            --callee.stackTop;
                                            rhs = callee.stack[callee.stackTop + 1];
                                            lhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                                rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop + 1);
                                                lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl <= rDbl;
                                            } else {
                                                valBln = 1 == ScriptRuntime.cmp_LE(lhs, rhs);
                                            }
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 18: {
                                            --callee.stackTop;
                                            rhs = callee.stack[callee.stackTop + 1];
                                            lhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                                rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop + 1);
                                                lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl < lDbl;
                                            } else {
                                                valBln = 1 == ScriptRuntime.cmp_LT(rhs, lhs);
                                            }
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 16: {
                                            --callee.stackTop;
                                            rhs = callee.stack[callee.stackTop + 1];
                                            lhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                                rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop + 1);
                                                lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl < rDbl;
                                            } else {
                                                valBln = 1 == ScriptRuntime.cmp_LT(lhs, rhs);
                                            }
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 63: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            valBln = ScriptRuntime.in(lhs, rhs, callee.scope);
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 64: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            valBln = ScriptRuntime.instanceOf(callee.scope, lhs, rhs);
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 14: {
                                            --callee.stackTop;
                                            valBln = Interpreter.do_eq(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 15: {
                                            --callee.stackTop;
                                            valBln = Interpreter.do_eq(callee.stack, callee.sDbl, callee.stackTop) == false;
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 53: {
                                            --callee.stackTop;
                                            valBln = Interpreter.do_sheq(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 54: {
                                            --callee.stackTop;
                                            valBln = Interpreter.do_sheq(callee.stack, callee.sDbl, callee.stackTop) == false;
                                            callee.stack[callee.stackTop] = valBln != false ? Boolean.TRUE : Boolean.FALSE;
                                            break block110;
                                        }
                                        case 8: {
                                            val = callee.stack[callee.stackTop];
                                            valBln = val != DBL_MRK ? ScriptRuntime.toBoolean(val) == false : (valDbl = callee.sDbl[callee.stackTop]) != valDbl || valDbl == 0.0;
                                            --callee.stackTop;
                                            if (valBln) {
                                                callee.pc = Interpreter.getTarget(iCode, callee.pc + 1);
                                                continue block110;
                                            }
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 7: {
                                            val = callee.stack[callee.stackTop];
                                            valBln = val != DBL_MRK ? ScriptRuntime.toBoolean(val) : (valDbl = callee.sDbl[callee.stackTop]) == valDbl && valDbl != 0.0;
                                            --callee.stackTop;
                                            if (valBln) {
                                                callee.pc = Interpreter.getTarget(iCode, callee.pc + 1);
                                                continue block110;
                                            }
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 6: {
                                            callee.pc = Interpreter.getTarget(iCode, callee.pc + 1);
                                            continue block110;
                                        }
                                        case 65: {
                                            callee.sDbl[++callee.stackTop] = callee.pc + 3;
                                            callee.pc = Interpreter.getTarget(iCode, callee.pc + 1);
                                            continue block110;
                                        }
                                        case 66: {
                                            slot = iCode[callee.pc + 1] & 255;
                                            callee.pc = (int)callee.varDbl[LOCAL_SHFT + slot];
                                            continue block110;
                                        }
                                        case 57: {
                                            --callee.stackTop;
                                            break block110;
                                        }
                                        case 9: {
                                            callee.stack[callee.stackTop + 1] = callee.stack[callee.stackTop];
                                            callee.sDbl[callee.stackTop + 1] = callee.sDbl[callee.stackTop];
                                            ++callee.stackTop;
                                            break block110;
                                        }
                                        case 2: {
                                            result = callee.stack[callee.stackTop];
                                            if (result == DBL_MRK) {
                                                result = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            break block110;
                                        }
                                        case 5: {
                                            result = callee.stack[callee.stackTop];
                                            if (result == DBL_MRK) {
                                                result = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            break block248;
                                        }
                                        case 152: {
                                            result = undefined;
                                        }
                                        case 153: {
                                            break block248;
                                        }
                                        case 28: {
                                            rIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = ~rIntValue;
                                            break block110;
                                        }
                                        case 13: {
                                            rIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lIntValue & rIntValue;
                                            break block110;
                                        }
                                        case 11: {
                                            rIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lIntValue | rIntValue;
                                            break block110;
                                        }
                                        case 12: {
                                            rIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lIntValue ^ rIntValue;
                                            break block110;
                                        }
                                        case 20: {
                                            rIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lIntValue << rIntValue;
                                            break block110;
                                        }
                                        case 21: {
                                            rIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lIntValue >> rIntValue;
                                            break block110;
                                        }
                                        case 22: {
                                            rIntValue = Interpreter.stack_int32(callee.stack, callee.sDbl, callee.stackTop) & 31;
                                            --callee.stackTop;
                                            lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
                                            break block110;
                                        }
                                        case 23: {
                                            --callee.stackTop;
                                            Interpreter.do_add(callee.stack, callee.sDbl, callee.stackTop);
                                            break block110;
                                        }
                                        case 24: {
                                            rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lDbl - rDbl;
                                            break block110;
                                        }
                                        case 29: {
                                            rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = -rDbl;
                                            break block110;
                                        }
                                        case 58: {
                                            rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = rDbl;
                                            break block110;
                                        }
                                        case 25: {
                                            rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lDbl * rDbl;
                                            break block110;
                                        }
                                        case 26: {
                                            rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lDbl / rDbl;
                                            break block110;
                                        }
                                        case 27: {
                                            rDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            --callee.stackTop;
                                            lDbl = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop);
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = lDbl % rDbl;
                                            break block110;
                                        }
                                        case 61: {
                                            name = strings[Interpreter.getShort(iCode, callee.pc + 1)];
                                            callee.stack[++callee.stackTop] = ScriptRuntime.bind(callee.scope, name);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 71: {
                                            name = strings[Interpreter.getShort(iCode, callee.pc + 1)];
                                            callee.stack[++callee.stackTop] = ScriptRuntime.getBase(callee.scope, name);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 10: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            callee.stack[callee.stackTop] = ScriptRuntime.setName((Scriptable)lhs, rhs, callee.scope, strings[Interpreter.getShort(iCode, callee.pc + 1)]);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 31: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.delete(lhs, rhs);
                                            break block110;
                                        }
                                        case 39: {
                                            name = (String)callee.stack[callee.stackTop];
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.getProp(lhs, name, callee.scope);
                                            break block110;
                                        }
                                        case 40: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            name = (String)callee.stack[callee.stackTop];
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.setProp(lhs, name, rhs, callee.scope);
                                            break block110;
                                        }
                                        case 41: {
                                            lhs = callee.stack[callee.stackTop - 1];
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK && lhs instanceof String && (double)(i = (int)(valDbl = callee.sDbl[callee.stackTop])) == valDbl) {
                                                result = undefined;
                                                str = (String)lhs;
                                                if (i >= 0 && i < str.length()) {
                                                    result = str.substring(i, i + 1);
                                                }
                                                callee.stack[--callee.stackTop] = result;
                                                break block110;
                                            }
                                            Interpreter.do_getElem(cx, callee.stack, callee.sDbl, callee.stackTop, callee.scope);
                                            --callee.stackTop;
                                            break block110;
                                        }
                                        case 42: {
                                            Interpreter.do_setElem(cx, callee.stack, callee.sDbl, callee.stackTop, callee.scope);
                                            callee.stackTop -= 2;
                                            break block110;
                                        }
                                        case 34: {
                                            name = (String)callee.stack[callee.stackTop];
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.postIncrement(lhs, name, callee.scope);
                                            break block110;
                                        }
                                        case 37: {
                                            name = (String)callee.stack[callee.stackTop];
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.postDecrement(lhs, name, callee.scope);
                                            break block110;
                                        }
                                        case 35: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.postIncrementElem(lhs, rhs, callee.scope);
                                            break block110;
                                        }
                                        case 38: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.postDecrementElem(lhs, rhs, callee.scope);
                                            break block110;
                                        }
                                        case 68: {
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.getThis((Scriptable)lhs);
                                            break block110;
                                        }
                                        case 69: {
                                            slot = iCode[++callee.pc] & 255;
                                            callee.vars[LOCAL_SHFT + slot] = callee.stack[callee.stackTop];
                                            callee.varDbl[LOCAL_SHFT + slot] = callee.sDbl[callee.stackTop];
                                            break block110;
                                        }
                                        case 70: {
                                            slot = iCode[++callee.pc] & 255;
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = callee.vars[LOCAL_SHFT + slot];
                                            callee.sDbl[callee.stackTop] = callee.varDbl[LOCAL_SHFT + slot];
                                            break block110;
                                        }
                                        case 67: {
                                            callee.lineno = lineNum = Interpreter.getShort(iCode, callee.pc + 1);
                                            Interpreter.setInterpreterLine(cx, lineNum);
                                            name = strings[Interpreter.getShort(iCode, callee.pc + 3)];
                                            count = Interpreter.getShort(iCode, callee.pc + 5);
                                            outArgs = Interpreter.getArgsArray(callee.stack, callee.sDbl, callee.stackTop, count);
                                            callee.stackTop -= count;
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            i = callee.stackTop;
                                            while (i < callee.theData.itsMaxStack) {
                                                callee.stack[i] = null;
                                                ++i;
                                            }
                                            if (lhs == Function_eval && (script = InterpretedScriptImpl.createEvalSpecial(cx, callee.scope, rhs, outArgs, name, lineNum)) != null) {
                                                calleeState = ContinuationInterpreter.newInterpreterState();
                                                script.init(calleeState, cx, rhs, new Object[0], callee.scope);
                                                callee.pc += 7;
                                                stk.push(calleeState);
                                                if (cx.getDebugger() == null) continue block108;
                                                calleeState.frame = ContinuationInterpreter.enterFrame(cx, calleeState.scope, calleeState.thisObj, calleeState.getArguments(), (DebuggableScript)calleeState.fnOrScript, calleeState.theData);
                                                continue block108;
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.callSpecial(cx, lhs, rhs, outArgs, callee.thisObj, callee.scope, name, lineNum);
                                            callee.pc += 6;
                                            break block110;
                                        }
                                        case 43: 
                                        case 253: 
                                        case 254: {
                                            count = Interpreter.getShort(iCode, callee.pc + 3);
                                            outArgs = Interpreter.getArgsArray(callee.stack, callee.sDbl, callee.stackTop, count);
                                            callee.stackTop -= count;
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            if (lhs == undefined && (i = Interpreter.getShort(iCode, callee.pc + 1)) != -1) {
                                                lhs = strings[i];
                                            }
                                            calleeScope = callee.scope;
                                            if (callee.theData.itsNeedsActivation) {
                                                calleeScope = topScope;
                                            }
                                            if (interp = lhs instanceof Interpreted) ** GOTO lbl587
                                            if (Function_call != lhs) ** GOTO lbl506
                                            scope = calleeScope;
                                            thisObj = (Scriptable)rhs;
                                            args = outArgs;
                                            defval = thisObj.getDefaultValue(ScriptRuntime.FunctionClass);
                                            newThis = thisObj;
                                            newArgs = outArgs;
                                            if (args.length == 0) {
                                                s = ScriptRuntime.toObject(cx, scope, defval);
                                                newThis = scope = s.getParentScope();
                                            } else {
                                                newThis = args[0] == null ? topScope : ScriptRuntime.toObject(cx, scope, args[0]);
                                                newArgs = new Object[args.length - 1];
                                                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                                            }
                                            lhs = defval;
                                            rhs = newThis;
                                            outArgs = newArgs;
                                            calleeScope = scope;
                                            ** GOTO lbl533
lbl506:
                                            // 1 sources

                                            if (Function_apply != lhs) ** GOTO lbl533
                                            scope = calleeScope;
                                            thisObj = (Scriptable)rhs;
                                            args = outArgs;
                                            defval = thisObj.getDefaultValue(ScriptRuntime.FunctionClass);
                                            newThis = thisObj;
                                            newArgs = outArgs;
                                            if (args.length >= 2) ** GOTO lbl522
                                            if (args.length == 0) {
                                                s = ScriptRuntime.toObject(cx, scope, defval);
                                                newThis = scope = s.getParentScope();
                                            } else {
                                                newThis = args[0] == null ? topScope : ScriptRuntime.toObject(cx, scope, args[0]);
                                                newArgs = new Object[args.length - 1];
                                                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                                            }
                                            ** GOTO lbl529
lbl522:
                                            // 1 sources

                                            v0 = newThis = args[0] == null ? ScriptableObject.getTopLevelScope(thisObj) : ScriptRuntime.toObject(cx, scope, args[0]);
                                            if (args.length <= 1) ** GOTO lbl528
                                            if (args[1] instanceof NativeArray || args[1] instanceof Arguments) {
                                                newArgs = cx.getElements((Scriptable)args[1]);
                                            } else {
                                                throw NativeGlobal.typeError0("msg.arg.isnt.array", thisObj);
lbl528:
                                                // 1 sources

                                                newArgs = ScriptRuntime.emptyArgs;
                                            }
lbl529:
                                            // 4 sources

                                            lhs = defval;
                                            rhs = newThis;
                                            outArgs = newArgs;
                                            calleeScope = scope;
lbl533:
                                            // 3 sources

                                            if (lhs instanceof Continuation) {
                                                arg = outArgs.length < 1 ? undefined : outArgs[0];
                                                s = callee;
                                                while (s != null) {
                                                    if (s.theData.itsNeedsActivation) {
                                                        ScriptRuntime.popActivation(cx);
                                                    }
                                                    s = s.caller;
                                                }
                                                if (cx.getDebugger() != null) {
                                                    s = callee;
                                                    while (s != null) {
                                                        if (s.frame != null) {
                                                            s.frame.onExit(cx, false, Undefined.instance);
                                                            s.frame = null;
                                                        }
                                                        s = s.caller;
                                                    }
                                                }
                                                callee.writeUnlock();
                                                InterpreterState.terminate(cx, (InterpreterState)callee);
                                                cont = (Continuation)lhs;
                                                dup = cont.getInterpreterState(cx);
                                                if (dup == null) {
                                                    return arg;
                                                }
                                                dup = dup.writeLock();
                                                if (dup.ctor && (!(arg instanceof Scriptable) || arg == undefined)) {
                                                    arg = dup.thisObj;
                                                }
                                                if (dup.stackTop >= 0) {
                                                    dup.stack[dup.stackTop] = arg;
                                                }
                                                stk.replace(dup);
                                                s = dup;
                                                caller = null;
                                                callee = null;
                                                while (s != null) {
                                                    if (s.scope instanceof NativeCall && (tmp = (NativeCall)s.scope) != caller) {
                                                        tmp.caller = caller;
                                                        caller = tmp;
                                                        if (callee == null) {
                                                            callee = tmp;
                                                        }
                                                    }
                                                    s = s.caller;
                                                }
                                                if (cx.getDebugger() != null) {
                                                    s = dup;
                                                    while (s != null) {
                                                        s.frame = ContinuationInterpreter.enterFrame(cx, s.scope, s.thisObj, s.getArguments(), (DebuggableScript)s.fnOrScript, s.theData);
                                                        s = s.caller;
                                                    }
                                                }
                                                if (caller != null && Interpreter.getCurrentActivation(cx) != callee) {
                                                    caller.caller = Interpreter.getCurrentActivation(cx);
                                                    Interpreter.setCurrentActivation(cx, callee);
                                                }
                                                dup.writeUnlock();
                                                if (!(arg instanceof ContinuationException)) continue block108;
                                                continuationException = (ContinuationException)arg;
                                                continue block108;
                                            }
                                            interp = lhs instanceof Interpreted;
lbl587:
                                            // 2 sources

                                            if (interp) {
                                                op = ic;
                                                switch (op) {
                                                    case 253: 
                                                    case 254: {
                                                        break;
                                                    }
                                                    default: {
                                                        if (cx.getDebugger() != null) break;
                                                        op = callee.checkTail();
                                                    }
                                                }
                                                if (op == 254) {
                                                    if (callee.theData.itsNeedsActivation) {
                                                        ScriptRuntime.popActivation(cx);
                                                    }
                                                    callee.ctor = false;
                                                    if (lhs instanceof InterpretedFunctionImpl) {
                                                        ((InterpretedFunctionImpl)lhs).init((InterpreterState)callee, cx, rhs, outArgs, calleeScope);
                                                    } else {
                                                        ((InterpretedScriptImpl)lhs).init((InterpreterState)callee, cx, rhs, outArgs, calleeScope);
                                                    }
                                                    callee.writeUnlock();
                                                    continue block108;
                                                }
                                                callee.clearStack();
                                                callee = ContinuationInterpreter.newInterpreterState();
                                                if (lhs instanceof InterpretedFunctionImpl) {
                                                    ((InterpretedFunctionImpl)lhs).init(callee, cx, rhs, outArgs, calleeScope);
                                                } else {
                                                    ((InterpretedScriptImpl)lhs).init(callee, cx, rhs, outArgs, calleeScope);
                                                }
                                                callee.pc += 5;
                                                if (cx.getDebugger() != null) {
                                                    callee.frame = ContinuationInterpreter.enterFrame(cx, callee.scope, callee.thisObj, callee.getArguments(), (DebuggableScript)callee.fnOrScript, callee.theData);
                                                }
                                                stk.push(callee);
                                                continue block108;
                                            }
                                            if (lhs == Continuation_ctor) {
                                                caller = callee.caller;
                                                if (caller != null) {
                                                    caller.readLock();
                                                }
                                                cont = new Continuation(cx, caller);
                                                cont.setParentScope(caller == null ? ScriptableObject.getTopLevelScope(callee.scope) : ScriptableObject.getTopLevelScope(caller.scope));
                                                cont.setPrototype(Continuation_prototype);
                                                callee.stack[callee.stackTop] = cont;
                                                callee.pc += 5;
                                                continue block110;
                                            }
                                            if (lhs == ContinuationException_ctor) {
                                                arg = undefined;
                                                if (outArgs.length > 0) {
                                                    arg = outArgs[0];
                                                }
                                                obj = new ContinuationException(arg);
                                                obj.setParentScope(topScope);
                                                obj.setPrototype(ContinuationException_prototype);
                                                callee.stack[callee.stackTop] = obj;
                                                callee.pc += 5;
                                                continue block110;
                                            }
                                            callee.clearStack();
                                            callee.stack[callee.stackTop] = ScriptRuntime.call(cx, lhs, rhs, outArgs, calleeScope);
                                            callee.pc += 4;
                                            break block110;
                                        }
                                        case 30: {
                                            count = Interpreter.getShort(iCode, callee.pc + 3);
                                            outArgs = Interpreter.getArgsArray(callee.stack, callee.sDbl, callee.stackTop, count);
                                            callee.stackTop -= count;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.clearStack();
                                            if (lhs == undefined && Interpreter.getShort(iCode, callee.pc + 1) != -1) {
                                                lhs = strings[Interpreter.getShort(iCode, callee.pc + 1)];
                                            } else {
                                                if (lhs == Continuation_ctor) {
                                                    caller = callee.caller;
                                                    if (caller != null) {
                                                        caller.readLock();
                                                    }
                                                    cont = new Continuation(cx, caller);
                                                    cont.setParentScope(caller == null ? ScriptableObject.getTopLevelScope(callee.scope) : ScriptableObject.getTopLevelScope(caller.scope));
                                                    cont.setPrototype(Continuation_prototype);
                                                    callee.stack[callee.stackTop] = cont;
                                                    callee.pc += 5;
                                                    continue block110;
                                                }
                                                if (lhs == ContinuationException_ctor) {
                                                    if (outArgs.length < 1) {
                                                        throw new JavaScriptException((Object)"expected an argument");
                                                    }
                                                    obj = new ContinuationException(outArgs[0]);
                                                    obj.setParentScope(topScope);
                                                    obj.setPrototype(ContinuationException_prototype);
                                                    callee.stack[callee.stackTop] = obj;
                                                    callee.pc += 5;
                                                    continue block110;
                                                }
                                                if (lhs instanceof InterpretedFunctionImpl) {
                                                    f = (InterpretedFunctionImpl)lhs;
                                                    calleeState = ContinuationInterpreter.newInterpreterState();
                                                    f.newInstance(calleeState, cx, callee.scope, outArgs);
                                                    callee.pc += 5;
                                                    if (cx.getDebugger() != null) {
                                                        calleeState.frame = ContinuationInterpreter.enterFrame(cx, calleeState.scope, calleeState.thisObj, calleeState.getArguments(), (DebuggableScript)calleeState.fnOrScript, calleeState.theData);
                                                    }
                                                    stk.push(calleeState);
                                                    continue block108;
                                                }
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.newObject(cx, lhs, outArgs, callee.scope);
                                            callee.pc += 4;
                                            break block110;
                                        }
                                        case 32: {
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.typeof(lhs);
                                            break block110;
                                        }
                                        case 78: {
                                            name = strings[Interpreter.getShort(iCode, callee.pc + 1)];
                                            callee.stack[++callee.stackTop] = ScriptRuntime.typeofName(callee.scope, name);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 46: {
                                            callee.stack[++callee.stackTop] = strings[Interpreter.getShort(iCode, callee.pc + 1)];
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 150: {
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = Interpreter.getShort(iCode, callee.pc + 1);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 151: {
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = Interpreter.getInt(iCode, callee.pc + 1);
                                            callee.pc += 4;
                                            break block110;
                                        }
                                        case 45: {
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = callee.theData.itsDoubleTable[Interpreter.getShort(iCode, callee.pc + 1)];
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 44: {
                                            callee.stack[++callee.stackTop] = ScriptRuntime.name(callee.scope, strings[Interpreter.getShort(iCode, callee.pc + 1)]);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 33: {
                                            callee.stack[++callee.stackTop] = ScriptRuntime.postIncrement(callee.scope, strings[Interpreter.getShort(iCode, callee.pc + 1)]);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 36: {
                                            callee.stack[++callee.stackTop] = ScriptRuntime.postDecrement(callee.scope, strings[Interpreter.getShort(iCode, callee.pc + 1)]);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 73: {
                                            slot = iCode[++callee.pc] & 255;
                                            callee.vars[slot] = callee.stack[callee.stackTop];
                                            callee.varDbl[slot] = callee.sDbl[callee.stackTop];
                                            break block110;
                                        }
                                        case 252: {
                                            slot = iCode[++callee.pc] & 255;
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = val = callee.vars[slot];
                                            callee.vars[slot] = null;
                                            callee.sDbl[callee.stackTop] = callee.varDbl[slot];
                                            break block110;
                                        }
                                        case 251: {
                                            slot = iCode[++callee.pc] & 255;
                                            val = callee.vars[slot += LOCAL_SHFT];
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = ScriptRuntime.nextEnum((Enumeration)val);
                                            callee.stack[slot] = null;
                                            break block110;
                                        }
                                        case 250: {
                                            slot = iCode[++callee.pc] & 255;
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = val = callee.vars[slot += LOCAL_SHFT];
                                            callee.vars[slot] = null;
                                            callee.sDbl[callee.stackTop] = callee.varDbl[slot];
                                            break block110;
                                        }
                                        case 72: {
                                            slot = iCode[++callee.pc] & 255;
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = callee.vars[slot];
                                            callee.sDbl[callee.stackTop] = callee.varDbl[slot];
                                            break block110;
                                        }
                                        case 59: {
                                            slot = iCode[++callee.pc] & 255;
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = callee.vars[slot];
                                            callee.sDbl[callee.stackTop] = callee.varDbl[slot];
                                            callee.vars[slot] = DBL_MRK;
                                            callee.varDbl[slot] = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop) + 1.0;
                                            break block110;
                                        }
                                        case 60: {
                                            slot = iCode[++callee.pc] & 255;
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = callee.vars[slot];
                                            callee.sDbl[callee.stackTop] = callee.varDbl[slot];
                                            callee.vars[slot] = DBL_MRK;
                                            callee.varDbl[slot] = Interpreter.stack_double(callee.stack, callee.sDbl, callee.stackTop) - 1.0;
                                            break block110;
                                        }
                                        case 47: {
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = 0.0;
                                            break block110;
                                        }
                                        case 48: {
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = DBL_MRK;
                                            callee.sDbl[callee.stackTop] = 1.0;
                                            break block110;
                                        }
                                        case 49: {
                                            callee.stack[++callee.stackTop] = null;
                                            break block110;
                                        }
                                        case 50: {
                                            callee.stack[++callee.stackTop] = callee.thisObj;
                                            break block110;
                                        }
                                        case 87: {
                                            callee.stack[++callee.stackTop] = callee.fnOrScript;
                                            break block110;
                                        }
                                        case 51: {
                                            callee.stack[++callee.stackTop] = Boolean.FALSE;
                                            break block110;
                                        }
                                        case 52: {
                                            callee.stack[++callee.stackTop] = Boolean.TRUE;
                                            break block110;
                                        }
                                        case 74: {
                                            callee.stack[++callee.stackTop] = Undefined.instance;
                                            break block110;
                                        }
                                        case 62: {
                                            result = callee.stack[callee.stackTop];
                                            if (result == DBL_MRK) {
                                                result = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            throw new JavaScriptException(result);
                                        }
                                        case 88: {
                                            result = callee.stack[callee.stackTop];
                                            --callee.stackTop;
                                            if (result instanceof JavaScriptException) {
                                                throw (JavaScriptException)result;
                                            }
                                            throw (RuntimeException)result;
                                        }
                                        case 3: {
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            callee.scope = ScriptRuntime.enterWith(lhs, callee.scope);
                                            break block110;
                                        }
                                        case 4: {
                                            callee.scope = ScriptRuntime.leaveWith(callee.scope);
                                            break block110;
                                        }
                                        case 77: {
                                            callee.stack[++callee.stackTop] = ScriptRuntime.newScope();
                                            break block110;
                                        }
                                        case 79: {
                                            slot = iCode[++callee.pc] & 255;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            callee.vars[LOCAL_SHFT + slot] = ScriptRuntime.initEnum(lhs, callee.scope);
                                            break block110;
                                        }
                                        case 80: {
                                            slot = iCode[++callee.pc] & 255;
                                            val = callee.vars[LOCAL_SHFT + slot];
                                            ++callee.stackTop;
                                            callee.stack[callee.stackTop] = ScriptRuntime.nextEnum((Enumeration)val);
                                            break block110;
                                        }
                                        case 81: {
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.getProto(lhs, callee.scope);
                                            break block110;
                                        }
                                        case 82: {
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.getParent(lhs);
                                            break block110;
                                        }
                                        case 86: {
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.getParent(lhs, callee.scope);
                                            break block110;
                                        }
                                        case 83: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.setProto(lhs, rhs, callee.scope);
                                            break block110;
                                        }
                                        case 84: {
                                            rhs = callee.stack[callee.stackTop];
                                            if (rhs == DBL_MRK) {
                                                rhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            --callee.stackTop;
                                            lhs = callee.stack[callee.stackTop];
                                            if (lhs == DBL_MRK) {
                                                lhs = Interpreter.doubleWrap(callee.sDbl[callee.stackTop]);
                                            }
                                            callee.stack[callee.stackTop] = ScriptRuntime.setParent(lhs, rhs, callee.scope);
                                            break block110;
                                        }
                                        case 85: {
                                            callee.stack[++callee.stackTop] = callee.scope;
                                            break block110;
                                        }
                                        case 55: {
                                            i = Interpreter.getShort(iCode, callee.pc + 1);
                                            closureScope = callee.scope;
                                            if (closureScope.getParentScope() == null) {
                                                closureScope = null;
                                            }
                                            callee.stack[++callee.stackTop] = new InterpretedFunctionImpl(callee.theData.itsNestedFunctions[i], closureScope, cx);
                                            Interpreter.createFunctionObject((InterpretedFunction)callee.stack[callee.stackTop], callee.scope, callee.theData.itsFromEvalCode);
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 56: {
                                            i = Interpreter.getShort(iCode, callee.pc + 1);
                                            callee.stack[++callee.stackTop] = callee.theData.itsRegExpLiterals[i];
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        case 148: {
                                            Interpreter.setInterpreterSourceFile(cx, callee.theData.itsSourceFile);
                                            break block110;
                                        }
                                        case 147: 
                                        case 149: {
                                            callee.lineno = i = Interpreter.getShort(iCode, callee.pc + 1);
                                            Interpreter.setInterpreterLine(cx, i);
                                            if (callee.frame != null) {
                                                callee.frame.onLineChange(cx, i, ic == 149);
                                            }
                                            callee.pc += 2;
                                            break block110;
                                        }
                                        default: {
                                            Interpreter.dumpICode(callee.theData);
                                            throw new Error("Unknown icode : " + (iCode[callee.pc] & 255) + " @ state.pc : " + callee.pc);
                                        }
                                    }
                                    break;
                                }
                                ++callee.pc;
                            }
                            catch (Throwable ex) {
                                block249: {
                                    block250: {
                                        SCRIPT_THROW = false;
                                        ECMA = true;
                                        RUNTIME = 2;
                                        OTHER = 3;
                                        while (true) {
                                            if (ex instanceof JavaScriptException) {
                                                errObj = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)ex);
                                                if (errObj instanceof NativeError) {
                                                    err = (NativeError)errObj;
                                                    sourceName = err.get("sourceName", (Scriptable)err);
                                                    lineNum = err.get("lineNumber", (Scriptable)err);
                                                    ex = new EcmaError(err, Context.toString(sourceName), (int)Context.toNumber(lineNum), 0, null);
                                                    exType = 1;
                                                } else {
                                                    exType = 0;
                                                }
                                                break block249;
                                            }
                                            if (ex instanceof EcmaError) {
                                                ecmaErr = (EcmaError)ex;
                                                nativeErr = ecmaErr.getErrorObject();
                                                nativeErr.put("sourceName", nativeErr, (Object)ecmaErr.getSourceName());
                                                nativeErr.put("lineNumber", nativeErr, (Object)new Integer(ecmaErr.getLineNumber()));
                                                errObj = nativeErr;
                                                exType = 1;
                                                break block249;
                                            }
                                            if (!(ex instanceof WrappedException)) break block250;
                                            w = ((WrappedException)ex).unwrap();
                                            if (!(w instanceof Throwable)) break;
                                            ex = (Throwable)w;
                                        }
                                        errObj = ex;
                                        exType = 2;
                                        break block249;
                                    }
                                    if (ex instanceof RuntimeException) {
                                        errObj = ex;
                                        exType = 2;
                                    } else {
                                        errObj = ex;
                                        exType = 3;
                                    }
                                }
                                if (exType != 3 && callee.frame != null) {
                                    callee.frame.onExceptionThrown(cx, ex);
                                }
                                if (continuation) {
                                    callee.writeUnlock();
                                    if (ex instanceof JavaScriptException) {
                                        throw (JavaScriptException)ex;
                                    }
                                    if (ex instanceof RuntimeException) {
                                        throw (RuntimeException)ex;
                                    }
                                    throw (Error)ex;
                                }
                                rethrow = true;
                                stackTrace = new Vector<Object>();
                                if (exType != 3) {
                                    do {
                                        if (callee.tryStackTop > 0) {
                                            --callee.tryStackTop;
                                            break;
                                        }
                                        if (callee.theData.itsNeedsActivation) {
                                            ScriptRuntime.popActivation(cx);
                                        }
                                        if (callee.frame != null) {
                                            callee.frame.onExit(cx, true, ex);
                                            callee.frame = null;
                                        }
                                        stackTrace.addElement(callee.theData.itsSourceFile);
                                        stackTrace.addElement(callee.theData.itsName);
                                        stackTrace.addElement(new Integer(callee.lineno));
                                        stk.pop();
                                    } while ((state = stk.top()) != null);
                                    if (state != null) {
                                        if (exType == 0 || exType == 1) {
                                            state.pc = state.catchStack[state.tryStackTop * 2];
                                            if (state.pc != 0) {
                                                rethrow = false;
                                            }
                                        }
                                        if (rethrow) {
                                            state.pc = state.catchStack[state.tryStackTop * 2 + 1];
                                            if (state.pc != 0) {
                                                rethrow = false;
                                                errObj = ex;
                                            }
                                        }
                                    }
                                }
                                if (!rethrow) break block251;
lbl991:
                                // 2 sources

                                while (state != null) {
                                    break block109;
                                }
                                break block252;
                            }
                        }
                        if (state.theData.itsNeedsActivation) {
                            ScriptRuntime.popActivation(cx);
                        }
                        if (state.frame != null) {
                            state.frame.onExit(cx, true, ex);
                            state.frame = null;
                        }
                        stackTrace.addElement(state.theData.itsSourceFile);
                        stackTrace.addElement(state.theData.itsName);
                        stackTrace.addElement(new Integer(state.lineno));
                        stk.pop();
                        state = stk.top();
                        ** GOTO lbl991
                    }
                    cx.setInterpreterStackTrace(stackTrace);
                    if (exType == 0) {
                        jsex = (JavaScriptException)ex;
                        jsex.setJSStackTrace(stackTrace);
                        throw jsex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw (Error)ex;
                }
                state.scope = (Scriptable)state.stack[state.TRY_SCOPE_SHFT() + state.tryStackTop];
                j = state.TRY_SCOPE_SHFT() + state.tryStackTop;
                while (j < state.stack.length) {
                    state.stack[j] = null;
                    ++j;
                }
                state.stackTop = 0;
                state.stack[0] = errObj;
                state.writeUnlock();
                continue;
            }
            if (state.theData.itsNeedsActivation) {
                ScriptRuntime.popActivation(cx);
            }
            if (state.frame != null) {
                state.frame.onExit(cx, false, result);
                state.frame = null;
            }
            if (state.ctor && (!(result instanceof Scriptable) || result == undefined)) {
                result = state.thisObj;
            }
            stk.pop();
            state = stk.top();
            if (state == null) continue;
            if (state.stackTop >= 0) {
                state.stack[state.stackTop] = result;
            }
            state.writeUnlock();
        }
        return result;
    }

    protected InterpretedFunction newInterpretedFunction(Context cx, InterpreterData itsData, String[] argNames, short argCount) {
        InterpretedFunctionImpl res = new InterpretedFunctionImpl(cx, itsData, argNames, argCount);
        return res;
    }

    protected InterpretedScript newInterpretedScript(Context cx, InterpreterData itsData, String[] argNames, short argCount) {
        InterpretedScriptImpl res = new InterpretedScriptImpl(cx, itsData, argNames, argCount);
        return res;
    }

    protected Interpreter newInterpreter() {
        return new ContinuationInterpreter();
    }

    static void createFunctionObjects(InterpretedFunction[] fn, Scriptable scope) {
        Scriptable proto = ScriptableObject.getClassPrototype(scope, "Function");
        int i = 0;
        while (i < fn.length) {
            ContinuationInterpreter.createFunctionObject(fn[i], scope, proto, fn[i].itsData.itsFromEvalCode);
            ++i;
        }
    }

    static void createFunctionObject(InterpretedFunction fn, Scriptable scope, Scriptable proto, boolean fromEvalCode) {
        InterpreterData id = fn.itsData;
        fn.setPrototype(proto);
        fn.setParentScope(scope);
        if (id.itsName.length() == 0) {
            return;
        }
        boolean callSetProp = false;
        if (id.itsFunctionType == 1 && fn.itsClosure == null) {
            if (fromEvalCode) {
                callSetProp = true;
            } else {
                try {
                    ((ScriptableObject)scope).defineProperty(fn.itsData.itsName, fn, 4);
                }
                catch (ClassCastException e) {
                    callSetProp = true;
                }
            }
        }
        if (id.itsFunctionType == 3 && fn.itsClosure != null) {
            callSetProp = true;
        }
        if (callSetProp) {
            ScriptRuntime.setProp(scope, fn.itsData.itsName, fn, scope);
        }
    }

    static void initFunctionObjects(InterpretedFunction[] fn, Scriptable scope) {
        Scriptable proto = ScriptableObject.getClassPrototype(scope, "Function");
        int i = 0;
        while (i < fn.length) {
            ContinuationInterpreter.initFunctionObject(fn[i], scope, proto, fn[i].itsData.itsFromEvalCode);
            ++i;
        }
    }

    static void initFunctionObject(InterpretedFunction fn, Scriptable scope, Scriptable proto, boolean fromEvalCode) {
        InterpreterData id = fn.itsData;
        if (id.itsName.length() == 0) {
            return;
        }
        boolean callSetProp = false;
        if (id.itsFunctionType == 1 && fn.itsClosure == null) {
            if (fromEvalCode) {
                callSetProp = true;
            } else {
                try {
                    ((ScriptableObject)scope).defineProperty(fn.itsData.itsName, fn, 4);
                }
                catch (ClassCastException e) {
                    callSetProp = true;
                }
            }
        }
        if (id.itsFunctionType == 3 && fn.itsClosure != null) {
            callSetProp = true;
        }
        if (callSetProp) {
            ScriptRuntime.setProp(scope, fn.itsData.itsName, fn, scope);
        }
    }

    public Object compile(Context cx, Scriptable scope, Node tree, Object securityDomain, SecuritySupport securitySupport, ClassNameHelper nameHelper) throws IOException {
        Object result = super.compile(cx, scope, tree, securityDomain, securitySupport, nameHelper);
        if (result instanceof InterpretedScriptImpl) {
            InterpreterData theData = ((InterpretedScriptImpl)result).itsData;
        }
        return result;
    }

    protected InterpretedFunction generateFunctionICode(Context cx, Scriptable scope, FunctionNode theFunction, Object securityDomain) {
        InterpretedFunction result = super.generateFunctionICode(cx, scope, theFunction, securityDomain);
        if (result instanceof InterpretedFunctionImpl) {
            InterpreterData theData = ((InterpretedFunctionImpl)result).itsData;
        }
        return result;
    }

    protected void generateICodeFromTree(Node tree, VariableTable varTable, boolean needsActivation, Object securityDomain) {
        int theICodeTop = 0;
        this.itsVariableTable = varTable;
        this.itsData.itsNeedsActivation = needsActivation;
        this.itsBefore = new Vector();
        this.itsAfter = new Vector();
        this.itsReturn = new Vector();
        theICodeTop = this.addShort(0, theICodeTop);
        theICodeTop = this.addShort(0, theICodeTop);
        theICodeTop = this.addShort(0, theICodeTop);
        theICodeTop = this.generateICode(tree, theICodeTop);
        if (!this.itsData.isFunction) {
            theICodeTop = this.addByte(153, theICodeTop);
        }
        Vector before = this.itsBefore;
        Vector after = this.itsAfter;
        Vector ret = this.itsReturn;
        this.itsBefore = null;
        this.itsAfter = null;
        int beforeTarget = theICodeTop;
        if (before.size() + after.size() > 0) {
            ++this.itsData.itsMaxStack;
        }
        if (before.size() > 0) {
            Enumeration e = before.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                theICodeTop = this.updateLineNumber(n, theICodeTop);
                theICodeTop = this.generateICode(n.getFirstChild().getNextSibling(), theICodeTop);
            }
        }
        int afterTarget = theICodeTop = this.addByte(249, theICodeTop);
        if (after.size() > 0) {
            Enumeration e = after.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                theICodeTop = this.updateLineNumber(n, theICodeTop);
                theICodeTop = this.generateICode(n.getFirstChild().getNextSibling(), theICodeTop);
            }
        }
        int returnTarget = theICodeTop = this.addByte(248, theICodeTop);
        if (ret.size() > 0) {
            Enumeration e = ret.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                theICodeTop = this.updateLineNumber(n, theICodeTop);
                theICodeTop = this.generateICode(n.getFirstChild().getNextSibling(), theICodeTop);
            }
        }
        theICodeTop = this.addByte(247, theICodeTop);
        int i = 0;
        while (i < this.itsLabelTableTop) {
            this.itsLabelTable[i].fixGotos(this.itsData.itsICode);
            ++i;
        }
        this.setShort(0, beforeTarget);
        this.setShort(2, afterTarget);
        this.setShort(4, returnTarget);
        this.itsData.itsICodeTop = theICodeTop;
        if (this.itsData.itsICode.length != theICodeTop) {
            byte[] tmp = new byte[theICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, tmp, 0, theICodeTop);
            this.itsData.itsICode = tmp;
        }
        this.itsData.itsMaxVars = this.itsVariableTable.size();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxTryDepth + this.itsData.itsMaxStack;
    }

    void setShort(int pc, int i) {
        this.itsData.itsICode[pc] = (byte)(i >>> 8 & 0xFF);
        this.itsData.itsICode[pc + 1] = (byte)(i >>> 0 & 0xFF);
    }

    protected int generateICode(Node node, int iCodeTop) {
        int type = node.getType();
        switch (type) {
            case 5: {
                if (this.itsBefore != null) break;
                String message = Context.getMessage("msg.bad.return", null);
                Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                return iCodeTop;
            }
            case 125: {
                Node child = node.getFirstChild();
                Node block = child.getNextSibling();
                if (child.getType() == 122) {
                    if (this.itsBefore == null) {
                        String message = Context.getMessage("msg.continue.outside", null);
                        Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                        return iCodeTop;
                    }
                    this.itsBefore.addElement(node);
                } else if (child.getType() == 121) {
                    if (this.itsAfter == null) {
                        String message = Context.getMessage("msg.bad.break", null);
                        Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                        return iCodeTop;
                    }
                    this.itsAfter.addElement(node);
                } else {
                    if (this.itsReturn == null) {
                        String message = Context.getMessage("msg.bad.return", null);
                        Context.reportError(message, this.itsSourceFile, 1 + this.itsLineNumber, null, 0);
                        return iCodeTop;
                    }
                    this.itsReturn.addElement(node);
                }
                return iCodeTop;
            }
        }
        return super.generateICode(node, iCodeTop);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

