/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import org.mozilla.classfile.DefiningClassLoader;
import org.mozilla.javascript.BinaryDigitReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdEnumeration;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class ScriptRuntime {
    public static final Class UndefinedClass = class$org$mozilla$javascript$Undefined == null ? (class$org$mozilla$javascript$Undefined = ScriptRuntime.class$("org.mozilla.javascript.Undefined")) : class$org$mozilla$javascript$Undefined;
    public static final Class ScriptableClass = class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = ScriptRuntime.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable;
    public static final Class StringClass = class$java$lang$String == null ? (class$java$lang$String = ScriptRuntime.class$("java.lang.String")) : class$java$lang$String;
    public static final Class NumberClass = class$java$lang$Number == null ? (class$java$lang$Number = ScriptRuntime.class$("java.lang.Number")) : class$java$lang$Number;
    public static final Class BooleanClass = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ScriptRuntime.class$("java.lang.Boolean")) : class$java$lang$Boolean;
    public static final Class ByteClass = class$java$lang$Byte == null ? (class$java$lang$Byte = ScriptRuntime.class$("java.lang.Byte")) : class$java$lang$Byte;
    public static final Class ShortClass = class$java$lang$Short == null ? (class$java$lang$Short = ScriptRuntime.class$("java.lang.Short")) : class$java$lang$Short;
    public static final Class IntegerClass = class$java$lang$Integer == null ? (class$java$lang$Integer = ScriptRuntime.class$("java.lang.Integer")) : class$java$lang$Integer;
    public static final Class LongClass = class$java$lang$Long == null ? (class$java$lang$Long = ScriptRuntime.class$("java.lang.Long")) : class$java$lang$Long;
    public static final Class FloatClass = class$java$lang$Float == null ? (class$java$lang$Float = ScriptRuntime.class$("java.lang.Float")) : class$java$lang$Float;
    public static final Class DoubleClass = class$java$lang$Double == null ? (class$java$lang$Double = ScriptRuntime.class$("java.lang.Double")) : class$java$lang$Double;
    public static final Class CharacterClass = class$java$lang$Character == null ? (class$java$lang$Character = ScriptRuntime.class$("java.lang.Character")) : class$java$lang$Character;
    public static final Class ObjectClass = class$java$lang$Object == null ? (class$java$lang$Object = ScriptRuntime.class$("java.lang.Object")) : class$java$lang$Object;
    public static final Class FunctionClass = class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = ScriptRuntime.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function;
    public static final Class ClassClass = class$java$lang$Class == null ? (class$java$lang$Class = ScriptRuntime.class$("java.lang.Class")) : class$java$lang$Class;
    public static double NaN = Double.NaN;
    public static Double NaNobj = new Double(Double.NaN);
    public static double negativeZero = -0.0;
    private static final boolean MSJVM_BUG_WORKAROUNDS = true;
    private static final String GLOBAL_CLASS = "org.mozilla.javascript.tools.shell.Global";
    public static final Object[] emptyArgs = new Object[0];
    static /* synthetic */ Class class$org$mozilla$javascript$Undefined;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeGlobal;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeWith;
    static /* synthetic */ Class class$org$mozilla$javascript$NativeScript;
    static /* synthetic */ Class class$org$mozilla$javascript$Context;

    protected ScriptRuntime() {
    }

    public static boolean toBoolean(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Scriptable) {
            if (Context.getContext().isVersionECMA1()) {
                return val != Undefined.instance;
            }
            if ((val = ((Scriptable)val).getDefaultValue(BooleanClass)) instanceof Scriptable) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val);
            }
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
        }
        if (val instanceof String) {
            return ((String)val).length() != 0;
        }
        if (val instanceof Number) {
            double d = ((Number)val).doubleValue();
            return d == d && d != 0.0;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", val);
    }

    public static boolean toBoolean(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toBoolean(args[index]) : false;
    }

    public static double toNumber(Object val) {
        if (val == null) {
            return 0.0;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof Scriptable) {
            if ((val = ((Scriptable)val).getDefaultValue(NumberClass)) != null && val instanceof Scriptable) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val);
            }
            if (val instanceof Number) {
                return ((Number)val).doubleValue();
            }
        }
        if (val instanceof String) {
            return ScriptRuntime.toNumber((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", val);
    }

    public static double toNumber(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toNumber(args[index]) : NaN;
    }

    /*
     * WARNING - void declaration
     */
    static double stringToNumber(String s, int start, int radix) {
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        int len = s.length();
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        int end = start;
        while (end < len) {
            int newDigit;
            char c = s.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else {
                if ('A' > c || c >= upperCaseBound) break;
                newDigit = c - 65 + 10;
            }
            sum = sum * (double)radix + (double)newDigit;
            ++end;
        }
        if (start == end) {
            return NaN;
        }
        if (sum >= 9.007199254740992E15) {
            if (radix == 10) {
                try {
                    return Double.valueOf(s.substring(start, end));
                }
                catch (NumberFormatException nfe) {
                    return NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bit;
                BinaryDigitReader bdr = new BinaryDigitReader(radix, s, start, end);
                sum = 0.0;
                while ((bit = bdr.getNextBinaryDigit()) == 0) {
                }
                if (bit == 1) {
                    sum = 1.0;
                    int j = 52;
                    while (j != 0) {
                        bit = bdr.getNextBinaryDigit();
                        if (bit < 0) {
                            return sum;
                        }
                        sum = sum * 2.0 + (double)bit;
                        --j;
                    }
                    int bit54 = bdr.getNextBinaryDigit();
                    if (bit54 >= 0) {
                        int bit3;
                        double factor = 2.0;
                        int sticky = 0;
                        while ((bit3 = bdr.getNextBinaryDigit()) >= 0) {
                            void var17_17;
                            sticky |= var17_17;
                            factor *= 2.0;
                        }
                        sum += (double)(bit54 & (bit | sticky));
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }

    public static double toNumber(String s) {
        char endChar;
        char startChar;
        int len = s.length();
        int start = 0;
        while (true) {
            if (start == len) {
                return 0.0;
            }
            startChar = s.charAt(start);
            if (!Character.isWhitespace(startChar)) break;
            ++start;
        }
        if (startChar == '0' && start + 2 < len && Character.toLowerCase(s.charAt(start + 1)) == 'x') {
            return ScriptRuntime.stringToNumber(s, start + 2, 16);
        }
        if ((startChar == '+' || startChar == '-') && start + 3 < len && s.charAt(start + 1) == '0' && Character.toLowerCase(s.charAt(start + 2)) == 'x') {
            double val = ScriptRuntime.stringToNumber(s, start + 3, 16);
            return startChar == '-' ? -val : val;
        }
        int end = len - 1;
        while (Character.isWhitespace(endChar = s.charAt(end))) {
            --end;
        }
        if (endChar == 'y') {
            if (startChar == '+' || startChar == '-') {
                ++start;
            }
            if (start + 7 == end && s.regionMatches(start, "Infinity", 0, 8)) {
                return startChar == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return NaN;
        }
        String sub = s.substring(start, end + 1);
        int i = sub.length() - 1;
        while (i >= 0) {
            char c = sub.charAt(i);
            if (('0' > c || c > '9') && c != '.' && c != 'e' && c != 'E' && c != '+' && c != '-') {
                return NaN;
            }
            --i;
        }
        try {
            return Double.valueOf(sub);
        }
        catch (NumberFormatException ex) {
            return NaN;
        }
    }

    public static Object[] padArguments(Object[] args, int count) {
        if (count < args.length) {
            return args;
        }
        Object[] result = new Object[count];
        int i = 0;
        while (i < args.length) {
            result[i] = args[i];
            ++i;
        }
        while (i < count) {
            result[i] = Undefined.instance;
            ++i;
        }
        return result;
    }

    public static String escapeString(String s) {
        String escapeMap = "\bb\ff\nn\rr\tt\u000bv\"\"''";
        StringBuffer result = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~' && c != '\"') {
                result.append(c);
            } else {
                String hex;
                int index = escapeMap.indexOf(c);
                if (index >= 0) {
                    result.append("\\");
                    result.append(escapeMap.charAt(index + 1));
                } else if (c < '\u0100') {
                    hex = Integer.toHexString(c);
                    if (hex.length() == 1) {
                        result.append("\\x0");
                        result.append(hex);
                    } else {
                        result.append("\\x");
                        result.append(hex);
                    }
                } else {
                    hex = Integer.toHexString(c);
                    result.append("\\u");
                    int l = hex.length();
                    while (l < 4) {
                        result.append('0');
                        ++l;
                    }
                    result.append(hex);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String toString(Object val) {
        block3: {
            do {
                if (val == null) {
                    return "null";
                }
                if (!(val instanceof Scriptable)) break block3;
            } while ((val = ((Scriptable)val).getDefaultValue(StringClass)) == Undefined.instance || !(val instanceof Scriptable));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val);
        }
        if (val instanceof Number) {
            return ScriptRuntime.numberToString(((Number)val).doubleValue(), 10);
        }
        return val.toString();
    }

    public static String toString(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toString(args[index]) : "undefined";
    }

    public static String toString(double val) {
        return ScriptRuntime.numberToString(val, 10);
    }

    public static String numberToString(double d, int base) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (base < 2 || base > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(base));
        }
        if (base != 10) {
            return DToA.JS_dtobasestr(base, d);
        }
        StringBuffer result = new StringBuffer();
        DToA.JS_dtostr(result, 0, 0, d);
        return result.toString();
    }

    public static Scriptable toObject(Scriptable scope, Object val) {
        return ScriptRuntime.toObject(Context.getContext(), scope, val, null);
    }

    public static Scriptable toObject(Scriptable scope, Object val, Class staticClass) {
        return ScriptRuntime.toObject(Context.getContext(), scope, val, staticClass);
    }

    public static Scriptable toObject(Context cx, Scriptable scope, Object val) {
        return ScriptRuntime.toObject(cx, scope, val, null);
    }

    public static Scriptable toObject(Context cx, Scriptable scope, Object val, Class staticClass) {
        String className;
        if (val == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        if (val instanceof Scriptable) {
            if (val == Undefined.instance) {
                throw NativeGlobal.typeError0("msg.undef.to.object", scope);
            }
            return (Scriptable)val;
        }
        String string = val instanceof String ? "String" : (val instanceof Number ? "Number" : (className = val instanceof Boolean ? "Boolean" : null));
        if (className == null) {
            Object wrapped = NativeJavaObject.wrap(scope, val, staticClass);
            if (wrapped instanceof Scriptable) {
                return (Scriptable)wrapped;
            }
            throw ScriptRuntime.errorWithClassName("msg.invalid.type", val);
        }
        Object[] args = new Object[]{val};
        scope = ScriptableObject.getTopLevelScope(scope);
        Scriptable result = ScriptRuntime.newObject(cx, scope, className, args);
        return result;
    }

    public static Scriptable newObject(Context cx, Scriptable scope, String constructorName, Object[] args) {
        Exception re = null;
        try {
            return cx.newObject(scope, constructorName, args);
        }
        catch (NotAFunctionException e) {
            re = e;
        }
        catch (PropertyException e) {
            re = e;
        }
        catch (JavaScriptException e) {
            re = e;
        }
        throw Context.reportRuntimeError(re.getMessage());
    }

    public static double toInteger(Object val) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(val));
    }

    public static double toInteger(double d) {
        if (d != d) {
            return 0.0;
        }
        if (d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toInteger(args[index]) : 0.0;
    }

    public static int toInt32(Object val) {
        double two32 = 4.294967296E9;
        double two31 = 2.147483648E9;
        if (val instanceof Byte) {
            return ((Number)val).intValue();
        }
        double d = ScriptRuntime.toNumber(val);
        if (d != d || d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d2 = d = (d = Math.IEEEremainder(d, two32)) >= 0.0 ? d : d + two32;
        if (d >= two31) {
            return (int)(d - two32);
        }
        return (int)d;
    }

    public static int toInt32(Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toInt32(args[index]) : 0;
    }

    public static int toInt32(double d) {
        double two32 = 4.294967296E9;
        double two31 = 2.147483648E9;
        if (d != d || d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d2 = d = (d = Math.IEEEremainder(d, two32)) >= 0.0 ? d : d + two32;
        if (d >= two31) {
            return (int)(d - two32);
        }
        return (int)d;
    }

    public static long toUint32(double d) {
        double two32 = 4.294967296E9;
        if (d != d || d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0L;
        }
        d = d > 0.0 ? Math.floor(d) : Math.ceil(d);
        d = Math.IEEEremainder(d, two32);
        d = d >= 0.0 ? d : d + two32;
        return (long)Math.floor(d);
    }

    public static long toUint32(Object val) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(val));
    }

    public static char toUint16(Object val) {
        long int16 = 65536L;
        double d = ScriptRuntime.toNumber(val);
        if (d != d || d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return '\u0000';
        }
        d = (d = Math.IEEEremainder(d, int16)) >= 0.0 ? d : d + (double)int16;
        return (char)Math.floor(d);
    }

    public static Object unwrapJavaScriptException(JavaScriptException jse) {
        return jse.value;
    }

    public static Object unwrapWrappedException(WrappedException we) {
        Throwable t = we.getWrappedException();
        if (t instanceof JavaScriptException) {
            return ((JavaScriptException)t).value;
        }
        throw we;
    }

    public static Object getProp(Object obj, String id, Scriptable scope) {
        Scriptable start = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        if (start == null || start == Undefined.instance) {
            String msg = start == null ? "msg.null.to.object" : "msg.undefined";
            throw NativeGlobal.constructError(Context.getContext(), "ConversionError", ScriptRuntime.getMessage0(msg), scope);
        }
        Scriptable m = start;
        do {
            Object result;
            if ((result = m.get(id, start)) == Scriptable.NOT_FOUND) continue;
            return result;
        } while ((m = m.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object getTopLevelProp(Scriptable scope, String id) {
        Object v;
        Scriptable s = ScriptableObject.getTopLevelScope(scope);
        do {
            if ((v = s.get(id, s)) == Scriptable.NOT_FOUND) continue;
            return v;
        } while ((s = s.getPrototype()) != null);
        return v;
    }

    public static Scriptable getProto(Object obj, Scriptable scope) {
        Scriptable s = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        if (s == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        return s.getPrototype();
    }

    public static Scriptable getParent(Object obj) {
        Scriptable s;
        try {
            s = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            return null;
        }
        if (s == null) {
            return null;
        }
        return ScriptRuntime.getThis(s.getParentScope());
    }

    public static Scriptable getParent(Object obj, Scriptable scope) {
        Scriptable s = obj instanceof Scriptable ? (Scriptable)obj : ScriptRuntime.toObject(scope, obj);
        if (s == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        return s.getParentScope();
    }

    public static Object setProto(Object obj, Object value, Scriptable scope) {
        Scriptable result;
        Scriptable start;
        try {
            start = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            start = ScriptRuntime.toObject(scope, obj);
        }
        Scriptable s = result = value == null ? null : ScriptRuntime.toObject(scope, value);
        while (s != null) {
            if (s == start) {
                throw Context.reportRuntimeError1("msg.cyclic.value", "__proto__");
            }
            s = s.getPrototype();
        }
        if (start == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        start.setPrototype(result);
        return result;
    }

    public static Object setParent(Object obj, Object value, Scriptable scope) {
        Scriptable result;
        Scriptable start;
        try {
            start = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            start = ScriptRuntime.toObject(scope, obj);
        }
        Scriptable s = result = value == null ? null : ScriptRuntime.toObject(scope, value);
        while (s != null) {
            if (s == start) {
                throw Context.reportRuntimeError1("msg.cyclic.value", "__parent__");
            }
            s = s.getParentScope();
        }
        if (start == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        start.setParentScope(result);
        return result;
    }

    public static Object setProp(Object obj, String id, Object value, Scriptable scope) {
        Scriptable start;
        try {
            start = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            start = ScriptRuntime.toObject(scope, obj);
        }
        if (start == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        Scriptable m = start;
        do {
            if (!m.has(id, start)) continue;
            m.put(id, start, value);
            return value;
        } while ((m = m.getPrototype()) != null);
        start.put(id, start, value);
        return value;
    }

    private static long indexFromString(String str) {
        int MAX_VALUE_LENGTH = 10;
        int len = str.length();
        if (len > 0) {
            int i = 0;
            boolean negate = false;
            int c = str.charAt(0);
            if (c == 45 && len > 1) {
                c = str.charAt(1);
                i = 1;
                negate = true;
            }
            if (0 <= (c -= 48) && c <= 9 && len <= (negate ? 11 : 10)) {
                int index = -c;
                int oldIndex = 0;
                ++i;
                if (index != 0) {
                    while (i != len && 0 <= (c = str.charAt(i) - 48) && c <= 9) {
                        oldIndex = index;
                        index = 10 * index - c;
                        ++i;
                    }
                }
                if (i == len && (oldIndex > -214748364 || oldIndex == -214748364 && c <= (negate ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(negate ? index : -index);
                }
            }
        }
        return -1L;
    }

    static String getStringId(Object id) {
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            int index = (int)d;
            if ((double)index == d) {
                return null;
            }
            return ScriptRuntime.toString(id);
        }
        String s = ScriptRuntime.toString(id);
        long indexTest = ScriptRuntime.indexFromString(s);
        if (indexTest >= 0L) {
            return null;
        }
        return s;
    }

    static int getIntId(Object id) {
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            int index = (int)d;
            if ((double)index == d) {
                return index;
            }
            return 0;
        }
        String s = ScriptRuntime.toString(id);
        long indexTest = ScriptRuntime.indexFromString(s);
        if (indexTest >= 0L) {
            return (int)indexTest;
        }
        return 0;
    }

    public static Object getElem(Object obj, Object id, Scriptable scope) {
        Scriptable start;
        String s;
        int index;
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            index = (int)d;
            s = (double)index == d ? null : ScriptRuntime.toString(id);
        } else {
            s = id instanceof String ? (String)id : ScriptRuntime.toString(id);
            long indexTest = ScriptRuntime.indexFromString(s);
            if (indexTest >= 0L) {
                index = (int)indexTest;
                s = null;
            } else {
                index = 0;
            }
        }
        try {
            start = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            start = ScriptRuntime.toObject(scope, obj);
        }
        if (s != null) {
            return ScriptRuntime.getStrIdElem(start, s);
        }
        return ScriptRuntime.getElem(start, index);
    }

    public static Object getElem(Scriptable obj, int index) {
        Scriptable m = obj;
        while (m != null) {
            Object result = m.get(index, obj);
            if (result != Scriptable.NOT_FOUND) {
                return result;
            }
            m = m.getPrototype();
        }
        return Undefined.instance;
    }

    static Object getStrIdElem(Scriptable obj, String id) {
        int l = id.length();
        if (l == 9) {
            if (id.equals("__proto__")) {
                return obj.getPrototype();
            }
        } else if (l == 10 && id.equals("__parent__")) {
            return obj.getParentScope();
        }
        Scriptable m = obj;
        while (m != null) {
            Object result = m.get(id, obj);
            if (result != Scriptable.NOT_FOUND) {
                return result;
            }
            m = m.getPrototype();
        }
        return Undefined.instance;
    }

    public static Object setElem(Object obj, Object id, Object value, Scriptable scope) {
        Scriptable start;
        String s;
        int index;
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            index = (int)d;
            s = (double)index == d ? null : ScriptRuntime.toString(id);
        } else {
            s = id instanceof String ? (String)id : ScriptRuntime.toString(id);
            long indexTest = ScriptRuntime.indexFromString(s);
            if (indexTest >= 0L) {
                index = (int)indexTest;
                s = null;
            } else {
                index = 0;
            }
        }
        try {
            start = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            start = ScriptRuntime.toObject(scope, obj);
        }
        if (s != null) {
            return ScriptRuntime.setStrIdElem(start, s, value, scope);
        }
        return ScriptRuntime.setElem(start, index, value);
    }

    public static Object setElem(Scriptable obj, int index, Object value) {
        Scriptable m = obj;
        do {
            if (!m.has(index, obj)) continue;
            m.put(index, obj, value);
            return value;
        } while ((m = m.getPrototype()) != null);
        obj.put(index, obj, value);
        return value;
    }

    static Object setStrIdElem(Scriptable obj, String id, Object value, Scriptable scope) {
        int l = id.length();
        if (l == 9) {
            if (id.equals("__proto__")) {
                return ScriptRuntime.setProto(obj, value, scope);
            }
        } else if (l == 10 && id.equals("__parent__")) {
            return ScriptRuntime.setParent(obj, value, scope);
        }
        Scriptable m = obj;
        do {
            if (!m.has(id, obj)) continue;
            m.put(id, obj, value);
            return value;
        } while ((m = m.getPrototype()) != null);
        obj.put(id, obj, value);
        return value;
    }

    public static Object delete(Object obj, Object id) {
        String s = ScriptRuntime.getStringId(id);
        boolean result = s != null ? ScriptableObject.deleteProperty((Scriptable)obj, s) : ScriptableObject.deleteProperty((Scriptable)obj, ScriptRuntime.getIntId(id));
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object name(Scriptable scopeChain, String id) {
        Scriptable obj = scopeChain;
        while (obj != null) {
            Scriptable m = obj;
            do {
                Object result;
                if ((result = m.get(id, obj)) == Scriptable.NOT_FOUND) continue;
                return result;
            } while ((m = m.getPrototype()) != null);
            obj = obj.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", id.toString()), scopeChain);
    }

    public static Scriptable bind(Scriptable scope, String id) {
        Scriptable obj = scope;
        while (obj != null) {
            Scriptable m = obj;
            do {
                if (!m.has(id, obj)) continue;
                return obj;
            } while ((m = m.getPrototype()) != null);
            obj = obj.getParentScope();
        }
        return null;
    }

    public static Scriptable getBase(Scriptable scope, String id) {
        Scriptable obj = scope;
        while (obj != null) {
            Scriptable m = obj;
            do {
                if (m.get(id, obj) == Scriptable.NOT_FOUND) continue;
                return obj;
            } while ((m = m.getPrototype()) != null);
            obj = obj.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", id), scope);
    }

    public static Scriptable getThis(Scriptable base) {
        while (base instanceof NativeWith) {
            base = base.getPrototype();
        }
        if (base instanceof NativeCall) {
            base = ScriptableObject.getTopLevelScope(base);
        }
        return base;
    }

    public static Object setName(Scriptable bound, Object value, Scriptable scope, String id) {
        if (bound == null) {
            Scriptable next = scope;
            while ((next = (bound = next).getParentScope()) != null) {
            }
            bound.put(id, bound, value);
            return value;
        }
        return ScriptRuntime.setProp(bound, id, value, scope);
    }

    public static Enumeration initEnum(Object value, Scriptable scope) {
        Scriptable m = ScriptRuntime.toObject(scope, value);
        return new IdEnumeration(m);
    }

    public static Object nextEnum(Enumeration enumeration) {
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return enumeration.nextElement();
    }

    public static Object call(Context cx, Object fun, Object thisArg, Object[] args) throws JavaScriptException {
        Scriptable scope = null;
        if (fun instanceof Scriptable) {
            scope = ((Scriptable)fun).getParentScope();
        }
        return ScriptRuntime.call(cx, fun, thisArg, args, scope);
    }

    public static Object call(Context cx, Object fun, Object thisArg, Object[] args, Scriptable scope) throws JavaScriptException {
        if (!(fun instanceof Function)) {
            throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(fun), scope);
        }
        Function function = (Function)fun;
        Scriptable thisObj = thisArg instanceof Scriptable || thisArg == null ? (Scriptable)thisArg : ScriptRuntime.toObject(cx, scope, thisArg);
        return function.call(cx, scope, thisObj, args);
    }

    private static Object callOrNewSpecial(Context cx, Scriptable scope, Object fun, Object jsThis, Object thisArg, Object[] args, boolean isCall, String filename, int lineNumber) throws JavaScriptException {
        if (fun instanceof IdFunction) {
            IdFunction f = (IdFunction)fun;
            String name = f.getFunctionName();
            if (name.length() == 4) {
                if (name.equals("eval")) {
                    if (f.master.getClass() == (class$org$mozilla$javascript$NativeGlobal == null ? (class$org$mozilla$javascript$NativeGlobal = ScriptRuntime.class$("org.mozilla.javascript.NativeGlobal")) : class$org$mozilla$javascript$NativeGlobal)) {
                        return NativeGlobal.evalSpecial(cx, scope, thisArg, args, filename, lineNumber);
                    }
                } else if (name.equals("With")) {
                    if (f.master.getClass() == (class$org$mozilla$javascript$NativeWith == null ? (class$org$mozilla$javascript$NativeWith = ScriptRuntime.class$("org.mozilla.javascript.NativeWith")) : class$org$mozilla$javascript$NativeWith)) {
                        return NativeWith.newWithSpecial(cx, args, f, !isCall);
                    }
                } else if (name.equals("exec")) {
                    if (f.master.getClass() == (class$org$mozilla$javascript$NativeScript == null ? (class$org$mozilla$javascript$NativeScript = ScriptRuntime.class$("org.mozilla.javascript.NativeScript")) : class$org$mozilla$javascript$NativeScript)) {
                        return ((NativeScript)jsThis).exec(cx, ScriptableObject.getTopLevelScope(scope));
                    }
                    RegExpProxy proxy = cx.getRegExpProxy();
                    if (proxy != null && proxy.isRegExp(jsThis)) {
                        return ScriptRuntime.call(cx, fun, jsThis, args, scope);
                    }
                }
            }
        } else if (fun instanceof NativeJavaMethod) {
            return ScriptRuntime.call(cx, fun, jsThis, args, scope);
        }
        if (isCall) {
            return ScriptRuntime.call(cx, fun, thisArg, args, scope);
        }
        return ScriptRuntime.newObject(cx, fun, args, scope);
    }

    public static Object callSpecial(Context cx, Object fun, Object thisArg, Object[] args, Scriptable enclosingThisArg, Scriptable scope, String filename, int lineNumber) throws JavaScriptException {
        return ScriptRuntime.callOrNewSpecial(cx, scope, fun, thisArg, enclosingThisArg, args, true, filename, lineNumber);
    }

    public static Scriptable newObject(Context cx, Object fun, Object[] args, Scriptable scope) throws JavaScriptException {
        try {
            Function f = (Function)fun;
            if (f != null) {
                return f.construct(cx, scope, args);
            }
        }
        catch (ClassCastException e) {}
        throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(fun), scope);
    }

    public static Scriptable newObjectSpecial(Context cx, Object fun, Object[] args, Scriptable scope) throws JavaScriptException {
        return (Scriptable)ScriptRuntime.callOrNewSpecial(cx, scope, fun, null, null, args, false, null, -1);
    }

    public static String typeof(Object value) {
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (value == null) {
            return "object";
        }
        if (value instanceof Scriptable) {
            return value instanceof Function ? "function" : "object";
        }
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", value);
    }

    public static String typeofName(Scriptable scope, String id) {
        Scriptable val = ScriptRuntime.bind(scope, id);
        if (val == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getProp(val, id, scope));
    }

    public static Object add(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            return new Double(((Number)val1).doubleValue() + ((Number)val2).doubleValue());
        }
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(null);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(null);
        }
        if (!(val1 instanceof String) && !(val2 instanceof String)) {
            if (val1 instanceof Number && val2 instanceof Number) {
                return new Double(((Number)val1).doubleValue() + ((Number)val2).doubleValue());
            }
            return new Double(ScriptRuntime.toNumber(val1) + ScriptRuntime.toNumber(val2));
        }
        return ScriptRuntime.toString(val1) + ScriptRuntime.toString(val2);
    }

    public static Object postIncrement(Object value) {
        value = value instanceof Number ? new Double(((Number)value).doubleValue() + 1.0) : new Double(ScriptRuntime.toNumber(value) + 1.0);
        return value;
    }

    public static Object postIncrement(Scriptable scopeChain, String id) {
        Scriptable obj = scopeChain;
        while (obj != null) {
            Scriptable m = obj;
            do {
                Object result;
                if ((result = m.get(id, obj)) == Scriptable.NOT_FOUND) continue;
                Object newValue = result;
                if (newValue instanceof Number) {
                    newValue = new Double(((Number)newValue).doubleValue() + 1.0);
                    m.put(id, obj, newValue);
                    return result;
                }
                newValue = new Double(ScriptRuntime.toNumber(newValue) + 1.0);
                m.put(id, obj, newValue);
                return new Double(ScriptRuntime.toNumber(result));
            } while ((m = m.getPrototype()) != null);
            obj = obj.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", id), scopeChain);
    }

    public static Object postIncrement(Object obj, String id, Scriptable scope) {
        Scriptable start;
        try {
            start = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            start = ScriptRuntime.toObject(scope, obj);
        }
        if (start == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        Scriptable m = start;
        do {
            Object result;
            if ((result = m.get(id, start)) == Scriptable.NOT_FOUND) continue;
            Object newValue = result;
            if (newValue instanceof Number) {
                newValue = new Double(((Number)newValue).doubleValue() + 1.0);
                m.put(id, start, newValue);
                return result;
            }
            newValue = new Double(ScriptRuntime.toNumber(newValue) + 1.0);
            m.put(id, start, newValue);
            return new Double(ScriptRuntime.toNumber(result));
        } while ((m = m.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postIncrementElem(Object obj, Object index, Scriptable scope) {
        Object oldValue = ScriptRuntime.getElem(obj, index, scope);
        if (oldValue == Undefined.instance) {
            return Undefined.instance;
        }
        double resultValue = ScriptRuntime.toNumber(oldValue);
        Double newValue = new Double(resultValue + 1.0);
        ScriptRuntime.setElem(obj, index, newValue, scope);
        return new Double(resultValue);
    }

    public static Object postDecrementElem(Object obj, Object index, Scriptable scope) {
        Object oldValue = ScriptRuntime.getElem(obj, index, scope);
        if (oldValue == Undefined.instance) {
            return Undefined.instance;
        }
        double resultValue = ScriptRuntime.toNumber(oldValue);
        Double newValue = new Double(resultValue - 1.0);
        ScriptRuntime.setElem(obj, index, newValue, scope);
        return new Double(resultValue);
    }

    public static Object postDecrement(Object value) {
        value = value instanceof Number ? new Double(((Number)value).doubleValue() - 1.0) : new Double(ScriptRuntime.toNumber(value) - 1.0);
        return value;
    }

    public static Object postDecrement(Scriptable scopeChain, String id) {
        Scriptable obj = scopeChain;
        while (obj != null) {
            Scriptable m = obj;
            do {
                Object result;
                if ((result = m.get(id, obj)) == Scriptable.NOT_FOUND) continue;
                Object newValue = result;
                if (newValue instanceof Number) {
                    newValue = new Double(((Number)newValue).doubleValue() - 1.0);
                    m.put(id, obj, newValue);
                    return result;
                }
                newValue = new Double(ScriptRuntime.toNumber(newValue) - 1.0);
                m.put(id, obj, newValue);
                return new Double(ScriptRuntime.toNumber(result));
            } while ((m = m.getPrototype()) != null);
            obj = obj.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", id), scopeChain);
    }

    public static Object postDecrement(Object obj, String id, Scriptable scope) {
        Scriptable start;
        try {
            start = (Scriptable)obj;
        }
        catch (ClassCastException e) {
            start = ScriptRuntime.toObject(scope, obj);
        }
        if (start == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scope);
        }
        Scriptable m = start;
        do {
            Object result;
            if ((result = m.get(id, start)) == Scriptable.NOT_FOUND) continue;
            Object newValue = result;
            if (newValue instanceof Number) {
                newValue = new Double(((Number)newValue).doubleValue() - 1.0);
                m.put(id, start, newValue);
                return result;
            }
            newValue = new Double(ScriptRuntime.toNumber(newValue) - 1.0);
            m.put(id, start, newValue);
            return new Double(ScriptRuntime.toNumber(result));
        } while ((m = m.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object toPrimitive(Object val) {
        if (val == null || !(val instanceof Scriptable)) {
            return val;
        }
        Object result = ((Scriptable)val).getDefaultValue(null);
        if (result != null && result instanceof Scriptable) {
            throw NativeGlobal.typeError0("msg.bad.default.value", val);
        }
        return result;
    }

    private static Class getTypeOfValue(Object obj) {
        if (obj == null) {
            return ScriptableClass;
        }
        if (obj == Undefined.instance) {
            return UndefinedClass;
        }
        if (obj instanceof Number) {
            return NumberClass;
        }
        if (obj instanceof Scriptable) {
            return ScriptableClass;
        }
        return obj.getClass();
    }

    public static boolean eq(Object x, Object y) {
        Object xCopy = x;
        Object yCopy = y;
        while (true) {
            Class typeY;
            Class typeX;
            if ((typeX = ScriptRuntime.getTypeOfValue(x)) == (typeY = ScriptRuntime.getTypeOfValue(y))) {
                if (typeX == UndefinedClass) {
                    return true;
                }
                if (typeX == NumberClass) {
                    return ((Number)x).doubleValue() == ((Number)y).doubleValue();
                }
                if (typeX == StringClass || typeX == BooleanClass) {
                    return xCopy.equals(yCopy);
                }
                if (typeX == ScriptableClass) {
                    if (x == y) {
                        return true;
                    }
                    if (x instanceof Wrapper && y instanceof Wrapper) {
                        return ((Wrapper)x).unwrap() == ((Wrapper)y).unwrap();
                    }
                    return false;
                }
                throw new RuntimeException();
            }
            if (x == null && y == Undefined.instance) {
                return true;
            }
            if (x == Undefined.instance && y == null) {
                return true;
            }
            if (typeX == NumberClass && typeY == StringClass) {
                return ((Number)x).doubleValue() == ScriptRuntime.toNumber(y);
            }
            if (typeX == StringClass && typeY == NumberClass) {
                return ScriptRuntime.toNumber(x) == ((Number)y).doubleValue();
            }
            if (typeX == BooleanClass) {
                xCopy = x = new Double(ScriptRuntime.toNumber(x));
                continue;
            }
            if (typeY == BooleanClass) {
                yCopy = y = new Double(ScriptRuntime.toNumber(y));
                continue;
            }
            if ((typeX == StringClass || typeX == NumberClass) && typeY == ScriptableClass && y != null) {
                yCopy = y = ScriptRuntime.toPrimitive(y);
                continue;
            }
            if (typeX != ScriptableClass || x == null || typeY != StringClass && typeY != NumberClass) break;
            xCopy = x = ScriptRuntime.toPrimitive(x);
        }
        return false;
    }

    public static Boolean eqB(Object x, Object y) {
        if (ScriptRuntime.eq(x, y)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean neB(Object x, Object y) {
        if (ScriptRuntime.eq(x, y)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean shallowEq(Object x, Object y) {
        Class type = ScriptRuntime.getTypeOfValue(x);
        if (type != ScriptRuntime.getTypeOfValue(y)) {
            return false;
        }
        if (type == StringClass || type == BooleanClass) {
            return x.equals(y);
        }
        if (type == NumberClass) {
            return ((Number)x).doubleValue() == ((Number)y).doubleValue();
        }
        if (type == ScriptableClass) {
            if (x == y) {
                return true;
            }
            if (x instanceof Wrapper && y instanceof Wrapper) {
                return ((Wrapper)x).unwrap() == ((Wrapper)y).unwrap();
            }
            return false;
        }
        return type == UndefinedClass;
    }

    public static Boolean seqB(Object x, Object y) {
        if (ScriptRuntime.shallowEq(x, y)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean sneB(Object x, Object y) {
        if (ScriptRuntime.shallowEq(x, y)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean instanceOf(Scriptable scope, Object a, Object b) {
        if (!(b instanceof Scriptable)) {
            throw NativeGlobal.typeError0("msg.instanceof.not.object", scope);
        }
        if (!(a instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)b).hasInstance((Scriptable)a);
    }

    protected static boolean jsDelegatesTo(Scriptable lhs, Scriptable rhs) {
        Scriptable proto = lhs.getPrototype();
        while (proto != null) {
            if (proto.equals(rhs)) {
                return true;
            }
            proto = proto.getPrototype();
        }
        return false;
    }

    public static boolean in(Object a, Object b, Scriptable scope) {
        if (!(b instanceof Scriptable)) {
            throw NativeGlobal.typeError0("msg.instanceof.not.object", scope);
        }
        String s = ScriptRuntime.getStringId(a);
        return s != null ? ScriptableObject.hasProperty((Scriptable)b, s) : ScriptableObject.hasProperty((Scriptable)b, ScriptRuntime.getIntId(a));
    }

    public static Boolean cmp_LTB(Object val1, Object val2) {
        if (ScriptRuntime.cmp_LT(val1, val2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            double d1 = ((Number)val1).doubleValue();
            double d2 = ((Number)val2).doubleValue();
            if (d1 != d1) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d1 < d2 ? 1 : 0;
        }
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(NumberClass);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(NumberClass);
        }
        if (!(val1 instanceof String) || !(val2 instanceof String)) {
            double d1 = ScriptRuntime.toNumber(val1);
            if (d1 != d1) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(val2);
            if (d2 != d2) {
                return 0;
            }
            return d1 < d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(val1).compareTo(ScriptRuntime.toString(val2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object val1, Object val2) {
        if (ScriptRuntime.cmp_LE(val1, val2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            double d1 = ((Number)val1).doubleValue();
            double d2 = ((Number)val2).doubleValue();
            if (d1 != d1) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d1 <= d2 ? 1 : 0;
        }
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(NumberClass);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(NumberClass);
        }
        if (!(val1 instanceof String) || !(val2 instanceof String)) {
            double d1 = ScriptRuntime.toNumber(val1);
            if (d1 != d1) {
                return 0;
            }
            double d2 = ScriptRuntime.toNumber(val2);
            if (d2 != d2) {
                return 0;
            }
            return d1 <= d2 ? 1 : 0;
        }
        return ScriptRuntime.toString(val1).compareTo(ScriptRuntime.toString(val2)) <= 0 ? 1 : 0;
    }

    private static ScriptableObject getGlobal(Context cx) {
        try {
            Class globalClass = ScriptRuntime.loadClassName(GLOBAL_CLASS);
            Class[] parm = new Class[]{class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = ScriptRuntime.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context};
            Constructor globalClassCtor = globalClass.getConstructor(parm);
            Object[] arg = new Object[]{cx};
            return (ScriptableObject)globalClassCtor.newInstance(arg);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        return new ImporterTopLevel(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String scriptClassName, String[] args) throws JavaScriptException {
        Context cx = Context.enter();
        ScriptableObject global = ScriptRuntime.getGlobal(cx);
        Scriptable argsObj = cx.newArray((Scriptable)global, args);
        global.defineProperty("arguments", argsObj, 2);
        try {
            try {
                Class cl = ScriptRuntime.loadClassName(scriptClassName);
                Script script = (Script)cl.newInstance();
                script.exec(cx, global);
                Object var9_9 = null;
            }
            catch (ClassNotFoundException e) {
                Object var9_10 = null;
                Context.exit();
                throw new RuntimeException("Error creating script object");
            }
            catch (InstantiationException e) {
                Object var9_11 = null;
                Context.exit();
                throw new RuntimeException("Error creating script object");
            }
            catch (IllegalAccessException e) {
                Object var9_12 = null;
                Context.exit();
                throw new RuntimeException("Error creating script object");
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public static Scriptable initScript(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, boolean fromEvalCode) {
        String[] argNames = funObj.argNames;
        if (argNames != null) {
            ScriptableObject so;
            try {
                so = (ScriptableObject)scope;
            }
            catch (ClassCastException x) {
                so = null;
            }
            Scriptable varScope = scope;
            if (fromEvalCode) {
                varScope = scope;
                while (varScope instanceof NativeWith) {
                    varScope = varScope.getParentScope();
                }
            }
            int i = argNames.length;
            while (i-- != 0) {
                String name = argNames[i];
                if (ScriptRuntime.hasProp(scope, name)) continue;
                if (so != null && !fromEvalCode) {
                    so.defineProperty(name, Undefined.instance, 4);
                    continue;
                }
                varScope.put(name, varScope, (Object)Undefined.instance);
            }
        }
        return scope;
    }

    public static Scriptable runScript(Script script) {
        Context cx = Context.enter();
        ScriptableObject global = ScriptRuntime.getGlobal(cx);
        try {
            try {
                script.exec(cx, global);
            }
            catch (JavaScriptException e) {
                throw new Error(e.toString());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return global;
    }

    public static Scriptable initVarObj(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, Object[] args) {
        NativeCall result = new NativeCall(cx, scope, funObj, thisObj, args);
        String[] argNames = funObj.argNames;
        if (argNames != null) {
            int i = funObj.argCount;
            while (i != argNames.length) {
                String name = argNames[i];
                result.put(name, (Scriptable)result, (Object)Undefined.instance);
                ++i;
            }
        }
        return result;
    }

    public static void popActivation(Context cx) {
        NativeCall current = cx.currentActivation;
        if (current != null) {
            cx.currentActivation = current.caller;
            current.caller = null;
        }
    }

    public static Scriptable newScope() {
        return new NativeObject();
    }

    public static Scriptable enterWith(Object value, Scriptable scope) {
        return new NativeWith(scope, ScriptRuntime.toObject(scope, value));
    }

    public static Scriptable leaveWith(Scriptable scope) {
        return scope.getParentScope();
    }

    public static NativeFunction initFunction(NativeFunction fn, Scriptable scope, String fnName, Context cx, boolean doSetName) {
        block2: {
            fn.setPrototype(ScriptableObject.getClassPrototype(scope, "Function"));
            fn.setParentScope(scope);
            if (!doSetName) break block2;
            try {
                ((ScriptableObject)scope).defineProperty(fnName, fn, 4);
            }
            catch (ClassCastException e) {
                ScriptRuntime.setName(scope, fn, scope, fnName);
            }
        }
        return fn;
    }

    public static NativeFunction createFunctionObject(Scriptable scope, Class functionClass, Context cx, boolean setName) {
        Constructor<?>[] ctors = functionClass.getConstructors();
        NativeFunction result = null;
        Object[] initArgs = new Object[]{scope, cx};
        try {
            result = (NativeFunction)ctors[0].newInstance(initArgs);
        }
        catch (InstantiationException e) {
            throw WrappedException.wrapException(e);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        catch (IllegalArgumentException e) {
            throw WrappedException.wrapException(e);
        }
        catch (InvocationTargetException e) {
            throw WrappedException.wrapException(e);
        }
        result.setPrototype(ScriptableObject.getClassPrototype(scope, "Function"));
        result.setParentScope(scope);
        String fnName = result.getFunctionName();
        if (setName && fnName != null && fnName.length() != 0 && !fnName.equals("anonymous")) {
            ScriptRuntime.setProp(scope, fnName, result, scope);
        }
        return result;
    }

    static void checkDeprecated(Context cx, String name) {
        int version = cx.getLanguageVersion();
        if (version >= 140 || version == 0) {
            String msg = ScriptRuntime.getMessage1("msg.deprec.ctor", name);
            if (version == 0) {
                Context.reportWarning(msg);
            } else {
                throw Context.reportRuntimeError(msg);
            }
        }
    }

    public static String getMessage0(String messageId) {
        return Context.getMessage0(messageId);
    }

    public static String getMessage1(String messageId, Object arg1) {
        return Context.getMessage1(messageId, arg1);
    }

    public static String getMessage2(String messageId, Object arg1, Object arg2) {
        return Context.getMessage2(messageId, arg1, arg2);
    }

    public static String getMessage(String messageId, Object[] arguments) {
        return Context.getMessage(messageId, arguments);
    }

    public static RegExpProxy getRegExpProxy(Context cx) {
        return cx.getRegExpProxy();
    }

    public static NativeCall getCurrentActivation(Context cx) {
        return cx.currentActivation;
    }

    public static void setCurrentActivation(Context cx, NativeCall activation) {
        cx.currentActivation = activation;
    }

    public static Class loadClassName(String className) throws ClassNotFoundException {
        try {
            ClassLoader cl = DefiningClassLoader.getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
        }
        catch (SecurityException e) {
        }
        catch (ClassNotFoundException e) {}
        return Class.forName(className);
    }

    static boolean hasProp(Scriptable start, String name) {
        Scriptable m = start;
        do {
            if (!m.has(name, start)) continue;
            return true;
        } while ((m = m.getPrototype()) != null);
        return false;
    }

    private static RuntimeException errorWithClassName(String msg, Object val) {
        return Context.reportRuntimeError1(msg, val.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

