/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int MAX_PROTOTYPE_ID = 7;
    private boolean prototypeFlag;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeObject obj = new NativeObject();
        obj.prototypeFlag = true;
        obj.addAsPrototype(7, cx, scope, sealed);
    }

    public String getClassName() {
        return "Object";
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    return NativeObject.jsConstructor(cx, args, f, thisObj == null);
                }
                case 2: {
                    return NativeObject.jsFunction_toString(cx, thisObj);
                }
                case 3: {
                    return NativeObject.jsFunction_toLocaleString(cx, thisObj);
                }
                case 4: {
                    return NativeObject.jsFunction_valueOf(thisObj);
                }
                case 5: {
                    return NativeObject.jsFunction_hasOwnProperty(thisObj, args);
                }
                case 6: {
                    return NativeObject.jsFunction_propertyIsEnumerable(cx, thisObj, args);
                }
                case 7: {
                    return NativeObject.jsFunction_isPrototypeOf(cx, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws JavaScriptException {
        if (!inNewExpr) {
            return ctorObj.construct(cx, ctorObj.getParentScope(), args);
        }
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            return new NativeObject();
        }
        return ScriptRuntime.toObject(cx, ctorObj.getParentScope(), args[0]);
    }

    public String toString() {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return NativeObject.jsFunction_toString(cx, this);
        }
        return "[object " + this.getClassName() + "]";
    }

    private static String jsFunction_toString(Context cx, Scriptable thisObj) {
        if (cx.getLanguageVersion() != 120) {
            return "[object " + thisObj.getClassName() + "]";
        }
        return NativeObject.toSource(cx, thisObj);
    }

    private static String jsFunction_toLocaleString(Context cx, Scriptable thisObj) {
        return NativeObject.jsFunction_toString(cx, thisObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toSource(Context cx, Scriptable thisObj) {
        Scriptable m = thisObj;
        if (cx.iterating == null) {
            cx.iterating = new Hashtable(31);
        }
        if (cx.iterating.get(m) == Boolean.TRUE) {
            return "{}";
        }
        StringBuffer result = new StringBuffer("{");
        Object[] ids = m.getIds();
        int i = 0;
        while (i < ids.length) {
            Object p;
            if (i > 0) {
                result.append(", ");
            }
            Object id = ids[i];
            String idString = ScriptRuntime.toString(id);
            Object object = p = id instanceof String ? m.get((String)id, m) : m.get(((Number)id).intValue(), m);
            if (p instanceof String) {
                result.append(idString + ":\"" + ScriptRuntime.escapeString(ScriptRuntime.toString(p)) + "\"");
            } else {
                Object var10_9;
                try {
                    cx.iterating.put(m, Boolean.TRUE);
                    result.append(idString + ":" + ScriptRuntime.toString(p));
                    var10_9 = null;
                    cx.iterating.remove(m);
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    cx.iterating.remove(m);
                    throw throwable;
                }
                {
                }
            }
            ++i;
        }
        result.append('}');
        return result.toString();
    }

    private static Object jsFunction_valueOf(Scriptable thisObj) {
        return thisObj;
    }

    private static Object jsFunction_hasOwnProperty(Scriptable thisObj, Object[] args) {
        if (args.length != 0 && thisObj.has(ScriptRuntime.toString(args[0]), thisObj)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object jsFunction_propertyIsEnumerable(Context cx, Scriptable thisObj, Object[] args) {
        try {
            int a;
            String name;
            if (args.length != 0 && thisObj.has(name = ScriptRuntime.toString(args[0]), thisObj) && ((a = ((ScriptableObject)thisObj).getAttributes(name, thisObj)) & 2) == 0) {
                return Boolean.TRUE;
            }
        }
        catch (PropertyException x) {
        }
        catch (ClassCastException x) {}
        return Boolean.FALSE;
    }

    private static Object jsFunction_isPrototypeOf(Context cx, Scriptable thisObj, Object[] args) {
        if (args.length != 0 && args[0] instanceof Scriptable) {
            Scriptable v = (Scriptable)args[0];
            do {
                if ((v = v.getPrototype()) != thisObj) continue;
                return Boolean.TRUE;
            } while (v != null);
        }
        return Boolean.FALSE;
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            switch (id) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toLocaleString";
                }
                case 4: {
                    return "valueOf";
                }
                case 5: {
                    return "hasOwnProperty";
                }
                case 6: {
                    return "propertyIsEnumerable";
                }
                case 7: {
                    return "isPrototypeOf";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 7: {
                X = "valueOf";
                id = 4;
                break;
            }
            case 8: {
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
            case 13: {
                X = "isPrototypeOf";
                id = 7;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'h') {
                    X = "hasOwnProperty";
                    id = 5;
                    break;
                }
                if (c != 't') break;
                X = "toLocaleString";
                id = 3;
                break;
            }
            case 20: {
                X = "propertyIsEnumerable";
                id = 6;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

