/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaArray
extends NativeJavaObject {
    Object array;
    int length;
    Class cls;
    Scriptable prototype;

    public String getClassName() {
        return "JavaArray";
    }

    public static NativeJavaArray wrap(Scriptable scope, Object array) {
        return new NativeJavaArray(scope, array);
    }

    public Object unwrap() {
        return this.array;
    }

    public NativeJavaArray(Scriptable scope, Object array) {
        super(scope, null, ScriptRuntime.ObjectClass);
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = array;
        this.length = Array.getLength(array);
        this.cls = cl.getComponentType();
    }

    public boolean has(String id, Scriptable start) {
        return id.equals("length") || super.has(id, start);
    }

    public boolean has(int index, Scriptable start) {
        return 0 <= index && index < this.length;
    }

    public Object get(String id, Scriptable start) {
        if (id.equals("length")) {
            return new Integer(this.length);
        }
        Object result = super.get(id, start);
        if (result == Scriptable.NOT_FOUND && !ScriptRuntime.hasProp(this.getPrototype(), id)) {
            throw Context.reportRuntimeError2("msg.java.member.not.found", this.array.getClass().getName(), id);
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.length) {
            return NativeJavaObject.wrap(this, Array.get(this.array, index), this.cls);
        }
        return Undefined.instance;
    }

    public void put(String id, Scriptable start, Object value) {
        if (!id.equals("length")) {
            super.put(id, start, value);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        if (0 <= index && index < this.length) {
            Array.set(this.array, index, NativeJavaObject.coerceType(this.cls, value, true));
            return;
        }
        super.put(index, start, value);
    }

    public Object getDefaultValue(Class hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object[] getIds() {
        Object[] result = new Object[this.length];
        int i = this.length;
        while (--i >= 0) {
            result[i] = new Integer(i);
        }
        return result;
    }

    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Object instance = ((Wrapper)((Object)value)).unwrap();
        return this.cls.isInstance(instance);
    }

    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getClassPrototype(this.getParentScope(), "Array");
        }
        return this.prototype;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.array);
        out.writeInt(this.length);
        out.writeObject(this.cls.getName());
        out.writeObject(this.prototype);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.array = in.readObject();
        this.length = in.readInt();
        this.cls = Class.forName((String)in.readObject());
        this.prototype = (Scriptable)in.readObject();
    }
}

