/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class NativeFunction
extends BaseFunction {
    private static final int OFFSET = 4;
    private static final int SETBACK = 2;
    private static final boolean printSource = false;
    public String[] argNames;
    public short argCount;
    public short version;
    protected String source;
    public Scriptable itsClosure;
    public NativeFunction[] nestedFunctions;
    public int debug_level = -1;
    public String debug_srcName;

    private boolean nextIs(int i, int token) {
        if (i + 1 < this.source.length()) {
            return this.source.charAt(i + 1) == token;
        }
        return false;
    }

    public String decompile(Context cx, int indent, boolean justbody) {
        StringBuffer result = new StringBuffer();
        this.decompile(indent, true, justbody, result);
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void decompile(int indent, boolean toplevel, boolean justbody, StringBuffer result) {
        block137: {
            if (this.source == null) {
                if (!justbody) {
                    result.append("function ");
                    result.append(this.getFunctionName());
                    result.append("() {\n\t");
                }
                result.append("[native code]\n");
                if (!justbody) {
                    result.append("}\n");
                }
                return;
            }
            i = 0;
            if (this.source.length() <= 0) break block137;
            if (toplevel) {
                if (!justbody) {
                    result.append('\n');
                }
                j = 0;
                while (j < indent) {
                    result.append(' ');
                    ++j;
                }
            }
            if (this.source.charAt(0) != 'n' || this.source.length() <= 1 || this.source.charAt(1) != ',' && this.source.charAt(1) != '^') break block137;
            if (justbody) ** GOTO lbl37
            result.append("function ");
            if (this.nextIs(i, 94) && this.version != 120 && this.functionName != null && this.functionName.equals("anonymous")) {
                result.append("anonymous");
            }
            ++i;
            break block137;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl37:
                // 2 sources

                ** while (i < this.source.length() && (this.source.charAt((int)i) != '\u0001' || i > 0 && this.source.charAt((int)(i - 1)) == ','))
            }
lbl38:
            // 1 sources

            ++i;
        }
        while (i < this.source.length()) {
            switch (this.source.charAt(i)) {
                case ',': 
                case '8': {
                    stop = ++i + this.source.charAt(i);
                    result.append(this.source.substring(i + 1, stop + 1));
                    i = stop;
                    break;
                }
                case '-': {
                    lbits = 0L;
                    switch (this.source.charAt(++i)) {
                        case 'S': {
                            result.append((int)this.source.charAt(++i));
                            break;
                        }
                        case 'J': {
                            v0 = ++i;
                            lbits |= (long)this.source.charAt(v0) << 48;
                            v1 = ++i;
                            lbits |= (long)this.source.charAt(v1) << 32;
                            v2 = ++i;
                            lbits |= (long)this.source.charAt(v2) << 16;
                            result.append(lbits |= (long)this.source.charAt(++i));
                            break;
                        }
                        case 'D': {
                            v3 = ++i;
                            lbits |= (long)this.source.charAt(v3) << 48;
                            v4 = ++i;
                            lbits |= (long)this.source.charAt(v4) << 32;
                            v5 = ++i;
                            lbits |= (long)this.source.charAt(v5) << 16;
                            dval = Double.longBitsToDouble(lbits |= (long)this.source.charAt(++i));
                            result.append(ScriptRuntime.numberToString(dval, 10));
                        }
                    }
                    break;
                }
                case '.': {
                    stop = ++i + this.source.charAt(i);
                    result.append('\"');
                    result.append(ScriptRuntime.escapeString(this.source.substring(i + 1, stop + 1)));
                    result.append('\"');
                    i = stop;
                    break;
                }
                case 'm': {
                    switch (this.source.charAt(++i)) {
                        case '4': {
                            result.append("true");
                            break;
                        }
                        case '3': {
                            result.append("false");
                            break;
                        }
                        case '1': {
                            result.append("null");
                            break;
                        }
                        case '2': {
                            result.append("this");
                            break;
                        }
                        case ' ': {
                            result.append("typeof");
                            break;
                        }
                        case '\u0084': {
                            result.append("void");
                            break;
                        }
                        case 'J': {
                            result.append("undefined");
                        }
                    }
                    break;
                }
                case 'n': {
                    functionNumber = this.source.charAt(++i);
                    if (this.nestedFunctions == null || functionNumber > this.nestedFunctions.length) {
                        message = this.functionName != null && this.functionName.length() > 0 ? Context.getMessage2("msg.no.function.ref.found.in", new Integer(this.source.charAt(i)), this.functionName) : Context.getMessage1("msg.no.function.ref.found", new Integer(this.source.charAt(i)));
                        throw Context.reportRuntimeError(message);
                    }
                    this.nestedFunctions[functionNumber].decompile(indent, false, false, result);
                    break;
                }
                case '`': {
                    result.append(", ");
                    break;
                }
                case '\\': {
                    if (this.nextIs(i, 1)) {
                        indent += 4;
                    }
                    result.append('{');
                    break;
                }
                case ']': {
                    if (justbody && toplevel && i + 1 == this.source.length()) break;
                    if (this.nextIs(i, 1)) {
                        indent -= 4;
                    }
                    if (this.nextIs(i, 118) || this.nextIs(i, 114)) {
                        indent -= 4;
                        result.append("} ");
                        break;
                    }
                    result.append('}');
                    break;
                }
                case '^': {
                    result.append('(');
                    break;
                }
                case '_': {
                    if (this.nextIs(i, 92)) {
                        result.append(") ");
                        break;
                    }
                    result.append(')');
                    break;
                }
                case 'Z': {
                    result.append('[');
                    break;
                }
                case '[': {
                    result.append(']');
                    break;
                }
                case '\u0001': {
                    result.append('\n');
                    if (i + 1 >= this.source.length()) break;
                    less = 0;
                    if (this.nextIs(i, 116) || this.nextIs(i, 117)) {
                        less = 2;
                    } else if (this.nextIs(i, 93)) {
                        less = 4;
                    } else if (this.nextIs(i, 44) && this.source.charAt(i + (skip = this.source.charAt(i + 2)) + 3) == 'c') {
                        less = 4;
                    }
                    while (less < indent) {
                        result.append(' ');
                        ++less;
                    }
                    break;
                }
                case 'l': {
                    result.append('.');
                    break;
                }
                case '\u001e': {
                    result.append("new ");
                    break;
                }
                case '\u001f': {
                    result.append("delete ");
                    break;
                }
                case 'q': {
                    result.append("if ");
                    break;
                }
                case 'r': {
                    result.append("else ");
                    break;
                }
                case 'x': {
                    result.append("for ");
                    break;
                }
                case '?': {
                    result.append(" in ");
                    break;
                }
                case '|': {
                    result.append("with ");
                    break;
                }
                case 'v': {
                    result.append("while ");
                    break;
                }
                case 'w': {
                    result.append("do ");
                    break;
                }
                case 'K': {
                    result.append("try ");
                    break;
                }
                case '}': {
                    result.append("catch ");
                    break;
                }
                case '~': {
                    result.append("finally ");
                    break;
                }
                case '>': {
                    result.append("throw ");
                    break;
                }
                case 's': {
                    result.append("switch ");
                    break;
                }
                case 'y': {
                    if (this.nextIs(i, 44)) {
                        result.append("break ");
                        break;
                    }
                    result.append("break");
                    break;
                }
                case 'z': {
                    if (this.nextIs(i, 44)) {
                        result.append("continue ");
                        break;
                    }
                    result.append("continue");
                    break;
                }
                case 't': {
                    result.append("case ");
                    break;
                }
                case 'u': {
                    result.append("default");
                    break;
                }
                case '\u0005': {
                    if (this.nextIs(i, 89)) {
                        result.append("return");
                        break;
                    }
                    result.append("return ");
                    break;
                }
                case '{': {
                    result.append("var ");
                    break;
                }
                case 'Y': {
                    if (this.nextIs(i, 1)) {
                        result.append(';');
                        break;
                    }
                    result.append("; ");
                    break;
                }
                case 'a': {
                    switch (this.source.charAt(++i)) {
                        case '\u0080': {
                            result.append(" = ");
                            break;
                        }
                        case '\u0017': {
                            result.append(" += ");
                            break;
                        }
                        case '\u0018': {
                            result.append(" -= ");
                            break;
                        }
                        case '\u0019': {
                            result.append(" *= ");
                            break;
                        }
                        case '\u001a': {
                            result.append(" /= ");
                            break;
                        }
                        case '\u001b': {
                            result.append(" %= ");
                            break;
                        }
                        case '\u000b': {
                            result.append(" |= ");
                            break;
                        }
                        case '\f': {
                            result.append(" ^= ");
                            break;
                        }
                        case '\r': {
                            result.append(" &= ");
                            break;
                        }
                        case '\u0014': {
                            result.append(" <<= ");
                            break;
                        }
                        case '\u0015': {
                            result.append(" >>= ");
                            break;
                        }
                        case '\u0016': {
                            result.append(" >>>= ");
                        }
                    }
                    break;
                }
                case 'b': {
                    result.append(" ? ");
                    break;
                }
                case '\u0087': {
                    result.append(':');
                    break;
                }
                case 'c': {
                    if (this.nextIs(i, 1)) {
                        result.append(':');
                        break;
                    }
                    result.append(" : ");
                    break;
                }
                case 'd': {
                    result.append(" || ");
                    break;
                }
                case 'e': {
                    result.append(" && ");
                    break;
                }
                case '\u000b': {
                    result.append(" | ");
                    break;
                }
                case '\f': {
                    result.append(" ^ ");
                    break;
                }
                case '\r': {
                    result.append(" & ");
                    break;
                }
                case 'f': {
                    switch (this.source.charAt(++i)) {
                        case '5': {
                            result.append(this.version == 120 ? " == " : " === ");
                            break;
                        }
                        case '6': {
                            result.append(this.version == 120 ? " != " : " !== ");
                            break;
                        }
                        case '\u000e': {
                            result.append(" == ");
                            break;
                        }
                        case '\u000f': {
                            result.append(" != ");
                        }
                    }
                    break;
                }
                case 'g': {
                    switch (this.source.charAt(++i)) {
                        case '\u0011': {
                            result.append(" <= ");
                            break;
                        }
                        case '\u0010': {
                            result.append(" < ");
                            break;
                        }
                        case '\u0013': {
                            result.append(" >= ");
                            break;
                        }
                        case '\u0012': {
                            result.append(" > ");
                            break;
                        }
                        case '@': {
                            result.append(" instanceof ");
                        }
                    }
                    break;
                }
                case 'h': {
                    switch (this.source.charAt(++i)) {
                        case '\u0014': {
                            result.append(" << ");
                            break;
                        }
                        case '\u0015': {
                            result.append(" >> ");
                            break;
                        }
                        case '\u0016': {
                            result.append(" >>> ");
                        }
                    }
                    break;
                }
                case 'i': {
                    switch (this.source.charAt(++i)) {
                        case ' ': {
                            result.append("typeof ");
                            break;
                        }
                        case '\u0084': {
                            result.append("void ");
                            break;
                        }
                        case '\u0081': {
                            result.append('!');
                            break;
                        }
                        case '\u001c': {
                            result.append('~');
                            break;
                        }
                        case '\u0017': {
                            result.append('+');
                            break;
                        }
                        case '\u0018': {
                            result.append('-');
                        }
                    }
                    break;
                }
                case 'j': {
                    result.append("++");
                    break;
                }
                case 'k': {
                    result.append("--");
                    break;
                }
                case '\u0017': {
                    result.append(" + ");
                    break;
                }
                case '\u0018': {
                    result.append(" - ");
                    break;
                }
                case '\u0019': {
                    result.append(" * ");
                    break;
                }
                case '\u001a': {
                    result.append(" / ");
                    break;
                }
                case '\u001b': {
                    result.append(" % ");
                    break;
                }
            }
            ++i;
        }
        if (toplevel && !justbody) {
            result.append('\n');
        }
    }

    public int getLength() {
        Context cx = Context.getContext();
        if (cx != null && cx.getLanguageVersion() != 120) {
            return this.argCount;
        }
        NativeCall activation = this.getActivation(cx);
        if (activation == null) {
            return this.argCount;
        }
        return activation.getOriginalArguments().length;
    }

    public int getArity() {
        return this.argCount;
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }
}

