/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;

final class LineBuffer {
    static final int BUFLEN = 256;
    private static final int EOL_HINT_MASK = 57296;
    private Reader in;
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int offset = 0;
    private int end = 0;
    private int otherEnd;
    private int lineno;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;
    private int stringStart = -1;
    private StringBuffer stringSoFar = null;
    private boolean hadCFSinceStringStart = false;
    private static final boolean checkSelf = true;

    LineBuffer(Reader in, int lineno) {
        this.in = in;
        this.lineno = lineno;
    }

    int read() throws IOException {
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            ++this.offset;
            if ((c & 0xDFD0) == 0) {
                switch (c) {
                    case '\r': {
                        if (this.offset != this.end) {
                            if (this.buffer[this.offset] == '\n') {
                                ++this.offset;
                            }
                        } else {
                            this.lastWasCR = true;
                        }
                    }
                    case '\n': 
                    case '\u2028': 
                    case '\u2029': {
                        this.prevStart = this.lineStart;
                        this.lineStart = this.offset;
                        ++this.lineno;
                        return 10;
                    }
                }
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return c;
            }
            this.hadCFSinceStringStart = true;
        }
        return -1;
    }

    void unread() {
        if (this.offset == 0 && !this.hitEOF) {
            Context.codeBug();
        }
        if (this.offset == 0) {
            return;
        }
        --this.offset;
        char c = this.buffer[this.offset];
        if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
            this.lineStart = this.prevStart;
            --this.lineno;
        }
    }

    private void skipFormatChar() {
        if (!LineBuffer.formatChar(this.buffer[this.offset])) {
            Context.codeBug();
        }
        if (this.stringStart >= 0 || this.stringSoFar != null) {
            this.hadCFSinceStringStart = true;
        } else if (this.offset != 0) {
            char tmp = this.buffer[this.offset];
            this.buffer[this.offset] = this.buffer[this.offset - 1];
            this.buffer[this.offset - 1] = tmp;
        } else if (this.otherEnd != 0) {
            char tmp = this.buffer[this.offset];
            this.buffer[this.offset] = this.otherBuffer[this.otherEnd - 1];
            this.otherBuffer[this.otherEnd - 1] = tmp;
        }
        ++this.offset;
    }

    int peek() throws IOException {
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if ((c & 0xDFD0) == 0 && LineBuffer.eolChar(c)) {
                return 10;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return c;
            }
            this.skipFormatChar();
        }
        return -1;
    }

    boolean match(int test) throws IOException {
        if ((test & 0xDFD0) == 0 && LineBuffer.eolChar(test)) {
            Context.codeBug();
        }
        if (test >= 128 && LineBuffer.formatChar(test)) {
            Context.codeBug();
        }
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if (test == c) {
                ++this.offset;
                return true;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return false;
            }
            this.skipFormatChar();
        }
        return false;
    }

    String getLine() {
        StringBuffer result = new StringBuffer();
        int start = this.lineStart;
        if (start >= this.offset) {
            if (this.otherStart < this.otherEnd) {
                result.append(this.otherBuffer, this.otherStart, this.otherEnd - this.otherStart);
            }
            start = 0;
        }
        result.append(this.buffer, start, this.offset - start);
        int i = this.offset;
        while (true) {
            char c;
            if (i == this.buffer.length) {
                char[] newBuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
                int charsRead = 0;
                try {
                    charsRead = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (charsRead < 0) break;
                this.end += charsRead;
            }
            if (((c = this.buffer[i]) & 0xDFD0) == 0 && LineBuffer.eolChar(c)) break;
            ++i;
        }
        result.append(this.buffer, this.offset, i - this.offset);
        return result.toString();
    }

    int getOffset() {
        if (this.lineStart >= this.offset) {
            return this.offset + (this.otherEnd - this.otherStart);
        }
        return this.offset - this.lineStart;
    }

    void startString() {
        char c;
        if (this.offset == 0) {
            this.stringSoFar = new StringBuffer();
            this.stringStart = -1;
            c = this.otherBuffer[this.otherEnd - 1];
            this.stringSoFar.append(c);
        } else {
            this.stringSoFar = null;
            this.stringStart = this.offset - 1;
            c = this.buffer[this.stringStart];
        }
        this.hadCFSinceStringStart = c >= '\u0080' && LineBuffer.formatChar(c);
    }

    String getString() {
        if (this.stringStart < 0 && this.stringSoFar == null) {
            Context.codeBug();
        }
        int loseCR = this.offset > 0 && this.buffer[this.offset] == '\n' && this.buffer[this.offset - 1] == '\r' ? 1 : 0;
        String result = this.stringStart >= 0 ? new String(this.buffer, this.stringStart, this.offset - this.stringStart - loseCR) : this.stringSoFar.append(this.buffer, 0, this.offset - loseCR).toString();
        this.stringStart = -1;
        this.stringSoFar = null;
        if (this.hadCFSinceStringStart) {
            char[] c = result.toCharArray();
            StringBuffer x = null;
            int i = 0;
            while (i < c.length) {
                if (LineBuffer.formatChar(c[i])) {
                    if (x == null) {
                        x = new StringBuffer();
                        x.append(c, 0, i);
                    }
                } else if (x != null) {
                    x.append(c[i]);
                }
                ++i;
            }
            if (x != null) {
                result = x.toString();
            }
        }
        return result;
    }

    private boolean fill() throws IOException {
        int loseCR;
        if (this.end != this.offset) {
            Context.codeBug();
        }
        int n = loseCR = this.offset > 0 && this.lastWasCR ? 1 : 0;
        if (this.stringStart != -1) {
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.buffer, this.stringStart, this.end - this.stringStart - loseCR);
            this.stringStart = -1;
        } else if (this.stringSoFar != null) {
            this.stringSoFar.append(this.buffer, 0, this.end - loseCR);
        }
        char[] tempBuffer = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = tempBuffer;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : this.buffer.length + 1;
        this.prevStart = this.lineStart;
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.offset;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.offset;
            this.lastWasCR = false;
        }
        return true;
    }

    int getLineno() {
        return this.lineno;
    }

    boolean eof() {
        return this.hitEOF;
    }

    private static boolean formatChar(int c) {
        return Character.getType((char)c) == 16;
    }

    private static boolean eolChar(int c) {
        return c == 13 || c == 10 || c == 8232 || c == 8233;
    }
}

