/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.UintMap;

public class InterpreterData
implements Serializable {
    static final long serialVersionUID = 4815333329084415557L;
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    public boolean isFunction;
    public String itsName;
    public String itsSource;
    public String itsSourceFile;
    public boolean itsNeedsActivation;
    public boolean itsFromEvalCode;
    public boolean itsUseDynamicScope;
    public boolean itsCheckThis;
    public byte itsFunctionType;
    public String[] itsStringTable;
    public int itsStringTableIndex;
    public double[] itsDoubleTable;
    public int itsDoubleTableIndex;
    public InterpretedFunction[] itsNestedFunctions;
    public Object[] itsRegExpLiterals;
    public byte[] itsICode = new byte[this.itsICodeTop];
    public int itsICodeTop = 1024;
    public int itsMaxVars;
    public int itsMaxLocals;
    public int itsMaxTryDepth;
    public int itsMaxStack;
    public int itsMaxFrameArray;
    public int itsMaxCalleeArgs;
    public UintMap itsLineNumberTable;
    public Object securityDomain;

    InterpreterData(Object securityDomain, boolean useDynamicScope, boolean checkThis) {
        this.itsStringTable = new String[64];
        this.itsUseDynamicScope = useDynamicScope;
        this.itsCheckThis = checkThis;
        if (securityDomain == null) {
            Context.checkSecurityDomainRequired();
        }
        this.securityDomain = securityDomain;
    }

    public boolean placeBreakpoint(int line) {
        int offset = this.getOffset(line);
        if (offset != -1) {
            int icode = 0xFF & this.itsICode[offset];
            if (icode == 149) {
                return true;
            }
            if (icode == 147) {
                this.itsICode[offset] = -107;
                return true;
            }
        }
        return false;
    }

    public boolean removeBreakpoint(int line) {
        int icode;
        int offset = this.getOffset(line);
        if (offset != -1 && (icode = 0xFF & this.itsICode[offset]) == 149) {
            this.itsICode[offset] = -109;
            return true;
        }
        return false;
    }

    private int getOffset(int line) {
        if (this.itsLineNumberTable == null) {
            return -1;
        }
        int offset = this.itsLineNumberTable.getInt(line, -1);
        if (0 <= offset && offset <= this.itsICode.length) {
            return offset;
        }
        return -1;
    }
}

