/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;

public class Interpreter
extends LabelTable {
    public static final int LINE_ICODE = 147;
    public static final int SOURCEFILE_ICODE = 148;
    public static final int BREAKPOINT_ICODE = 149;
    public static final int SHORTNUMBER_ICODE = 150;
    public static final int INTNUMBER_ICODE = 151;
    public static final int RETURN_UNDEF_ICODE = 152;
    public static final int END_ICODE = 153;
    protected boolean itsInFunctionFlag;
    protected Vector itsFunctionList;
    protected InterpreterData itsData;
    protected VariableTable itsVariableTable;
    protected int itsTryDepth = 0;
    protected int itsStackDepth = 0;
    protected String itsSourceFile;
    protected int itsLineNumber = 0;
    protected InterpretedFunction[] itsNestedFunctions = null;
    static PrintWriter out;
    protected int version;
    protected boolean inLineStepMode;
    protected StringBuffer debugSource;
    public static final Object DBL_MRK;

    public IRFactory createIRFactory(TokenStream ts, ClassNameHelper nameHelper, Scriptable scope) {
        return new IRFactory(ts, scope);
    }

    public Parser createParser(TokenStream ts, ClassNameHelper nameHelper, Scriptable scope) {
        return new Parser(new IRFactory(ts, scope));
    }

    public Node transform(Node tree, TokenStream ts, Scriptable scope) {
        return new NodeTransformer().transform(tree, null, ts, scope);
    }

    public Object compile(Context cx, Scriptable scope, Node tree, Object securityDomain, SecuritySupport securitySupport, ClassNameHelper nameHelper) throws IOException {
        this.version = cx.getLanguageVersion();
        this.itsData = new InterpreterData(securityDomain, cx.hasCompileFunctionsWithDynamicScope(), false);
        if (tree instanceof FunctionNode) {
            this.itsData.isFunction = true;
            FunctionNode f = (FunctionNode)tree;
            InterpretedFunction result = this.generateFunctionICode(cx, scope, f, securityDomain);
            result.itsData.itsFunctionType = f.getFunctionType();
            Interpreter.createFunctionObject(result, scope, false);
            return result;
        }
        return this.generateScriptICode(cx, scope, tree, securityDomain);
    }

    protected void generateICodeFromTree(Node tree, VariableTable varTable, boolean needsActivation, Object securityDomain) {
        int theICodeTop = 0;
        this.itsVariableTable = varTable;
        this.itsData.itsNeedsActivation = needsActivation;
        theICodeTop = this.generateICode(tree, theICodeTop);
        int i = 0;
        while (i < this.itsLabelTableTop) {
            this.itsLabelTable[i].fixGotos(this.itsData.itsICode);
            ++i;
        }
        if (!this.itsData.isFunction) {
            theICodeTop = this.addByte(153, theICodeTop);
        }
        this.itsData.itsICodeTop = theICodeTop;
        if (this.itsData.itsICode.length != theICodeTop) {
            byte[] tmp = new byte[theICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, tmp, 0, theICodeTop);
            this.itsData.itsICode = tmp;
        }
        this.itsData.itsMaxVars = this.itsVariableTable.size();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxTryDepth + this.itsData.itsMaxStack;
    }

    protected Object[] generateRegExpLiterals(Context cx, Scriptable scope, Vector regexps) {
        Object[] result = new Object[regexps.size()];
        RegExpProxy rep = cx.getRegExpProxy();
        int i = 0;
        while (i < regexps.size()) {
            Node regexp = (Node)regexps.elementAt(i);
            Node left = regexp.getFirstChild();
            Node right = regexp.getLastChild();
            result[i] = rep.newRegExp(cx, scope, left.getString(), left != right ? right.getString() : null, false);
            regexp.putIntProp(12, i);
            ++i;
        }
        return result;
    }

    protected InterpretedScript generateScriptICode(Context cx, Scriptable scope, Node tree, Object securityDomain) {
        this.itsData.itsSourceFile = this.itsSourceFile = (String)tree.getProp(16);
        this.itsFunctionList = (Vector)tree.getProp(5);
        this.debugSource = (StringBuffer)tree.getProp(31);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scope, cx, securityDomain);
        }
        Object[] regExpLiterals = null;
        Vector regexps = (Vector)tree.getProp(12);
        if (regexps != null) {
            regExpLiterals = this.generateRegExpLiterals(cx, scope, regexps);
        }
        VariableTable varTable = (VariableTable)tree.getProp(10);
        boolean activationNeeded = cx.isGeneratingDebugChanged() && cx.isGeneratingDebug();
        this.generateICodeFromTree(tree, varTable, activationNeeded, securityDomain);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = regExpLiterals;
        String[] argNames = this.itsVariableTable.getAllNames();
        short argCount = (short)this.itsVariableTable.getParameterCount();
        InterpretedScript result = this.newInterpretedScript(cx, this.itsData, argNames, argCount);
        result.setParentScope(scope);
        result.setPrototype(ScriptableObject.getClassPrototype(scope, "Script"));
        if (cx.debugger != null) {
            cx.debugger.handleCompilationDone(cx, result, this.debugSource);
        }
        return result;
    }

    protected void generateNestedFunctions(Scriptable scope, Context cx, Object securityDomain) {
        this.itsNestedFunctions = new InterpretedFunction[this.itsFunctionList.size()];
        int i = 0;
        while (i < this.itsFunctionList.size()) {
            FunctionNode def = (FunctionNode)this.itsFunctionList.elementAt(i);
            Interpreter jsi = this.newInterpreter();
            jsi.itsSourceFile = this.itsSourceFile;
            jsi.itsData = new InterpreterData(securityDomain, cx.hasCompileFunctionsWithDynamicScope(), def.getCheckThis());
            jsi.itsData.isFunction = true;
            jsi.itsData.itsFunctionType = def.getFunctionType();
            jsi.itsInFunctionFlag = true;
            jsi.debugSource = this.debugSource;
            this.itsNestedFunctions[i] = jsi.generateFunctionICode(cx, scope, def, securityDomain);
            def.putIntProp(5, i);
            i = (short)(i + 1);
        }
    }

    protected InterpretedFunction generateFunctionICode(Context cx, Scriptable scope, FunctionNode theFunction, Object securityDomain) {
        this.itsFunctionList = (Vector)theFunction.getProp(5);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scope, cx, securityDomain);
        }
        Object[] regExpLiterals = null;
        Vector regexps = (Vector)theFunction.getProp(12);
        if (regexps != null) {
            regExpLiterals = this.generateRegExpLiterals(cx, scope, regexps);
        }
        VariableTable varTable = theFunction.getVariableTable();
        boolean needsActivation = theFunction.requiresActivation() || cx.isGeneratingDebugChanged() && cx.isGeneratingDebug();
        this.generateICodeFromTree(theFunction.getLastChild(), varTable, needsActivation, securityDomain);
        this.itsData.itsName = theFunction.getFunctionName();
        this.itsData.itsSourceFile = (String)theFunction.getProp(16);
        this.itsData.itsSource = (String)theFunction.getProp(17);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = regExpLiterals;
        String[] argNames = this.itsVariableTable.getAllNames();
        short argCount = (short)this.itsVariableTable.getParameterCount();
        InterpretedFunction result = this.newInterpretedFunction(cx, this.itsData, argNames, argCount);
        result.setParentScope(scope);
        result.setPrototype(ScriptableObject.getClassPrototype(scope, "Function"));
        if (cx.debugger != null) {
            cx.debugger.handleCompilationDone(cx, result, this.debugSource);
        }
        return result;
    }

    protected InterpretedFunction newInterpretedFunction(Context cx, InterpreterData itsData, String[] argNames, short argCount) {
        return new InterpretedFunction(cx, itsData, argNames, argCount);
    }

    protected InterpretedScript newInterpretedScript(Context cx, InterpreterData itsData, String[] argNames, short argCount) {
        return new InterpretedScript(cx, itsData, argNames, argCount);
    }

    protected Interpreter newInterpreter() {
        return new Interpreter();
    }

    protected int updateLineNumber(Node node, int iCodeTop) {
        Object datum = node.getDatum();
        if (datum == null || !(datum instanceof Number)) {
            return iCodeTop;
        }
        short lineNumber = ((Number)datum).shortValue();
        if (lineNumber != this.itsLineNumber) {
            this.itsLineNumber = lineNumber;
            if (this.itsData.itsLineNumberTable == null && Context.getCurrentContext().isGeneratingDebug()) {
                this.itsData.itsLineNumberTable = new UintMap();
            }
            if (lineNumber > 0 && this.itsData.itsLineNumberTable != null) {
                this.itsData.itsLineNumberTable.put((int)lineNumber, iCodeTop);
            }
            iCodeTop = this.addByte(147, iCodeTop);
            iCodeTop = this.addShort(lineNumber, iCodeTop);
        }
        return iCodeTop;
    }

    protected void badTree(Node node) {
        Throwable t = new Throwable();
        t.printStackTrace();
        try {
            out = new PrintWriter(new FileOutputStream("icode.txt", true));
            out.println("Un-handled node : " + node.toString());
            out.close();
        }
        catch (IOException x) {
            // empty catch block
        }
        throw new RuntimeException("Un-handled node : " + node.toString());
    }

    protected int generateICode(Node node, int iCodeTop) {
        Node child;
        int type = node.getType();
        Node firstChild = child = node.getFirstChild();
        block0 : switch (type) {
            case 110: {
                iCodeTop = this.addByte(55, iCodeTop);
                Node fn = (Node)node.getProp(5);
                int index = fn.getExistingIntProp(5);
                iCodeTop = this.addByte(index >> 8, iCodeTop);
                iCodeTop = this.addByte(index & 0xFF, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 146: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    if (child.getType() != 110) {
                        iCodeTop = this.generateICode(child, iCodeTop);
                    }
                    child = child.getNextSibling();
                }
                break;
            }
            case 116: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                child = child.getNextSibling();
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    child = child.getNextSibling();
                }
                break;
            }
            case 117: 
            case 124: 
            case 128: 
            case 132: 
            case 133: 
            case 136: 
            case 138: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    child = child.getNextSibling();
                }
                break;
            }
            case 96: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                break;
            }
            case 115: {
                Node branch;
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                int theLocalSlot = this.itsData.itsMaxLocals++;
                iCodeTop = this.addByte(69, iCodeTop);
                iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                iCodeTop = this.addByte(57, iCodeTop);
                --this.itsStackDepth;
                Vector cases = (Vector)node.getProp(13);
                int i = 0;
                while (i < cases.size()) {
                    Node thisCase = (Node)cases.elementAt(i);
                    Node first = thisCase.getFirstChild();
                    iCodeTop = this.generateICode(first, iCodeTop);
                    iCodeTop = this.addByte(70, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte(53, iCodeTop);
                    Node target = new Node(137);
                    thisCase.addChildAfter(target, first);
                    Node branch2 = new Node(7);
                    branch2.putProp(1, target);
                    iCodeTop = this.addGoto(branch2, 7, iCodeTop);
                    --this.itsStackDepth;
                    ++i;
                }
                Node defaultNode = (Node)node.getProp(14);
                if (defaultNode != null) {
                    Node defaultTarget = new Node(137);
                    defaultNode.getFirstChild().addChildToFront(defaultTarget);
                    branch = new Node(6);
                    branch.putProp(1, defaultTarget);
                    iCodeTop = this.addGoto(branch, 6, iCodeTop);
                }
                Node breakTarget = (Node)node.getProp(2);
                branch = new Node(6);
                branch.putProp(1, breakTarget);
                iCodeTop = this.addGoto(branch, 6, iCodeTop);
                break;
            }
            case 137: {
                int label = node.getIntProp(20, -1);
                if (label == -1) {
                    label = this.acquireLabel();
                    node.putIntProp(20, label);
                }
                this.markLabel(label, iCodeTop);
                if (node.getProp(21) == null) break;
                this.itsStackDepth = 1;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 102: 
            case 103: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                int op = node.getInt();
                if (this.version == 120) {
                    if (op == 14) {
                        op = 53;
                    } else if (op == 15) {
                        op = 54;
                    }
                }
                iCodeTop = this.addByte(op, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 30: 
            case 43: {
                if (!(this.itsSourceFile == null || this.itsData.itsSourceFile != null && this.itsSourceFile.equals(this.itsData.itsSourceFile))) {
                    this.itsData.itsSourceFile = this.itsSourceFile;
                }
                iCodeTop = this.addByte(148, iCodeTop);
                int childCount = 0;
                int nameIndex = -1;
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    if (nameIndex == -1) {
                        if (child.getType() == 44) {
                            nameIndex = (short)(this.itsData.itsStringTableIndex - 1);
                        } else if (child.getType() == 39) {
                            nameIndex = (short)(this.itsData.itsStringTableIndex - 1);
                        }
                    }
                    child = child.getNextSibling();
                    ++childCount;
                }
                if (node.getProp(30) != null) {
                    iCodeTop = this.addByte(67, iCodeTop);
                    iCodeTop = this.addShort(this.itsLineNumber, iCodeTop);
                    iCodeTop = this.addString(this.itsSourceFile, iCodeTop);
                } else {
                    iCodeTop = this.addByte(type, iCodeTop);
                    iCodeTop = this.addShort(nameIndex, iCodeTop);
                }
                this.itsStackDepth -= childCount - 1;
                childCount = type == 30 ? --childCount : (childCount -= 2);
                iCodeTop = this.addShort(childCount, iCodeTop);
                if (childCount > this.itsData.itsMaxCalleeArgs) {
                    this.itsData.itsMaxCalleeArgs = childCount;
                }
                iCodeTop = this.addByte(148, iCodeTop);
                break;
            }
            case 69: 
            case 144: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(69, iCodeTop);
                iCodeTop = this.addLocalRef(node, iCodeTop);
                break;
            }
            case 145: {
                if (node.getProp(1) != null) {
                    iCodeTop = this.addByte(66, iCodeTop);
                } else {
                    iCodeTop = this.addByte(70, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                Node temp = (Node)node.getProp(7);
                iCodeTop = this.addLocalRef(temp, iCodeTop);
                break;
            }
            case 70: {
                iCodeTop = this.addByte(70, iCodeTop);
                Node temp = (Node)node.getProp(6);
                iCodeTop = this.addLocalRef(temp, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 7: 
            case 8: {
                iCodeTop = this.generateICode(child, iCodeTop);
                --this.itsStackDepth;
            }
            case 6: {
                iCodeTop = this.addGoto(node, (int)((byte)type), iCodeTop);
                break;
            }
            case 143: {
                Node target = (Node)node.getProp(1);
                target.putProp(21, node);
                iCodeTop = this.addGoto(node, 65, iCodeTop);
                break;
            }
            case 101: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(9, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int falseTarget = this.acquireLabel();
                iCodeTop = this.addGoto(falseTarget, 8, iCodeTop);
                iCodeTop = this.addByte(57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                this.markLabel(falseTarget, iCodeTop);
                break;
            }
            case 100: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(9, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int trueTarget = this.acquireLabel();
                iCodeTop = this.addGoto(trueTarget, 7, iCodeTop);
                iCodeTop = this.addByte(57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                this.markLabel(trueTarget, iCodeTop);
                break;
            }
            case 39: {
                iCodeTop = this.generateICode(child, iCodeTop);
                String s = (String)node.getProp(19);
                if (s != null) {
                    if (s.equals("__proto__")) {
                        iCodeTop = this.addByte(81, iCodeTop);
                        break;
                    }
                    if (s.equals("__parent__")) {
                        iCodeTop = this.addByte(86, iCodeTop);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(39, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 41: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 142: {
                iCodeTop = this.generateICode(child, iCodeTop);
                Object toType = node.getProp(18);
                if (toType == ScriptRuntime.NumberClass) {
                    iCodeTop = this.addByte(58, iCodeTop);
                    break;
                }
                this.badTree(node);
                break;
            }
            case 105: {
                iCodeTop = this.generateICode(child, iCodeTop);
                switch (node.getInt()) {
                    case 132: {
                        iCodeTop = this.addByte(57, iCodeTop);
                        iCodeTop = this.addByte(74, iCodeTop);
                        break block0;
                    }
                    case 129: {
                        int trueTarget = this.acquireLabel();
                        int beyond = this.acquireLabel();
                        iCodeTop = this.addGoto(trueTarget, 7, iCodeTop);
                        iCodeTop = this.addByte(52, iCodeTop);
                        iCodeTop = this.addGoto(beyond, 6, iCodeTop);
                        this.markLabel(trueTarget, iCodeTop);
                        iCodeTop = this.addByte(51, iCodeTop);
                        this.markLabel(beyond, iCodeTop);
                        break block0;
                    }
                    case 28: {
                        iCodeTop = this.addByte(28, iCodeTop);
                        break block0;
                    }
                    case 32: {
                        iCodeTop = this.addByte(32, iCodeTop);
                        break block0;
                    }
                    case 24: {
                        iCodeTop = this.addByte(29, iCodeTop);
                        break block0;
                    }
                    case 23: {
                        iCodeTop = this.addByte(58, iCodeTop);
                        break block0;
                    }
                }
                this.badTree(node);
                break;
            }
            case 40: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                String s = (String)node.getProp(19);
                if (s != null) {
                    if (s.equals("__proto__")) {
                        iCodeTop = this.addByte(83, iCodeTop);
                        break;
                    }
                    if (s.equals("__parent__")) {
                        iCodeTop = this.addByte(84, iCodeTop);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(40, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 42: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 10: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(10, iCodeTop);
                iCodeTop = this.addString(firstChild.getString(), iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 32: {
                String name = node.getString();
                int index = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    index = this.itsVariableTable.getOrdinal(name);
                }
                if (index == -1) {
                    iCodeTop = this.addByte(78, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                } else {
                    iCodeTop = this.addByte(72, iCodeTop);
                    iCodeTop = this.addByte(index, iCodeTop);
                    iCodeTop = this.addByte(32, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 141: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(82, iCodeTop);
                break;
            }
            case 44: 
            case 46: 
            case 61: 
            case 71: {
                iCodeTop = this.addByte(type, iCodeTop);
                iCodeTop = this.addString(node.getString(), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 106: 
            case 107: {
                int childType = child.getType();
                switch (childType) {
                    case 72: {
                        String name = child.getString();
                        if (this.itsData.itsNeedsActivation) {
                            iCodeTop = this.addByte(85, iCodeTop);
                            iCodeTop = this.addByte(46, iCodeTop);
                            iCodeTop = this.addString(name, iCodeTop);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            iCodeTop = this.addByte(type == 106 ? 34 : 37, iCodeTop);
                            --this.itsStackDepth;
                            break;
                        }
                        iCodeTop = this.addByte(type == 106 ? 59 : 60, iCodeTop);
                        int i = this.itsVariableTable.getOrdinal(name);
                        iCodeTop = this.addByte(i, iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                    case 39: 
                    case 41: {
                        Node getPropChild = child.getFirstChild();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        getPropChild = getPropChild.getNextSibling();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        iCodeTop = childType == 39 ? this.addByte(type == 106 ? 34 : 37, iCodeTop) : this.addByte(type == 106 ? 35 : 38, iCodeTop);
                        --this.itsStackDepth;
                        break;
                    }
                    default: {
                        iCodeTop = this.addByte(type == 106 ? 33 : 36, iCodeTop);
                        iCodeTop = this.addString(child.getString(), iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                }
                break;
            }
            case 45: {
                double num = node.getDouble();
                int inum = (int)num;
                if ((double)inum == num) {
                    if (inum == 0) {
                        iCodeTop = this.addByte(47, iCodeTop);
                    } else if (inum == 1) {
                        iCodeTop = this.addByte(48, iCodeTop);
                    } else if ((short)inum == inum) {
                        iCodeTop = this.addByte(150, iCodeTop);
                        iCodeTop = this.addShort(inum, iCodeTop);
                    } else {
                        iCodeTop = this.addByte(151, iCodeTop);
                        iCodeTop = this.addInt(inum, iCodeTop);
                    }
                } else {
                    iCodeTop = this.addByte(45, iCodeTop);
                    iCodeTop = this.addDouble(num, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: 
            case 57: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
            }
            case 3: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 68: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                break;
            }
            case 77: {
                iCodeTop = this.addByte(type, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 4: {
                iCodeTop = this.addByte(type, iCodeTop);
                break;
            }
            case 75: {
                ++this.itsTryDepth;
                if (this.itsTryDepth > this.itsData.itsMaxTryDepth) {
                    this.itsData.itsMaxTryDepth = this.itsTryDepth;
                }
                Node catchTarget = (Node)node.getProp(1);
                Node finallyTarget = (Node)node.getProp(21);
                if (catchTarget == null) {
                    iCodeTop = this.addByte(75, iCodeTop);
                    iCodeTop = this.addShort(0, iCodeTop);
                } else {
                    iCodeTop = this.addGoto(node, 75, iCodeTop);
                }
                int finallyHandler = 0;
                if (finallyTarget != null) {
                    finallyHandler = this.acquireLabel();
                    int theLabel = finallyHandler & Integer.MAX_VALUE;
                    this.itsLabelTable[theLabel].addFixup(iCodeTop);
                }
                iCodeTop = this.addShort(0, iCodeTop);
                Node lastChild = null;
                boolean insertedEndTry = false;
                while (child != null) {
                    if (catchTarget != null && lastChild == catchTarget) {
                        this.itsStackDepth = 1;
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                    }
                    Node nextSibling = child.getNextSibling();
                    if (!(insertedEndTry || nextSibling == null || nextSibling != catchTarget && nextSibling != finallyTarget)) {
                        iCodeTop = this.addByte(76, iCodeTop);
                        insertedEndTry = true;
                    }
                    iCodeTop = this.generateICode(child, iCodeTop);
                    lastChild = child;
                    child = child.getNextSibling();
                }
                this.itsStackDepth = 0;
                if (finallyTarget != null) {
                    int skippy = this.acquireLabel();
                    iCodeTop = this.addGoto(skippy, 6, iCodeTop);
                    this.markLabel(finallyHandler, iCodeTop);
                    this.itsStackDepth = 1;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    int theLocalSlot = this.itsData.itsMaxLocals++;
                    iCodeTop = this.addByte(69, iCodeTop);
                    iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte(57, iCodeTop);
                    int finallyLabel = finallyTarget.getExistingIntProp(20);
                    iCodeTop = this.addGoto(finallyLabel, 65, iCodeTop);
                    iCodeTop = this.addByte(70, iCodeTop);
                    iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte(88, iCodeTop);
                    this.itsStackDepth = 0;
                    this.markLabel(skippy, iCodeTop);
                }
                --this.itsTryDepth;
                break;
            }
            case 62: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(62, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 5: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                if (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    iCodeTop = this.addByte(5, iCodeTop);
                    --this.itsStackDepth;
                    break;
                }
                iCodeTop = this.addByte(152, iCodeTop);
                break;
            }
            case 72: {
                String name = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    iCodeTop = this.addByte(85, iCodeTop);
                    iCodeTop = this.addByte(46, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addByte(39, iCodeTop);
                    --this.itsStackDepth;
                    break;
                }
                int index = this.itsVariableTable.getOrdinal(name);
                iCodeTop = this.addByte(72, iCodeTop);
                iCodeTop = this.addByte(index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 73: {
                if (this.itsData.itsNeedsActivation) {
                    child.setType(61);
                    node.setType(10);
                    iCodeTop = this.generateICode(node, iCodeTop);
                    break;
                }
                String name = child.getString();
                child = child.getNextSibling();
                iCodeTop = this.generateICode(child, iCodeTop);
                int index = this.itsVariableTable.getOrdinal(name);
                iCodeTop = this.addByte(73, iCodeTop);
                iCodeTop = this.addByte(index, iCodeTop);
                break;
            }
            case 109: {
                iCodeTop = this.addByte(node.getInt(), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 79: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(79, iCodeTop);
                iCodeTop = this.addLocalRef(node, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 80: {
                iCodeTop = this.addByte(80, iCodeTop);
                Node init = (Node)node.getProp(4);
                iCodeTop = this.addLocalRef(init, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 139: {
                break;
            }
            case 56: {
                Node regexp = (Node)node.getProp(12);
                int index = regexp.getExistingIntProp(12);
                iCodeTop = this.addByte(56, iCodeTop);
                iCodeTop = this.addShort(index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
            }
        }
        return iCodeTop;
    }

    protected int addLocalRef(Node node, int iCodeTop) {
        int theLocalSlot = node.getIntProp(7, -1);
        if (theLocalSlot == -1) {
            theLocalSlot = this.itsData.itsMaxLocals++;
            node.putIntProp(7, theLocalSlot);
        }
        iCodeTop = this.addByte(theLocalSlot, iCodeTop);
        if (theLocalSlot >= this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = theLocalSlot + 1;
        }
        return iCodeTop;
    }

    protected int addGoto(Node node, int gotoOp, int iCodeTop) {
        Node target = (Node)node.getProp(1);
        int targetLabel = target.getIntProp(20, -1);
        if (targetLabel == -1) {
            targetLabel = this.acquireLabel();
            target.putIntProp(20, targetLabel);
        }
        iCodeTop = this.addGoto(targetLabel, (int)((byte)gotoOp), iCodeTop);
        return iCodeTop;
    }

    protected int addGoto(int targetLabel, int gotoOp, int iCodeTop) {
        int gotoPC = iCodeTop;
        iCodeTop = this.addByte(gotoOp, iCodeTop);
        int theLabel = targetLabel & Integer.MAX_VALUE;
        short targetPC = this.itsLabelTable[theLabel].getPC();
        if (targetPC != -1) {
            int offset = targetPC - gotoPC;
            iCodeTop = this.addShort(offset, iCodeTop);
        } else {
            this.itsLabelTable[theLabel].addFixup(gotoPC + 1);
            iCodeTop = this.addShort(0, iCodeTop);
        }
        return iCodeTop;
    }

    protected int addByte(int b, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (array.length == iCodeTop) {
            byte[] ba = new byte[iCodeTop * 2];
            System.arraycopy(array, 0, ba, 0, iCodeTop);
            array = ba;
            this.itsData.itsICode = ba;
        }
        array[iCodeTop++] = (byte)b;
        return iCodeTop;
    }

    protected int addShort(int s, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 2 > array.length) {
            byte[] ba = new byte[(iCodeTop + 2) * 2];
            System.arraycopy(array, 0, ba, 0, iCodeTop);
            array = ba;
            this.itsData.itsICode = ba;
        }
        array[iCodeTop] = (byte)(s >>> 8);
        array[iCodeTop + 1] = (byte)s;
        return iCodeTop + 2;
    }

    protected int addInt(int i, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 4 > array.length) {
            byte[] ba = new byte[(iCodeTop + 4) * 2];
            System.arraycopy(array, 0, ba, 0, iCodeTop);
            array = ba;
            this.itsData.itsICode = ba;
        }
        array[iCodeTop] = (byte)(i >>> 24);
        array[iCodeTop + 1] = (byte)(i >>> 16);
        array[iCodeTop + 2] = (byte)(i >>> 8);
        array[iCodeTop + 3] = (byte)i;
        return iCodeTop + 4;
    }

    protected int addDouble(double num, int iCodeTop) {
        int index = this.itsData.itsDoubleTableIndex;
        if (index == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == index) {
            double[] na = new double[index * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, na, 0, index);
            this.itsData.itsDoubleTable = na;
        }
        this.itsData.itsDoubleTable[index] = num;
        this.itsData.itsDoubleTableIndex = index + 1;
        iCodeTop = this.addShort(index, iCodeTop);
        return iCodeTop;
    }

    protected int addString(String str, int iCodeTop) {
        int index = this.itsData.itsStringTableIndex;
        if (this.itsData.itsStringTable.length == index) {
            String[] sa = new String[index * 2];
            System.arraycopy(this.itsData.itsStringTable, 0, sa, 0, index);
            this.itsData.itsStringTable = sa;
        }
        this.itsData.itsStringTable[index] = str;
        this.itsData.itsStringTableIndex = index + 1;
        iCodeTop = this.addShort(index, iCodeTop);
        return iCodeTop;
    }

    public static int getShort(byte[] iCode, int pc) {
        return iCode[pc] << 8 | iCode[pc + 1] & 0xFF;
    }

    public static int getInt(byte[] iCode, int pc) {
        return iCode[pc] << 24 | (iCode[pc + 1] & 0xFF) << 16 | (iCode[pc + 2] & 0xFF) << 8 | iCode[pc + 3] & 0xFF;
    }

    public static int getTarget(byte[] iCode, int pc) {
        int displacement = Interpreter.getShort(iCode, pc);
        return pc - 1 + displacement;
    }

    protected static String icodeToName(int icode) {
        if (icode <= 146) {
            return TokenStream.tokenToName(icode);
        }
        switch (icode) {
            case 147: {
                return "line";
            }
            case 148: {
                return "sourcefile";
            }
            case 149: {
                return "breakpoint";
            }
            case 150: {
                return "shortnumber";
            }
            case 151: {
                return "intnumber";
            }
            case 152: {
                return "return_undef";
            }
            case 153: {
                return "end";
            }
        }
        return "<UNKNOWN ICODE: " + icode + ">";
    }

    protected static void dumpICode(InterpreterData theData) {
    }

    protected static void createFunctionObject(InterpretedFunction fn, Scriptable scope, boolean fromEvalCode) {
        fn.setPrototype(ScriptableObject.getClassPrototype(scope, "Function"));
        fn.setParentScope(scope);
        InterpreterData id = fn.itsData;
        if (id.itsName.length() == 0) {
            return;
        }
        boolean callSetProp = false;
        if (id.itsFunctionType == 1 && fn.itsClosure == null) {
            if (fromEvalCode) {
                callSetProp = true;
            } else {
                try {
                    ((ScriptableObject)scope).defineProperty(fn.itsData.itsName, fn, 4);
                }
                catch (ClassCastException e) {
                    callSetProp = true;
                }
            }
        }
        if (id.itsFunctionType == 3 && fn.itsClosure != null) {
            callSetProp = true;
        }
        if (callSetProp) {
            ScriptRuntime.setProp(scope, fn.itsData.itsName, fn, scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object interpret(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, NativeFunction fnOrScript, InterpreterData theData) throws JavaScriptException {
        int pc;
        int i;
        if (cx.interpreterSecurityDomain != theData.securityDomain) {
            Object savedDomain = cx.interpreterSecurityDomain;
            cx.interpreterSecurityDomain = theData.securityDomain;
            try {
                Object object = Interpreter.interpret(cx, scope, thisObj, args, fnOrScript, theData);
                Object var9_10 = null;
                cx.interpreterSecurityDomain = savedDomain;
                return object;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                cx.interpreterSecurityDomain = savedDomain;
                throw throwable;
            }
        }
        Object DBL_MRK = Interpreter.DBL_MRK;
        Scriptable undefined = Undefined.instance;
        boolean VAR_SHFT = false;
        int maxFrameArray = theData.itsMaxFrameArray;
        int maxVars = theData.itsMaxVars;
        int LOCAL_SHFT = 0 + maxVars;
        int TRY_STACK_SHFT = LOCAL_SHFT + theData.itsMaxLocals;
        int STACK_SHFT = TRY_STACK_SHFT + theData.itsMaxTryDepth;
        if (maxFrameArray != STACK_SHFT + theData.itsMaxStack) {
            Context.codeBug();
        }
        Object[] stack = new Object[maxFrameArray];
        double[] sDbl = new double[maxFrameArray];
        int stackTop = STACK_SHFT - 1;
        int tryStackTop = 0;
        int definedArgs = fnOrScript.argCount;
        if (definedArgs != 0) {
            if (definedArgs > args.length) {
                definedArgs = args.length;
            }
            i = 0;
            while (i != definedArgs) {
                stack[0 + i] = args[i];
                ++i;
            }
        }
        i = definedArgs;
        while (i != maxVars) {
            stack[0 + i] = undefined;
            ++i;
        }
        if (theData.isFunction) {
            if (fnOrScript.itsClosure != null) {
                scope = fnOrScript.itsClosure;
            } else if (!theData.itsUseDynamicScope) {
                scope = fnOrScript.getParentScope();
            }
            if (theData.itsCheckThis) {
                thisObj = ScriptRuntime.getThis(thisObj);
            }
            if (theData.itsNeedsActivation) {
                scope = ScriptRuntime.initVarObj(cx, scope, fnOrScript, thisObj, args);
            }
        } else {
            scope = ScriptRuntime.initScript(cx, scope, fnOrScript, thisObj, theData.itsFromEvalCode);
        }
        DebugFrame frame = null;
        if (cx.debugger != null) {
            frame = cx.debugger.enterFrame(cx, scope, thisObj, args, (DebuggableScript)((Object)fnOrScript));
        }
        if (theData.itsNestedFunctions != null) {
            int i2 = 0;
            while (i2 < theData.itsNestedFunctions.length) {
                Interpreter.createFunctionObject(theData.itsNestedFunctions[i2], scope, theData.itsFromEvalCode);
                ++i2;
            }
        }
        Object result = undefined;
        byte[] iCode = theData.itsICode;
        String[] strings = theData.itsStringTable;
        int pcPrevBranch = pc = 0;
        int instructionThreshold = cx.instructionThreshold;
        int instructionCount = cx.instructionCount;
        int INVOCATION_COST = 100;
        block102: while (true) {
            try {
                block103: while (true) {
                    switch (iCode[pc] & 0xFF) {
                        case 76: {
                            --tryStackTop;
                            break block103;
                        }
                        case 75: {
                            stack[TRY_STACK_SHFT + tryStackTop] = scope;
                            sDbl[TRY_STACK_SHFT + tryStackTop] = pc;
                            ++tryStackTop;
                            pc += 4;
                            break block103;
                        }
                        case 19: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl <= lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 17: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl <= rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 18: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl < lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 16: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl < rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 63: {
                            boolean valBln;
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.in(lhs, rhs, scope)) ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 64: {
                            boolean valBln;
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.instanceOf(scope, lhs, rhs)) ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 14: {
                            boolean valBln = Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 15: {
                            boolean valBln = !Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 53: {
                            boolean valBln = Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 54: {
                            boolean valBln = !Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block103;
                        }
                        case 8: {
                            double valDbl;
                            Object val = stack[stackTop];
                            boolean valBln = val != DBL_MRK ? !ScriptRuntime.toBoolean(val) : (valDbl = sDbl[stackTop]) != valDbl || valDbl == 0.0;
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block103;
                            }
                            pc += 2;
                            break block103;
                        }
                        case 7: {
                            double valDbl;
                            Object val = stack[stackTop];
                            boolean valBln = val != DBL_MRK ? ScriptRuntime.toBoolean(val) : (valDbl = sDbl[stackTop]) == valDbl && valDbl != 0.0;
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block103;
                            }
                            pc += 2;
                            break block103;
                        }
                        case 6: {
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block103;
                        }
                        case 65: {
                            sDbl[++stackTop] = pc + 3;
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block103;
                        }
                        case 66: {
                            int slot = iCode[pc + 1] & 0xFF;
                            if (instructionThreshold != 0 && (instructionCount += pc + 2 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = (int)sDbl[LOCAL_SHFT + slot];
                            continue block103;
                        }
                        case 57: {
                            --stackTop;
                            break block103;
                        }
                        case 9: {
                            stack[stackTop + 1] = stack[stackTop];
                            sDbl[stackTop + 1] = sDbl[stackTop];
                            ++stackTop;
                            break block103;
                        }
                        case 2: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            break block103;
                        }
                        case 5: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            break block102;
                        }
                        case 152: {
                            result = undefined;
                            break block102;
                        }
                        case 153: {
                            break block102;
                        }
                        case 28: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = ~rIntValue;
                            break block103;
                        }
                        case 13: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue & rIntValue;
                            break block103;
                        }
                        case 11: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue | rIntValue;
                            break block103;
                        }
                        case 12: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue ^ rIntValue;
                            break block103;
                        }
                        case 20: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue << rIntValue;
                            break block103;
                        }
                        case 21: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue >> rIntValue;
                            break block103;
                        }
                        case 22: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop) & 0x1F;
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
                            break block103;
                        }
                        case 23: {
                            Interpreter.do_add(stack, sDbl, --stackTop);
                            break block103;
                        }
                        case 24: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl - rDbl;
                            break block103;
                        }
                        case 29: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = -rDbl;
                            break block103;
                        }
                        case 58: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = rDbl;
                            break block103;
                        }
                        case 25: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl * rDbl;
                            break block103;
                        }
                        case 26: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl / rDbl;
                            break block103;
                        }
                        case 27: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl % rDbl;
                            break block103;
                        }
                        case 61: {
                            String name = strings[Interpreter.getShort(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.bind(scope, name);
                            pc += 2;
                            break block103;
                        }
                        case 71: {
                            String name = strings[Interpreter.getShort(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.getBase(scope, name);
                            pc += 2;
                            break block103;
                        }
                        case 10: {
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            Object lhs = stack[--stackTop];
                            stack[stackTop] = ScriptRuntime.setName((Scriptable)lhs, rhs, scope, strings[Interpreter.getShort(iCode, pc + 1)]);
                            pc += 2;
                            break block103;
                        }
                        case 31: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.delete(lhs, rhs);
                            break block103;
                        }
                        case 39: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getProp(lhs, name, scope);
                            break block103;
                        }
                        case 40: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            String name = (String)stack[--stackTop];
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProp(lhs, name, rhs, scope);
                            break block103;
                        }
                        case 41: {
                            Interpreter.do_getElem(cx, stack, sDbl, stackTop, scope);
                            --stackTop;
                            break block103;
                        }
                        case 42: {
                            Interpreter.do_setElem(cx, stack, sDbl, stackTop, scope);
                            stackTop -= 2;
                            break block103;
                        }
                        case 34: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrement(lhs, name, scope);
                            break block103;
                        }
                        case 37: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrement(lhs, name, scope);
                            break block103;
                        }
                        case 35: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrementElem(lhs, rhs, scope);
                            break block103;
                        }
                        case 38: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrementElem(lhs, rhs, scope);
                            break block103;
                        }
                        case 68: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getThis((Scriptable)lhs);
                            break block103;
                        }
                        case 69: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[LOCAL_SHFT + slot] = stack[stackTop];
                            sDbl[LOCAL_SHFT + slot] = sDbl[stackTop];
                            break block103;
                        }
                        case 70: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[LOCAL_SHFT + slot];
                            sDbl[stackTop] = sDbl[LOCAL_SHFT + slot];
                            break block103;
                        }
                        case 67: {
                            Object lhs;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int lineNum = Interpreter.getShort(iCode, pc + 1);
                            String name = strings[Interpreter.getShort(iCode, pc + 3)];
                            int count = Interpreter.getShort(iCode, pc + 5);
                            Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop, count);
                            Object rhs = stack[stackTop -= count];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.callSpecial(cx, lhs, rhs, outArgs, thisObj, scope, name, lineNum);
                            pc += 6;
                            instructionCount = cx.instructionCount;
                            break block103;
                        }
                        case 43: {
                            int i3;
                            Object lhs;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            cx.instructionCount = instructionCount;
                            int count = Interpreter.getShort(iCode, pc + 3);
                            Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop, count);
                            Object rhs = stack[stackTop -= count];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if (lhs == undefined && (i3 = Interpreter.getShort(iCode, pc + 1)) != -1) {
                                lhs = strings[i3];
                            }
                            Scriptable calleeScope = scope;
                            if (theData.itsNeedsActivation) {
                                calleeScope = ScriptableObject.getTopLevelScope(scope);
                            }
                            stack[stackTop] = ScriptRuntime.call(cx, lhs, rhs, outArgs, calleeScope);
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break block103;
                        }
                        case 30: {
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int count = Interpreter.getShort(iCode, pc + 3);
                            Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, stackTop, count);
                            Object lhs = stack[stackTop -= count];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if (lhs == undefined && Interpreter.getShort(iCode, pc + 1) != -1) {
                                lhs = strings[Interpreter.getShort(iCode, pc + 1)];
                            }
                            stack[stackTop] = ScriptRuntime.newObject(cx, lhs, outArgs, scope);
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break block103;
                        }
                        case 32: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.typeof(lhs);
                            break block103;
                        }
                        case 78: {
                            String name = strings[Interpreter.getShort(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.typeofName(scope, name);
                            pc += 2;
                            break block103;
                        }
                        case 46: {
                            stack[++stackTop] = strings[Interpreter.getShort(iCode, pc + 1)];
                            pc += 2;
                            break block103;
                        }
                        case 150: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = Interpreter.getShort(iCode, pc + 1);
                            pc += 2;
                            break block103;
                        }
                        case 151: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = Interpreter.getInt(iCode, pc + 1);
                            pc += 4;
                            break block103;
                        }
                        case 45: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = theData.itsDoubleTable[Interpreter.getShort(iCode, pc + 1)];
                            pc += 2;
                            break block103;
                        }
                        case 44: {
                            stack[++stackTop] = ScriptRuntime.name(scope, strings[Interpreter.getShort(iCode, pc + 1)]);
                            pc += 2;
                            break block103;
                        }
                        case 33: {
                            stack[++stackTop] = ScriptRuntime.postIncrement(scope, strings[Interpreter.getShort(iCode, pc + 1)]);
                            pc += 2;
                            break block103;
                        }
                        case 36: {
                            stack[++stackTop] = ScriptRuntime.postDecrement(scope, strings[Interpreter.getShort(iCode, pc + 1)]);
                            pc += 2;
                            break block103;
                        }
                        case 73: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[0 + slot] = stack[stackTop];
                            sDbl[0 + slot] = sDbl[stackTop];
                            break block103;
                        }
                        case 72: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[0 + slot];
                            sDbl[stackTop] = sDbl[0 + slot];
                            break block103;
                        }
                        case 59: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[0 + slot];
                            sDbl[stackTop] = sDbl[0 + slot];
                            stack[0 + slot] = DBL_MRK;
                            sDbl[0 + slot] = Interpreter.stack_double(stack, sDbl, stackTop) + 1.0;
                            break block103;
                        }
                        case 60: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[0 + slot];
                            sDbl[stackTop] = sDbl[0 + slot];
                            stack[0 + slot] = DBL_MRK;
                            sDbl[0 + slot] = Interpreter.stack_double(stack, sDbl, stackTop) - 1.0;
                            break block103;
                        }
                        case 47: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 0.0;
                            break block103;
                        }
                        case 48: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 1.0;
                            break block103;
                        }
                        case 49: {
                            stack[++stackTop] = null;
                            break block103;
                        }
                        case 50: {
                            stack[++stackTop] = thisObj;
                            break block103;
                        }
                        case 87: {
                            stack[++stackTop] = fnOrScript;
                            break block103;
                        }
                        case 51: {
                            stack[++stackTop] = Boolean.FALSE;
                            break block103;
                        }
                        case 52: {
                            stack[++stackTop] = Boolean.TRUE;
                            break block103;
                        }
                        case 74: {
                            stack[++stackTop] = Undefined.instance;
                            break block103;
                        }
                        case 62: {
                            Object exception = stack[stackTop];
                            if (exception == DBL_MRK) {
                                exception = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            throw new JavaScriptException(exception);
                        }
                        case 88: {
                            Object exception = stack[stackTop];
                            --stackTop;
                            if (exception instanceof JavaScriptException) {
                                throw (JavaScriptException)exception;
                            }
                            throw (RuntimeException)exception;
                        }
                        case 3: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            scope = ScriptRuntime.enterWith(lhs, scope);
                            break block103;
                        }
                        case 4: {
                            scope = ScriptRuntime.leaveWith(scope);
                            break block103;
                        }
                        case 77: {
                            stack[++stackTop] = ScriptRuntime.newScope();
                            break block103;
                        }
                        case 79: {
                            int slot = iCode[++pc] & 0xFF;
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            stack[LOCAL_SHFT + slot] = ScriptRuntime.initEnum(lhs, scope);
                            break block103;
                        }
                        case 80: {
                            int slot = iCode[++pc] & 0xFF;
                            Object val = stack[LOCAL_SHFT + slot];
                            stack[++stackTop] = ScriptRuntime.nextEnum((Enumeration)val);
                            break block103;
                        }
                        case 81: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getProto(lhs, scope);
                            break block103;
                        }
                        case 82: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getParent(lhs);
                            break block103;
                        }
                        case 86: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getParent(lhs, scope);
                            break block103;
                        }
                        case 83: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProto(lhs, rhs, scope);
                            break block103;
                        }
                        case 84: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setParent(lhs, rhs, scope);
                            break block103;
                        }
                        case 85: {
                            stack[++stackTop] = scope;
                            break block103;
                        }
                        case 55: {
                            int i4 = Interpreter.getShort(iCode, pc + 1);
                            stack[++stackTop] = new InterpretedFunction(theData.itsNestedFunctions[i4], scope, cx);
                            Interpreter.createFunctionObject((InterpretedFunction)stack[stackTop], scope, theData.itsFromEvalCode);
                            pc += 2;
                            break block103;
                        }
                        case 56: {
                            int i5 = Interpreter.getShort(iCode, pc + 1);
                            stack[++stackTop] = theData.itsRegExpLiterals[i5];
                            pc += 2;
                            break block103;
                        }
                        case 148: {
                            cx.interpreterSourceFile = theData.itsSourceFile;
                            break block103;
                        }
                        case 147: 
                        case 149: {
                            int line;
                            cx.interpreterLine = line = Interpreter.getShort(iCode, pc + 1);
                            if (frame != null) {
                                boolean breakpoint = (iCode[pc] & 0xFF) == 149;
                                frame.onLineChange(cx, line, breakpoint);
                            }
                            pc += 2;
                            break block103;
                        }
                        default: {
                            Interpreter.dumpICode(theData);
                            throw new RuntimeException("Unknown icode : " + (iCode[pc] & 0xFF) + " @ pc : " + pc);
                        }
                    }
                    break;
                }
                ++pc;
            }
            catch (Throwable ex) {
                int exType;
                Object catchObj;
                block199: {
                    block200: {
                        if (instructionThreshold != 0) {
                            if (instructionCount < 0) {
                                instructionCount = cx.instructionCount;
                            } else {
                                cx.instructionCount = instructionCount += pc - pcPrevBranch;
                            }
                        }
                        boolean SCRIPT_THROW = false;
                        boolean ECMA = true;
                        int RUNTIME = 2;
                        int OTHER = 3;
                        catchObj = ex;
                        while (true) {
                            Object w;
                            if (catchObj instanceof JavaScriptException) {
                                catchObj = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)catchObj);
                                exType = 0;
                                break block199;
                            }
                            if (catchObj instanceof EcmaError) {
                                catchObj = ((EcmaError)catchObj).getErrorObject();
                                exType = 1;
                                break block199;
                            }
                            if (!(catchObj instanceof RuntimeException)) break block200;
                            if (!(catchObj instanceof WrappedException) || !((w = ((WrappedException)catchObj).unwrap()) instanceof Throwable)) break;
                            catchObj = (Throwable)w;
                        }
                        catchObj = null;
                        exType = 2;
                        break block199;
                    }
                    catchObj = null;
                    exType = 3;
                }
                if (exType != 3 && frame != null) {
                    frame.onExceptionThrown(cx, ex);
                }
                boolean rethrow = true;
                if (exType != 3 && tryStackTop > 0) {
                    int try_pc = (int)sDbl[TRY_STACK_SHFT + --tryStackTop];
                    if (exType == 0 || exType == 1) {
                        int catch_pc = Interpreter.getTarget(iCode, try_pc + 1);
                        if (catch_pc == try_pc) {
                            catch_pc = 0;
                        }
                        if (catch_pc != 0) {
                            rethrow = false;
                            pc = catch_pc;
                            stackTop = STACK_SHFT;
                            stack[stackTop] = catchObj;
                        }
                    }
                    if (rethrow) {
                        int finally_pc = Interpreter.getTarget(iCode, try_pc + 3);
                        if (finally_pc == try_pc + 2) {
                            finally_pc = 0;
                        }
                        if (finally_pc != 0) {
                            rethrow = false;
                            pc = finally_pc;
                            stackTop = STACK_SHFT;
                            stack[stackTop] = ex;
                        }
                    }
                }
                if (rethrow) {
                    if (frame != null) {
                        frame.onExit(cx, true, ex);
                    }
                    if (theData.itsNeedsActivation) {
                        ScriptRuntime.popActivation(cx);
                    }
                    if (exType == 0) {
                        throw (JavaScriptException)ex;
                    }
                    if (exType == 1 || exType == 2) {
                        throw (RuntimeException)ex;
                    }
                    throw (Error)ex;
                }
                if (instructionThreshold != 0 && instructionCount > instructionThreshold) {
                    cx.observeInstructionCount(instructionCount);
                    instructionCount = 0;
                }
                pcPrevBranch = pc;
                scope = (Scriptable)stack[TRY_STACK_SHFT + tryStackTop];
            }
        }
        if (frame != null) {
            frame.onExit(cx, false, result);
        }
        if (theData.itsNeedsActivation) {
            ScriptRuntime.popActivation(cx);
        }
        if (instructionThreshold != 0) {
            if (instructionCount > instructionThreshold) {
                cx.observeInstructionCount(instructionCount);
                instructionCount = 0;
            }
            cx.instructionCount = instructionCount;
        }
        return result;
    }

    protected static Object doubleWrap(double x) {
        return new Double(x);
    }

    protected static int stack_int32(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toInt32(x) : ScriptRuntime.toInt32(stackDbl[i]);
    }

    protected static double stack_double(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toNumber(x) : stackDbl[i];
    }

    protected static void do_add(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                int n = stackTop;
                stackDbl[n] = stackDbl[n] + rDbl;
            } else {
                Interpreter.do_add(lhs, rDbl, stack, stackDbl, stackTop, true);
            }
        } else if (lhs == DBL_MRK) {
            Interpreter.do_add(rhs, stackDbl[stackTop], stack, stackDbl, stackTop, false);
        } else {
            if (lhs instanceof Scriptable) {
                lhs = ((Scriptable)lhs).getDefaultValue(null);
            }
            if (rhs instanceof Scriptable) {
                rhs = ((Scriptable)rhs).getDefaultValue(null);
            }
            if (lhs instanceof String || rhs instanceof String) {
                stack[stackTop] = ScriptRuntime.toString(lhs) + ScriptRuntime.toString(rhs);
            } else {
                double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
                double rDbl = rhs instanceof Number ? ((Number)rhs).doubleValue() : ScriptRuntime.toNumber(rhs);
                stack[stackTop] = DBL_MRK;
                stackDbl[stackTop] = lDbl + rDbl;
            }
        }
    }

    protected static void do_add(Object lhs, double rDbl, Object[] stack, double[] stackDbl, int stackTop, boolean left_right_order) {
        if (lhs instanceof Scriptable) {
            lhs = lhs == Undefined.instance ? ScriptRuntime.NaNobj : ((Scriptable)lhs).getDefaultValue(null);
        }
        if (lhs instanceof String) {
            stack[stackTop] = left_right_order ? (String)lhs + ScriptRuntime.toString(rDbl) : ScriptRuntime.toString(rDbl) + (String)lhs;
        } else {
            double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
            stack[stackTop] = DBL_MRK;
            stackDbl[stackTop] = lDbl + rDbl;
        }
    }

    protected static boolean do_eq(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        boolean result = rhs == DBL_MRK ? (lhs == DBL_MRK ? stackDbl[stackTop] == stackDbl[stackTop + 1] : Interpreter.do_eq(stackDbl[stackTop + 1], lhs)) : (lhs == DBL_MRK ? Interpreter.do_eq(stackDbl[stackTop], rhs) : ScriptRuntime.eq(lhs, rhs));
        return result;
    }

    protected static boolean do_eq(double x, Object y) {
        while (true) {
            if (y instanceof Number) {
                return x == ((Number)y).doubleValue();
            }
            if (y instanceof String) {
                return x == ScriptRuntime.toNumber((String)y);
            }
            if (y instanceof Boolean) {
                return x == (double)((Boolean)y != false ? 1 : 0);
            }
            if (!(y instanceof Scriptable)) break;
            if (y == Undefined.instance) {
                return false;
            }
            y = ScriptRuntime.toPrimitive(y);
        }
        return false;
    }

    protected static boolean do_sheq(Object[] stack, double[] stackDbl, int stackTop) {
        boolean result;
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else if (rhs instanceof Number) {
            double rDbl = ((Number)rhs).doubleValue();
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else {
            result = ScriptRuntime.shallowEq(lhs, rhs);
        }
        return result;
    }

    protected static void do_getElem(Context cx, Object[] stack, double[] stackDbl, int stackTop, Scriptable scope) {
        Object result;
        Object id;
        Object lhs = stack[stackTop - 1];
        if (lhs == DBL_MRK) {
            lhs = Interpreter.doubleWrap(stackDbl[stackTop - 1]);
        }
        if ((id = stack[stackTop]) != DBL_MRK) {
            result = ScriptRuntime.getElem(lhs, id, scope);
        } else {
            Scriptable obj = lhs instanceof Scriptable ? (Scriptable)lhs : ScriptRuntime.toObject(cx, scope, lhs);
            double val = stackDbl[stackTop];
            int index = (int)val;
            if ((double)index == val) {
                result = ScriptRuntime.getElem(obj, index);
            } else {
                String s = ScriptRuntime.toString(val);
                result = ScriptRuntime.getStrIdElem(obj, s);
            }
        }
        stack[stackTop - 1] = result;
    }

    protected static void do_setElem(Context cx, Object[] stack, double[] stackDbl, int stackTop, Scriptable scope) {
        Object result;
        Object id;
        Object lhs;
        Object rhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            rhs = Interpreter.doubleWrap(stackDbl[stackTop]);
        }
        if ((lhs = stack[stackTop - 2]) == DBL_MRK) {
            lhs = Interpreter.doubleWrap(stackDbl[stackTop - 2]);
        }
        if ((id = stack[stackTop - 1]) != DBL_MRK) {
            result = ScriptRuntime.setElem(lhs, id, rhs, scope);
        } else {
            Scriptable obj = lhs instanceof Scriptable ? (Scriptable)lhs : ScriptRuntime.toObject(cx, scope, lhs);
            double val = stackDbl[stackTop - 1];
            int index = (int)val;
            if ((double)index == val) {
                result = ScriptRuntime.setElem(obj, index, rhs);
            } else {
                String s = ScriptRuntime.toString(val);
                result = ScriptRuntime.setStrIdElem(obj, s, rhs, scope);
            }
        }
        stack[stackTop - 2] = result;
    }

    protected static Object[] getArgsArray(Object[] stack, double[] sDbl, int stackTop, int count) {
        if (count == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] args = new Object[count];
        do {
            Object val;
            if ((val = stack[stackTop]) == DBL_MRK) {
                val = Interpreter.doubleWrap(sDbl[stackTop]);
            }
            args[--count] = val;
            --stackTop;
        } while (count != 0);
        return args;
    }

    protected static void setInterpreterSourceFile(Context cx, String interpreterSourceFile) {
        cx.interpreterSourceFile = interpreterSourceFile;
    }

    protected static String getInterpreterSourceFile(Context cx) {
        return cx.interpreterSourceFile;
    }

    protected static void setInterpreterLine(Context cx, int line) {
        cx.interpreterLine = line;
    }

    protected static int getInterpreterLine(Context cx) {
        return cx.interpreterLine;
    }

    protected static NativeCall getCurrentActivation(Context cx) {
        return cx.currentActivation;
    }

    protected static void setCurrentActivation(Context cx, NativeCall call) {
        cx.currentActivation = call;
    }

    protected Object getSecurityDomainForStackDepth(Context cx, int depth) {
        return cx.getSecurityDomainForStackDepth(depth);
    }

    static {
        DBL_MRK = new Object();
    }
}

