/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

public class InterpretedScript
extends NativeScript
implements DebuggableScript {
    public InterpreterData itsData;

    public InterpretedScript(Context cx, InterpreterData theData, String[] argNames, short argCount) {
        this.itsData = theData;
        this.argNames = argNames;
        this.argCount = argCount;
        this.functionName = "";
        this.nestedFunctions = this.itsData.itsNestedFunctions;
        this.version = (short)cx.getLanguageVersion();
    }

    public Object exec(Context cx, Scriptable scope) throws JavaScriptException {
        return this.call(cx, scope, scope, null);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return Interpreter.interpret(cx, scope, thisObj, args, this, this.itsData);
    }

    public boolean isFunction() {
        return false;
    }

    public Scriptable getScriptable() {
        return this;
    }

    public String getSourceName() {
        return this.itsData.itsSourceFile;
    }

    public int[] getLineNumbers() {
        return this.itsData.itsLineNumberTable.getKeys();
    }

    public boolean placeBreakpoint(int line) {
        return this.itsData.placeBreakpoint(line);
    }

    public boolean removeBreakpoint(int line) {
        return this.itsData.removeBreakpoint(line);
    }
}

