/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Invoker;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class FunctionObject
extends NativeFunction
implements Serializable {
    static final long serialVersionUID = -4074285335521944312L;
    private static final Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static final String INVOKER_MASTER_CLASS = "org.mozilla.javascript.optimizer.InvokerImpl";
    static Invoker invokerMaster = FunctionObject.newInvokerMaster();
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    static Method[] methodsCache;
    transient Method method;
    transient Constructor ctor;
    transient Invoker invoker;
    private transient Class[] types;
    private short parmsLength;
    private short lengthPropertyValue;
    private boolean hasVoidReturn;
    private boolean isStatic;
    private boolean useDynamicScope;
    static /* synthetic */ Class class$org$mozilla$javascript$Context;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

    public FunctionObject(String name, Member methodOrConstructor, Scriptable scope) {
        short length;
        String methodName;
        if (methodOrConstructor instanceof Constructor) {
            this.ctor = (Constructor)methodOrConstructor;
            this.isStatic = true;
            this.types = this.ctor.getParameterTypes();
            methodName = this.ctor.getName();
        } else {
            this.method = (Method)methodOrConstructor;
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
            this.types = this.method.getParameterTypes();
            methodName = this.method.getName();
        }
        this.functionName = name;
        if (this.types.length == 4 && (this.types[1].isArray() || this.types[2].isArray())) {
            if (this.types[1].isArray()) {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context) || this.types[1].getComponentType() != ScriptRuntime.ObjectClass || this.types[2] != ScriptRuntime.FunctionClass || this.types[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", methodName);
                }
                this.parmsLength = (short)-2;
            } else {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context) || this.types[1] != ScriptRuntime.ScriptableClass || this.types[2].getComponentType() != ScriptRuntime.ObjectClass || this.types[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", methodName);
                }
                this.parmsLength = (short)-1;
            }
            length = 1;
        } else {
            this.parmsLength = (short)this.types.length;
            int i = 0;
            while (i < this.parmsLength) {
                Class type = this.types[i];
                if (type != ScriptRuntime.ObjectClass && type != ScriptRuntime.StringClass && type != ScriptRuntime.BooleanClass && !ScriptRuntime.NumberClass.isAssignableFrom(type) && !(class$org$mozilla$javascript$Scriptable == null ? FunctionObject.class$("org.mozilla.javascript.Scriptable") : class$org$mozilla$javascript$Scriptable).isAssignableFrom(type) && type != Boolean.TYPE && type != Byte.TYPE && type != Short.TYPE && type != Integer.TYPE && type != Float.TYPE && type != Double.TYPE) {
                    throw Context.reportRuntimeError1("msg.bad.parms", methodName);
                }
                ++i;
            }
            length = this.parmsLength;
        }
        this.lengthPropertyValue = length;
        this.hasVoidReturn = this.method != null && this.method.getReturnType() == Void.TYPE;
        this.argCount = length;
        this.setParentScope(scope);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scope));
        Context cx = Context.getCurrentContext();
        this.useDynamicScope = cx != null && cx.hasCompileFunctionsWithDynamicScope();
    }

    public int getLength() {
        return this.lengthPropertyValue;
    }

    public void setLength(short length) {
        this.lengthPropertyValue = length;
    }

    public static Method[] findMethods(Class clazz, String name) {
        return FunctionObject.findMethods(FunctionObject.getMethodList(clazz), name);
    }

    static Method[] findMethods(Method[] methods, String name) {
        Vector<Method> v = null;
        Method first = null;
        int i = 0;
        while (i < methods.length) {
            if (methods[i] != null && methods[i].getName().equals(name)) {
                if (first == null) {
                    first = methods[i];
                } else {
                    if (v == null) {
                        v = new Vector<Method>(5);
                        v.addElement(first);
                    }
                    v.addElement(methods[i]);
                }
            }
            ++i;
        }
        if (v == null) {
            if (first == null) {
                return null;
            }
            Method[] single = new Method[]{first};
            return single;
        }
        Object[] result = new Method[v.size()];
        v.copyInto(result);
        return result;
    }

    static Method[] getMethodList(Class clazz) {
        Method[] cached = methodsCache;
        if (cached != null && cached[0].getDeclaringClass() == clazz) {
            return cached;
        }
        Method[] methods = null;
        try {
            if (!sawSecurityException) {
                methods = clazz.getDeclaredMethods();
            }
        }
        catch (SecurityException e) {
            sawSecurityException = true;
        }
        if (methods == null) {
            methods = clazz.getMethods();
        }
        int count = 0;
        int i = 0;
        while (i < methods.length) {
            if (sawSecurityException ? methods[i].getDeclaringClass() != clazz : !Modifier.isPublic(methods[i].getModifiers())) {
                methods[i] = null;
            } else {
                ++count;
            }
            ++i;
        }
        Method[] result = new Method[count];
        int j = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            if (methods[i2] != null) {
                result[j++] = methods[i2];
            }
            ++i2;
        }
        if (result.length > 0 && Context.isCachingEnabled) {
            methodsCache = result;
        }
        return result;
    }

    public void addAsConstructor(Scriptable scope, Scriptable prototype) {
        this.setParentScope(scope);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scope));
        this.setImmunePrototypeProperty(prototype);
        prototype.setParentScope(this);
        int attr = 7;
        ScriptableObject.defineProperty(prototype, "constructor", this, 7);
        String name = prototype.getClassName();
        ScriptableObject.defineProperty(scope, name, this, 2);
        this.setParentScope(scope);
    }

    public static Object convertArg(Context cx, Scriptable scope, Object arg, Class desired) {
        if (desired == ScriptRuntime.StringClass) {
            return ScriptRuntime.toString(arg);
        }
        if (desired == ScriptRuntime.IntegerClass || desired == Integer.TYPE) {
            return new Integer(ScriptRuntime.toInt32(arg));
        }
        if (desired == ScriptRuntime.BooleanClass || desired == Boolean.TYPE) {
            return ScriptRuntime.toBoolean(arg) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (desired == ScriptRuntime.DoubleClass || desired == Double.TYPE) {
            return new Double(ScriptRuntime.toNumber(arg));
        }
        if (desired == ScriptRuntime.ScriptableClass) {
            return ScriptRuntime.toObject(cx, scope, arg);
        }
        if (desired == ScriptRuntime.ObjectClass) {
            return arg;
        }
        throw Context.reportRuntimeError1("msg.cant.convert", desired.getName());
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        short i;
        Object[] invokeArgs;
        if (this.parmsLength < 0) {
            return this.callVarargs(cx, thisObj, args, false);
        }
        if (!this.isStatic) {
            Class<Object> clazz = this.method != null ? this.method.getDeclaringClass() : this.ctor.getDeclaringClass();
            while (!clazz.isInstance(thisObj)) {
                if ((thisObj = thisObj.getPrototype()) != null && this.useDynamicScope) continue;
                throw NativeGlobal.typeError1("msg.incompat.call", this.functionName, scope);
            }
        }
        if (this.parmsLength == args.length) {
            invokeArgs = args;
            i = this.types == null ? this.parmsLength : (short)0;
        } else {
            invokeArgs = new Object[this.parmsLength];
            i = 0;
        }
        while (i < this.parmsLength) {
            Object arg;
            Object object = arg = i < args.length ? args[i] : Undefined.instance;
            if (this.types != null) {
                arg = FunctionObject.convertArg(cx, this, arg, this.types[i]);
            }
            invokeArgs[i] = arg;
            i = (short)(i + 1);
        }
        try {
            Object result = this.method == null ? this.ctor.newInstance(invokeArgs) : this.doInvoke(thisObj, invokeArgs);
            return this.hasVoidReturn ? Undefined.instance : result;
        }
        catch (InvocationTargetException e) {
            throw JavaScriptException.wrapException(scope, e);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        catch (InstantiationException e) {
            throw WrappedException.wrapException(e);
        }
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        if (this.method == null || this.parmsLength == -2) {
            Scriptable parent;
            Scriptable result = this.method != null ? (Scriptable)this.callVarargs(cx, null, args, true) : (Scriptable)this.call(cx, scope, null, args);
            if (result.getPrototype() == null) {
                result.setPrototype(this.getClassPrototype());
            }
            if (result.getParentScope() == null && result != (parent = this.getParentScope())) {
                result.setParentScope(parent);
            }
            return result;
        }
        if (this.method != null && !this.isStatic) {
            Scriptable result;
            try {
                result = (Scriptable)this.method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException e) {
                throw WrappedException.wrapException(e);
            }
            catch (InstantiationException e) {
                throw WrappedException.wrapException(e);
            }
            result.setPrototype(this.getClassPrototype());
            result.setParentScope(this.getParentScope());
            Object val = this.call(cx, scope, result, args);
            if (val != null && val != Undefined.instance && val instanceof Scriptable) {
                return (Scriptable)val;
            }
            return result;
        }
        return super.construct(cx, scope, args);
    }

    private final Object doInvoke(Object thisObj, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Invoker master = invokerMaster;
        if (master != null) {
            if (this.invoker == null) {
                this.invoker = master.createInvoker(this.method, this.types);
            }
            try {
                return this.invoker.invoke(thisObj, args);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        return this.method.invoke(thisObj, args);
    }

    private Object callVarargs(Context cx, Scriptable thisObj, Object[] args, boolean inNewExpr) throws JavaScriptException {
        try {
            if (this.parmsLength == -1) {
                Object[] invokeArgs = new Object[]{cx, thisObj, args, this};
                Object result = this.doInvoke(null, invokeArgs);
                return this.hasVoidReturn ? Undefined.instance : result;
            }
            Boolean b = inNewExpr ? Boolean.TRUE : Boolean.FALSE;
            Object[] invokeArgs = new Object[]{cx, args, this, b};
            return this.method == null ? this.ctor.newInstance(invokeArgs) : this.doInvoke(null, invokeArgs);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof EvaluatorException) {
                throw (EvaluatorException)target;
            }
            if (target instanceof EcmaError) {
                throw (EcmaError)target;
            }
            Scriptable scope = thisObj == null ? this : thisObj;
            throw JavaScriptException.wrapException(scope, target);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        catch (InstantiationException e) {
            throw WrappedException.wrapException(e);
        }
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    static void setCachingEnabled(boolean enabled) {
        if (!enabled) {
            methodsCache = null;
            invokerMaster = null;
        } else if (invokerMaster == null) {
            invokerMaster = FunctionObject.newInvokerMaster();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        boolean hasConstructor = this.ctor != null;
        Executable member = hasConstructor ? this.ctor : this.method;
        FunctionObject.writeMember(out, member);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Member member = FunctionObject.readMember(in);
        if (member instanceof Method) {
            this.method = (Method)member;
            this.types = this.method.getParameterTypes();
        } else {
            this.ctor = (Constructor)member;
            this.types = this.ctor.getParameterTypes();
        }
    }

    static void writeMember(ObjectOutputStream out, Member member) throws IOException {
        if (member == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (!(member instanceof Method) && !(member instanceof Constructor)) {
            throw new IllegalArgumentException("not Method or Constructor");
        }
        out.writeBoolean(member instanceof Method);
        out.writeObject(member.getName());
        out.writeObject(member.getDeclaringClass());
        if (member instanceof Method) {
            FunctionObject.writeParameters(out, ((Method)member).getParameterTypes());
        } else {
            FunctionObject.writeParameters(out, ((Constructor)member).getParameterTypes());
        }
    }

    static Member readMember(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!in.readBoolean()) {
            return null;
        }
        boolean isMethod = in.readBoolean();
        String name = (String)in.readObject();
        Class declaring = (Class)in.readObject();
        Class[] parms = FunctionObject.readParameters(in);
        try {
            if (isMethod) {
                return declaring.getMethod(name, parms);
            }
            return declaring.getConstructor(parms);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Cannot find member: " + e);
        }
    }

    static void writeParameters(ObjectOutputStream out, Class[] parms) throws IOException {
        out.writeShort(parms.length);
        int i = 0;
        while (i < parms.length) {
            block5: {
                Class parm = parms[i];
                out.writeBoolean(parm.isPrimitive());
                if (!parm.isPrimitive()) {
                    out.writeObject(parm);
                } else {
                    int j = 0;
                    while (j < primitives.length) {
                        if (parm.equals(primitives[j])) {
                            out.writeByte(j);
                            break block5;
                        }
                        ++j;
                    }
                    throw new IllegalArgumentException("Primitive " + parm + " not found");
                }
            }
            ++i;
        }
    }

    static Class[] readParameters(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class[] result = new Class[in.readShort()];
        int i = 0;
        while (i < result.length) {
            result[i] = !in.readBoolean() ? (Class)in.readObject() : primitives[in.readByte()];
            ++i;
        }
        return result;
    }

    private static Invoker newInvokerMaster() {
        try {
            Class cl = ScriptRuntime.loadClassName(INVOKER_MASTER_CLASS);
            return (Invoker)cl.newInstance();
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (SecurityException ex) {
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

