/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.CapabilityDefinition;
import com.hp.hpl.deli.DatatypeExpression;
import com.hp.hpl.deli.LocalProfiles;
import com.hp.hpl.deli.ProfileCache;
import com.hp.hpl.deli.Vocabulary;
import com.hp.hpl.deli.Workspace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Workspace
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.hp.hpl.deli.Workspace");
    private static transient Workspace _instance = null;
    private static final long HOURINMILLISECONDS = 3600000L;
    private String path = null;
    protected static CapabilityDefinition capabilityClasses;
    protected HashMap datatypeExpressions;
    private transient ServletContext servletContext;
    protected Vocabulary vocabulary;
    protected transient ProfileCache profileCache;
    protected transient LocalProfiles localProfiles;
    protected long maxCachedProfileLifetime = 86400000L;
    protected int maxCacheSize = 100;
    protected static boolean useLog4j;
    protected boolean refreshStaleProfiles = false;
    protected boolean useCapabilityClasses = false;
    protected boolean processUndefinedAttributes = false;
    protected boolean normaliseWhitespaceInProfileDiff = false;
    protected boolean profileDiffDigestVerification = false;
    protected boolean useLocalProfilesIfNoCCPP = true;
    protected String localProfilesPath = "localProfiles";
    protected String datatypeConfigFile = "config/uaprofValidatorConfig.xml";
    protected boolean processUnconfiguredNamespaces = true;
    protected boolean printDefaults = true;
    protected boolean debug = false;
    protected boolean debugRequestHeaders = false;
    protected boolean printProfileBeforeMerge = false;
    protected boolean cacheReferenceProfiles = true;
    protected String rdfUri = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected Vector rdfsUri;
    protected String componentProperty = "component";
    protected boolean preferLocalOverRemoteProfiles = false;

    public Workspace() {
        _instance = this;
        this.servletContext = null;
    }

    public static Workspace getInstance() {
        if (_instance == null) {
            _instance = new Workspace();
        }
        return _instance;
    }

    public static void setInstance(Workspace w) {
        _instance = w;
    }

    public void configure(ServletContext sc, String filename) throws ParserConfigurationException, MalformedURLException {
        this.servletContext = sc;
        if (this.servletContext != null) {
            if (this.path == null) {
                try {
                    this.path = this.servletContext.getRealPath("/WEB-INF").toString();
                    Workspace.printDebug("Using getRealPath: " + this.path);
                }
                catch (Exception e) {
                    System.out.println("Unable to use getRealPath to locate /WEB-INF");
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            }
            if (this.path == null) {
                try {
                    URL resUrl = this.servletContext.getResource("/WEB-INF");
                    if (resUrl != null) {
                        this.path = resUrl.toString();
                        Workspace.printDebug("Using getResource: " + this.path);
                    }
                }
                catch (MalformedURLException me) {
                    System.out.println("Unable to use getResource to locate /WEB-INF");
                    System.out.println(me.toString());
                    me.printStackTrace();
                }
            }
        } else {
            this.path = "";
        }
        if (this.path.endsWith("WEB-INF")) {
            this.path = this.path.substring(0, this.path.length() - "WEB-INF".length());
        }
        Workspace.printDebug("DELI is using path: " + this.path);
        class CreateWorkspace {
            String namespaceConfigFile;
            String capabilityClassFile;
            String localProfilesFile;
            private final /* synthetic */ String val$filename;
            private final /* synthetic */ Workspace this$0;

            CreateWorkspace(Workspace this$0, String path, String val$filename) throws ParserConfigurationException, MalformedURLException {
                this.this$0 = this$0;
                this.val$filename = val$filename;
                this.namespaceConfigFile = "config/namespaceConfig.xml";
                this.capabilityClassFile = "config/capClass.xml";
                this.localProfilesFile = "config/localProfiles.xml";
                this$0.rdfsUri = new Vector<E>();
                this$0.rdfsUri.add("http://www.w3.org/2000/01/rdf-schema#");
                Workspace.printDebug("Workspace: loading configuration file");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = dbf.newDocumentBuilder();
                try {
                    InputSource inputSource = this$0.getInputSource(path + this.val$filename);
                    this.traverse(parser.parse(inputSource));
                }
                catch (Exception e) {
                    Workspace.printDebug("Workspace: Cannot load workspace configuration file from " + path + this.val$filename);
                    e.printStackTrace();
                }
                Workspace.printDebug("Workspace: loading vocabularies");
                this$0.vocabulary = new Vocabulary(path, this.namespaceConfigFile);
                Workspace.printDebug("Workspace: Creating the local profiles database");
                this$0.localProfiles = new LocalProfiles(path + this.localProfilesFile);
                if (this$0.useCapabilityClasses) {
                    Workspace.printDebug("Workspace: Using capability classes");
                    Workspace.capabilityClasses = new CapabilityDefinition(path + this.capabilityClassFile);
                }
                try {
                    new DatatypeExpression(path + this$0.datatypeConfigFile);
                }
                catch (Exception e) {
                    Workspace.printDebug("Failed to load validator datatypes from config/uaprofValidatorConfig.xml");
                    Workspace.printDebug("Using defaults");
                }
            }

            private void traverse(Node n) {
                Node next;
                1.CreateWorkspace.UpdateProperties temp = new 1.CreateWorkspace.UpdateProperties(this, n);
                if (n.hasChildNodes()) {
                    this.traverse(n.getFirstChild());
                }
                if ((next = n.getNextSibling()) != null) {
                    this.traverse(next);
                }
            }

            static /* synthetic */ Workspace access$000(CreateWorkspace x0) {
                return x0.this$0;
            }
        }
        CreateWorkspace temp = new CreateWorkspace(this, this.path, filename);
        Workspace.printDebug("Workspace: Creating the profile cache");
        this.profileCache = new ProfileCache();
        Workspace.printDebug("Workspace: Finished creating workspace");
    }

    protected static void printDebug(String output) {
        if (Workspace._instance.debug) {
            if (logger.isDebugEnabled() && useLog4j) {
                logger.log((Priority)Level.DEBUG, (Object)output);
            } else {
                System.out.println(output);
            }
        }
    }

    protected static void printWarning(String output) {
        logger.log((Priority)Level.WARN, (Object)output);
    }

    protected static void printInfo(String output) {
        logger.log((Priority)Level.INFO, (Object)output);
    }

    private String setUriProperty(Node n) {
        String t = n.getFirstChild().getNodeValue();
        if (t != null) {
            if (t.charAt(t.length() - 1) != '#') {
                t = t + '#';
            }
            return t;
        }
        return null;
    }

    protected InputSource getInputSource(String name) throws Exception {
        InputStream in = this.getResource(name);
        InputStreamReader resource = new InputStreamReader(in);
        InputSource inputSource = new InputSource(resource);
        return inputSource;
    }

    protected InputStream getResource(String name) throws Exception {
        try {
            InputStream in;
            Workspace.printDebug("Getting resource: " + name);
            File file = new File(name);
            if (file.exists()) {
                in = new FileInputStream(name);
            } else if (name.startsWith("http") || name.startsWith("file") || name.startsWith("jndi")) {
                in = new URL(name).openStream();
            } else if (this.servletContext != null) {
                URL url = this.servletContext.getResource(name);
                in = url.openStream();
            } else {
                in = this.getClass().getClassLoader().getResourceAsStream(name);
            }
            return in;
        }
        catch (FileNotFoundException fnfe) {
            Workspace.printDebug("Could not load file: " + name);
            System.out.println(fnfe.toString());
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            Workspace.printDebug("Cannot retrieve resource: " + name);
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return null;
    }

    static /* synthetic */ String access$100(Workspace x0, Node x1) {
        return x0.setUriProperty(x1);
    }

    static {
        useLog4j = true;
    }
}

