/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.DeliUtil;
import com.hp.hpl.deli.URI;
import com.hp.hpl.deli.Workspace;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class VocabularyConfig {
    protected HashMap namespaceLookup;
    protected HashMap attributeProperties;
    String currentCcppUri;
    private Vector schemas;
    private Vector schemaURIs;
    private Vector vocabularies;

    /*
     * Unable to fully structure code
     */
    VocabularyConfig(String path, String configFile) throws ParserConfigurationException {
        block8: {
            super();
            this.currentCcppUri = null;
            this.schemas = new Vector<E>();
            this.schemaURIs = new Vector<E>();
            this.vocabularies = new Vector<E>();
            this.namespaceLookup = new HashMap<K, V>();
            try {
                inputSource = Workspace.getInstance().getInputSource(path + configFile);
                dbf = DocumentBuilderFactory.newInstance();
                parser = dbf.newDocumentBuilder();
                root = parser.parse(inputSource).getChildNodes().item(0);
                this.parseConfigFile(root);
            }
            catch (Exception e) {
                Workspace.printDebug("DELI Failed to load namespace/vocabulary configuration file from: " + path + configFile);
                Workspace.printDebug("Exception: " + e);
                e.printStackTrace();
            }
            this.attributeProperties = new HashMap<K, V>();
            schema = this.schemas.iterator();
            schemaURI = this.schemaURIs.iterator();
            vocabulary = this.vocabularies.iterator();
            if (vocabulary.hasNext() || schema.hasNext()) ** GOTO lbl37
            Workspace.printDebug("Vocabulary: No vocabularies or schemas defined.");
            break block8;
lbl-1000:
            // 1 sources

            {
                vocabularyName = path + vocabulary.next().toString();
                Workspace.printDebug("Vocabulary: Processing XML vocabulary file: " + vocabularyName);
                dbf = DocumentBuilderFactory.newInstance();
                parser = dbf.newDocumentBuilder();
                try {
                    inputSource = Workspace.getInstance().getInputSource(vocabularyName);
                    this.xmlVocabularyTraverse(parser.parse(inputSource));
                    continue;
                }
                catch (Exception e) {
                    Workspace.printDebug("Vocabulary: Cannot load vocabulary configuration file from " + vocabularyName);
                    Workspace.printDebug(e.toString());
                    e.printStackTrace();
                }
lbl37:
                // 3 sources

                ** while (vocabulary.hasNext())
            }
lbl38:
            // 3 sources

            while (schema.hasNext()) {
                schemaName = schema.next().toString();
                namespace = schemaURI.next().toString();
                Workspace.printDebug("Vocabulary: Processing UAProf schema vocabulary file: " + schemaName);
                try {
                    in = Workspace.getInstance().getResource(schemaName);
                    this.schemaProcess(in, namespace);
                }
                catch (Exception e) {
                    Workspace.printDebug("Vocabulary: Cannot load vocabulary schema from " + schemaName);
                    Workspace.printDebug(e.toString());
                    e.printStackTrace();
                }
            }
        }
    }

    void parseConfigFile(Node root) throws Exception {
        NodeList nl = root.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("namespaceDeclaration")) {
                NodeList namespaces = n.getChildNodes();
                int j = 0;
                while (j < namespaces.getLength()) {
                    Node ns = namespaces.item(j);
                    String URI2 = null;
                    if (ns.getNodeName().equals("namespace")) {
                        NodeList values = ns.getChildNodes();
                        int k = 0;
                        while (k < values.getLength()) {
                            Node value = values.item(k);
                            if (value.getNodeName().equals("uri")) {
                                URI2 = value.getFirstChild().getNodeValue();
                                this.namespaceLookup.put(URI2, URI2);
                            } else if (value.getNodeName().equals("aliasUri")) {
                                String aliasUri = value.getFirstChild().getNodeValue();
                                this.namespaceLookup.put(aliasUri, URI2);
                            } else if (value.getNodeName().equals("schemaVocabularyFile")) {
                                this.schemas.add(value.getFirstChild().getNodeValue());
                                this.schemaURIs.add(URI2);
                            } else if (value.getNodeName().equals("vocabularyFile")) {
                                this.vocabularies.add(value.getFirstChild().getNodeValue());
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void xmlVocabularyTraverse(Node n) throws Exception {
        if (n.getNodeName().equals("attribute") && n.hasChildNodes()) {
            HashMap<String, URI> properties = new HashMap<String, URI>();
            NodeList list = n.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node a = list.item(i);
                if (a.getNodeName().equals("name")) {
                    properties.put("ccppAttribute", new URI(this.currentCcppUri + a.getFirstChild().getNodeValue()));
                } else if (a.getNodeName().equals("component")) {
                    properties.put("ccppComponent", new URI(this.currentCcppUri + new String(a.getFirstChild().getNodeValue())));
                } else if (a.getNodeName().equals("attributeType")) {
                    properties.put("ccppType", new URI(this.currentCcppUri + new String(a.getFirstChild().getNodeValue())));
                } else if (a.getNodeName().equals("resolution")) {
                    properties.put("ccppResolution", new URI(this.currentCcppUri + new String(a.getFirstChild().getNodeValue())));
                } else if (a.getNodeName().equals("collectionType")) {
                    properties.put("ccppCollectionType", new URI(this.currentCcppUri + new String(a.getFirstChild().getNodeValue())));
                }
                ++i;
            }
            this.addAttributePropertiesToVocabulary(properties);
        } else if (n.getNodeName().equals("ccppUri")) {
            String t = n.getFirstChild().getNodeValue();
            if (t != null) {
                if (t.charAt(t.length() - 1) != '#') {
                    t = t + '#';
                }
                this.currentCcppUri = t;
            }
        } else if (n.hasChildNodes()) {
            this.xmlVocabularyTraverse(n.getFirstChild());
        }
        Node next = n.getNextSibling();
        if (next != null) {
            this.xmlVocabularyTraverse(next);
        }
    }

    private void schemaProcess(InputStream in, String prfUri) throws Exception {
        String attributeName = null;
        String componentName = null;
        String collectionTypeName = null;
        String commentString = null;
        Model vocabularySchema = ModelFactory.createDefaultModel();
        vocabularySchema.read(in, "");
        ResIterator attributeList = null;
        Property domainProperty = null;
        Property typeProperty = null;
        Property commentProperty = null;
        Property rangeProperty = null;
        Vector applicableRdfsUris = new Vector();
        Iterator allRdfsUris = Workspace.getInstance().rdfsUri.iterator();
        Iterator i = Workspace.getInstance().rdfsUri.iterator();
        while (i.hasNext()) {
            String theRdfsUri = (String)i.next();
            domainProperty = vocabularySchema.createProperty(theRdfsUri + "domain");
            rangeProperty = vocabularySchema.createProperty(theRdfsUri + "range");
            typeProperty = vocabularySchema.createProperty(Workspace.getInstance().rdfUri + "type");
            commentProperty = vocabularySchema.createProperty(theRdfsUri + "comment");
            attributeList = vocabularySchema.listSubjectsWithProperty(domainProperty);
            while (attributeList.hasNext()) {
                Resource attribute = (Resource)attributeList.next();
                attributeName = DeliUtil.getID(attribute.toString());
                if (attributeName.equals("Defaults")) continue;
                Iterator rdfsIterator = null;
                rdfsIterator = Workspace.getInstance().rdfsUri.iterator();
                Vector<Object> componentListVector = new Vector<Object>();
                while (rdfsIterator.hasNext()) {
                    NodeIterator componentList = vocabularySchema.listObjectsOfProperty(attribute, vocabularySchema.createProperty((String)rdfsIterator.next() + "domain"));
                    while (componentList.hasNext()) {
                        componentListVector.add(componentList.next());
                    }
                }
                Iterator fullComponentList = componentListVector.iterator();
                while (fullComponentList.hasNext()) {
                    Resource component = (Resource)fullComponentList.next();
                    componentName = component.toString();
                    if (!componentName.startsWith("#")) continue;
                    componentName = prfUri + DeliUtil.getID(componentName);
                }
                NodeIterator rangeList = vocabularySchema.listObjectsOfProperty(attribute, rangeProperty);
                collectionTypeName = "Simple";
                while (rangeList.hasNext()) {
                    Resource collectionType = (Resource)rangeList.next();
                    if (!collectionType.toString().endsWith("Bag") && !collectionType.toString().endsWith("Seq")) continue;
                    collectionTypeName = DeliUtil.getID(collectionType.toString());
                }
                rdfsIterator = Workspace.getInstance().rdfsUri.iterator();
                Vector<Object> commentListVector = new Vector<Object>();
                while (rdfsIterator.hasNext()) {
                    NodeIterator commentList = vocabularySchema.listObjectsOfProperty(attribute, vocabularySchema.createProperty((String)rdfsIterator.next() + "comment"));
                    while (commentList.hasNext()) {
                        commentListVector.add(commentList.next());
                    }
                }
                Iterator fullCommentList = commentListVector.iterator();
                while (fullCommentList.hasNext()) {
                    RDFNode comment = (RDFNode)fullCommentList.next();
                    commentString = comment.toString();
                }
                StringTokenizer str = new StringTokenizer(commentString, " ");
                String attributeType = "Literal";
                String resolutionRule = "Override";
                while (str.hasMoreTokens()) {
                    String current = str.nextToken();
                    if (current.equals("Type:")) {
                        attributeType = str.nextToken().trim();
                    }
                    if (!current.equals("Resolution:")) continue;
                    resolutionRule = str.nextToken().trim();
                }
                HashMap<String, URI> properties = new HashMap<String, URI>();
                properties.put("ccppAttribute", new URI(prfUri + attributeName));
                properties.put("ccppComponent", new URI(componentName));
                properties.put("ccppType", new URI(prfUri + attributeType));
                properties.put("ccppResolution", new URI(prfUri + resolutionRule));
                properties.put("ccppCollectionType", new URI(prfUri + collectionTypeName));
                this.addAttributePropertiesToVocabulary(properties);
            }
        }
    }

    private void addAttributePropertiesToVocabulary(HashMap properties) {
        if (this.attributeProperties.containsKey((URI)properties.get("ccppAttribute"))) {
            Iterator i = ((Vector)this.attributeProperties.get((URI)properties.get("ccppAttribute"))).iterator();
            boolean found = false;
            while (i.hasNext()) {
                HashMap existingPropertySet = (HashMap)i.next();
                if ((URI)existingPropertySet.get("ccppComponent") == null || (URI)properties.get("ccppComponent") == null) {
                    if ((URI)existingPropertySet.get("ccppComponent") != (URI)properties.get("ccppComponent")) continue;
                    found = true;
                    continue;
                }
                if (!((URI)existingPropertySet.get("ccppComponent")).equals((URI)properties.get("ccppComponent"))) continue;
                found = true;
            }
            if (!found) {
                ((Vector)this.attributeProperties.get((URI)properties.get("ccppAttribute"))).add(properties);
            }
        } else {
            Vector<HashMap> v = new Vector<HashMap>();
            v.add(properties);
            this.attributeProperties.put((URI)properties.get("ccppAttribute"), v);
        }
    }
}

