/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.DeliUtil;
import com.hp.hpl.deli.URI;
import com.hp.hpl.deli.VocabularyConfig;
import com.hp.hpl.deli.Workspace;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;

class Vocabulary
implements Serializable {
    protected HashMap namespaceLookup;
    private HashMap attributeProperties;

    protected Vocabulary(String path, String configFile) throws ParserConfigurationException {
        VocabularyConfig config = new VocabularyConfig(path, configFile);
        this.namespaceLookup = config.namespaceLookup;
        this.attributeProperties = config.attributeProperties;
    }

    protected URI getAttributeProperty(URI attributeQName, String paramName) {
        URI aliasAttributeQName = this.getRealQName(attributeQName);
        if (this.attributeProperties.containsKey(aliasAttributeQName)) {
            Vector v = (Vector)this.attributeProperties.get(aliasAttributeQName);
            Iterator i = v.iterator();
            if (i.hasNext()) {
                HashMap currentProperties = (HashMap)i.next();
                return this.getRealQName((URI)currentProperties.get(paramName));
            }
        }
        return null;
    }

    private URI getRealQName(URI theUri) {
        URI aliasQName = null;
        if (theUri == null) {
            return null;
        }
        String theUristring = theUri.toString();
        String realUri = this.getRealNamespace(theUristring);
        if (realUri == null) {
            System.out.println("Fatal error: cannot find " + theUristring);
            System.exit(0);
        }
        try {
            aliasQName = new URI(realUri);
        }
        catch (Exception use) {
            Workspace.printDebug("Exception in Vocabulary");
            Workspace.printDebug(use.toString());
            use.printStackTrace();
        }
        return aliasQName;
    }

    protected Vector getAttPropertiesWithAttName(String name) {
        if (name.lastIndexOf("#") > 0) {
            URI aliasQName = null;
            try {
                String namespace = this.getRealNamespace(name);
                if (namespace != null) {
                    aliasQName = new URI(this.getRealNamespace(name));
                }
            }
            catch (Exception use) {
                Workspace.printDebug(use.toString());
                use.printStackTrace();
            }
            if (aliasQName != null) {
                return this.getAttPropertiesWithAttName(aliasQName);
            }
            return null;
        }
        Vector v = new Vector();
        Set keys = this.attributeProperties.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            URI qn = (URI)i.next();
            if (!qn.getFragment().equals(name)) continue;
            Vector props = (Vector)this.attributeProperties.get(qn);
            v.addAll(props);
        }
        return v;
    }

    protected Vector getAttPropertiesWithAttName(URI qualifiedAttributeName) {
        return (Vector)this.attributeProperties.get(qualifiedAttributeName);
    }

    protected HashMap getAttribute(URI attributeQName) {
        URI aliasAttributeQName = this.getRealQName(attributeQName);
        if (this.attributeProperties.get(aliasAttributeQName) != null) {
            Vector v = (Vector)this.attributeProperties.get(aliasAttributeQName);
            return (HashMap)v.firstElement();
        }
        return null;
    }

    protected void addAttributeToVocabulary(String qualifiedAttribute, String currentComponent, String collectionType) {
        qualifiedAttribute = this.getRealNamespace(qualifiedAttribute);
        String name = DeliUtil.getID(qualifiedAttribute);
        String theURI = null;
        if (qualifiedAttribute.lastIndexOf("#") > 1) {
            theURI = qualifiedAttribute.substring(0, qualifiedAttribute.lastIndexOf(35));
        }
        if (theURI == null) {
            System.out.println("Fatal error: cannot create new attribute when namespace is null");
            System.exit(0);
        }
        currentComponent = currentComponent == null ? theURI + "Unknown" : this.getRealNamespace(currentComponent);
        collectionType = collectionType == null ? "Simple" : collectionType;
        HashMap<String, URI> properties = new HashMap<String, URI>();
        try {
            properties.put("ccppAttribute", new URI(qualifiedAttribute));
            properties.put("ccppComponent", this.getRealQName(new URI(currentComponent)));
            properties.put("ccppType", this.getRealQName(new URI(theURI + "Literal")));
            properties.put("ccppResolution", this.getRealQName(new URI(theURI + "Override")));
            properties.put("ccppCollectionType", this.getRealQName(new URI(theURI + collectionType)));
        }
        catch (Exception use) {
            Workspace.printDebug(use.toString());
            use.printStackTrace();
        }
        Vector<HashMap<String, URI>> v = new Vector<HashMap<String, URI>>();
        v.add(properties);
        this.attributeProperties.put((URI)properties.get("ccppAttribute"), v);
    }

    protected String getRealNamespace(String alias) {
        if (alias == null) {
            return null;
        }
        String fragment = null;
        String aliasNamespace = null;
        if (alias.lastIndexOf("#") > 0) {
            fragment = alias.substring(alias.lastIndexOf(35) + 1, alias.length());
            aliasNamespace = alias.substring(0, alias.lastIndexOf(35));
        }
        if (aliasNamespace != null) {
            String string = aliasNamespace = aliasNamespace.endsWith("#") ? aliasNamespace : aliasNamespace + "#";
            if (this.namespaceLookup.containsKey(aliasNamespace)) {
                String namespace = (String)this.namespaceLookup.get(aliasNamespace);
                if (fragment != null) {
                    return namespace + fragment;
                }
                return namespace;
            }
        }
        return alias;
    }
}

